# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools unit tests
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

import unittest
import math, sys

import pgm
from pypgmtools.graph.image import Image
from pypgmtools.graph.text import Text
from pypgmtools.graph.group import Group

class TestGroup(unittest.TestCase):

    def test_one_group(self):
        canvas = pgm.Canvas()
        img=Image()
        txt=Text()

        # testing "position" property
        img.position=(1.0, 1.0, 1.0)
        self.assertEqual(img.x, 1.0)
        self.assertEqual(img.y, 1.0)
        self.assertEqual(img.z, 1.0)
        txt.position=(1.0, 1.0, 1.0)
        self.assertEqual(txt.x, 1.0)
        self.assertEqual(txt.y, 1.0)
        self.assertEqual(txt.z, 1.0)

        g=Group(canvas)
        g.position=(0.5, 0.5, 0.5)
        self.assertEqual(g.x, 0.5)
        self.assertEqual(g.y, 0.5)
        self.assertEqual(g.z, 0.5)

        g.add(img)
        self.assertEqual(img.position, (1.0, 1.0, 1.0))
        self.assertEqual(pgm.Image.get_position(img), (1.5, 1.5, 1.5))

        img.x = 2.0
        self.assertEqual(img.position, (2.0, 1.0, 1.0))
        self.assertEqual(pgm.Image.get_position(img), (2.5, 1.5, 1.5))
        self.assertEqual(img.x, 2.0)

        img.y = 2.0
        self.assertEqual(img.position, (2.0, 2.0, 1.0))
        self.assertEqual(pgm.Image.get_position(img), (2.5, 2.5, 1.5))
        self.assertEqual(img.y, 2.0)

        img.z = 2.0
        self.assertEqual(img.position, (2.0, 2.0, 2.0))
        self.assertEqual(pgm.Image.get_position(img), (2.5, 2.5, 2.5))
        self.assertEqual(img.z, 2.0)

        img.position=(1.0, 1.0, 1.0)
        self.assertEqual(img.position, (1.0, 1.0, 1.0))
        self.assertEqual(pgm.Image.get_position(img), (1.5, 1.5, 1.5))


        g.add(txt)
        self.assertEqual(txt.position, (1.0, 1.0, 1.0))
        self.assertEqual(pgm.Text.get_position(txt), (1.5, 1.5, 1.5))

        g.x=0.25
        self.assertEqual(img.position, (1.0, 1.0, 1.0))
        self.assertEqual(pgm.Image.get_position(img), (1.25, 1.5, 1.5))
        self.assertEqual(txt.position, (1.0, 1.0, 1.0))
        self.assertEqual(pgm.Text.get_position(txt), (1.25, 1.5, 1.5))

        # testing "opacity" property
        g.opacity=255
        img.opacity=64
        txt.opacity=64
        self.assertEqual(g.opacity, 255)
        self.assertEqual(img.opacity, 64)
        self.assertEqual(txt.opacity, 64)
        g.opacity=64
        self.assertEqual(g.opacity, 64)
        self.assertEqual(img.opacity, 64)
        self.assertEqual(txt.opacity, 64)
        self.assertEqual(pgm.Image.get_opacity(img), 16)
        self.assertEqual(pgm.Text.get_opacity(txt), 16)

        g.opacity=32
        self.assertEqual(g.opacity, 32)
        self.assertEqual(img.opacity, 64)
        self.assertEqual(txt.opacity, 64)
        self.assertEqual(pgm.Image.get_opacity(img), 8)
        self.assertEqual(pgm.Text.get_opacity(txt), 8)
        g.opacity=255
        self.assertEqual(g.opacity, 255)
        self.assertEqual(img.opacity, 64)
        self.assertEqual(txt.opacity, 64)

        img.opacity = 255
        txt.opacity = 255
        self.assertEqual(g.opacity, 255)
        self.assertEqual(img.opacity, 255)
        self.assertEqual(txt.opacity, 255)
        g.opacity=64
        self.assertEqual(g.opacity, 64)
        self.assertEqual(img.opacity, 255)
        self.assertEqual(txt.opacity, 255)
        self.assertEqual(pgm.Image.get_opacity(img), 64)
        self.assertEqual(pgm.Text.get_opacity(txt), 64)
        g.opacity=127
        self.assertEqual(g.opacity, 127)
        self.assertEqual(img.opacity, 255)
        self.assertEqual(txt.opacity, 255)
        self.assertEqual(pgm.Image.get_opacity(img), 127)
        self.assertEqual(pgm.Text.get_opacity(txt), 127)
        g.opacity=255
        self.assertEqual(g.opacity, 255)
        self.assertEqual(img.opacity, 255)
        self.assertEqual(txt.opacity, 255)

        # testing "visible" property
        g.visible = True
        img.visible = False
        txt.visible = False
        self.assertEqual(img.visible, False)
        self.assertEqual(txt.visible, False)
        img.visible = True
        txt.visible = True
        self.assertEqual(img.visible, True)
        self.assertEqual(txt.visible, True)

        g.visible = True
        img.visible = False
        txt.visible = True
        self.assertEqual(g.visible, True)
        self.assertEqual(img.visible, False)
        self.assertEqual(txt.visible, True)

        g.visible = False
        img.visible = False
        txt.visible = True
        self.assertEqual(g.visible, False)
        self.assertEqual(img.visible, False)
        #self.assertEqual(txt.visible, False)

        g.visible = True
        img.visible = True
        txt.visible = False
        self.assertEqual(g.visible, True)
        self.assertEqual(img.visible, True)
        #self.assertEqual(txt.visible, False)

        g.visible = False
        self.assertEqual(g.visible, False)
        self.assertEqual(img.visible, False)
        #self.assertEqual(txt.visible, False)

        g.visible = True
        txt.visible = True
        self.assertEqual(g.visible, True)
        self.assertEqual(img.visible, True)
        #self.assertEqual(txt.visible, True)

        # testing "size" property
        # getter
        self.assertEqual(g.size, (1.0, 1.0))
        self.assertEqual(g.width, 1.0)
        self.assertEqual(g.height, 1.0)

        img.position = (0.0, 0.0, 0.0)
        self.assertEqual(g.size, (2.0, 2.0))
        self.assertEqual(g.width, 2.0)
        self.assertEqual(g.height, 2.0)

        txt.size = (0.5, 0.5)
        self.assertEqual(g.size, (1.5, 1.5))
        self.assertEqual(g.width, 1.5)
        self.assertEqual(g.height, 1.5)

        txt.position = (0.0, 1.0, 1.0)
        self.assertEqual(g.size, (1.0, 1.5))
        self.assertEqual(g.width, 1.0)
        self.assertEqual(g.height, 1.5)

        # setter
        g.size = (1.0, 1.5)
        self.assertEqual(g.size, (1.0, 1.5))
        self.assertEqual(txt.size, (0.5, 0.5))
        self.assertEqual(txt.position, (0.0, 1.0, 1.0))
        self.assertEqual(img.size, (1.0, 1.0))
        self.assertEqual(img.position, (0.0, 0.0, 0.0))

        g.size = (2.0, 1.5)
        self.assertEqual(g.size, (2.0, 1.5))
        self.assertEqual(txt.size, (1.0, 0.5))
        self.assertEqual(txt.position, (0.0, 1.0, 1.0))
        self.assertEqual(img.size, (2.0, 1.0))
        self.assertEqual(img.position, (0.0, 0.0, 0.0))

        g.size = (2.0, 3.0)
        self.assertEqual(g.size, (2.0, 3.0))
        self.assertEqual(txt.size, (1.0, 1.0))
        self.assertEqual(txt.position, (0.0, 2.0, 1.0))
        self.assertEqual(img.size, (2.0, 2.0))
        self.assertEqual(img.position, (0.0, 0.0, 0.0))


    def test_two_empty_group(self):
        canvas = pgm.Canvas()
        # testing "opacity" property
        g_parent = Group(canvas)
        g_child = Group(canvas)
        self.assertEqual(g_parent.position, (0.0, 0.0, 0.0))
        self.assertEqual(g_parent.absolute_position, (0.0, 0.0, 0.0))

        g_parent.add(g_child)
        self.assertEqual(g_child.position, (0.0, 0.0, 0.0))
        g_child.position = (0.5, 0.5, 0.5)
        self.assertEqual(g_parent.position, (0.0, 0.0, 0.0))
        self.assertEqual(g_parent.absolute_position, (0.0, 0.0, 0.0))
        self.assertEqual(g_child.position, (0.5, 0.5, 0.5))
        self.assertEqual(g_child.absolute_position, (0.5, 0.5, 0.5))

        g_parent.position = (1.0, 1.0, 1.0)
        self.assertEqual(g_parent.position, (1.0, 1.0, 1.0))
        self.assertEqual(g_parent.absolute_position, (1.0, 1.0, 1.0))
        self.assertEqual(g_child.position, (0.5, 0.5, 0.5))
        self.assertEqual(g_child.absolute_position, (1.5, 1.5, 1.5))

        g_child2 = Group(canvas)
        g_child2.position = (0.2, 0.2, 0.2)
        g_parent.add(g_child2)
        self.assertEqual(g_child2.absolute_position, (1.2, 1.2, 1.2))

        # testing "opacity" property
        g_parent.opacity = 128
        g_child.opacity = 64
        self.assertEqual(g_parent.opacity, 128)
        self.assertEqual(g_child.opacity, 64)
        opacity = math.floor(g_child.opacity * g_child.parent.absolute_opacity_factor)
        self.assertEqual(opacity, 32)
        g_child.opacity = 32
        self.assertEqual(g_child.opacity, 32)
        opacity = math.floor(g_child.opacity * g_child.parent.absolute_opacity_factor)
        self.assertEqual(opacity, 16)
        g_child.opacity = 128
        self.assertEqual(g_child.opacity, 128)
        opacity = math.floor(g_child.opacity * g_child.parent.absolute_opacity_factor)
        self.assertEqual(opacity, 64)

        # testing "visible" property
        g_parent.visible = True
        g_child.visible = True
        self.assertEqual(g_parent.visible, True)
        self.assertEqual(g_child.visible, True)

        g_parent.visible = False
        self.assertEqual(g_parent.visible, False)
        self.assertEqual(g_child.visible, False)

        g_child.visible = False
        self.assertEqual(g_child.visible, False)

        g_child.visible = True
        self.assertEqual(g_parent.visible, False)
        self.assertEqual(g_child.visible, False)

        g_child2.visible = True
        self.assertEqual(g_child.visible, False)

        g_parent.visible = True
        self.assertEqual(g_parent.visible, True)
        self.assertEqual(g_child.visible, True)
        self.assertEqual(g_child2.visible, True)

        g_parent.visible = False
        self.assertEqual(g_parent.visible, False)
        self.assertEqual(g_child.visible, False)
        self.assertEqual(g_child2.visible, False)

        g_parent.visible = True
        g_child.visible = False
        g_child2.visible = True
        self.assertEqual(g_parent.visible, True)
        self.assertEqual(g_child.visible, False)
        self.assertEqual(g_child2.visible, True)

        g_parent.visible = False
        self.assertEqual(g_parent.visible, False)
        self.assertEqual(g_child.visible, False)
        self.assertEqual(g_child2.visible, False)

        g_parent.visible = True
        self.assertEqual(g_parent.visible, True)
        self.assertEqual(g_child.visible, False)
        self.assertEqual(g_child2.visible, True)


    def test_two_empty_group2(self):
        canvas = pgm.Canvas()
        g=Group(canvas)
        img=Image()
        self.assertEqual(img.parent_visibility, True)
        g.add(img)
        self.assertEqual(img.parent_visibility, False)



    def test_two_group(self):
        canvas = pgm.Canvas()
        # testing "position" property
        g_parent=Group(canvas)
        img=Image()
        txt=Text()
        img.position=(1.0, 1.0, 1.0)
        txt.position=(1.0, 1.0, 1.0)
        g_parent.add(img)
        g_parent.add(txt)
        g_parent.position=(0.5, 0.5, 0.5)
        self.assertEqual(img.position, (1.0, 1.0, 1.0))
        self.assertEqual(txt.position, (1.0, 1.0, 1.0))
        self.assertEqual(g_parent.position, (0.5, 0.5, 0.5))
        self.assertEqual(pgm.Image.get_position(img), (1.5, 1.5, 1.5))
        self.assertEqual(pgm.Image.get_position(txt), (1.5, 1.5, 1.5))

        img2=Image()
        img2.position=(2.0, 2.0, 2.0)
        txt2=Text()
        txt2.position=(2.0, 2.0, 2.0)
        g_child=Group(canvas)
        g_child.add(img2)
        g_child.add(txt2)
        g_parent.add(g_child)
        g_child.position=(1.0, 1.0, 1.0)
        self.assertEqual(pgm.Image.get_position(img2), (3.5, 3.5, 3.5))
        self.assertEqual(pgm.Text.get_position(txt2), (3.5, 3.5, 3.5))

        # testing "opacity" property
        g_parent.opacity=255
        g_child.opacity=128
        img.opacity=128
        img2.opacity=128
        txt.opacity=128
        txt2.opacity=128
        self.assertEqual(g_parent.opacity, 255)
        self.assertEqual(g_child.opacity, 128)
        self.assertEqual(img.opacity, 128)
        self.assertEqual(img2.opacity, 128)
        self.assertEqual(txt.opacity, 128)
        self.assertEqual(txt2.opacity, 128)
        self.assertEqual(pgm.Image.get_opacity(img), 128)
        self.assertEqual(pgm.Image.get_opacity(img2), 64)
        self.assertEqual(pgm.Text.get_opacity(txt), 128)
        self.assertEqual(pgm.Text.get_opacity(txt2), 64)

        g_parent.opacity=128
        g_child.opacity=128
        img.opacity=128
        img2.opacity=128
        txt.opacity=128
        txt2.opacity=128
        self.assertEqual(g_parent.opacity, 128)
        self.assertEqual(g_child.opacity, 128)
        opacity = math.floor(g_child.opacity * g_child.parent.absolute_opacity_factor)
        self.assertEqual(opacity, 64)
        self.assertEqual(img.opacity, 128)
        self.assertEqual(img2.opacity, 128)
        self.assertEqual(txt.opacity, 128)
        self.assertEqual(txt2.opacity, 128)
        self.assertEqual(pgm.Image.get_opacity(img), 64)
        self.assertEqual(pgm.Image.get_opacity(img2), 32)
        self.assertEqual(pgm.Text.get_opacity(txt), 64)
        self.assertEqual(pgm.Text.get_opacity(txt2), 32)

        img.opacity=255
        img2.opacity=64
        txt.opacity=255
        txt2.opacity=64
        self.assertEqual(img.opacity, 255)
        self.assertEqual(img2.opacity, 64)
        self.assertEqual(txt.opacity, 255)
        self.assertEqual(txt2.opacity, 64)
        self.assertEqual(pgm.Image.get_opacity(img), 128)
        self.assertEqual(pgm.Image.get_opacity(img2), 16)
        self.assertEqual(pgm.Text.get_opacity(txt), 128)
        self.assertEqual(pgm.Text.get_opacity(txt2), 16)


        # testing "visible" property
        g_parent.visible = True
        g_child.visible = True
        img.visible = True
        img2.visible = False
        self.assertEqual(g_parent.visible, True)
        self.assertEqual(g_child.visible, True)
        self.assertEqual(img.visible, True)
        self.assertEqual(img2.visible, False)

        g_child.visible = False
        self.assertEqual(g_child.visible, False)
        self.assertEqual(img2.visible, False)

        g_child.visible = True
        self.assertEqual(g_child.visible, True)
        self.assertEqual(img2.visible, False)

        g_parent.visible = False
        self.assertEqual(g_child.visible, False)
        self.assertEqual(img2.visible, False)

        g_parent.visible = True
        self.assertEqual(g_child.visible, True)
        self.assertEqual(img2.visible, False)

        img2.visible = True
        self.assertEqual(img2.visible, True)

        g_child.visible = False
        self.assertEqual(img2.visible, False)

        g_parent.visible = False
        self.assertEqual(img2.visible, False)
        g_child.visible = True
        self.assertEqual(img2.visible, False)

        g_parent.visible = True
        self.assertEqual(img2.visible, True)

    def test_two_groups2(self):
        canvas = pgm.Canvas()
        g_parent=Group(canvas)
        g_child=Group(canvas)
        img=Image()
        txt=Text()
        g_child.add(img)
        g_child.add(txt)
        g_parent.add(g_child)

        g_parent.position=(1.0, 0.0, 0.0)
        self.assertEqual(pgm.Image.get_position(img), (1.0, 0.0, 0.0))
        self.assertEqual(pgm.Text.get_position(txt), (1.0, 0.0, 0.0))

        g_child.position=(0.0, 1.0, 0.0)
        self.assertEqual(pgm.Image.get_position(img), (1.0, 1.0, 0.0))
        self.assertEqual(pgm.Text.get_position(txt), (1.0, 1.0, 0.0))


    def test_two_groups3(self):
        canvas = pgm.Canvas()
        g_parent=Group(canvas)
        g_child=Group(canvas)
        img=Image()

        g_child.add(img)
        g_parent.y=2.0
        g_child.position=(1.0, 0.0, 0.0)
        g_parent.add(g_child)
        self.assertEqual(g_child.absolute_position, (1.0, 2.0, 0.0))
        self.assertEqual(pgm.Image.get_position(img), (1.0, 2.0, 0.0))

    def test_three_groups(self):
        canvas = pgm.Canvas()
        g_p = Group(canvas)
        g_a = Group(canvas)
        g_b = Group(canvas)
        img = Image()

        g_p.add(g_a)
        g_a.add(g_b)
        g_b.add(img)

        img.x = 1.0
        g_a.x = 1.0
        g_p.x = 1.0
        g_b.x = 1.0

        self.assertEqual(pgm.Image.get_position(img), (4.0, 0.0, 0.0))

    def test_remove_elements_from_group(self):
        canvas = pgm.Canvas()
        g_parent = Group(canvas)
        i_child_a = Image()
        i_child_b = Image()
        i_child_c = Image()
        i_child_d = Image()
        
        # before insertion in group
        self.assertEqual(sys.getrefcount(g_parent), 2)
        self.assertEqual(sys.getrefcount(i_child_a), 3)
        self.assertEqual(sys.getrefcount(i_child_b), 3)
        self.assertEqual(sys.getrefcount(i_child_c), 3)
        self.assertEqual(sys.getrefcount(i_child_d), 3)
        self.assertEqual(i_child_a.__gstrefcount__, 1)
        self.assertEqual(i_child_b.__gstrefcount__, 1)
        self.assertEqual(i_child_c.__gstrefcount__, 1)
        self.assertEqual(i_child_d.__gstrefcount__, 1)

        g_parent.add(i_child_a)
        g_parent.add(i_child_b)
        g_parent.add(i_child_c)
        g_parent.add(i_child_d)

        # after insertion in the group
        self.assertEqual(sys.getrefcount(i_child_a), 4)
        self.assertEqual(sys.getrefcount(i_child_b), 4)
        self.assertEqual(sys.getrefcount(i_child_c), 4)
        self.assertEqual(sys.getrefcount(i_child_d), 4)
        self.assertEqual(i_child_a.__gstrefcount__, 2)
        self.assertEqual(i_child_b.__gstrefcount__, 2)
        self.assertEqual(i_child_c.__gstrefcount__, 2)
        self.assertEqual(i_child_d.__gstrefcount__, 2)

        # progressive removal
        self.assertEqual(len(g_parent.children), 4)

        g_parent.remove(i_child_b)
        self.assertEqual(len(g_parent.children), 3)
        self.assertEqual(sys.getrefcount(i_child_b), 3)
        self.assertEqual(i_child_b.__gstrefcount__, 1)

        g_parent.remove(i_child_a)
        self.assertEqual(sys.getrefcount(i_child_a), 3)
        self.assertEqual(i_child_a.__gstrefcount__, 1)

        g_parent.remove(i_child_c)
        self.assertEqual(len(g_parent.children), 1)
        self.assertEqual(sys.getrefcount(i_child_c), 3)
        self.assertEqual(i_child_c.__gstrefcount__, 1)

        g_parent.remove(i_child_d)
        self.assertEqual(len(g_parent.children), 0)
        self.assertEqual(sys.getrefcount(i_child_d), 3)
        self.assertEqual(i_child_d.__gstrefcount__, 1)

    def test_remove_groups_from_group(self):
        canvas = pgm.Canvas()
        g_parent = Group(canvas)
        g_child1 = Group(canvas)
        g_child2 = Group(canvas)

        # before insertion in group
        self.assertEqual(sys.getrefcount(g_parent), 2)
        self.assertEqual(sys.getrefcount(g_child1), 2)
        self.assertEqual(sys.getrefcount(g_child2), 2)

        g_parent.add(g_child1)
        g_parent.add(g_child1)

        # after insertion of one group twice in the parent group
        self.assertEqual(sys.getrefcount(g_parent), 3)
        self.assertEqual(sys.getrefcount(g_child1), 3)
        self.assertEqual(sys.getrefcount(g_child2), 2)
        self.assertEqual(len(g_parent.children), 1)


        g_parent.add(g_child2)

        # after insertion of the second group in the parent group
        self.assertEqual(sys.getrefcount(g_parent), 4)
        self.assertEqual(sys.getrefcount(g_child1), 3)
        self.assertEqual(sys.getrefcount(g_child2), 3)
        self.assertEqual(len(g_parent.children), 2)

        g_parent.remove(g_child1)

        # after removal of one group from the parent group
        self.assertEqual(sys.getrefcount(g_parent), 3)
        self.assertEqual(sys.getrefcount(g_child1), 2)
        self.assertEqual(sys.getrefcount(g_child2), 3)
        self.assertEqual(len(g_parent.children), 1)

        g_parent.remove(g_child2)

        # after removal of the other group from the parent group
        self.assertEqual(sys.getrefcount(g_parent), 2)
        self.assertEqual(sys.getrefcount(g_child1), 2)
        self.assertEqual(sys.getrefcount(g_child2), 2)
        self.assertEqual(len(g_parent.children), 0)

        g_parent.remove(g_child2)

        # after removal of the other group from the parent group
        self.assertEqual(sys.getrefcount(g_parent), 2)
        self.assertEqual(sys.getrefcount(g_child1), 2)
        self.assertEqual(sys.getrefcount(g_child2), 2)
        self.assertEqual(len(g_parent.children), 0)
