/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL plugin
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Arek Korbik <arkadini@gmail.com>
 */

#ifndef __PGM_AGL_BACKEND_H__
#define __PGM_AGL_BACKEND_H__

#include <OpenGL/gl.h>
#include <AGL/agl.h>
#include "pgmbackend.h"

G_BEGIN_DECLS

#define PGM_TYPE_AGL_BACKEND (pgm_agl_backend_get_type ())
#define PGM_AGL_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_AGL_BACKEND, PgmAglBackend))
#define PGM_AGL_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_AGL_BACKEND, PgmAglBackendClass))
#define PGM_IS_AGL_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_AGL_BACKEND))
#define PGM_IS_AGL_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_AGL_BACKEND))
#define PGM_AGL_BACKEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_AGL_BACKEND, PgmAglBackendClass))

typedef struct _PgmAglBackend      PgmAglBackend;
typedef struct _PgmAglBackendClass PgmAglBackendClass;

struct _PgmAglBackend {
  PgmBackend parent;

  /* Window management & OS X stuff */
  WindowRef win;
  CFBundleRef gl_bundle_ref;
  EventHandlerUPP app_event_handler;
  EventHandlerUPP win_event_handler;

  /* OpenGL context handling */
  AGLContext ctx;
  AGLPixelFormat pixfmt;
  gint currentVS;

  /* Display lists to rasterize X fonts (for debugging purpose) */
  guint text_lists;

  /* Screen informations */
  gint resolution_width;
  gint resolution_height;
  gint size_mm_width;
  gint size_mm_height;

  /* Whether window and context are created */
  gboolean created;
};

struct _PgmAglBackendClass {
  PgmBackendClass parent_class;
};

GType       pgm_agl_backend_get_type (void) G_GNUC_CONST;

PgmBackend *pgm_agl_backend_new      (PgmContext *context);

G_END_DECLS

#endif /* __PGM_AGL_BACKEND_H__ */
