# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python tools
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Mirco Müller <macslow@bangang.de>


import pgm
from pypgmtools.graph.text import Text
from list import *

class TextList(List):

    def __init__(self,
                 canvas,
                 layer,
                 font_family       = "Sans",
                 font_height       = 0.1,
                 fg_color          = (255, 255, 255, 255),
                 bg_color          = (0, 0, 0, 0),
                 width             = 1.0,
                 height            = 2.0,
                 visible_items     = 7,
                 orientation       = VERTICAL,
                 selected_item     = 0,
                 selector_file     = None,
                 selector_offset   = (0.0, 0.0, 0.0),
                 selector_size     = (1.0, 1.0)):
        List.__init__(self,
                      canvas,
                      layer,
                      width,
                      height,
                      visible_items,
                      orientation,
                      selected_item,
                      selector_file,
                      selector_offset,
                      selector_size)

        self._font_family      = font_family
        self._font_height      = font_height
        self._fg_color         = fg_color
        self._bg_color         = bg_color

    def font_family__get(self):
        return self._font_family

    def font_family__set(self, font_family):
        self._font_family = font_family
        self._layout()
        self._update()

    def font_height__get(self):
        return self._font_height

    def font_height__set(self, font_height):
        self._font_height = font_height
        for widget in self.widgets:
            widget.font_height = font_height

        self._layout()
        self._update()

    def fg_color__set(self, color):
        self._fg_color = color
        self._layout()
        self._update()

    def bg_color__set(self, color):
        self._bg_color = color
        self._layout()
        self._update()

    def insert(self, index, label):
        txt = Text()
        txt.label = label
        txt.font_family = self._font_family
        txt.font_height = self._font_height
        txt.fg_color = self._fg_color
        txt.bg_color = self._bg_color
        txt.opacity = 0
        txt.ellipsize = pgm.TEXT_ELLIPSIZE_END

        List.insert(self, index, txt)


# this is a simple example, showing off how the widget looks and behaves
if __name__ == "__main__":
    import pgm
    import gobject
    from pypgmtools.timing.implicit import AnimatedObject

    def on_key_press(viewport,
                     event,
                     gl,
                     widget,
                     animated_widget,
                     step_size):
        if event.type == pgm.KEY_PRESS:
                # also quit on q or ESC
                if event.keyval == pgm.keysyms.q or event.keyval == pgm.keysyms.Escape:
                    pgm.main_quit()

                # move the widget up
                elif event.keyval == pgm.keysyms.w:
                    widget.y -= step_size

                # move the widget down
                elif event.keyval == pgm.keysyms.s:
                    widget.y += step_size

                # move the widget left
                elif event.keyval == pgm.keysyms.a:
                    widget.x -= step_size

                # move the widget right
                elif event.keyval == pgm.keysyms.d:
                    widget.x += step_size

                # move down in the list
                elif event.keyval == pgm.keysyms.Down:
                    list_widget.selected_item += 1

                # move down in the list
                elif event.keyval == pgm.keysyms.Up:
                    list_widget.selected_item -= 1

                # add an example entry at the 3rd position
                # FIXME: wrong key symbol
                elif event.keyval == pgm.keysyms.space:
                    list_widget.insert(2, "Kekse")

                # remove the currently selected item
                # FIXME: wrong key symbol
                elif event.keyval == pgm.keysyms.Return:
                    list_widget.pop(list_widget.selected_item)

    def on_delete(viewport, event):
        pgm.main_quit()

    # OpenGL viewport creation
    factory = pgm.ViewportFactory('opengl')
    gl = factory.create()
    gl.title = 'TextList widget-test'

    # Canvas and image drawable creation
    canvas = pgm.Canvas()

    # Bind the canvas to the OpenGL viewport
    gl.set_canvas(canvas)
    gl.show()

    list_widget = TextList(canvas, pgm.DRAWABLE_MIDDLE)
    list_widget.position = (0.2, 0.0, 0.0)
    list_widget.font_family = "Bitstream DejaVu"
    list_widget.font_height = 0.225
    list_widget.fg_color = (255, 255, 255, 255)
    list_widget.bg_color = (0, 0, 0, 0)
    list_widget.width = 1.5
    list_widget.height = 2.5
    list_widget.append("DVD")
    list_widget.append("Web")
    list_widget.append("Radio")
    list_widget.append("Music")
    list_widget.append("flickr")
    list_widget.append("Photos")
    list_widget.append("Audio")
    list_widget.append("iTunes")
    list_widget.append("Video")
    list_widget.append("Internets")
    list_widget.append("Foo-Bar")
    list_widget.append("Office")
    list_widget.append("uPNP")
    list_widget.append("DAAP")
    list_widget.append("Movies")
    list_widget.visible_items = 7
    list_widget.selected_item = 3
    list_widget.visible = True

    animated_list_widget = AnimatedObject(list_widget)

    # Let's start a mainloop
    gl.connect('key-press-event',
               on_key_press,
               gl,
               list_widget,
               animated_list_widget,
               0.25)
    gl.connect('delete-event', on_delete)
    gobject.timeout_add(10, gl.update)
    pgm.main()
