/*
Copyright (c) 2008-2010
	Lars-Dominik Braun <PromyLOPh@lavabit.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef _CRYPT_KEY_INPUT_H
#define _CRYPT_KEY_INPUT_H

#include <stdint.h>

/* decryption key for last 48 bytes of audio urls
 * search for rpc.input in the decompiled pandora actionscript
 */

const unsigned int in_key_n = 16;

static const uint32_t in_key_p [16 + 2] = {
		0x81A0D315L, 0x62EE1AE1L, 0xA464BCC1L, 0x3BA1681EL,
		0x95F51922L, 0xD23ADF85L, 0x454592EFL, 0xEF7E7533L,
		0x502B8DF3L, 0xA3D1BC15L, 0x5548A7C4L, 0x8C91C026L,
		0x16EA1478L, 0x64BF6223L, 0x3CEF49B3L, 0xB4053114L,
		0x3D5034E6L, 0xDC0A7EF9L,
		};

static const uint32_t in_key_s [4][256] = {{
		0xD917FE9FL, 0x0415253BL, 0x083ED0BEL, 0xE8FDFF96L,
		0xF160743CL, 0x0A2A426CL, 0x8B4C86A0L, 0x239474CEL,
		0xCA0CCA8FL, 0x4CB2A8A0L, 0x5F2D5947L, 0xE7DF1D06L,
		0xED666D53L, 0xCDE0F6AAL, 0x4F5136FEL, 0xAD78E4C9L,
		0x36695B87L, 0x7512CA0FL, 0x7A3AFCA8L, 0x92BE5537L,
		0x586E9827L, 0x6CD158CDL, 0x3ABEC6C1L, 0x844E3243L,
		0xF4F6DA5DL, 0x070021EFL, 0xFFCF8CEFL, 0x2636B763L,
		0x2E1150F3L, 0xDE157BEFL, 0xB3AE8FDCL, 0xA402474CL,
		0x9B1E8377L, 0x14C51EA4L, 0x7E90973AL, 0x52087D2CL,
		0xC08FD313L, 0x43CA6149L, 0xE340346BL, 0x083198CAL,
		0x6430D9F8L, 0xA64E607FL, 0x540CC1C6L, 0x4E5160FFL,
		0xB2513F00L, 0xF98F447AL, 0x810ABF6BL, 0x9096855BL,
		0x9AE434FDL, 0x1A01BD81L, 0x3E300842L, 0x61C50018L,
		0x4B28DB32L, 0x4CB09631L, 0xFFA521DAL, 0x14CC2650L,
		0x48F807FAL, 0xC4FAA6C0L, 0xDE6A7678L, 0xE709BF2FL,
		0xC175D659L, 0x5F23843CL, 0xF07A01FEL, 0x2739FB7EL,
		0x8C5A36A9L, 0xB0EADEA6L, 0x8B4FBFD8L, 0x4BE3679EL,
		0xD5F24F61L, 0x3A158ECEL, 0x329676B4L, 0x33F9ABC2L,
		0xD4907F47L, 0x5F354B2EL, 0xFB92B109L, 0x31EEAE70L,
		0xE9EAC38DL, 0x91DCC642L, 0xE173298BL, 0x051E8AE8L,
		0x2843FAFBL, 0xB387F8D1L, 0x980AD6AAL, 0x6EC6DE49L,
		0xE9D49EF3L, 0xAFC06576L, 0x3FD70CF0L, 0x269AAFD3L,
		0x7827EFBAL, 0xA51ADEBEL, 0x75F014CFL, 0xBA91772BL,
		0x8ABAC12DL, 0xD6C98EA7L, 0x66546028L, 0x6D50E0AEL,
		0x5C9D3C92L, 0x8095947AL, 0xF7CCE938L, 0x0D952ADAL,
		0xE5E64966L, 0x5E357512L, 0x5A7E0958L, 0x44BEB107L,
		0xED03D60EL, 0x1D652EFFL, 0x2275EA01L, 0x736831C3L,
		0xAA8B2A23L, 0x50D29632L, 0xD6CFD665L, 0x5CD7CED2L,
		0x65BB97FEL, 0x2F49D183L, 0xC09EC338L, 0x84A8DCBEL,
		0xEFF624AFL, 0xC7C1B0B5L, 0xCDFE1163L, 0x6751E288L,
		0x8B96D144L, 0xE09AB660L, 0xE91BAE11L, 0x1D097DF5L,
		0x6742E0A6L, 0x53500F63L, 0xAB090438L, 0x4040F128L,
		0xE4EFB0E0L, 0x2DE74905L, 0xFC2262C0L, 0xF4FFD6E0L,
		0xDADDDEC1L, 0xF1E0D8C0L, 0x36FBD004L, 0xEC1DE306L,
		0xA19826B4L, 0xBFAF36C7L, 0x516777B2L, 0x7B7C5DC6L,
		0xD9758DACL, 0xCD33563DL, 0x0B83FC22L, 0xB55DEB5EL,
		0x9ACF93D2L, 0x2A7B90ABL, 0xED8A4449L, 0xEA1CF38AL,
		0x5AB412A8L, 0x924F9E21L, 0x44FBDDA1L, 0xE99C321AL,
		0x5908C6CEL, 0xEE748C6DL, 0x124D6B51L, 0x7B05962CL,
		0x41D9FA9DL, 0xCCB14DBDL, 0x47FA3D9FL, 0xC68104F6L,
		0x511C7864L, 0xAB06E6CDL, 0x43FE0F54L, 0xA8331C3AL,
		0x7237FEE4L, 0x41A782A1L, 0xFEA2C7F8L, 0x2A0E9509L,
		0xB2224704L, 0x30BD541CL, 0xE177C904L, 0xF52AADD8L,
		0xEA244EA8L, 0x44E8F3A1L, 0x3B0EC183L, 0x1D2934A1L,
		0x5F550EA5L, 0x0B3E4620L, 0x94006D67L, 0xCF719E7DL,
		0xC0362EA3L, 0x1DD05063L, 0x21E557B0L, 0x34A1DFB1L,
		0x1D8582EDL, 0xA9CC3B68L, 0xCA7F7766L, 0x8876E7B0L,
		0x98AAF1A3L, 0x8C7B4649L, 0x2BBD4F71L, 0x0CFED7D5L,
		0x10336484L, 0xBAABD1D2L, 0x0DB5C3F3L, 0x250E18F3L,
		0x8A683DBBL, 0x46D87FC0L, 0x447C934EL, 0xB8A5178EL,
		0xCD83EEC2L, 0x82053D3FL, 0xA6172A7CL, 0xCE4B68E0L,
		0x50BFC9AFL, 0xA0C2BECBL, 0x69F8DE09L, 0x1BCC95C6L,
		0xCC8D91A3L, 0xE6DB39E3L, 0xA1FCE775L, 0xA3B597DFL,
		0x111CD9BEL, 0x26A5F501L, 0x56FCF9E1L, 0x2269E3B4L,
		0xAE97B607L, 0x04DFD213L, 0xD2502840L, 0x20A4DA45L,
		0x58EA780EL, 0x6AC470A2L, 0xFC90AA5BL, 0x0CF03917L,
		0x077DEC5CL, 0xF87A2BB2L, 0xA8BFD2B7L, 0x29CA7541L,
		0x6CEE0D2AL, 0x7E592E80L, 0x5CA17FD7L, 0x2DEB3F06L,
		0x070F47B7L, 0xF106EA36L, 0x49A80A00L, 0xC34E6467L,
		0xE537C2C5L, 0x23332658L, 0x00226F13L, 0x67E82FF4L,
		0x18126492L, 0x36E2C3B8L, 0x34FB0831L, 0x2AB02E28L,
		0x24FECC70L, 0x0E6E9168L, 0x86EC355EL, 0x34D09F1AL,
		0x343EEA56L, 0x324CA69CL, 0xDD85FDE3L, 0x228935F6L,
		0x3E520289L, 0xC06612ACL, 0xA6FDB351L, 0x29769037L,
		},{
		0xA1ED8646L, 0x78B0F130L, 0xB80E4F6DL, 0xB3F25B0DL,
		0xA1AF13EEL, 0xFB71D142L, 0xED6CC1D8L, 0x4EAE4AFFL,
		0x5C31D7AAL, 0x04DE3FBBL, 0x8D29E45DL, 0x8148FC65L,
		0x6BAACD11L, 0x615D39AEL, 0x87655C9FL, 0x226F4F08L,
		0x232A7047L, 0x7287D274L, 0xF078C150L, 0xBCD9C5B5L,
		0xE2F4010AL, 0x000D95AFL, 0x2A9FDA25L, 0xB4CE09D8L,
		0x1FAFF986L, 0x3276A088L, 0x65DF02B1L, 0xF9B75FE7L,
		0x58145A9EL, 0xE2F93A2CL, 0xDD170A40L, 0xE6088DC2L,
		0xD6766114L, 0x88D8995EL, 0x429AFEEAL, 0xFEB7E26CL,
		0x4C41D510L, 0x4B1509B2L, 0x5445A40FL, 0x26B14A90L,
		0xF3D465D4L, 0x20F710ACL, 0xC80BBFE8L, 0xBA9C1ABCL,
		0xF807EF33L, 0xFF107E9EL, 0xC171F48EL, 0x2AC2EE26L,
		0x8E68407AL, 0x01DC082FL, 0xCBC10314L, 0x1F193C51L,
		0xDDFF57FFL, 0x84494A20L, 0x02C89B2BL, 0xCC8B55C4L,
		0xF2E568A1L, 0xC52F326BL, 0xFD4827D5L, 0x6C3F05E5L,
		0xA3E5B47DL, 0x6A2DA767L, 0x832A6751L, 0x055985DFL,
		0x27D5A6CDL, 0xEEB25748L, 0xE60EAECEL, 0x5BEA030FL,
		0x1E36551AL, 0xE18AB6E8L, 0xCAE0C750L, 0x06A76E82L,
		0xCC562165L, 0xD45F5C2BL, 0x7F16470CL, 0xA8D495F5L,
		0xEA204FC7L, 0x3E9F4AC3L, 0xF408527FL, 0x9C2464D2L,
		0x2322FF71L, 0x0C629EE9L, 0x72FBE895L, 0x622638DAL,
		0xE5737C33L, 0x0E5A0207L, 0x1CB77EC7L, 0xEF12CDCAL,
		0x3D6A066CL, 0x1FD05DDDL, 0x16654480L, 0xE98719B2L,
		0x8CB9129FL, 0xAD2C07E4L, 0xA7E0D2DAL, 0x95AD3088L,
		0x770BE826L, 0x33353308L, 0xDB053D32L, 0xFBEEA722L,
		0xA0FBD4C3L, 0xCD57A408L, 0xAA1BBCABL, 0x013D007DL,
		0x25288D7BL, 0x5D45778AL, 0x904C200BL, 0x6CC8B50DL,
		0x03E0996DL, 0x1ECF9F23L, 0x446B1877L, 0x716FE26CL,
		0x0663DF9EL, 0x5AFB6E28L, 0x2715440BL, 0x42488497L,
		0xBF39BE28L, 0x4B227B91L, 0x02573AC5L, 0x0114691FL,
		0x96148EE7L, 0x762D908DL, 0xAEBE6962L, 0x534755F5L,
		0xFD0E05D7L, 0x050F9096L, 0x56F2F735L, 0xC773AF72L,
		0x9BAEFDEEL, 0x4FD21579L, 0x9673784AL, 0x3A7C8E5BL,
		0xF8255977L, 0xC6735487L, 0x9FDD06F2L, 0xF5E93C50L,
		0x745E3507L, 0xC4498EF9L, 0x5F590D15L, 0xB112137BL,
		0xC1BA3760L, 0x6BC2F1E3L, 0xCE91D9A8L, 0xFB586E03L,
		0x2915F799L, 0x81026163L, 0x1B4A8994L, 0xF25FF806L,
		0x3183173BL, 0xD217BA20L, 0x7F0D4F8DL, 0x95002D07L,
		0x5B8BC8DFL, 0x1FE178EBL, 0x27FAA511L, 0x60FCABA7L,
		0x21B9C00CL, 0x615E4AB3L, 0x94D6179CL, 0xED295168L,
		0x2DD86730L, 0xF1C2EE31L, 0xC9540C67L, 0xA5615927L,
		0xC4CC60E1L, 0xF67AEE70L, 0x34931ADCL, 0xDA931D9EL,
		0xB2A5B2BEL, 0x3DDAF5E6L, 0xCD95D8D2L, 0x11246601L,
		0x7095EC8AL, 0x7D88B394L, 0xD753A26BL, 0x19B4623BL,
		0x84FEE91FL, 0x1DF96B85L, 0x5B95035CL, 0xE2E7C21FL,
		0xD8D6C558L, 0x01A7D03AL, 0xFBCE3DA8L, 0x674E7949L,
		0xE4E96BDFL, 0x7AF510D4L, 0x826B49F1L, 0x772AEC6FL,
		0x1F82EF58L, 0xF42CC2FBL, 0x4B2FB5A4L, 0x71B410DFL,
		0x0D8BB5BAL, 0x73BB0DABL, 0xEC4A1DD8L, 0xD4414C41L,
		0x9CDAF740L, 0x9ADE7B33L, 0x305838A8L, 0xB3F26A28L,
		0xEC562623L, 0x167CFC51L, 0x0FCAA250L, 0x041D6B62L,
		0x62985581L, 0x4B3221FCL, 0x9883BD0AL, 0x8390FB46L,
		0x0F0EAD1AL, 0xB7616F50L, 0xA06DFC58L, 0xFC7556FDL,
		0x8CED7720L, 0xFA64F6A3L, 0x34A2DD7DL, 0x1EE5850CL,
		0xFD381171L, 0x6D7360CEL, 0x7E514232L, 0x0B4D50C5L,
		0x46526E7CL, 0x86B62C41L, 0xB2CCB005L, 0xE9311084L,
		0x870725C6L, 0x9B9DFEA5L, 0xDCE6D317L, 0xB0CA67DFL,
		0xF1D69CF0L, 0xD0C6AE15L, 0xB3B54912L, 0xF42DF9E7L,
		0x3B8D6173L, 0x6179EBADL, 0xD3B3888DL, 0x4F626FE0L,
		0x1CC8DD99L, 0x02277661L, 0xBA6C2685L, 0xAF4BC7A7L,
		0xEA71D285L, 0x152E2B03L, 0xCCD6AD79L, 0xE917EF56L,
		0xA497FD72L, 0x2C3C919CL, 0x6323E338L, 0x0A2022C9L,
		0x3ECED49DL, 0xE53B92AFL, 0xFACA03C8L, 0xA0DF19B3L,
		0xE62C51BDL, 0x794D9BE6L, 0xF216CFF6L, 0xAA5199AAL,
		},{
		0x3E5AA0D2L, 0xF96F565AL, 0x064BC237L, 0x2830A191L,
		0xAFFB6585L, 0x6A51E367L, 0xDB3EF2CEL, 0x12A17DE6L,
		0x80ACC70FL, 0xE2D77575L, 0x7F88930FL, 0xEEC1DBBDL,
		0x2C15DFB2L, 0xCCBD0F94L, 0xF01B5F96L, 0xEC7E7426L,
		0xB6C6DF58L, 0x4FE08F4BL, 0xFFB86D7DL, 0x3BBDD4C4L,
		0xFC6F23D2L, 0x0BD775C8L, 0x5E3DD3CCL, 0x2BAC2395L,
		0xB9BD4BA1L, 0x30BD0740L, 0x0E58E7B6L, 0x6C094B5CL,
		0xCE85A2CFL, 0x951BD527L, 0x610AE7E6L, 0x6D86F9BBL,
		0x696BB5F3L, 0x674C8334L, 0xCE79ACC5L, 0xE2E54B67L,
		0xC0DE1898L, 0xAD0828DBL, 0x438192C5L, 0xC3656E96L,
		0xA355D723L, 0xB75002F4L, 0xD4888A0FL, 0xBD8B83D6L,
		0x730918E2L, 0xD2D05B7EL, 0x170624B9L, 0x297B861CL,
		0xE1F25E81L, 0x8ACCC690L, 0xECAFF183L, 0xDBFF3F92L,
		0xEC22E420L, 0x0DD6C55CL, 0xA9B6B7BBL, 0x04899DE1L,
		0xF959D8D6L, 0xF74AC6D2L, 0xDF676B4CL, 0xB985D5EEL,
		0x18990A77L, 0x86606AC5L, 0xFD5A8957L, 0x0680250BL,
		0x41356702L, 0x5F3FDDA3L, 0x2BB36DB9L, 0xCA062524L,
		0x6BCC3124L, 0x782FB20EL, 0x8A1A2732L, 0x2955EE9AL,
		0xAFAE9471L, 0x6C53772FL, 0x896B0EACL, 0x0EAB16A1L,
		0x0C9F8C5BL, 0xC748E075L, 0xF35A1A15L, 0xF9020B17L,
		0xAC725870L, 0x170D5AC5L, 0x83CE7896L, 0xE2770702L,
		0x687B4649L, 0x23546539L, 0x4938AA52L, 0x32EDFD40L,
		0xEF1D620CL, 0x4A5A8820L, 0x59F3BC4FL, 0x6D38E7C3L,
		0xFF119588L, 0x1A08B636L, 0x7237B812L, 0x2609D6C1L,
		0x109472B1L, 0x532E58EAL, 0x98673821L, 0x26B1CA99L,
		0x629C045AL, 0x2C5FD013L, 0xD05CF784L, 0x8F46DB43L,
		0x68B7E93DL, 0x7A27CBD9L, 0xA10B75CAL, 0x20008840L,
		0x12E62425L, 0x1D4CD600L, 0x89BBF2E0L, 0x6BA62E06L,
		0x19732774L, 0x3B0E85ECL, 0x7388BB95L, 0x641F1A5DL,
		0xF8FFCE8EL, 0x35E0D842L, 0xDC3C21D0L, 0x91422DDBL,
		0x6AB513BCL, 0x4D1892D8L, 0xB53BB759L, 0x23425BF1L,
		0x605FD0E5L, 0xBF2F5BEEL, 0x8A05A13EL, 0x7222CE88L,
		0x20940E3BL, 0xABC87F9DL, 0x550E24F5L, 0x8313E1D2L,
		0x11BE3DC1L, 0x7EB6F965L, 0x7C47B1F7L, 0xFCDC0754L,
		0xB2017D7BL, 0x25E22B97L, 0x8719F66FL, 0x34B61812L,
		0x9A8A7692L, 0xC95DD310L, 0x9E190BFFL, 0x4CD4C251L,
		0x9C1EB6EDL, 0x5E3192FCL, 0xFA3ED1E8L, 0x0902229BL,
		0xCC268599L, 0xF980272BL, 0x9D553D7EL, 0x1A8214E8L,
		0x3AB98766L, 0xE9E10BECL, 0xB3292413L, 0x19703684L,
		0xA8140260L, 0x25607509L, 0x7AB4E61BL, 0xA94BC1C8L,
		0x7B2D5121L, 0x0D88D70BL, 0x5BC32663L, 0xA7460604L,
		0x92434D63L, 0xC24C3F63L, 0xC9A266DFL, 0xF7223A28L,
		0x51EB733DL, 0x9AB11960L, 0x8D9A8C0CL, 0x6C7E447FL,
		0x1670F2F1L, 0x361E64D7L, 0x4E3D881EL, 0x2FE9E812L,
		0xF65E5C7BL, 0x4673ABF7L, 0xC9C68A51L, 0x711DD24AL,
		0xC6E0BE5EL, 0x646E5DC8L, 0xFD62FCE4L, 0x59A70E4AL,
		0xB78295A9L, 0x6CFC4D09L, 0xFDDF41D9L, 0xCAD9CB46L,
		0xED7E3A82L, 0xCC8397A0L, 0x00F02E2EL, 0xBB8BB1AEL,
		0xB040785DL, 0x7B14FBF1L, 0x315BB31CL, 0x6F877F42L,
		0x7A7A7183L, 0x59FBEA58L, 0x8D20F0BDL, 0x8FD197FDL,
		0x5D546F76L, 0xEE4EB057L, 0xE39F6B57L, 0x37A024B9L,
		0x173BBC5FL, 0x87EA8A22L, 0xB9A1C2D6L, 0x8ED44DECL,
		0xC7EADA8AL, 0x9826C929L, 0xE64931E9L, 0xC82801B2L,
		0xCEA9ACFBL, 0xDA2794CCL, 0xEB1C7B8EL, 0x089C36C5L,
		0xAFF20D63L, 0x032CD6CFL, 0x92B2F7D8L, 0xC6E42489L,
		0x08E0C40BL, 0x5ADC848AL, 0xBE4E086FL, 0x1AE7F83DL,
		0xA9F60F15L, 0x18B42CF4L, 0xEB99DC92L, 0xD09EEE99L,
		0x882DF495L, 0xB74CA126L, 0xC2C820DBL, 0x52376742L,
		0x740DEAE3L, 0xF2161725L, 0x99C20F21L, 0x36A14E35L,
		0xD534F963L, 0xEBF3937EL, 0xAD22797DL, 0xFA6C6B3BL,
		0x67BAD23FL, 0x38970AA6L, 0xE0B96D89L, 0x8631EF0BL,
		0xF03B322EL, 0xB862966CL, 0x144A396BL, 0x1A3596C1L,
		0x51C09C59L, 0xC727B69EL, 0x08A35938L, 0xFE775D68L,
		0xF8895727L, 0xBB2406AFL, 0x0002D523L, 0x114F3521L,
		},{
		0xFCE0BA62L, 0x9B580728L, 0x4F06FAD8L, 0x555A12D4L,
		0x3E5AE7C3L, 0x1C5AB0ADL, 0x40178012L, 0xF97BE132L,
		0xF9B812A9L, 0xCD6130B0L, 0xCEA6DB01L, 0x971C027EL,
		0x10E9FBEBL, 0xB03CE073L, 0x6C055C20L, 0x4A66F807L,
		0x6291922AL, 0x963ABEDAL, 0x5FB257B1L, 0x98B9F263L,
		0xC738F134L, 0xEFFA1C2AL, 0x474E545BL, 0x444CB3B0L,
		0x0862DC34L, 0x6139AD94L, 0x460E3C6FL, 0xB7B67E78L,
		0x9C0009E0L, 0x3279C1B7L, 0xF3B41E35L, 0xF3CCB7C2L,
		0xB2AFB6C8L, 0x433D7759L, 0xC59D628FL, 0xF758FC32L,
		0x0B1958D0L, 0xC5CB3696L, 0x762C9D08L, 0x8DCA2135L,
		0x5C9D8146L, 0x9857DEA0L, 0xF845D21EL, 0x4B4A6137L,
		0x703E9861L, 0x27E16DEAL, 0xCD4353B3L, 0x1C5F8A22L,
		0x087A6C54L, 0x02097452L, 0x6129E803L, 0x13FA9CB8L,
		0x10323CBDL, 0xAF282A80L, 0x4C362D15L, 0x73A06D5CL,
		0x3A016509L, 0x65576942L, 0xD05FF2D6L, 0xD56E287AL,
		0x3F1D2104L, 0x2220DBCFL, 0x1A8C1898L, 0xB0732BF5L,
		0x87481E45L, 0xAAD604A9L, 0x31F4A6B7L, 0x9A769BBCL,
		0xB4EAC9D8L, 0xFF7D0A36L, 0x68EB7E5EL, 0xFF61448CL,
		0xA3D67379L, 0x4B36FA6CL, 0x220EA259L, 0x70344744L,
		0x41B18739L, 0x4D1D613EL, 0x64DE7065L, 0x726386F0L,
		0xDB9E34A0L, 0xC4A48D66L, 0xECAA7940L, 0x9CB2B38DL,
		0x1C51D989L, 0x9D9D47C7L, 0x51A92095L, 0x940DA179L,
		0xE2A2B9E2L, 0x05ADE31AL, 0xEE6B7C6DL, 0xF7B95A8FL,
		0x7DE793F0L, 0x32030AAAL, 0x353E0AD8L, 0xABDEB660L,
		0xC08E3257L, 0x9C434B65L, 0xE0BE2547L, 0x6AD549BFL,
		0x78B33263L, 0x576AD11CL, 0x7B59868CL, 0xC14C15FDL,
		0xABCAF02FL, 0xDF9062C8L, 0x864FAB21L, 0x661DFDBDL,
		0xAF3ED0A1L, 0xDBF4788AL, 0x572E40B7L, 0x0125B278L,
		0xB38CE858L, 0x7B3E4F56L, 0x3DA41EF9L, 0x7FA73018L,
		0x42097E40L, 0x23E2372BL, 0x66BDD881L, 0x566E3049L,
		0x6D0BA8C6L, 0x82ABC0A9L, 0xEA0F3332L, 0x91867254L,
		0xE122E5A3L, 0x6721E2F4L, 0xB58AF103L, 0xC83F6ABBL,
		0x5AC34206L, 0x677A5C26L, 0xEA19BAEFL, 0xDFA6DFB1L,
		0x11E0B3DFL, 0xD8238967L, 0x22AB2A52L, 0xAD800D8BL,
		0x7EFF0B14L, 0xBA38161FL, 0x0464AFB0L, 0x9137F1CAL,
		0x8B1778BBL, 0x937367E5L, 0x69C65AC1L, 0xCD0ACEACL,
		0xEAF76E7DL, 0xEF1596A4L, 0x0BA74934L, 0x23157AE4L,
		0xB7A151A0L, 0x39333E4CL, 0xE016BA38L, 0x9AFC2062L,
		0x4EE00DF0L, 0x60852091L, 0x32165EBFL, 0xC33DA8FEL,
		0xC5C89B6FL, 0xE28312F6L, 0x5EDF8D22L, 0x45F821A0L,
		0xF62FFED8L, 0xD1E7494EL, 0x85E8132CL, 0xB137DC87L,
		0x6800BF67L, 0xD648B744L, 0x30A6FA8BL, 0x4392C76AL,
		0xC41FB333L, 0x717E4103L, 0xD2A01FB3L, 0xF5572AFBL,
		0x2BB6E1FEL, 0xC5830CB9L, 0x0E4AA1B4L, 0xE27B1223L,
		0x01A28090L, 0x21674712L, 0xE65378FCL, 0x76B04D74L,
		0xB30885BFL, 0xC1894800L, 0x399428EEL, 0x976BA25DL,
		0x2ABD29E6L, 0xD3189CADL, 0xF6D2D0F6L, 0x55A17317L,
		0xAF1E8DF2L, 0xECBA699FL, 0xC9A6F1EEL, 0x662F5B28L,
		0xF16261CEL, 0x77411859L, 0x5018AA12L, 0xFABEFBF5L,
		0xD5DEF730L, 0x9979BE47L, 0x43354449L, 0xC4C699EFL,
		0x8F1556C9L, 0xFEEB944EL, 0xC73D9B33L, 0x85CEF02DL,
		0xEE8215C0L, 0x920E5437L, 0x60C8C2C2L, 0x5EAA9EB3L,
		0xF03605A5L, 0x8B607885L, 0x021894CCL, 0x2E855034L,
		0xED8A21DEL, 0xB4025DD3L, 0x5B6D2326L, 0xBE953409L,
		0xE78C2FD0L, 0xC9D04C2FL, 0xCDE0ED2DL, 0x3CA468B4L,
		0xF21E9A54L, 0x16C486C9L, 0x6A4B7834L, 0x7DCE3D37L,
		0x79B9B2D6L, 0x8110817AL, 0xBCDA6EBDL, 0xA3FAA681L,
		0x7054A90CL, 0x1144971FL, 0xD5487688L, 0x84D7760EL,
		0x571114FAL, 0x4EE4C565L, 0x1940E6E8L, 0xF7960077L,
		0xC0453E75L, 0x57A2F234L, 0x07BF50DAL, 0x33FD5F36L,
		0x0133C1C1L, 0x340EB759L, 0xA3AC3E07L, 0x7ECEA617L,
		0xE220D43DL, 0x20680396L, 0xEF9A1430L, 0x21C8D51AL,
		0x513A1648L, 0x55A9D9A8L, 0xB32595FFL, 0x81767024L,
		0x57CD5E89L, 0x8C53DB62L, 0x368B41CCL, 0xAF56D83EL,
		}};

#endif /* _CRYPT_KEY_INPUT_H */
