<?php

/**************************************************************************
 * A PHP 4 class to manipulate HTML forms.
 *
 * Copyright (C) 2001, Matthew Palmer.  Released under the GPL version 2.
 * You should have received a copy of this licence with this software, if not
 * see http://www.fsf.org/copyleft/gpl.html for a full copy of the licence.
 */

// $Id: form_class.inc,v 1.1.1.1 2001/12/30 02:39:25 mjp16 Exp $

error_reporting(E_ALL);

require_once("lib/form/textbox.inc");
require_once("lib/form/select.inc");
require_once("lib/form/textarea.inc");
require_once("lib/form/submit.inc");

require_once("lib/form/element.inc");

class Form extends formElement {
	var $types;
	var $elements;
	var $method;
	var $action;
	
	function Form($name) {
		$this->types = array("textbox" => "formTextbox",
			"textarea" => "formTextarea",
			"select" => "formSelect",
			"submit" => "formSubmit");
		parent::formElement($name);
		$this->method = "post";
		$this->action = "";
	}
	 
	function Element($type, $name) {
		$type = $this->types[$type];
		$this->elements[$name] = new $type($name);
	}
	
	function Values() {
		$vals = array();
		foreach ($this->elements as $name => $el) {
			echo "<!-- VALS: $name = ".$el->getVal()." -->\n";
			$vals[$name] = $el->getVal();
		}
		return $vals;
	}

	function HTML($body = NULL) {
		$ev = parent::HTML();
		$retval = "<form method=\"$this->method\" action=\"$this->action\"$ev>\n";
		if ($body == NULL) {
			foreach ($this->elements as $el) {
				$retval .= $el->HTML();
			}
		} else {
			$retval .= $body;
		}
		$retval .= "</form>\n";
		
		return $retval;
	}
}

?>
