<?php
	/**
	* Application configuration in a centralized location
	* @author Joseph Engo <jengo@phpgroupware.org>
	* @author Dave Hall - skwashd at phpgroupware.org
	* @copyright Copyright (C) 2000-2004 Free Software Foundation, Inc. http://www.fsf.org/
	* @license http://www.gnu.org/licenses/lgpl.html GNU Lesser General Public License
	* @package phpgwapi
	* @subpackage application
	* @version $Id: class.config.inc.php,v 1.7.2.1.2.6 2005/08/09 13:04:56 skwashd Exp $
	*/

	/**
	* Application configuration in a centralized location
	*
	* @package phpgwapi
	* @subpackage application
	*/
	class config
	{
		var $db;
		var $appname;
		var $config_data;

		function config($appname = '')
		{
			if (! $appname)
			{
				$appname = $GLOBALS['phpgw_info']['flags']['currentapp'];
			}

			$this->db      = $GLOBALS['phpgw']->db;
			$this->appname = $appname;
		}

		function read_repository()
		{
			$this->db->query("select * from phpgw_config where config_app='" . $this->appname . "'",__LINE__,__FILE__);
			while ($this->db->next_record())
			{
				$test = @unserialize($this->db->f('config_value', true));
				if($test)
				{
					$this->config_data[$this->db->f('config_name')] = $test;
				}
				else
				{
					$this->config_data[$this->db->f('config_name')] = $this->db->f('config_value', true);
				}
			}
		}

		function save_repository()
		{
			if ( is_array($this->config_data) && count($this->config_data) )
			{
				$config_data =& $this->config_data;
				
				$this->db->lock(array('phpgw_config', 'phpgw_app_sessions'));
				//$this->db->query("DELETE FROM phpgw_config WHERE config_app = '{$this->appname}'",__LINE__,__FILE__); //someone removed this without a proper explanation!
				if($this->appname == 'phpgwapi')
				{
					$this->db->query('DELETE FROM phpgw_app_sessions'
						. ' WHERE sessionid = \'0\''
							. ' AND loginid = 0'
							. " AND app = '{$this->appname}'"
							. ' AND location = \'config\'',
						__LINE__, __FILE__);
				}

				foreach($config_data as $name => $value)
				{
					if( is_array($value) || is_object($value) )
					{
						$value = serialize($value);
					}

					$name  = $this->db->db_addslashes($name);
					$value = $this->db->db_addslashes($value);
					$this->db->query("DELETE FROM phpgw_config WHERE config_name='{$name}'", __LINE__, __FILE__);

					$query = "INSERT INTO phpgw_config (config_app,config_name,config_value)"
						. " VALUES ('{$this->appname}', '{$name}', '{$value}')";
					$this->db->query($query, __LINE__, __FILE__);
				}
				$this->db->unlock();
			}
		}

		function delete_repository()
		{
			$this->db->query("DELETE FROM phpgw_config WHERE config_app = '{$this->appname}'", __LINE__, __FILE__);
		}

		function value($variable_name, $variable_data)
		{
			$this->config_data[$variable_name] = $variable_data;
		}
	}
?>
