<?php
	/*******************************************************************\
	* phpGroupWare - Projects                                           *
	* http://www.phpgroupware.org                                       *
	* This program is part of the GNU project, see http://www.gnu.org/	*
	*                                                                   *
	* Project Manager                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright 2000 - 2003 Free Software Foundation, Inc               *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.soprojecthours.inc.php,v 1.8.4.8 2003/06/20 22:04:32 ceb Exp $ */
	// $Source: /cvsroot/phpgroupware/projects/inc/class.soprojecthours.inc.php,v $

	class soprojecthours
	{
		var $db;
		var $grants;

		function soprojecthours()
		{
			$this->db		= $GLOBALS['phpgw']->db;
			$this->db2		= $this->db;
			$this->account	= $GLOBALS['phpgw_info']['user']['account_id'];
		}

		function read_hours($start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $state, $project_id)
		{
			if ($order)
			{
				$ordermethod = " order by $order $sort";
			}
			else
			{
				$ordermethod = ' order by start_date asc';
			}

			$filtermethod = ' project_id =' . intval($project_id);

			if ($state != 'all')
			{
				$filtermethod .= " AND status='$state'";
			}

			if ($filter == 'yours')
			{
				$filtermethod .= ' AND employee=' . $this->account;
			}

			if ($query)
			{
				$querymethod = " AND (remark like '%$query%' OR minutes like '%$query%' OR hours_descr like '%$query%')";
			}

			$sql = "SELECT * FROM phpgw_p_hours WHERE $filtermethod $querymethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			while ($this->db->next_record())
			{
				$hours[] = array
				(
					'hours_id'		=> $this->db->f('id'),
					'project_id'	=> $this->db->f('project_id'),
					'hours_descr'	=> $this->db->f('hours_descr'),
					'status'		=> $this->db->f('status'),
					'sdate'			=> $this->db->f('start_date'),
					'edate'			=> $this->db->f('end_date'),
					'minutes'		=> $this->db->f('minutes'),
					'employee'		=> $this->db->f('employee')
				);
			}
			return $hours;
		}

		function read_single_hours($hours_id)
		{
			$this->db->query('SELECT * from phpgw_p_hours WHERE id=' . $hours_id,__LINE__,__FILE__);
	
			while($this->db->next_record())
			{
				$hours['hours_id']		= $this->db->f('id');
				$hours['project_id']	= $this->db->f('project_id');
				$hours['pro_parent']	= $this->db->f('pro_parent');
				$hours['hours_descr']	= $this->db->f('hours_descr');
				$hours['status']		= $this->db->f('status');
				$hours['ae_minutes']	= $this->db->f('minutes');
				$hours['sdate']			= $this->db->f('start_date');
				$hours['edate']			= $this->db->f('end_date');
				$hours['employee']		= $this->db->f('employee');
				$hours['activity_id']	= $this->db->f('activity_id');
				$hours['remark']		= $this->db->f('remark');
				$hours['minperae']		= $this->db->f('minperae');
				$hours['billperae']		= $this->db->f('billperae');
			}
			return $hours;
		}

		function add_hours($values)
		{
			$values['ae_minutes']	= $values['hours']*60+$values['minutes'];
			$values['hours_descr']	= $this->db->db_addslashes($values['hours_descr']);
			$values['remark']		= $this->db->db_addslashes($values['remark']);

			$this->db->query('INSERT into phpgw_p_hours (project_id,activity_id,entry_date,start_date,end_date,hours_descr,remark,minutes,'
							. 'status,minperae,billperae,employee,pro_parent) VALUES (' . intval($values['project_id']) . ',' . intval($values['activity_id']) . ','
							. time() . ',' . intval($values['sdate']) . ',' . intval($values['edate']) . ",'" . $values['hours_descr'] . "','"
							. $values['remark'] . "'," . intval($values['ae_minutes']) . ",'" . $values['status'] . "'," . intval($values['minperae'])
							. ',' . $values['billperae'] . ',' . intval($values['employee']) . ',' . intval($values['pro_parent']) . ')',__LINE__,__FILE__); 
		}

		function edit_hours($values)
		{
			$values['ae_minutes']	= $values['hours']*60+$values['minutes'];
			$values['hours_descr']	= $this->db->db_addslashes($values['hours_descr']);
			$values['remark']		= $this->db->db_addslashes($values['remark']);

			$this->db->query('UPDATE phpgw_p_hours SET activity_id=' . intval($values['activity_id']) . ',entry_date=' . time() . ',start_date='
							. intval($values['sdate']) . ',end_date=' . intval($values['edate']) . ",hours_descr='" . $values['hours_descr'] . "',remark='"
							. $values['remark'] . "',minutes=" . intval($values['ae_minutes']) . ",status='" . $values['status'] . "',minperae="
							. intval($values['minperae']) . ',billperae=' . $values['billperae'] . ',employee=' . intval($values['employee'])
							. ' where id=' . intval($values['hours_id']),__LINE__,__FILE__);
		}

		function delete_hours($hours_id)
		{
			$this->db->query('Delete from phpgw_p_hours where id=' . intval($hours_id),__LINE__,__FILE__);
		}

		function update_hours_act($activity_id, $minperae)
		{
			$this->db->query('SELECT id,minperae from phpgw_p_hours where activity_id=' . intval($activity_id),__LINE__,__FILE__); 

			while ($this->db->next_record())
			{
				if ($this->db->f('minperae') == 0)
				{
					$hours[] = $this->db->f('id');
				}
			}

			if (is_array($hours))
			{
				for ($i=0;$i<=count($hours);$i++)
				{
					$this->db->query('UPDATE phpgw_p_hours set minperae=' . intval($minperae) . ' WHERE id=' . intval($hours[$i]),__LINE__,__FILE__);
				}
			}
		}

		function get_time_used($project_id)
		{
			$this->db->query('SELECT SUM(minutes) as utime from phpgw_p_hours where (project_id=' . intval($project_id) . ' OR pro_parent='
							. intval($project_id) . ')',__LINE__,__FILE__);
			if ($this->db->next_record())
			{
				return $this->db->f('utime');
			}
		}
	}
?>
