<?php
/** 
*
* common [Catalan]
*
* @package language
* @version $Id: common.php 9464 2009-04-17 15:52:40Z acydburn $
* @copyright (c) 2005 phpBB Group 
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste: 
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '<a href="http://abrodos.wordpress.com/phpbb/">Traducció del phpBB: Isaac Garcia Abrodos</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'ca',

	'1_DAY'			=> '1 dia',
	'1_MONTH'		=> '1 mes',
	'1_YEAR'		=> '1 any',
	'2_WEEKS'		=> '2 setmanes',
	'3_MONTHS'		=> '3 mesos',
	'6_MONTHS'		=> '6 mesos',
	'7_DAYS'		=> '7 dies',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'El vostre compte ja ha estat activat.',
	'ACCOUNT_DEACTIVATED'			=> 'El vostre compte ha estat desactivat manualment. Només el pot reactivar un administrador.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'El vostre compte encara no ha estat activat.',
	'ACP'							=> 'Tauler de control de l’administrador',
	'ACTIVE'						=> 'actiu',
	'ACTIVE_ERROR'					=> 'L’usuari especificat actualment està inactiu. Si teniu problemes per activar el vostre compte, poseu-vos en contacte amb l’administrador del fòrum.',
	'ADMINISTRATOR'					=> 'Administrador',
	'ADMINISTRATORS'				=> 'Administradors',
	'AGE'							=> 'Edat',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Permès',
	'ALL_FILES'						=> 'Tots el fitxers',
	'ALL_FORUMS'					=> 'Tots els fòrums',
	'ALL_MESSAGES'					=> 'Tots els missatges',
	'ALL_POSTS'						=> 'Totes les entrades',
	'ALL_TIMES'						=> 'Totes les hores són %1$s %2$s',
	'ALL_TOPICS'					=> 'Tots els temes',
	'AND'							=> 'I',
	'ARE_WATCHING_FORUM'			=> 'Esteu subscrits per rebre un avís si hi ha entrades noves en aquest fòrum.',
	'ARE_WATCHING_TOPIC'			=> 'Esteu subscrits per rebre un avís si hi ha entrades noves en aquest tema.',
	'ASCENDING'						=> 'Ascendent',
	'ATTACHMENTS'					=> 'Fitxers adjunts',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'La imatge que heu intentat adjuntar no és vàlida.',
	'AUTHOR'						=> 'Autor',
	'AUTH_NO_PROFILE_CREATED'		=> 'No s’ha pogut crear el perfil d’usuari.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'El fitxer a penjar ha estat rebutjat perquè s’ha identificat com un possible vector d’atac.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'No es pot mostrar aquest fitxer perquè l’extensió <strong>%s</strong> no està permesa.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'No s’ha penjat l’avatar especificat perquè les dades remotes no són vàlides o estan corruptes.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'El fitxer de l’avatar penjat està buit.',
	'AVATAR_INVALID_FILENAME'		=> '%s és un nom de fitxer no vàlid.',
	'AVATAR_NOT_UPLOADED'			=> 'No s’ha pogut penjar l’avatar.',
	'AVATAR_NO_SIZE'				=> 'L’amplària o l’alçària de l’avatar no s’han pogut determinar. Si us plau, introduïu-les manualment.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'El fitxer especificat només s’ha carregat parcialment.',
	'AVATAR_PHP_SIZE_NA'			=> 'La mida del fitxer d’avatar és massa gran.<br />No s’ha pogut determinar la mida màxima permesa definida a php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'La mida del fitxer d’avatar és massa gran. La mida màxima permesa és de %1$d %2$s.<br />Si us plau, tingueu en compte que això es defineix al fitxer php.ini i no es pot sobreescriure.',
	'AVATAR_URL_INVALID'			=> 'L’URL que heu especificat no és vàlida.',
	'AVATAR_URL_NOT_FOUND'			=> 'No s’ha pogut trobar el fitxer especificat.',
	'AVATAR_WRONG_FILESIZE'			=> 'El fitxer d’avatar ha de tenir una mida entre 0 i %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'L’avatar tramès té %5$d píxels d’amplària i %6$d píxels d’alçària. Els avatars han de tenir com a mínim %1$d píxels d’amplària i %2$d píxels d’alçària, i com a màxim %3$d píxels d’amplària i %4$d píxels d’alçària.',

	'BACK_TO_TOP'			=> 'Torna a l’inici',
	'BACK_TO_PREV'			=> 'Torna a la pàgina anterior',
	'BAN_TRIGGERED_BY_EMAIL'=> 'La vostra adreça electrònica està suspesa.',
	'BAN_TRIGGERED_BY_IP'	=> 'La vostra adreça IP està suspesa.',
	'BAN_TRIGGERED_BY_USER'	=> 'El vostre nom d’usuari està suspès.',
	'BBCODE_GUIDE'			=> 'Guia del BBCode',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Aniversaris',
	'BOARD_BAN_PERM'		=> 'Se us ha suspès <strong>permanentment</strong> en aquest fòrum.<br /><br />Si us plau, poseu-vos en contacte amb l’%2$sadministrador del fòrum%3$s per obtenir més informació.',
	'BOARD_BAN_REASON'		=> 'Raó de la suspensió: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Se us ha suspès en aquest fòrum fins el <strong>%1$s</strong>.<br /><br />Si us plau, poseu-vos en contacte amb l’%2$sadministrador del fòrum%3$s per obtenir més informació.',
	'BOARD_DISABLE'			=> 'Actualment aquest fòrum no està disponible.',
	'BOARD_DISABLED'		=> 'Actualment aquest fòrum està inhabilitat.',
	'BOARD_UNAVAILABLE'		=> 'El fòrum està temporalment no disponible, si us plau intenteu-ho d’aquí a uns minuts.',
	'BROWSING_FORUM'		=> 'Usuaris navegant en aquest fòrum: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Usuaris navegant en aquest fòrum: %1$s i %2$d visitant',
	'BROWSING_FORUM_GUESTS'	=> 'Usuaris navegant en aquest fòrum: %1$s i %2$d visitants',
	'BYTES'					=> 'Bytes',

	'CANCEL'				=> 'Cancel·la',
	'CHANGE'				=> 'Canvia',
	'CHANGE_FONT_SIZE'		=> 'Canvia la mida de la lletra',
	'CHANGING_PREFERENCES'	=> 'S’estan canviant les preferències del fòrum',
	'CHANGING_PROFILE'		=> 'S’està canviant la configuració del perfil',
	'CLICK_VIEW_PRIVMSG'	=> '%sVes a la meva bústia d’entrada%s',
	'COLLAPSE_VIEW'			=> 'Redueix la vista',
	'CLOSE_WINDOW'			=> 'Tanca la finestra',
	'COLOUR_SWATCH'			=> 'Paleta de colors',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Confirmació',
	'CONFIRM_CODE'			=> 'Codi de confirmació',
	'CONFIRM_CODE_EXPLAIN'	=> 'Introduïu el codi tal com es mostra. No es distingeix entre majúscules i minúscules.',
	'CONFIRM_CODE_WRONG'	=> 'El codi de confirmació que heu introduït és incorrecte.',
	'CONFIRM_OPERATION'		=> 'Esteu segur que voleu dur a terme aquesta operació?',
	'CONGRATULATIONS'		=> 'Felicitats a ',
	'CONNECTION_FAILED'		=> 'La connexió ha fallat.',
	'CONNECTION_SUCCESS'	=> 'La connexió ha tingut èxit!',
	'COOKIES_DELETED'		=> 'Totes les galetes del fòrum s’han eliminat correctament.',
	'CURRENT_TIME'			=> 'Hora i data actual: %s',

	'DAY'					=> 'Dia',
	'DAYS'					=> 'Dies',
	'DELETE'				=> 'Elimina',
	'DELETE_ALL'			=> 'Elimina-ho tot',
	'DELETE_COOKIES'		=> 'Elimina totes les galetes del fòrum',
	'DELETE_MARKED'			=> 'Elimina els elements marcats',
	'DELETE_POST'			=> 'Elimina l’entrada',
	'DELIMITER'				=> 'Delimitador',
	'DESCENDING'			=> 'Descendent',
	'DISABLED'				=> 'Inhabilitat',
	'DISPLAY'				=> 'Mostra',
	'DISPLAY_GUESTS'		=> 'Mostra els visitants',
	'DISPLAY_MESSAGES'		=> 'Mostra els missatges dels darrers',
	'DISPLAY_POSTS'			=> 'Mostra les entrades dels darrers',
	'DISPLAY_TOPICS'		=> 'Mostra els temes dels darrers',
	'DOWNLOADED'			=> 'Baixat',
	'DOWNLOADING_FILE'		=> 'S’està baixant el fitxer',
	'DOWNLOAD_COUNT'		=> 'S’ha baixat %d vegada',
	'DOWNLOAD_COUNTS'		=> 'S’ha baixat %d vegades',
	'DOWNLOAD_COUNT_NONE'	=> 'Encara no s’ha baixat',
	'VIEWED_COUNT'			=> 'S’ha visualitzat %d vegada',
	'VIEWED_COUNTS'			=> 'S’ha visualitzat %d vegades',
	'VIEWED_COUNT_NONE'		=> 'Encara no s’ha visualitzat',

	'EDIT_POST'							=> 'Edita l’entrada',
	'EMAIL'								=> 'Correu electrònic', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Adreça electrònica',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'S’ha produït un error en enviar l’e-mail a la <strong>línia %1$s</strong>. Resposta: %2$s.',
	'EMPTY_SUBJECT'						=> 'Heu d’especificar un assumpte quan publiqueu un tema nou.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Heu d’especificar un assumpte quan redacteu un missatge nou.',
	'ENABLED'							=> 'Habilitat',
	'ENCLOSURE'							=> 'Document adjunt',
	'ENTER_USERNAME'					=> 'Introduïu el nom d’usuari',
	'ERR_CHANGING_DIRECTORY'			=> 'No s’ha pogut canviar el directori.',
	'ERR_CONNECTING_SERVER'				=> 'S’ha produït un error en connectar amb el servidor.',
	'ERR_JAB_AUTH'						=> 'No se us ha pogut autoritzar al servidor Jabber.',
	'ERR_JAB_CONNECT'					=> 'No s’ha pogut connectar amb el servidor Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'El nom d’usuari o contrasenya especificats són incorrectes.',
	'ERR_UNWATCHING'					=> 'S’ha produït un error en intentar cancel·lar la subscripció.',
	'ERR_WATCHING'						=> 'S’ha produït un error en intentar crear la subscripció.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'El camí especificat per al phpBB no és vàlid.',
	'EXPAND_VIEW'						=> 'Amplia la vista',
	'EXTENSION'							=> 'Extensió',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'S’ha desactivat l’extensió <strong>%s</strong> i ja no es pot mostrar.',

	'FAQ'					=> 'PMF',
	'FAQ_EXPLAIN'			=> 'Preguntes més freqüents',
	'FILENAME'				=> 'Nom del fitxer',
	'FILESIZE'				=> 'Mida del fitxer',
	'FILEDATE'				=> 'Data del fitxer',
	'FILE_COMMENT'			=> 'Comentari del fitxer',
	'FILE_NOT_FOUND'		=> 'No s’ha trobat el fitxer sol·licitat.',
	'FIND_USERNAME'			=> 'Cerca un membre',
	'FOLDER'				=> 'Carpeta',
	'FORGOT_PASS'			=> 'He oblidat la meva contrasenya',
	'FORM_INVALID'			=> 'El formulari tramès no és vàlid. Intenteu tornar a trametre’l.',
	'FORUM'					=> 'Fòrum',
	'FORUMS'				=> 'Fòrums',
	'FORUMS_MARKED'			=> 'Els fòrums s’han marcat com a llegits.',
	'FORUM_CAT'				=> 'Categoria del fòrum',
	'FORUM_INDEX'			=> 'Índex del fòrum',
	'FORUM_LINK'			=> 'Enllaç del fòrum',
	'FORUM_LOCATION'		=> 'Ubicació del fòrum',
	'FORUM_LOCKED'			=> 'Fòrum tancat',
	'FORUM_RULES'			=> 'Regles del fòrum',
	'FORUM_RULES_LINK'		=> 'Si us plau feu clic aquí per veure les regles del fòrum',
	'FROM'					=> 'des de',
	'FSOCK_DISABLED'		=> 'No s’ha pogut completar l’operació perquè s’ha inhabilitat la funció <var>fsockopen</var> o bé no s’ha trobat el servidor consultat.',
	'FSOCK_TIMEOUT'			=> 'S’ha excedit el temps d’espera mentre es llegia el flux de dades de la xarxa.',

	'FTP_FSOCK_HOST'				=> 'Servidor FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Servidor FTP utilitzat per connectar-vos al vostre lloc web.',
	'FTP_FSOCK_PASSWORD'			=> 'Contrasenya FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Contrasenya del vostre usuari FTP.',
	'FTP_FSOCK_PORT'				=> 'Port FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port utilitzat per connectar-vos al servidor.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Camí fins al phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Camí des del directori arrel fins al fòrum phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'Temps d’espera FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'El temps, en segons, que el sistema s’esperarà per una resposta del servidor.',
	'FTP_FSOCK_USERNAME'			=> 'Nom d’usuari FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nom d’usuari per connectar-vos al servidor.',

	'FTP_HOST'					=> 'Servidor FTP',
	'FTP_HOST_EXPLAIN'			=> 'Servidor FTP utilitzat per connectar-vos al vostre lloc web.',
	'FTP_PASSWORD'				=> 'Contrasenya FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Contrasenya del vostre usuari FTP.',
	'FTP_PORT'					=> 'Port FTP',
	'FTP_PORT_EXPLAIN'			=> 'Port utilitzat per connectar-vos al servidor.',
	'FTP_ROOT_PATH'				=> 'Camí fins al phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Camí des del directori arrel fins al fòrum phpBB.',
	'FTP_TIMEOUT'				=> 'Temps d’espera FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'El temps, en segons, que el sistema s’esperarà per una resposta del servidor.',
	'FTP_USERNAME'				=> 'Nom d’usuari FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Nom d’usuari per connectar-vos al servidor.',

	'GENERAL_ERROR'				=> 'Error general',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'D’acord',
	'GOTO_PAGE'					=> 'Ves a la pàgina',
	'GROUP'						=> 'Grup',
	'GROUPS'					=> 'Grups',
	'GROUP_ERR_TYPE'			=> 'Heu especificat un tipus de grup inapropiat.',
	'GROUP_ERR_USERNAME'		=> 'No heu especificat un nom per al grup.',
	'GROUP_ERR_USER_LONG'		=> 'El noms de grup no poden tenir més de 60 caràcters. El nom de grup que heu especificat és massa llarg.',
	'GUEST'						=> 'Visitant',
	'GUEST_USERS_ONLINE'		=> 'Hi ha %d visitants connectats',
	'GUEST_USERS_TOTAL'			=> '%d visitants',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Hi ha 0 visitants connectats',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 visitants',
	'GUEST_USER_ONLINE'			=> 'Hi ha %d visitant connectat',
	'GUEST_USER_TOTAL'			=> '%d visitant',
	'G_ADMINISTRATORS'			=> 'Administradors',
	'G_BOTS'					=> 'Robots',
	'G_GUESTS'					=> 'Visitants',
	'G_REGISTERED'				=> 'Usuaris registrats',
	'G_REGISTERED_COPPA'		=> 'Usuaris COPPA registrats',
	'G_GLOBAL_MODERATORS'		=> 'Moderadors globals',
	'G_NEWLY_REGISTERED'		=> 'Nous usuaris registrats',

	'HIDDEN_USERS_ONLINE'			=> '%d usuaris ocults connectats',
	'HIDDEN_USERS_TOTAL'			=> '%d ocults',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d ocults i ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 usuaris ocults connectats',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 ocults',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 ocults i ',
	'HIDDEN_USER_ONLINE'			=> '%d usuari ocult connectat',
	'HIDDEN_USER_TOTAL'				=> '%d ocult',
	'HIDDEN_USER_TOTAL_AND'			=> '%d ocult i ',
	'HIDE_GUESTS'					=> 'Oculta els visitants',
	'HIDE_ME'						=> 'Oculta la meva presència durant aquesta sessió',
	'HOURS'							=> 'Hores',
	'HOME'							=> 'Inici',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Estat ICQ',
	'IF'						=> 'Si',
	'IMAGE'						=> 'Imatge',
	'IMAGE_FILETYPE_INVALID'	=> 'El tipus d’imatge %d per al tipus MIME %s no està permès.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Tipus d’imatge incorrecte: l’extensió esperada és %1$s però s’ha rebut l’extensió %2$s.',
	'IN'						=> 'a',
	'INDEX'						=> 'Pàgina d’índex',
	'INFORMATION'				=> 'Informació',
	'INTERESTS'					=> 'Aficions',
	'INVALID_DIGEST_CHALLENGE'	=> 'Intent d’autenticació invalid.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> possiblement una adreça electrònica no vàlida?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'La vostra IP %1$s està bloquejada perquè és en una llista negra. Podeu trobar més detalls a <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Membre des de',
	'JUMP_PAGE'				=> 'Introduïu el número de la pàgina a la que desitgeu anar',
	'JUMP_TO'				=> 'Salta a ',
	'JUMP_TO_PAGE'			=> 'Feu clic per saltar a la pàgina…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Darrera entrada',
	'LAST_UPDATED'						=> 'Actualitzat per darrera vegada',
	'LAST_VISIT'						=> 'Darrera visita',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Extensió LDAP no disponible.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'No s’ha pogut connectar amb el servidor LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'S’ha produït un error mentre es cercava el directori LDAP.',
	'LEGEND'							=> 'Llegenda',
	'LOCATION'							=> 'Ubicació',
	'LOCK_POST'							=> 'Bloqueja l’entrada',
	'LOCK_POST_EXPLAIN'					=> 'Impedeix l’edició',
	'LOCK_TOPIC'						=> 'Bloqueja el tema',
	'LOGIN'								=> 'Inicia la sessió',
	'LOGIN_CHECK_PM'					=> 'Inicieu una sessió per revisar els vostres missatges privats.',
	'LOGIN_CONFIRMATION'				=> 'Confirmació d’inici de sessió',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Per tal de prevenir l’entrada il·licita en comptes mitjançant la força bruta cal que introduïu un codi de confirmació després d’un nombre màxim d’intents fallits d’inici de sessió. El codi es mostra en la imatge que veieu a sota. Si teniu problemes de visió o per alguna raó no podeu llegir aquest codi, si us plau poseu-vos en contacte amb l’%sadministrador del fòrum%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Heu excedit el nombre màxim d’intents permesos per iniciar la sessió. A més del vostre nom d’usuari i contrasenya també heu de resoldre el CAPTCHA que hi ha a sota.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'No us heu autenticat amb l’Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Heu especificat una contrasenya incorrecta. Si us plau comproveu la vostra contrasenya i intenteu-ho una altra vegada. Si continueu tenint problemes, poseu-vos en contacte amb l’%sadministrador del fòrum%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'No s’ha pogut convertir la vostra contrasenya durant l’actualització d’aquest fòrum. Si us plau %sdemaneu una nova contrasenya%s. Si continueu tenint problemes poseu-vos en contate amb l’%sadministrador del fòrum%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Heu especificat un nom d’usuari incorrecte. Si us plau comproveu el vostre nom d’usuari i intenteu-ho una altra vegada. Si continueu tenint problemes, poseu-vos en contacte amb l’%sadministrador del fòrum%s.',
	'LOGIN_FORUM'						=> 'Per veure o publicar entrades en aquest fòrum heu d’introduir la seva contrasenya.',
	'LOGIN_INFO'						=> 'Per iniciar una sessió heu d’estar registrats. Registrar-se només costa una estona i us dóna noves capacitats. L’administrador del fòrum també pot donar permisos addicionals als usuaris registrats. Abans de registrar-vos assegureu-vos de que coneixeu les condicions d’ús. Si us plau, assegureu-vos de llegir les regles del fòrum mentre hi navegueu.',
	'LOGIN_VIEWFORUM'					=> 'Per veure aquest fòrum heu d’estar registrats i haver iniciat la sessió.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Per editar aquesta entrada del fòrum heu d’estar registrats i haver iniciat la sessió.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Per veure la llista d’usuaris connectats heu d’estar registrats i haver iniciat la sessió.',
	'LOGOUT'							=> 'Finalitza la sessió',
	'LOGOUT_USER'						=> 'Finalitza la sessió [ %s ]',
	'LOG_ME_IN'							=> 'Inicia la sessió a cada visita automàticament',

	'MARK'					=> 'Marca',
	'MARK_ALL'				=> 'Marca’ls tots',
	'MARK_FORUMS_READ'		=> 'Marca els fòrums com a llegits',
	'MARK_SUBFORUMS_READ'	=> 'Marca els subfòrums com a llegits',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Tauler de control del moderador',
	'MEMBERLIST'			=> 'Membres',
	'MEMBERLIST_EXPLAIN'	=> 'Veure la llista completa de membres',
	'MERGE'					=> 'Combina',
	'MERGE_POSTS'			=> 'Mou les entrades',
	'MERGE_TOPIC'			=> 'Combina el tema',
	'MESSAGE'				=> 'Missatge',
	'MESSAGES'				=> 'Missatges',
	'MESSAGE_BODY'			=> 'Cos del missatge',
	'MINUTES'				=> 'Minuts',
	'MODERATE'				=> 'Modera',
	'MODERATOR'				=> 'Moderador',
	'MODERATORS'			=> 'Moderadors',
	'MONTH'					=> 'Mes',
	'MOVE'					=> 'Desplaça',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'El membre més recent és <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Missatge nou',
	'NEW_MESSAGES'				=> 'Missatges nous',
	'NEW_PM'					=> '<strong>%d</strong> missatge nou',
	'NEW_PMS'					=> '<strong>%d</strong> miissatges nous',
	'NEW_POST'					=> 'Entrada nova',		// Not used anymore
	'NEW_POSTS'					=> 'Entrades noves',	// Not used anymore
	'NEXT'						=> 'Següent',			// Used in pagination
	'NEXT_STEP'					=> 'Següent',
	'NEVER'						=> 'Mai',
	'NO'						=> 'No',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'No se us permet gestionar aquest grup.',
	'NOT_AUTHORISED'			=> 'No esteu autoritzat a accedir a aquesta àrea.',
	'NOT_WATCHING_FORUM'		=> 'Ja no esteu subscrit a les actualitzacións d’aquest fòrum.',
	'NOT_WATCHING_TOPIC'		=> 'Ja no esteu subscrit a aquest tema.',
	'NOTIFY_ADMIN'				=> 'Si us plau aviseu l’administrador del fòrum o l’administrador de webs.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Si us plau aviseu l’administrador del fòrum o l’administrador de webs: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'No se us permet accedir a aquest fitxer.',
	'NO_ACTION'					=> 'No s’ha especificat cap acció.',
	'NO_ADMINISTRATORS'			=> 'No hi ha cap administrador.',
	'NO_AUTH_ADMIN'				=> 'No teniu accés al Tauler de control de l’administrador perquè no teniu permisos administratius.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'No podeu reautenticar-vos com un usuari diferent.',
	'NO_AUTH_OPERATION'			=> 'No teniu els permisos necessaris per completar aquesta operació.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'No s’ha pogut connectar amb el servidor SMTP : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Avui no hi ha cap aniversari',
	'NO_EMAIL_MESSAGE'			=> 'El correu electrònic està buit',
	'NO_EMAIL_RESPONSE_CODE'	=> 'No s’han pogut obtenir els codis de resposta del servidor de correu.',
	'NO_EMAIL_SUBJECT'			=> 'No s’ha especificat l’assumpte del correu electrònic.',
	'NO_FORUM'					=> 'El fòrum que heu seleccionat no existeix.',
	'NO_FORUMS'					=> 'No hi ha cap fòrum.',
	'NO_GROUP'					=> 'El grup d’usuaris sol·licitat no existeix.',
	'NO_GROUP_MEMBERS'			=> 'Actualment aquest grup no té cap membre.',
	'NO_IPS_DEFINED'			=> 'No s’han definit adreces IP ni noms d’amfitrió',
	'NO_MEMBERS'				=> 'No s’ha trobat cap membre amb aquests criteris de cerca.',
	'NO_MESSAGES'				=> 'No hi ha cap missatge',
	'NO_MODE'					=> 'No s’ha especificat cap mode.',
	'NO_MODERATORS'				=> 'No hi ha cap moderador.',
	'NO_NEW_MESSAGES'			=> 'No hi ha missatges nous',
	'NO_NEW_PM'					=> '<strong>0</strong> missatges nous',
	'NO_NEW_POSTS'				=> 'No hi ha entrades noves',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'No hi ha cap usuari registrat',
	'NO_POSTS'					=> 'No hi ha cap entrada',
	'NO_POSTS_TIME_FRAME'		=> 'No existeix cap entrada en aquest tema per al període de temps seleccionat.',
	'NO_FEED_ENABLED'			=> 'No hi ha canals d’informació disponibles en aquest fòrum.',
	'NO_FEED'					=> 'El canal d’informació sol·licitat no està disponible.',
	'NO_SUBJECT'				=> 'No s’ha especificat cap assumpte',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'El mòdul de cerca especificat no existeix.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'No hi ha cap dels mètodes d’autenticació permesos.',
	'NO_TOPIC'					=> 'El tema sol·licitat no existeix.',
	'NO_TOPIC_FORUM'			=> 'El tema o fòrum ja no existeix.',
	'NO_TOPICS'					=> 'No hi temes ni entrades en aquest fòrum.',
	'NO_TOPICS_TIME_FRAME'		=> 'No existeix cap tema en aquest fòrum per al període de temps seleccionat.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> missatges no llegits',
	'NO_UNREAD_POSTS'			=> 'No hi ha entrades no llegides',
	'NO_UPLOAD_FORM_FOUND'		=> 'S’ha iniciat la cárrega però no s’ha trobat un formulari de càrrega de fitxer vàlid.',
	'NO_USER'					=> 'L’usuari sol·licitat no existeix.',
	'NO_USERS'					=> 'Els usuaris sol·licitats no existeixen.',
	'NO_USER_SPECIFIED'			=> 'No s’ha especificat cap nom d’usuari.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Cap entrada a la cua',		// 0
		1			=> '1 entrada a la cua',		// 1
		2			=> '%d entrades a la cua',		// 2+
	),

	'OCCUPATION'				=> 'Feina',
	'OFFLINE'					=> 'Desconnectat',
	'ONLINE'					=> 'Connectat',
	'ONLINE_BUDDIES'			=> 'Amics connectats',
	'ONLINE_USERS_TOTAL'		=> 'En total hi ha <strong>%d</strong> usuaris connectats :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'En total hi ha <strong>0</strong> usuaris connectats :: ',
	'ONLINE_USER_TOTAL'			=> 'En total hi ha <strong>%d</strong> usuari connectat :: ',
	'OPTIONS'					=> 'Opcions',

	'PAGE_OF'				=> 'Pàgina <strong>%1$d</strong> de <strong>%2$d</strong>',
	'PASSWORD'				=> 'Contrasenya',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Reproduir fitxer Quicktime',
	'PM'					=> 'MP',
	'PM_REPORTED'			=> 'Feu clic per veure l’informe',
	'POSTING_MESSAGE'		=> 'Està enviant el missatge en %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Està redactant un missatge privat',
	'POST'					=> 'Entrada',
	'POST_ANNOUNCEMENT'		=> 'Avís',
	'POST_STICKY'			=> 'Tema recurrent',
	'POSTED'				=> 'Publicat',
	'POSTED_IN_FORUM'		=> 'a',
	'POSTED_ON_DATE'		=> 'Data:',
	'POSTS'					=> 'Entrades',
	'POSTS_UNAPPROVED'		=> 'Com a mínim una de les entrades d’aquest tema no han estat aprovades.',
	'POST_BY_AUTHOR'		=> 'Autor:',
	'POST_BY_FOE'			=> 'Aquesta entrada l’ha escrit <strong>%1$s</strong> el qual és a la vostra llista d’usuaris ignorats. %2$sMostra aquesta entrada%3$s.',
	'POST_DAY'				=> '%.2f entrades per dia',
	'POST_DETAILS'			=> 'Detalls de l’entrada',
	'POST_NEW_TOPIC'		=> 'Publica un nou tema',
	'POST_PCT'				=> '%.2f%% de totes les entrades',
	'POST_PCT_ACTIVE'		=> '%.2f%% de les entrades de l’usuari',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% de les vostres entrades',
	'POST_REPLY'			=> 'Envia una resposta',
	'POST_REPORTED'			=> 'Feu clic per veure l’informe',
	'POST_SUBJECT'			=> 'Assumpte de l’entrada',
	'POST_TIME'				=> 'Data de l’entrada',
	'POST_TOPIC'			=> 'Publica un nou tema',
	'POST_UNAPPROVED'		=> 'Aquesta entrada està pendent d’aprovació',
	'POWERED_BY'			=> 'Funciona amb %s',
	'PREVIEW'				=> 'Previsualització',
	'PREVIOUS'				=> 'Anterior',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Anterior',
	'PRIVACY'				=> 'Normes de privadesa',
	'PRIVATE_MESSAGE'		=> 'Missatge privat',
	'PRIVATE_MESSAGES'		=> 'Missatges privats',
	'PRIVATE_MESSAGING'		=> 'Missatgeria privada',
	'PROFILE'				=> 'Tauler de control de l’usuari',

	'RANK'						=> 'Rang',
	'READING_FORUM'				=> 'Està veient temes a %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Està llegint un avís global',
	'READING_LINK'				=> 'Ha fet clic sobre l’enllaç del fòrum %s',
	'READING_TOPIC'				=> 'Està llegint un tema a %s',
	'READ_PROFILE'				=> 'Perfil',
	'REASON'					=> 'Raó',
	'RECORD_ONLINE_USERS'		=> 'El nombre màxim d’usuaris connectats ha estat <strong>%1$s</strong> el %2$s',
	'REDIRECT'					=> 'Redirecció',
	'REDIRECTS'					=> 'Nombre de redireccions',
	'REGISTER'					=> 'Registreu-vos',
	'REGISTERED_USERS'			=> 'Usuaris registrats:',
	'REG_USERS_ONLINE'			=> 'Hi ha %d usuaris registrats i ',
	'REG_USERS_TOTAL'			=> '%d registrats, ',
	'REG_USERS_TOTAL_AND'		=> '%d registrats i ',
	'REG_USERS_ZERO_ONLINE'		=> 'Hi ha 0 usuaris registrats i ',
	'REG_USERS_ZERO_TOTAL'		=> '0 registrats, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 registrats i ',
	'REG_USER_ONLINE'			=> 'Hi ha %d usuari registrat i ',
	'REG_USER_TOTAL'			=> '%d registrat, ',
	'REG_USER_TOTAL_AND'		=> '%d registrat i ',
	'REMOVE'					=> 'Elimina',
	'REMOVE_INSTALL'			=> 'Si us plau, elimineu, moveu o canvieu el nom del directori d’instal·lació abans d’utilitzar el fòrum. Si aquest directori és present, només es podrà accedir al Tauler de control de l’administrador (TCA).',
	'REPLIES'					=> 'Respostes',
	'REPLY_WITH_QUOTE'			=> 'Respon citant el text de l’entrada',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Està responent a un avís global',
	'REPLYING_MESSAGE'			=> 'Està responent un missatge a %s',
	'REPORT_BY'					=> 'Informe escrit per',
	'REPORT_POST'				=> 'Informa d’aquesta entrada',
	'REPORTING_POST'			=> 'Està informant d’una entrada',
	'RESEND_ACTIVATION'			=> 'Reenvia el correu d’activació',
	'RESET'						=> 'Reinicialitza',
	'RESTORE_PERMISSIONS'		=> 'Restaura els meus permisos',
	'RETURN_INDEX'				=> '%sTorna a la pàgina d’índex%s',
	'RETURN_FORUM'				=> '%sTorna al darrer fòrum visitat%s',
	'RETURN_PAGE'				=> '%sTorna a la pàgina anterior%s',
	'RETURN_TOPIC'				=> '%sTorna al darrer tema visitat%s',
	'RETURN_TO'					=> 'Torna a:',
	'FEED'						=> 'Canal d’informació',
	'FEED_NEWS'					=> 'Notícies',
	'FEED_TOPICS_ACTIVE'		=> 'Temes actius',
	'FEED_TOPICS_NEW'			=> 'Temes nous',
	'RULES_ATTACH_CAN'			=> '<strong>Podeu</strong> publicar fitxers adjunts en aquest fòrum',
	'RULES_ATTACH_CANNOT'		=> '<strong>No podeu</strong> publicar fitxers adjunts en aquest fòrum',
	'RULES_DELETE_CAN'			=> '<strong>Podeu</strong> eliminar les vostres entrades en aquest fòrum',
	'RULES_DELETE_CANNOT'		=> '<strong>No podeu</strong> eliminar les vostres entrades en aquest fòrum',
	'RULES_DOWNLOAD_CAN'		=> '<strong>Podeu</strong> baixar-vos fitxers adjunts d’aquest fòrum',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>No podeu</strong> baixar-vos fitxers adjunts d’aquest fòrum',
	'RULES_EDIT_CAN'			=> '<strong>Podeu</strong> editar les vostres entrades en aquest fòrum',
	'RULES_EDIT_CANNOT'			=> '<strong>No podeu</strong> editar les vostres entrades en aquest fòrum',
	'RULES_LOCK_CAN'			=> '<strong>Podeu</strong> bloquejar els vostres temes en aquest fòrum',
	'RULES_LOCK_CANNOT'			=> '<strong>No podeu</strong> bloquejar els vostres temes en aquest fòrum',
	'RULES_POST_CAN'			=> '<strong>Podeu</strong> publicar temes nous en aquest fòrum',
	'RULES_POST_CANNOT'			=> '<strong>No podeu</strong> publicar temes nous en aquest fòrum',
	'RULES_REPLY_CAN'			=> '<strong>Podeu</strong> respondre en temes d’aquest fòrum',
	'RULES_REPLY_CANNOT'		=> '<strong>No podeu</strong> respondre en temes d’aquest fòrum',
	'RULES_VOTE_CAN'			=> '<strong>Podeu</strong> votar en les enquestes d’aquest fòrum',
	'RULES_VOTE_CANNOT'			=> '<strong>No podeu</strong> votar en les enquestes d’aquest fòrum',

	'SEARCH'					=> 'Cerca',
	'SEARCH_MINI'				=> 'Cerca…',
	'SEARCH_ADV'				=> 'Cerca avançada',
	'SEARCH_ADV_EXPLAIN'		=> 'Mostra les opcions de cerca avançada',
	'SEARCH_KEYWORDS'			=> 'Cerca paraules clau',
	'SEARCHING_FORUMS'			=> 'Està cercant en els fòrums',
	'SEARCH_ACTIVE_TOPICS'		=> 'Mostra els temes actius',
	'SEARCH_FOR'				=> 'Cerca',
	'SEARCH_FORUM'				=> 'Cerca al fòrum…',
	'SEARCH_NEW'				=> 'Mostra les entrades noves',
	'SEARCH_POSTS_BY'			=> 'Cerca les entrades per',
	'SEARCH_SELF'				=> 'Mostra les meves entrades',
	'SEARCH_TOPIC'				=> 'Cerca al tema…',
	'SEARCH_UNANSWERED'			=> 'Mostra les entrades sense resposta',
	'SEARCH_UNREAD'				=> 'Mostra les entrades no llegides',
	'SEARCH_USER_POSTS'			=> 'Cerca les entrades d’aquest usuari',
	'SECONDS'					=> 'Segons',
	'SELECT'					=> 'Selecciona',
	'SELECT_ALL_CODE'			=> 'Selecciona’ls tots',
	'SELECT_DESTINATION_FORUM'	=> 'Si us plau, selecioneu el fòrum de destí',
	'SELECT_FORUM'				=> 'Seleccioneu un fòrum',
	'SEND_EMAIL'				=> 'Envia el correu electrònic',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Envia un correu electrònic a',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Envia-li un missatge privat',
	'SETTINGS'					=> 'Configuració',
	'SIGNATURE'					=> 'Signatura',
	'SKIP'						=> 'Saltar fins al contingut',
	'SMTP_NO_AUTH_SUPPORT'		=> 'El servidor SMTP no permet autenticar-se.',
	'SORRY_AUTH_READ'			=> 'No teniu autorització per llegir aquest fòrum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'No teniu autorització per baixar-vos aquest fitxer adjunt.',
	'SORT_BY'					=> 'Ordena per',
	'SORT_JOINED'				=> 'Data de registre',
	'SORT_LOCATION'				=> 'Ubicació',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Entrades',
	'SORT_TOPIC_TITLE'			=> 'Títol del tema',
	'SORT_USERNAME'				=> 'Nom d’usuari',
	'SPLIT_TOPIC'				=> 'Divideix el tema',
	'SQL_ERROR_OCCURRED'		=> 'S’ha produït un error SQL durant l’obtenció d’aquesta pàgina. Si us plau, poseu-vos en contacte amb l’%sadministrador del fòrum%s si aquest problema continua.',
	'STATISTICS'				=> 'Estadístiques',
	'START_WATCHING_FORUM'		=> 'Subscriu-me a aquest fòrum',
	'START_WATCHING_TOPIC'		=> 'Subscriu-me a aquest tema',
	'STOP_WATCHING_FORUM'		=> 'Cancel·la la subscripció a aquest fòrum',
	'STOP_WATCHING_TOPIC'		=> 'Cancel·la la subscripció a aquest tema',
	'SUBFORUM'					=> 'Subfòrum',
	'SUBFORUMS'					=> 'Subfòrums',
	'SUBJECT'					=> 'Assumpte',
	'SUBMIT'					=> 'Tramet',

	'TERMS_USE'			=> 'Condicions d’ús',
	'TEST_CONNECTION'	=> 'Prova la connexió',
	'THE_TEAM'			=> 'L’equip',
	'TIME'				=> 'Data',

	'TOO_LARGE'						=> 'El valor que heu introduït és massa gran.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'El valor de la configuració <strong>Nombre màxim de destinataris permesos per missatge privat</strong> que heu introduït és massa gran.',

	'TOO_LONG'						=> 'El valor que heu introduït és massa llarg.',

	'TOO_LONG_AIM'					=> 'L’àlies que heu introduït és massa llarg.',
	'TOO_LONG_CONFIRM_CODE'			=> 'El codi de confirmació que heu introduït és massa llarg.',
	'TOO_LONG_DATEFORMAT'			=> 'El format de data que heu introduït és massa llarg.',
	'TOO_LONG_ICQ'					=> 'El número ICQ que heu introduït és massa llarg.',
	'TOO_LONG_INTERESTS'			=> 'Les aficions que heu introduït són massa llargues.',
	'TOO_LONG_JABBER'				=> 'El compte de Jabber que heu introduït és massa llarg.',
	'TOO_LONG_LOCATION'				=> 'La ubicació que heu introduït és massa llarga.',
	'TOO_LONG_MSN'					=> 'El nom MSNM/WLM que heu introduït és massa llarg.',
	'TOO_LONG_NEW_PASSWORD'			=> 'La contrasenya que heu introduït és massa llarga.',
	'TOO_LONG_OCCUPATION'			=> 'La feina que heu introduït és massa llarga.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'La confirmació de contrasenya que heu introduït és massa llarga.',
	'TOO_LONG_USER_PASSWORD'		=> 'La contrasenya que heu introduït és massa llarga.',
	'TOO_LONG_USERNAME'				=> 'El nom d’usuari que heu introduït és massa llarg.',
	'TOO_LONG_EMAIL'				=> 'L’adreça electrònica que heu introduït és massa llarga.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'La confirmació d’adreça electrònica que heu introduït és massa llarga.',
	'TOO_LONG_WEBSITE'				=> 'L’adreça del lloc web que heu introduït és massa llarga.',
	'TOO_LONG_YIM'					=> 'El nom de Yahoo! Messenger que heu introduït és massa llarg.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Heu provat de votar massa opcions diferents.',

	'TOO_SHORT'						=> 'El valor que heu introduït és massa curt.',

	'TOO_SHORT_AIM'					=> 'L’àlies que heu introduït és massa curt.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'El codi de confirmació que heu introduït és massa curt.',
	'TOO_SHORT_DATEFORMAT'			=> 'El format de data que heu introduït és massa curt.',
	'TOO_SHORT_ICQ'					=> 'El número ICQ que heu introduït és massa curt.',
	'TOO_SHORT_INTERESTS'			=> 'Les aficions que heu introduït són massa curtes.',
	'TOO_SHORT_JABBER'				=> 'El compte de Jabber que heu introduït és massa curt.',
	'TOO_SHORT_LOCATION'			=> 'La ubicació que heu introduït és massa curta.',
	'TOO_SHORT_MSN'					=> 'El nom MSNM/WLM que heu introduït és massa curt.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'La contrasenya que heu introduït és massa curta.',
	'TOO_SHORT_OCCUPATION'			=> 'La feina que heu introduït és massa curta.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'La confirmació de contrasenya que heu introduït és massa curta.',
	'TOO_SHORT_USER_PASSWORD'		=> 'La contrasenya que heu introduït és massa curta.',
	'TOO_SHORT_USERNAME'			=> 'El nom d’usuari que heu introduït és massa curt.',
	'TOO_SHORT_EMAIL'				=> 'L’adreça electrònica que heu introduït és massa curta.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'La confirmació d’adreça electrònica que heu introduït és massa curta.',
	'TOO_SHORT_WEBSITE'				=> 'L’adreça del lloc web que heu introduït és massa curta.',
	'TOO_SHORT_YIM'					=> 'El nom de Yahoo! Messenger que heu introduït és massa curt.',

	'TOO_SMALL'						=> 'El valor que heu introduït és massa petit.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'El valor de la configuració <strong>Nombre màxim de destinataris permesos per missatge privat</strong> que heu introduït és massa petit.',

	'TOPIC'				=> 'Tema',
	'TOPICS'			=> 'Temes',
	'TOPICS_UNAPPROVED'	=> 'Com a mínim, un tema d’aquest fòrum no està aprovat.',
	'TOPIC_ICON'		=> 'Icona de tema',
	'TOPIC_LOCKED'		=> 'Aquest tema està bloquejat, no hi podeu editar entrades ni publicar-hi més respostes.',
	'TOPIC_LOCKED_SHORT'=> 'Tema bloquejat',
	'TOPIC_MOVED'		=> 'Tema mogut',
	'TOPIC_REVIEW'		=> 'Revisió del tema',
	'TOPIC_TITLE'		=> 'Títol del tema',
	'TOPIC_UNAPPROVED'	=> 'Aquest tema no ha estat aprovat',
	'TOTAL_ATTACHMENTS'	=> 'Fitxer(s) adjunt(s)',
	'TOTAL_LOG'			=> '1 registre',
	'TOTAL_LOGS'		=> '%d registres',
	'TOTAL_NO_PM'		=> '0 missatges privats en total',
	'TOTAL_PM'			=> '1 missatge privat en total',
	'TOTAL_PMS'			=> '%d misstages privats en total',
	'TOTAL_POSTS'		=> 'Nombre d’entrades',
	'TOTAL_POSTS_OTHER'	=> 'Nombre d’entrades <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Nombre d’entrades <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'S’ha informat d’aquest tema',
	'TOTAL_TOPICS_OTHER'=> 'Nombre de temes <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Nombre de temes <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Nombre de membres <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Nombre de membres <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Errors del PHP detectats: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'No s’han pogut determinar les dimensions de la imatge.',
	'UNABLE_TO_DELIVER_FILE'=> 'No s’ha pogut lliurar el fitxer.',
	'UNKNOWN_BROWSER'		=> 'Navegador desconegut',
	'UNMARK_ALL'			=> 'Desmarca’ls tots',
	'UNREAD_MESSAGES'		=> 'Missatges no llegits',
	'UNREAD_PM'				=> '<strong>%d</strong> missatge no llegit',
	'UNREAD_PMS'			=> '<strong>%d</strong> missatges no llegits',
	'UNREAD_POST'			=> 'Entrada no llegida',
	'UNREAD_POSTS'			=> 'Entrades no llegides',
	'UNWATCH_FORUM_CONFIRM'		=> 'Esteu segur que voleu cancel·lar la subscripció a aquest fòrum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Esteu segur que voleu cancel·lar la subscripció al fòrum “%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Esteu segur que voleu cancel·lar la subscripció a aquest tema?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Esteu segur que voleu cancel·lar la subscripció al tema “%s”?',
	'UNWATCHED_FORUMS'		    => 'Ja no esteu subscrit als fòrums seleccionats.',
	'UNWATCHED_TOPICS'		    => 'Ja no esteu subscrit als temes seleccionats.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Ja no esteu subscrit als elements seleccionats.',
	'UPDATE'				=> 'Actualitza',
	'UPLOAD_IN_PROGRESS'	=> 'La càrrega està en curs.',
	'URL_REDIRECT'			=> 'Si el vostre navegador no permet l’ús de meta redireccions, %ssi us plau feu clic aquí per ser redirigit%s.',
	'USERGROUPS'			=> 'Grups',
	'USERNAME'				=> 'Nom d’usuari',
	'USERNAMES'				=> 'Noms d’usuari',
	'USER_AVATAR'			=> 'Avatar de l’usuari',
	'USER_CANNOT_READ'		=> 'No podeu llegir entrades en aquest fòrum.',
	'USER_POST'				=> '%d entrada',
	'USER_POSTS'			=> '%d entrades',
	'USERS'					=> 'Usuaris',
	'USE_PERMISSIONS'		=> 'Prova els permisos de l’usuari',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'No esteu autoritzat a utilitzar aquesta funció. És possible que us hagueu registrat recentment i que calgui que participeu més per que pugueu utilitzar aquesta característica.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Visualitzat',
	'VIEWING_FAQ'				=> 'Està veient les PMF',
	'VIEWING_MEMBERS'			=> 'Està veient els detalls d’un membre',
	'VIEWING_ONLINE'			=> 'Està veient qui està connectat',
	'VIEWING_MCP'				=> 'Està veient el Tauler de control del moderador',
	'VIEWING_MEMBER_PROFILE'	=> 'Està veient el perfil d’un membre',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Està veient missatges privats',
	'VIEWING_REGISTER'			=> 'Està donant d’alta un compte',
	'VIEWING_UCP'				=> 'Està veient el Tauler de control de l’usuari',
	'VIEWS'						=> 'Visualització',
	'VIEW_BOOKMARKS'			=> 'Mostra les adreces d’interès',
	'VIEW_FORUM_LOGS'			=> 'Mostra els fitxers de registre',
	'VIEW_LATEST_POST'			=> 'Mostra l’entrada més recent',
	'VIEW_NEWEST_POST'			=> 'Mostra la primera entrada no llegida',
	'VIEW_NOTES'				=> 'Mostra les notes de l’usuari',
	'VIEW_ONLINE_TIME'			=> 'basat en els usuaris actius durant el darrer %d minut',
	'VIEW_ONLINE_TIMES'			=> 'basat en els usuaris actius durant els darrers %d minuts',
	'VIEW_TOPIC'				=> 'Mostra el tema',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Avís: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Avís global: ',
	'VIEW_TOPIC_LOCKED'			=> 'Bloquejat: ',
	'VIEW_TOPIC_LOGS'			=> 'Mostra els fitxers de registre',
	'VIEW_TOPIC_MOVED'			=> 'Mogut: ',
	'VIEW_TOPIC_POLL'			=> 'Enquesta: ',
	'VIEW_TOPIC_STICKY'			=> 'Tema recurrent: ',
	'VISIT_WEBSITE'				=> 'Visita el lloc web',

	'WARNINGS'			=> 'Advertiments',
	'WARN_USER'			=> 'Adverteix l’usuari',
	'WATCH_FORUM_CONFIRM'	=> 'Esteu segur que us voleu subscriure a aquest fòrum?',
	'WATCH_FORUM_DETAILED'	=> 'Esteu segur que us voleu subscriure al fòrum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Esteu segur que us voleu subscriure a aquest tema?',
	'WATCH_TOPIC_DETAILED'	=> 'Esteu segur que us voleu subscriure al tema “%s”?',
	'WELCOME_SUBJECT'	=> 'Benvingut als fòrums %s',
	'WEBSITE'			=> 'Lloc web',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Qui està connectat',
	'WRONG_PASSWORD'	=> 'Heu introduït una contrasenya incorrecta.',

	'WRONG_DATA_ICQ'			=> 'El número que heu introduït no és un número ICQ vàlid.',
	'WRONG_DATA_JABBER'			=> 'El nom que heu introduït no és un nom de compte Jabber vàlid.',
	'WRONG_DATA_LANG'			=> 'L’idioma que heu especificat no és vàlid.',
	'WRONG_DATA_WEBSITE'		=> 'L’adreça del lloc web ha de ser vàlida, incloent-hi el protocol. Per exemple http://www.exemple.cat/.',
	'WROTE'						=> 'ha escrit',

	'YEAR'				=> 'Any',
	'YEAR_MONTH_DAY'	=> '(AAAA-MM-DD)',
	'YES'				=> 'Sí',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Hora i data de la vostra darrera visita: %s',
	'YOU_NEW_PM'		=> 'Teniu un missatge privat nou a la safata d’entrada.',
	'YOU_NEW_PMS'		=> 'Teniu missatges privats nous a la safata d’entrada.',
	'YOU_NO_NEW_PM'		=> 'No teniu cap missatge privat nou.',

	'datetime'			=> array(
		'TODAY'		=> 'Avui',
		'TOMORROW'	=> 'Demà',
		'YESTERDAY'	=> 'Ahir',
		'AGO'		=> array(
			0		=> 'fa menys d’un minut',
			1		=> 'fa %d minut',
			2		=> 'fa %d minuts',
			60		=> 'fa una hora',
		),

		'Sunday'	=> 'Diumenge',
		'Monday'	=> 'Dilluns',
		'Tuesday'	=> 'Dimarts',
		'Wednesday'	=> 'Dimecres',
		'Thursday'	=> 'Dijous',
		'Friday'	=> 'Divendres',
		'Saturday'	=> 'Dissabte',

		'Sun'		=> 'dg.',
		'Mon'		=> 'dl.',
		'Tue'		=> 'dt.',
		'Wed'		=> 'dc.',
		'Thu'		=> 'dj.',
		'Fri'		=> 'dv.',
		'Sat'		=> 'ds.',

		'January'	=> 'gener',
		'February'	=> 'febrer',
		'March'		=> 'març',
		'April'		=> 'abril',
		'May'		=> 'maig',
		'June'		=> 'juny',
		'July'		=> 'juliol',
		'August'	=> 'agost',
		'September' => 'setembre',
		'October'	=> 'octubre',
		'November'	=> 'novembre',
		'December'	=> 'desembre',

		'Jan'		=> 'gen.',
		'Feb'		=> 'feb.',
		'Mar'		=> 'març',
		'Apr'		=> 'abr.',
		'May_short'	=> 'maig',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'juny',
		'Jul'		=> 'jul.',
		'Aug'		=> 'ago.',
		'Sep'		=> 'set.',
		'Oct'		=> 'oct.',
		'Nov'		=> 'nov.',
		'Dec'		=> 'des.',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 hores',
		'-11'	=> 'UTC - 11 hores',
		'-10'	=> 'UTC - 10 hores',
		'-9.5'	=> 'UTC - 9:30 hores',
		'-9'	=> 'UTC - 9 hores',
		'-8'	=> 'UTC - 8 hores',
		'-7'	=> 'UTC - 7 hores',
		'-6'	=> 'UTC - 6 hores',
		'-5'	=> 'UTC - 5 hores',
		'-4.5'	=> 'UTC - 4:30 hores',
		'-4'	=> 'UTC - 4 hores',
		'-3.5'	=> 'UTC - 3:30 hores',
		'-3'	=> 'UTC - 3 hores',
		'-2'	=> 'UTC - 2 hores',
		'-1'	=> 'UTC - 1 hora',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 hora',
		'2'		=> 'UTC + 2 hores',
		'3'		=> 'UTC + 3 hores',
		'3.5'	=> 'UTC + 3:30 hores',
		'4'		=> 'UTC + 4 hores',
		'4.5'	=> 'UTC + 4:30 hores',
		'5'		=> 'UTC + 5 hores',
		'5.5'	=> 'UTC + 5:30 hores',
		'5.75'	=> 'UTC + 5:45 hores',
		'6'		=> 'UTC + 6 hores',
		'6.5'	=> 'UTC + 6:30 hores',
		'7'		=> 'UTC + 7 hores',
		'8'		=> 'UTC + 8 hores',
		'8.75'	=> 'UTC + 8:45 hores',
		'9'		=> 'UTC + 9 hores',
		'9.5'	=> 'UTC + 9:30 hores',
		'10'	=> 'UTC + 10 hores',
		'10.5'	=> 'UTC + 10:30 hores',
		'11'	=> 'UTC + 11 hores',
		'11.5'	=> 'UTC + 11:30 hores',
		'12'	=> 'UTC + 12 hores',
		'12.75'	=> 'UTC + 12:45 hores',
		'13'	=> 'UTC + 13 hores',
		'14'	=> 'UTC + 14 hores',
		'dst'	=> '[ <abbr title="Horari d’estiu">DST</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Hora de Baker Island Time',
		'-11'	=> '[UTC - 11] Hora de Niue, Hora Estàndard de Samoa',
		'-10'	=> '[UTC - 10] Hora Estàndard de Hawaii-Aleutian, Hora de l’Illa Cook',
		'-9.5'	=> '[UTC - 9:30] Hora de les Illes Marqueses',
		'-9'	=> '[UTC - 9] Hora Estàndard d’Alaska, Hora de l’Illa Gambier',
		'-8'	=> '[UTC - 8] Hora Estàndard del Pacífic',
		'-7'	=> '[UTC - 7] Hora Estàndard de Muntanya',
		'-6'	=> '[UTC - 6] Hora Estàndard Central',
		'-5'	=> '[UTC - 5] Hora Estàndard de l’Est',
		'-4.5'	=> '[UTC - 4:30] Hora Estàndard de Veneçuela',
		'-4'	=> '[UTC - 4] Hora Estàndard de l’Atlàntic',
		'-3.5'	=> '[UTC - 3:30] Hora Estàndard de Newfoundland',
		'-3'	=> '[UTC - 3] Hora Estàndard de l’Amazones, Hora de Groenlàndia Central',
		'-2'	=> '[UTC - 2] Hora de Fernando de Noronha, Hora de les Illes Georgia del Sud i Sandwich del Sud',
		'-1'	=> '[UTC - 1] Hora Estàndard de les Açores, Hora de Cap Verd, Hora de Groenlàndia Oriental',
		'0'		=> '[UTC] Hora d’Europa Occidental, Temps Mitjà de Greenwich',
		'1'		=> '[UTC + 1] Hora d’Europa Central, Hora d’Àfrica Occidental',
		'2'		=> '[UTC + 2] Hora d’Europa Oriental, Hora d’Àfrica Central',
		'3'		=> '[UTC + 3] Hora Estàndard de Moscú, Hora d’Àfrica Oriental',
		'3.5'	=> '[UTC + 3:30] Hora Estàndard d’Iran',
		'4'		=> '[UTC + 4] Hora Estàndard del Golf, Hora Estàndard de Samara',
		'4.5'	=> '[UTC + 4:30] Hora d’Afganistan',
		'5'		=> '[UTC + 5] Hora Estàndard de Pakistan, Hora Estàndard de Yekaterinburg',
		'5.5'	=> '[UTC + 5:30] Hora Estàndard de l’India, Hora de Sri Lanka',
		'5.75'	=> '[UTC + 5:45] Hora de Nepal',
		'6'		=> '[UTC + 6] Hora de Bangladesh, Bhutan Time, Hora Estàndard de Novosibirsk',
		'6.5'	=> '[UTC + 6:30] Hora de les Illes Cocos, Hora de Myanmar',
		'7'		=> '[UTC + 7] Hora d’Indoxina, Hora Estàndard de Krasnoyarsk',
		'8'		=> '[UTC + 8] Hora Estàndard Xinesa, Hora Estàndard d’Australia Occidental, Hora Estàndard d’Irkutsk',
		'8.75'	=> '[UTC + 8:45] Hora Estàndard d’Austràlia Sud-oriental Occidental',
		'9'		=> '[UTC + 9] Hora Estàndard de Japó, Hora Estàndard de Corea, Hora Estàndard de Chita',
		'9.5'	=> '[UTC + 9:30] Hora Estàndard d’Austràlia Central',
		'10'	=> '[UTC + 10] Hora Estàndard d’Austràlia Oriental, Hora Estàndard de Vladivostok',
		'10.5'	=> '[UTC + 10:30] Hora Estàndard de Lord Howe',
		'11'	=> '[UTC + 11] Hora Estàndard de les Illes Salomó, Hora Estàndard de Magadan',
		'11.5'	=> '[UTC + 11:30] Hora de l’Illa Norfolk',
		'12'	=> '[UTC + 12] Hora de Nova Zelanda, Hora de Fiji, Hora Estàndard de Kamchatka',
		'12.75'	=> '[UTC + 12:45] Hora de les Illes Chatham',
		'13'	=> '[UTC + 13] Hora de Tonga, Hora de les Illes Phoenix',
		'14'	=> '[UTC + 14] Hora de l’Illa Line',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 gen 2007, 13:37',
		'd M Y H:i'				=> '01 gen 2007 13:37',
		//'M jS, \'y, H:i'		=> 'gen 1er, \'07, 13:37',
		//'D M d, Y g:i a'		=> 'dl gen 01, 2007 1:37 pm',
		'D d M Y, g:i a'		=> 'dl 01 gen 2007, 1:37 pm',
		//'F jS, Y, g:i a'		=> 'gener 1er, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Avui, 13:37 / 01 gen 2007, 13:37'/*,
		'|F jS, Y|, g:i a'		=> 'Avui, 1:37 pm / gener 1er, 2007, 1:37 pm'*/
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'd M Y, H:i', // 01 gen 2007, 13:37

));

?>