PHP_ARG_WITH(imagick, whether to enable the imagick extension,
[ --with-imagick[=DIR]	Enables the imagick extension. DIR is the prefix to Imagemagick installation directory.], no)

PHP_ARG_ENABLE(imagick-zend-mm, whether to make Imagick respect PHP memory limits,
[ --enable-imagick-zend-mm	Make Imagick respect PHP memory limits (experimental)], no, no)



if test $PHP_IMAGICK != "no"; then

#
# Find ImageMagick
#
  m4_include([imagemagick.m4])
  IM_FIND_IMAGEMAGICK([6.2.4], [$PHP_IMAGICK])

#
# Zend MM
#
  AC_MSG_CHECKING([whether to use Zend MM])
  if test $PHP_IMAGICK_ZEND_MM != "no"; then
    AC_DEFINE(PHP_IMAGICK_ZEND_MM,1,[ ])
    AC_MSG_RESULT([yes])
  else
    AC_MSG_RESULT([no])
  fi

#
# PHP minimum version
#
  AC_MSG_CHECKING([PHP version is at least 5.1.3])

  if test -z "${PHP_VERSION_ID}"; then
    if test -z "${PHP_CONFIG}"; then
      AC_MSG_ERROR([php-config not found])
    fi
    if test -z "${AWK}"; then
      AC_MSG_ERROR([awk not found])
    fi
    PHP_IMAGICK_FOUND_VERSION=`${PHP_CONFIG} --version`
    PHP_IMAGICK_FOUND_VERNUM=`echo "${PHP_IMAGICK_FOUND_VERSION}" | $AWK 'BEGIN { FS = "."; } { printf "%d", ([$]1 * 100 + [$]2) * 100 + [$]3;}'`
  else
    PHP_IMAGICK_FOUND_VERNUM="${PHP_VERSION_ID}"
    PHP_IMAGICK_FOUND_VERSION="${PHP_VERSION}"
  fi

  if test "$PHP_IMAGICK_FOUND_VERNUM" -ge "50103"; then
    AC_MSG_RESULT(yes. found $PHP_IMAGICK_FOUND_VERSION)
  else 
    AC_MSG_ERROR(no. found $PHP_IMAGICK_FOUND_VERSION)
  fi

#
# Set libs and CFLAGS for building
#
  PHP_EVAL_LIBLINE($IM_IMAGEMAGICK_LIBS, IMAGICK_SHARED_LIBADD)
  PHP_EVAL_INCLINE($IM_IMAGEMAGICK_CFLAGS)

  PHP_SUBST(IMAGICK_SHARED_LIBADD)
  AC_DEFINE(HAVE_IMAGICK,1,[ ])
  PHP_NEW_EXTENSION(imagick, imagick_file.c imagick_class.c imagickdraw_class.c imagickpixel_class.c imagickpixeliterator_class.c imagick_helpers.c imagick.c, $ext_shared,, $IM_IMAGEMAGICK_CFLAGS)
  PHP_INSTALL_HEADERS([ext/imagick], [php_imagick_shared.h])
fi
