# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.
#
# The beautiful icon is thanks to the work of the Geotag Icon Project
# http://www.geotagicons.com/
#
# Follows PEP8

from core import ct, models
from lib.reverse_translation import _t


def init():
    global gps
    from lib import gps


class Action(models.Action):
    """Defined variables: <filename> <type> <folder> <width> <height>"""

    label = _t('Geotag')
    author = 'Robin Mills'
    email = 'robin@clanmills.com'
    version = '0.1'
    tags = [_t('metadata')]
    init = staticmethod(init)
    __doc__ = _t('Add gps data')
    metadata = ['Exif_Image_DateTime']

    def interface(self, fields):
        fields[_t('GPS Data (gpx)')] = self.GeoReadFileField(' ')
        fields[_t('GPS Report (csv)')] = self.CsvFileField(' ')
        fields[_t('Time Shift (seconds)')] = self.IntegerField(0,
            choices=[-60, 0, 60])

    def apply(self, photo, setting, cache):
        #get info
        info = photo.info

        # get timeshift
        # construct timedict if necessary
        if not ('gps_timedict' in cache):
            cache['gps_timeshift'] = \
                self.get_field('Time Shift (seconds)', info)
            gpx_file = self.get_field('GPS Data (gpx)', info)
            csv_file = self.get_field('GPS Report (csv)', info).strip()
            if csv_file:
                csv_file = open(csv_file, 'w')
                gps.write_header(csv_file)
            cache['gps_report'] = csv_file
            cache['gps_timedict'] = gps.read_gpx(gpx_file)

        # get the geoTags
        gps_data = gps.get_metadata(info['Exif_Image_DateTime'],
            cache['gps_timedict'], cache['gps_timeshift'],
            info['path'], cache['gps_report'])

        # do not use update as info does not support it
        for key, value in gps_data.items():
            info[key.replace('.', '_')] = value  # writable

        return photo

    icon = \
'x\xda\x01\xaa\x0eU\xf1\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x0eaIDATh\x81\xbd\x99{\x8c\x1d\xd5}\xc7?\xe71sg\xef\
\xeez\xfd\x02\xef\xdak\x0b\xb0\xc1\xd8\x80K0\xc2\xd8\x98\x87,L\xe2"\x08DM\
\x01\xa5nx\x98\xa6\x7f\x84VD\tD\x04B\xec\x10b\x9c\x08\'*)A!AF$\xaa\xd4*\x04\
\x84\xea\x04\xd1\xe2\x14\x15\xe2\xda\xebG\xf0\x06c `\xb36\xe0\xc7>\xbcw\xefc\
f\xce\xf9\xf5\x8f\x99{\xbd^\xef\xda\x98\xba\x1c\xe9h\xae\xee\x9d{\xce\xf7{~\
\xef\xdfQ\xe4C\x81\x12\xa5\x04\x11\xa6\x15\x8b\xe7,>\xeb\xac[)\x14\x96Z\x91\
\xd9\xa9R\xa1\xe2\xd3\x1fJ\xc4\x07\xf0\xce\x01\x91\xffz\xf7\xbd\xf7\x9e\xde\
\xd9\xd7\xb7\x11@+\xa5\xbd\x88\xcfq\x83RJ\x89\x88\x14\xc1\xfc\xe5\x82\x05\
\x0f,X\xb0\xe0\x1f\x8b\xe3\xc6\x8d\xd7Z\xa3\xf3\x97\x94\xfa\xf4)\x88\x08\x1e\
\xf0"\xa4\x95Jm\xeb\xb6mO?\xb7a\xc37{\xd3\xb4\xb7NB)\xa5\xb4\x80\xb4\x1a\xd3\
z\xcfM7\xfd\xdb\xf9\x0b\x17.5\xce\x11*\xe5\xd0Zy\xd0\x92\xb1\xfc\xd4\t \x82\
\x01A\xc4\'"&\xb1\x96\xbe\x9d;\xff\xf4\xf8\xbau\xd7n\x1e\x18xO+\xa5\x95R\xca\
\xb4\x89\xc8=_\xfc\xe2\x0bs\xaf\xbcrY\x8bsI\x14E\xd6[\xab\xd0\x1ah\x88\xe9\
\xd4\x01S*\x93\xa8\x08(\x85x?\x06~i\x10\xd1\xce\x91V\xabI\xc9\x98`ww\xf7\xae\
\xfb\x7f\xf6\xb3\x85}I\xd2o\x00\xb9b\xee\xdc\x7f\xb8z\xc9\x92\xbb\x9a\xe38)\
\x06A\xe0\xb5V!\x10\x88\x10x\x8f\xf5\xbe\xf1\xf9\xff<E\xb0i\x8a\xaeV\xb1\xde\
\xa3k5B\xadG]\xdf\xe6O\xe3=\xde9\x8cs\xc6\x0c\x0e&\xa6\xad\xed\xf4\xf68>\xfd\
\x0f\xef\xbe\xfb\x1b;>\x08&/\x98;\xf7\x9b28\xe8\x0b\xc5\xa2\xa9\x1aC\x93\x08\
\xda\x18t\xfd\xa4\xeaR8\x05\'/\xdec\xac\xe5\xb4K.\xa1\xe9\xb4\xd3(\xbd\xff>\
\x077oF\x19\x93I\xb9~\xea@\xfd\x93\xe4d*I\x82N\x92 ,\x97\xdd\xd4Y\xb3\xfe\
\xf6\xec\xad[\xff\xd9\x9e3e\xca\x8dEc\xda\x83\xc1A?\x04\xba\xe0\x1c\x12\xc7\
\xf8|\xc1SI@i\x8d\xabT\xe8X\xb6\x8c\x8e\xf9\xf3I\xbdg\xc2\x8c\x19D\xcd\xcd\
\xec~\xfeyt\x10\xa0\x94j\xa8\xcep\x02\xde{HSJ\xd5*\xa6\\&H\x123{\xc6\x8c;\
\xedi\xe3\xc6-3\x95\x8a\xa4A \x0e\xb0qL\x1a\x04(\xad\x91\xdc\x06\xb2\xc3;\
\x05\x14\x94\xc2\xc71\xad\x9d\x9d\x88s(\x11\xbc\xf7\x9c~\xe1\x85\xe0\x1co\
\xff\xeaW\x98 \x00\xad\xc1\xfb\x06\x01/\x82\xf3\x1e\x97\xa6\xc4\xb5\x1a\xaaZ\
\xd5\x94JLoi\xb9\xdaNp\xae\xc3\x97\xcb\xaa\xa6\xb5\xd2\xde\x93\xd4j\x18k\x11\
\xad\xd1\xa7\x98\x80\xd2\x9adh\x88\xde\xed\xdbi\x996\r\xe5\x1cJk\xbcs\x9c>\
\x7f>\x12\xc7\xbc\xf1\xe4\x93\x980\x04\xad\x11\xe72\xd29\x81\xd89\x928\xc6\
\xd5j\x8aR\t\x0f\xd3\xad\x89\xe3\x0e?4D\nJ\xa5)q\x10\xa0\xad\xc5+\x85V\xaa\
\xe1}N\x95\r\x00\xecZ\xb7\x0e\x1d\x86t^}5\xe2}&m\xe7\x98\xb2p!.I\xd8\xf1\xa3\
\x1fa\n\x85\xccfD\x10\x11R\xefI\xbc\'N\x12|\x1c#CC\xa4\x95\n6\x8ec\xe5\xcaeR\
\xef\x918&\xb6\x16m\x0c>\x0fb\xa7\x9c\x80R\xc4\xfd\xfd\xd4\x0e\x1e\x1c\xf6\
\xb5\x02c\x10\xe7\x98z\xc5\x15\xf8Z\x8d\xad\x0f?\x8c\x8e\xa2\x86\x84\x9c\x08\
\x89s$\xce\xe1\x93\x04_\xa9\xe0*\x15e}\x92\x88\x1f\x1a"MS|\xadFlmflu\t\xd479\
\x05\xe0\x95R\xc4\x03\x03\\x\xef\xbd\xcc\xbc\xf9\xe6\xc6\xe97^\xc9It.]\x8a\
\x8fc6~\xeb[\xd8\xa6&P\x8a\xd49\x12\xef\xa99\x07i\x8a\x8bc\\\xb5*\xd6\xd7j\
\xb8r\x19\x97$$\xc6\x90\x18\x83R\xea\x88\n\x9d\n\x02J\xa1\x80Z\x7f?\xf3W\xae\
\xe4\xec\xe5\xcb3#6\xe6\xd8Ws\x123\xae\xbd\x16W\xab\xf1\xea\xd7\xbe\x86\x89"\
\xbcR\x99\rx\x8fr\x0e\x9f\xa6\xa4q\x8c\xf5q\x8c\x03\x9c1\xc4\xc6\x10\xe7bvpJ\
\x08\xd4\xa3x\xad\xaf\x8f\x05k\xd60\xe7\xce;\xc7\x04?\x9c\x84OS\xce\xfc\xc2\
\x17pq\xcc\xef\xbf\xf2\x15T\xa1@\xaa5q\x1e\xd8\x9cs\xa4\xcea]\x1c\x8bO\x12R\
\xa5\x88\x95"\xce\x171J\xa1\x87/z"\xa0Z\x1f\x9bn\x88 J\x11\x97\xcb,Z\xb3\x86\
\xf3\xef\xba\xeb\x84\xe0\xebC[\x8bO\x12f\xdd|3i\xb5\xca\x7f\xacX\x81\x04\x01\
q\x1e\xcd\xbd\x08ND\xacsN\xa5@\x92\xcf\x98,\x80\x18\xf8X\x04\xb4\xd6\x88\xf7\
\xa4\x80\x1b\xf1\x9b\x01<\xb0p\xd5*\xfe\xe2\x1b\xdf\xa0V\xa9d\xe0\xdd\xc87\
\xeb\x9b(\xf0\xbe\x11\x91\x05\xf0CC\xcc\xbe\xf5V\xde\xdb\xb0\x81m\xeb\xd6\
\x91\xe6*&@\nX\x9f\x83\x8eG\x10\xb0#@\x8f$P\x8f\x0b\xb1\xf7\x18`\xe2\x9c9L<\
\xef<\x9a\xda\xdbQJQ=x\x90\xfd\xdd\xdd\xcc\xba\xfez\xce\x7f\xe0\x01z\x0f\x1d\
:\xca`G\x03/\xcea\xc2\x10\xf1\x1em-i\xa5\x82\x8bc\x92 `\xdcE\x17Q[\xb7\x0e\
\x9f\xab\xb7d\x07\xa6\xac\x1b\x06<\x06\x82#?\x8eI@\x01.?\xa1\xb3>\xffy\xce]\
\xb1\x82\xc9\x17^H\xd8\xd6\xd6 &@20\x80\x0eCz{z\xc6\x06>\x0c\xbc\x8d"\x92\
\x03\x07\xf8\xcf\xdbn\xe3\x8c\xeb\xae\xe3\xfc\xaf~\x15W\xadR*\x95x\xf3\xb9\
\xe7H\x81\xc4{,\x99d\xeb\x12Pu\xf0\xc3\th\xc6P!\xa5\x10\xa08u*\x17\xddw\x1fg\
\xdex#\xe2\x1c\xe5r\x99\xd2\xe1\xc3G\xe1\xd2\xd6"\x83\x83G\xe5T\xa3\rq\x0e\
\x1dE\xb8\x03\x07x\xf9\xb6\xdb\xe8\xd9\xb4\x89=\xaf\xbc\xc2\x07\xdb\xb73q\
\xde<\xf6\xac_\xcf\xee\x97_\xceb\x88\xf7Y\x91\x93\x1f\xb2\x95\x1c\xb0\x1f1\
\x8f9\xa4\xfaSkb\xe78c\xc1\x02\xce\xba\xe5\x16J{\xf6\x80R\xe8z69l\xb8$9a-!\
\xcea\xa2\x88\xda\xe1\xc3l\xb8\xfdv>\xd8\xb2\x85\xc8Z|\x9a\xf2\xfa3\xcf4\xde\
3J\x91\xd6+\xb4|\xd6\x0fz\x14\xb4j\xccM\xc59B\xady\xeb\xd7\xbff\xe3=\xf7P\
\x984iL\xddV\xc7Yg8xW.\xf3\xfb\x15+\xf8p\xcb\x16\xa2\xdc\x85\xa2\x14\x05c(\
\x18Ch\xccQi\xf6\xf0af\xc2\xddm\xd0\xd6\x04\xa4\xa0\xc2\x9c\x95"\x8b\x03J\
\xeb\xc6<\xb2\xb3\xa0\xb5f_W\x17R.\xd3\xb9t)\xaeZ=\xa9\xcaM\xbc\xc7D\x11i\
\xa5\xc2\x86;\xee\xe0\xc3\xae.\n\xc6\xe0\x87y(\x11\xc9\xbcQ\xdd#e\x18\xd1d\
\xa7\x7f\x00\xfc1\x04\nZ\x13\x06\x01:/>R\x91Lt"h\xc0\xd4\xeb\x04\x11\xac1\
\xec\xdd\xb4\t)\x97\x99\xfe\xd9\xcf\xe2\xaa\xd5\x86\xbe\x1fo"\x82\x8d"\\\xa5\
\xc2\x86\xdbo\xcf\xc0[{\x14\xf8c\x08\x8f \x00\xb0\x1f\xbc\xd5\xe0\r`s\xff:\
\xed\xf2\xcb\xb9\xf4\xc1\x07\x91J\x05\xa9V\xa9\xec\xdf\xcf\xc0\xae]\x1c\xdc\
\xba\x95C\xdb\xb61\xd4\xdf\x8f\x02\x02\xadA\x84\xa21\xecx\xe2\t\x02\xad\x99\
\xff\x9d\xefP\xeb\xef?\xbe\xea\x88\x80\xd6\xf8Z\x8d\xff\xbe\xe3\x0e\xf6wuQ\
\xccu~dx\x93aO\xc5\x91\xf8d\x86}g\rxM\xe6\xf7\rP\x1c7\x8e\xd3/\xb8\x00\xa9T\
\xb0\x85\x02\xba\x9e\x9d&\tC==\xec}\xf9e\xde\xfe\xe5/\xf9\xb0\xab+#b-\xd6Z^\
\x7f\xfcq\x02c\xb8\xf8\xa1\x87\x88\xfb\xfb\xb3\x9ds\x92#\t\xe80\xa4R*1\xb8s\
\'MZ\xa3\x9d\x1b\xd5\x18\x87\x13\xa8;\x16\x93c\xf5\xb9$\xcc\xb9p\xd7D\x98\
\xd8\xa25\xb1\x88\xea\x98=\x9bY\xd7]\x87\x8ac\x0c\xa0\xd2\x14j5\xb4\x08\xc5\
\x89\x13\x99\xbah\x11\xe7\xdct\x13\xa7\x9dw\x1e\x87\xbb\xbb)\x1d<H\xe0=\xa11\
\xec\xdb\xb8\x11]\xa9p\xd6\r7@\x92`\x8d\xc1\xe6\x04\x87O\r\x14\'Mb\xdf\x8b/R\
\xea\xe9!\xd0\x1a\x9d\xab\xe8X\xb3.\xcf4\'\xa0\x81\x8f\xc0\x1f#\x81@k\nQ\x84\
\xf7\x1e\x9b\xd7\xa8@Cw\xa5T\xc2j\xcd\x9c/}\x893?\xf79\xbaV\xad\xe2\x8d\xa7\
\x9eB\xaaU\x8a\xd6\xb2\xed\xc7?\xc6\x1a\xc3\xa5?\xfc!\xb5\xde\xdeQ\xd5I\x9c#\
li\xa1\xa9\xad\r\r\xd8<\xb6\x1cO\x02\xf5\xe8;\\\x85t]\x85\xcc\xb0\x1f\xac1\
\x84a\x88O\xd3c\t\x0c_\xbcT\xa2\xa9\xa5\x85k\x1e{\x8cx\xdf>\xdez\xf6\xd9\xac\
=b-\xdb\x1e}\x94\xd0Z\x16>\xf2\x08\xb5\xc1A\xd0\xfaH\xb1\x9e;\x870\x080yT\
\xb5\xc3\xc0\x8eE\xa0\xbe{\xfd}\x9f\xe1\x95\x06\x01\x0bb@\x05J\x11\x86a\x16\
\xda\x8fG\xc0Z\x82B\x81\xcd\xdf\xfd.{\x9e\x7f\x9e&\xad!MQJ\xd1b-[\xd6\xac!\
\xd0\x9aK\xbf\xff}\x92Z\xed\xe8\x0cT)H\x12\x92}\xfb\x08\x01\x9b\xbb\xc9\x93%\
\xa0\x01\xab\xb5\x16\x03\x18\xad1\xcea\xac\xc5j\x8d\xe4\xfa:\x1a\x01q\x0eU(\
\xb0}\xcd\x1a6~\xfb\xdb\x84\xd6f\xef\x04\x01.I0@s\xa1\xc0\xe6\xd5\xab\xb1a\
\xc8\xc5+W\x1eI\xa3\xbd\x07\xad\x19\xdc\xbd\x9b\xd2\x9f\xffL\xa1\x1e\xc1G\
\xf1Z2\xcaS\x03&w\x0c\x99\xfa\x85\xa1U\x80\x0e\x02e\x93\x04\x1d\x86\xa3\x9c\
\xc5\xb0E\xd3\x14e-\xaf\xaf]\xcb\x1f\xee\xbd\x97\xe6\xb6\xb6\x86kL\x87\x86h\
\x9b5\x8b\xcaG\x1fe\x92hj\xa2k\xd5*\xb4\xb5\\\xf4\xc0\x03Y\x1a\x9c\x07\xc1\
\xdd/\xbc@R\xad\x12M\x98\x80\xa4\xe9\xe8{\x8d\x94\x80Hf\xc0\xdeg\xebx\x8fVA`\
t\x18\xa2\n\x05L\x18\xa2\x83`l\xf0\xce\xa1\xac\xa5\xfb\xb1\xc7\xf8\x9f\xfb\
\xee\xa3\xb9\xbd\x1d\x13E\x04--\xb8j\x95\xa9K\x96p\xfd+\xaf0}\xd92|\x92`\x8b\
E\x9a;:\xd8\xfa\xd0Cl{\xe4\x11\x941Ykep\x907\x9fz\x8ah\xfcxl\xa1\x80mj:\xf1\
\x8c"L\xfd\x19E\xa8B!;t\x15\x04Fk\x8d\x89"l\x92d=\x99\xb1\xc0\x1b\xc3\x1b?\
\xfd)\x9b\x1f|\x90\xe6\xa9S\x11\x11\x941\xc4}}t^s\rW\xad[Ga\xfcx.^\xb5\x8a\
\x03\x9b6e\xeab\x0c\xcd\xd3\xa7\xb3}\xf5j\xb41\xcc\xfb\xfa\xd7\xd9\xfa\xf0\
\xc3\x94\xf6\xec!\x9a<y\xcc\xd3?F\x02yJa\xbcG\xe7u\xb1\xd1\x1a\xab\x82@+c\
\xd0\x85\x026I\xd0Ap\xacAy\x8f2\x86\x9dO>\xc9\x96\xef}\x8fbG\x07\x88\xa0\xac\
\xa5\xd6\xd7\xc7\xd4%K\xb8\xf2\xe7?\'hm\xc5\'\t\xe3g\xcf\xe6\xec\xe5\xcby\
\xf3\x17\xbf\xa00n\x1c\xe2\x1c\xc5\xa9S\xf9\xd3\x13O\xd0\xbbc\x07\xfb7n\xa4\
\xd8\xde\x9e\xad}\x1c\x95m\x10\x10AA\xe6\xdas\xf0:\xcft\xad\xb6V\xe9 @\x17\n\
\x18\xe7\x1a6P7)\xf1\x1em\x0c\xbb\x9e~\x9a\xed?\xf8\xc1\x11\xf0\xc6P\xeb\xef\
g\xeaUW\xb1\xf8\'?!hm\xcd\xda$y\xe6x\xf6\xf2\xe5\xecy\xe1\x85\xa3j\x01\xdb\
\xdc\xcc\x81M\x9b\x08ZZ\x1a\xc0\x8e7\x1a\xbf\xe6I\x9d\x15\xc18\x07\xce\xa1\
\x95B\x8b`\x95\xb5\xa80\xcc\x08\xe4a\xbe\xf1\xbf\xbc\x93\xdc\xf3\xe2\x8b\xbc\
\xfe\xe8\xa3\x14\xdb\xdb\x1bj\x93\x0c\x0c\xd0q\xf9\xe5,\\\xbb\x96\xa0\xa5\
\xe5\xa8\x1e\x8f\x88\xd06k\x16\xed\x97]\xc6\x87\xaf\xbe\x8amnn\xb4\tm\xb1\
\x98\xdd\x07\xe41a\xac4y\xa4\x04D$\xc3\x93\xf7\x85\x14`\xbcWV[\x8b\x0eCt\x14\
a\x95\xca\x8cx\xc4\xa2=/\xbdD\xd8\xd6\x96\x01\x05\xe2\x81\x01\xa6\\v\x19\x0b\
V\xaf\xce\xc0\x8dhP\xd5u\xbf\xe3\xaa\xab8\xd0\xd5\x95\x81>N\xa6\xf9q\x08\x90\
\x13\xb0i\x8a$I\x96b8\x87\xc5\x98\x8c@\x18b\xb5\xce\xfa\x8e"G\xf9\xfd\xb6Y\
\xb3\xd8\xff\xdak(kI\x07\x07\x99r\xe9\xa5\\\xbcr\xe5\xe8\xe0\xa1\xe1\xd3\'\
\xce\x9bGa\xe2D\xb4\xb5\xc7=\xe9\x8fM\xc09L\x9a\xe2\xb5Fy\x8fN\x12lh\x8c#\'\
\x1045Q9p\x80x`\x80\xa8\xb55\xfb\xb3\xf7\xcc\xbc\xe5\x16\xd2\xa1!\xfaw\xedb\
\xfc\xb9\xe72g\xc5\x8a\xa3\xc0\x1f\xa3\xcb9\x81bG\x07\xcd\xd3\xa6Q\xed\xed\
\x1dU\xb2\'$P\xbf\'\xc8U\xc8;\x87I\x92,5q\x0e\x15\xc7b\x0fx\xbf\xef\x8cB\xe1\
L\x13\x86b\x9a\x9bU\xad\xaf\x8f\xde\xeen\xa6/^\x9cICk\x82\xd6V.\xb8\xfbn\\\
\xad\x96u\x8dsb\xf5\xee\xf1X\x9b\x07\xc5"M\xed\xed\xc4CC\xd8(\x1a\xf3.\xec\
\xa4\x08\x18\x93\xb5\xfd\x93\x04\x13\x04bk\xde\xbf/\x85\x82\x04Q$D\x11\x01\
\xf0\xfeo\x7f\xcb\x94\xcf|\x86\xa0X\xc4\xa7)\xca{\x94R\xe8B\xe1H\xd5t\x02\
\x03\xac{\xaa\xc2\xe4\xc9\xd8\xbd{\x8f\x18\xef\' \xe0s\xfd\xaf\x13\xb0J\x89O\
\x12\xaa\xfd\xfdo\xd9C\xfd\xfd\xcf\xa6Ap\xb3\x0eC\x15\x04\x01\xba\xa9\x89\
\xca\xa1C\xbc\xf9\xcc3\xcc\xf9\xf2\x97\xb3\xa2;\x8e\xb3\x8a(O\xd6>\xee\xe6F)\
LSS\xd6&\x8f\xa2\xcc\xb8O\x8e\x01@V+\xe4WL\xa1RX\xef\xbd\x8f"s\xe8\xf0\xe1\
\x7f7\x03\xb5\xda{\xf3\xa6O\xff\xeb\xc9\x93&M\x9cX(x\x17\x86:li\xa1\xfa\xd1G\
\x0c\xbc\xf3\x0e\xc1\x84\t\x04\xe3\xc6A\x10d=\xfc\xfc\xea\xe9D\x13\xad\xc1\
\x18\x0e\xfe\xf1\x8fTz{\xd1Q\xd4\xf8\xeecOk\xb3i\x0c\xde\x18R\xadi\x02\x19\
\x02\xde\xafT\xaa\xbf\xd9\xba\xf5\xef\xed\xa0sC[v\xee\xbc\x7f\xee\xcc\x99\
\xffR\xd6\xda\x8f3\xc6\xd4\x94\xc2\xb6\xb4\xd0\xff\xc1\x07\x0c\xac[GKg\'-\
\x9d\x9d\xd8b\xf1\xa4\xee\x8b\x95\xd6\x0c\xf6\xf6\xe2\xa2\xe8\x08\xb1O \x01\
\'B\xaa\x14M\xdeS\x83\xc4\x15\x8b\xe1;\x9b6\xad\xfd\xb0\\\xde\xa9\xb4R\x06\
\x11w\xdb\xa2EO,[\xbc\xf8\xef\n\xce\xa5\xcdA\xa0cc\xb4\xcbsx\x1f\xc7\'\xad\
\xbf\xf5a\xc20\xf3T\x9f\xe0\xbf\xf5,T\x8bPHS\x89\x93$\x1d4&x}\xc7\x8eW\x1e_\
\xbf\xfe\xea\x83"i\x86P)\xf3NO\xcf\xf3\x911\x1d\x1d3f\\\x92h\xad\x94s^\xbc\
\x17\xe7\xbd\xc8\xc9\x8a~\xd8t"8\xe7\xf0\xf9U\xe9INQ\xde\x8b\xa4\xa9/\x81\
\xae\x04\x81\xe9\xee\xee~i\xed\xef~\xf7W}\xce\x95\x94\xca-R\x81\xaa_\xea/\
\x9d9\xf3o\x16]r\xc9\xfd\x93&M\x9am\xeb\x1d\xb1\xbc\xe0\xfe\xb4G\xfd\x9a+\
\x15\xa1\xd6\xdf\xff\xc1k\xdb\xb7\xff\xd3\xfa\xed\xdb\x1f)\x83\xd7J)/"Gz\xb6\
\x99$\xb4\x88\xf8V\xad\x9b/\x98>\xfd\xfa\xce\xce\xce\x1b\xa6\xb4\xb6\x9e\x11\
\x06\xc1\x19\xa9Rc\x95\xae\xff/C\x83\xe8$\xd9\xbb\xb7R\xe9\x19\xe8\xe9Y\xff\
\xd6\xee\xdd\xff\xfav\x92\xec\xcf\xb1*\xc9\xb1\xfc/\x84j\xc7\x8c$d\xe5\xe5\
\x00\x00\x00\x00IEND\xaeB`\x82\x8dGQ\xf2'
