<?php

final class PhabricatorRepositoryListController
  extends PhabricatorRepositoryController {

  public function processRequest() {

    $request = $this->getRequest();
    $user = $request->getUser();
    $is_admin = $user->getIsAdmin();

    $repos = id(new PhabricatorRepositoryQuery())
      ->setViewer($user)
      ->execute();
    $repos = msort($repos, 'getName');

    $rows = array();
    foreach ($repos as $repo) {

      if ($repo->isTracked()) {
        $diffusion_link = phutil_tag(
          'a',
          array(
            'href' => '/diffusion/'.$repo->getCallsign().'/',
          ),
          'View in Diffusion');
      } else {
        $diffusion_link = phutil_tag('em', array(), 'Not Tracked');
      }

      $rows[] = array(
        $repo->getCallsign(),
        $repo->getName(),
        PhabricatorRepositoryType::getNameForRepositoryType(
          $repo->getVersionControlSystem()),
        $diffusion_link,
        phutil_tag(
          'a',
          array(
            'class' => 'button small grey',
            'href'  => '/diffusion/'.$repo->getCallsign().'/edit/',
          ),
          'Edit'),
      );
    }

    $table = new AphrontTableView($rows);
    $table->setHeaders(
      array(
        'Callsign',
        'Repository',
        'Type',
        'Diffusion',
        '',
      ));
    $table->setColumnClasses(
      array(
        null,
        'wide',
        null,
        null,
        'action',
      ));

    $table->setColumnVisibility(
      array(
        true,
        true,
        true,
        true,
        $is_admin,
      ));

    $panel = new AphrontPanelView();
    $panel->setHeader('Repositories');
    if ($is_admin) {
      $panel->setCreateButton('Create New Repository', '/diffusion/new/');
    }
    $panel->appendChild($table);
    $panel->setNoBackground();

    $projects = id(new PhabricatorRepositoryArcanistProject())->loadAll();

    $rows = array();
    foreach ($projects as $project) {
      $repo = idx($repos, $project->getRepositoryID());
      if ($repo) {
        $repo_name = $repo->getName();
      } else {
        $repo_name = '-';
      }

      $rows[] = array(
        $project->getName(),
        $repo_name,
        phutil_tag(
          'a',
          array(
            'href' => '/repository/project/edit/'.$project->getID().'/',
            'class' => 'button grey small',
          ),
          'Edit'),
        javelin_tag(
          'a',
          array(
            'href' => '/repository/project/delete/'.$project->getID().'/',
            'class' => 'button grey small',
            'sigil' => 'workflow',
          ),
          'Delete'),
      );

    }

    $project_table = new AphrontTableView($rows);
    $project_table->setHeaders(
      array(
        'Project ID',
        'Repository',
        '',
        '',
      ));
    $project_table->setColumnClasses(
      array(
        '',
        'wide',
        'action',
        'action',
      ));

    $project_table->setColumnVisibility(
      array(
        true,
        true,
        $is_admin,
        $is_admin,
      ));

    $project_panel = new AphrontPanelView();
    $project_panel->setHeader('Arcanist Projects');
    $project_panel->appendChild($project_table);
    $project_panel->setNoBackground();

    return $this->buildStandardPageResponse(
      array(
        $panel,
        $project_panel,
      ),
      array(
        'title' => 'Repository List',
      ));
  }

}
