-- These are MOCs generated by
-- SELECT smoc(mocorder, scircle '<(27d, -43d), 0.1d>');
-- intended to check automatic casts of other geometries.

CREATE TABLE varorders (
	mocorder smallint,
	geo smoc);
INSERT INTO varorders (mocorder, geo) VALUES
	(1, smoc('1/32 34 1/')),
	(-3, smoc('1/32 34 3/')),
	(3, smoc('3/547-548 550 553 3/')),
	(7, smoc('7/140857-140860 140862 140944-140945 7/')),
	(-7, smoc('1/32 34 7/'));

-- OVERLAPS smoc/scircle

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gsupc
FROM varorders 
WHERE geo @> scircle '<(30d, -43d), 1d>';

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gnsupc
FROM varorders 
WHERE geo !@> scircle '<(30d, -43d), 1d>';

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) csubg
FROM varorders 
WHERE scircle '<(30d, -43d), 1d>' <@ geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cnsubg
FROM varorders 
WHERE scircle '<(30d, -43d), 1d>' !<@ geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gsubc
FROM varorders 
WHERE geo <@ scircle '<(30d, -43d), 1d>';

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gnsubc
FROM varorders 
WHERE geo !<@ scircle '<(30d, -43d), 1d>';

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) csupg
FROM varorders 
WHERE scircle '<(30d, -43d), 1d>' @> geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cnsupg
FROM varorders 
WHERE scircle '<(30d, -43d), 1d>' !@> geo;


-- OVERLAPS smoc/spoly

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gsupp
FROM varorders 
WHERE geo @> spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}');

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gnsupp
FROM varorders 
WHERE geo !@> spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}');

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) psubg
FROM varorders 
WHERE spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}') <@ geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) pnsubg
FROM varorders 
WHERE spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}') !<@ geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gsubp
FROM varorders 
WHERE geo <@ spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}');

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) gnsubp
FROM varorders 
WHERE geo !<@ spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}');

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) psupg
FROM varorders 
WHERE spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}') @> geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) pnsupg
FROM varorders 
WHERE spoly('{(26d,-42d), (26d,-41d), (27d,-41d)}') !@> geo;


-- INTERSECTS smoc/scircle

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cgim
FROM varorders 
WHERE scircle '<(45d, -40d), 1d>' && geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cgnim
FROM varorders 
WHERE scircle '<(45d, -40d), 1d>' !&& geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cmig
FROM varorders 
WHERE geo && scircle '<(45d, -40d), 1d>';

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cnim
FROM varorders 
WHERE geo !&& scircle '<(45d, -40d), 1d>';


-- INTERSECTS smoc/spoly

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cgim
FROM varorders 
WHERE spoly '{(51.1d, -50.1d), (45.8d, -47.5), (46.7d, -43.7d)}' && geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cgnim
FROM varorders 
WHERE spoly '{(51.1d, -50.1d), (45.8d, -47.5), (46.7d, -43.7d)}' !&& geo;

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cmig
FROM varorders 
WHERE geo && spoly '{(51.1d, -50.1d), (45.8d, -47.5), (46.7d, -43.7d)}';

SELECT string_agg(to_char(mocorder, '9'), '/' ORDER BY mocorder) cnim
FROM varorders 
WHERE geo !&& spoly '{(51.1d, -50.1d), (45.8d, -47.5), (46.7d, -43.7d)}';


DROP TABLE varorders;
