//////////////////////////////////////////////////////////////////////////
//
// pgAdmin III - PostgreSQL Tools
// RCS-ID:      $Id: dlgIndexConstraint.cpp 3943 2005-01-10 15:30:26Z dpage $
// Copyright (C) 2002 - 2005, The pgAdmin Development Team
// This software is released under the Artistic Licence
//
// dlgIndexConstraint.cpp - PostgreSQL IndexConstraint Property
//
//////////////////////////////////////////////////////////////////////////

// wxWindows headers
#include <wx/wx.h>

// App headers
#include "pgAdmin3.h"
#include "misc.h"
#include "frmMain.h"
#include "dlgIndexConstraint.h"
#include "pgIndex.h"
#include "pgColumn.h"
#include "pgTable.h"
#include "pgIndexConstraint.h"



#define cbTablespace    CTRL_COMBOBOX("cbTablespace")
#define chkDeferrable   CTRL_CHECKBOX("chkDeferrable")
#define chkDeferred     CTRL_CHECKBOX("chkDeferred")
#define stDeferred      CTRL_STATIC("stDeferred")



BEGIN_EVENT_TABLE(dlgIndexConstraint, dlgIndexBase)
    EVT_CHECKBOX(XRCID("chkDeferrable"),        dlgIndexConstraint::OnCheckDeferrable)
END_EVENT_TABLE();



dlgIndexConstraint::dlgIndexConstraint(frmMain *frame, const wxString &resName, pgIndex *index, pgTable *parentNode)
: dlgIndexBase(frame, resName, index, parentNode)
{
}


dlgIndexConstraint::dlgIndexConstraint(frmMain *frame, const wxString &resName, ctlListView *colList)
: dlgIndexBase(frame, resName, colList)
{
}


int dlgIndexConstraint::Go(bool modal)
{
    wxNotifyEvent event;
    PrepareTablespace(cbTablespace);

    if (index)
    {
        pgIndexConstraint *idc=(pgIndexConstraint*)index;

        chkDeferrable->SetValue(idc->GetDeferrable());
        chkDeferred->SetValue(idc->GetDeferred());
        chkDeferrable->Disable();
        chkDeferred->Disable();
        if (!idc->GetTablespace().IsEmpty())
            cbTablespace->SetValue(idc->GetTablespace());
        cbTablespace->Enable(connection->BackendMinimumVersion(7, 5));
    }
    else
    {
        txtComment->Disable();
    }

    OnCheckDeferrable(event);

    return dlgIndexBase::Go(modal);
}


wxString dlgIndexConstraint::GetDefinition()
{
    wxString sql;

    sql = wxT("(") + GetColumns() + wxT(")");
    AppendIfFilled(sql, wxT(" USING INDEX TABLESPACE "),qtIdent(cbTablespace->GetValue()));
    if (chkDeferrable->GetValue())
    {
        sql += wxT(" DEFERRABLE INITIALLY ");
        if (chkDeferred->Enable())
            sql += wxT("DEFERRED");
        else
            sql += wxT("IMMEDIATE");
    }
    return sql;
}


void dlgIndexConstraint::OnCheckDeferrable(wxCommandEvent &ev)
{
    bool canDef=chkDeferrable->GetValue();
    stDeferred->Enable(canDef);
    if (!canDef)
        chkDeferred->SetValue(false);
    chkDeferred->Enable(canDef);
}


wxString dlgIndexConstraint::GetSql()
{
    wxString sql;
    wxString name=GetName();

    if (!index)
    {
        sql = wxT("ALTER TABLE ") + table->GetQuotedFullIdentifier()
            + wxT(" ADD");
        AppendIfFilled(sql, wxT(" CONSTRAINT "), qtIdent(name));
        sql +=wxT(" ") + wxString(typesList[objectType].typName).Upper() + wxT(" ") + GetDefinition()
            + wxT(";\n");
    }

    if (!name.IsEmpty())
        AppendComment(sql, wxT("CONSTRAINT ") + qtIdent(name) 
            + wxT(" ON ") + table->GetQuotedFullIdentifier(), index);

    return sql;
}




dlgPrimaryKey::dlgPrimaryKey(frmMain *frame, pgIndex *index, pgTable *parentNode)
: dlgIndexConstraint(frame, wxT("dlgIndexConstraint"), index, parentNode)
{
}


dlgPrimaryKey::dlgPrimaryKey(frmMain *frame, ctlListView *colList)
: dlgIndexConstraint(frame, wxT("dlgIndexConstraint"), colList)
{
    objectType=PG_PRIMARYKEY;
}


pgObject *dlgPrimaryKey::CreateObject(pgCollection *collection)
{
    wxString name=GetName();
    if (name.IsEmpty())
        return 0;

    pgObject *obj=pgPrimaryKey::ReadObjects(collection, 0, wxT(
        "\n   AND cls.relname=") + qtString(name) + wxT(
        "\n   AND cls.relnamespace=") + table->GetSchema()->GetOidStr());

    return obj;
}


dlgUnique::dlgUnique(frmMain *frame, pgIndex *index, pgTable *parentNode)
: dlgIndexConstraint(frame, wxT("dlgIndexConstraint"), index, parentNode)
{
}


dlgUnique::dlgUnique(frmMain *frame, ctlListView *colList)
: dlgIndexConstraint(frame, wxT("dlgIndexConstraint"), colList)
{
    objectType = PG_UNIQUE;
}


pgObject *dlgUnique::CreateObject(pgCollection *collection)
{
    wxString name=GetName();

    pgObject *obj=pgUnique::ReadObjects(collection, 0, wxT(
        "\n   AND cls.relname=") + qtString(name) + wxT(
        "\n   AND cls.relnamespace=") + table->GetSchema()->GetOidStr());
    return obj;
}
