/*
 * FILE : src/gtk/wx.cpp
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Build 883)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include "Python.h"

#include <string.h>
#include <stdlib.h>
/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a) __declspec(dllexport) a
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a) a _export
#	else
#	    define SWIGEXPORT(a) a
#	endif
#   endif
#else
#   define SWIGEXPORT(a) a
#endif

#ifdef __cplusplus
extern "C" {
#endif
extern void SWIG_MakePtr(char *, void *, char *);
extern void SWIG_RegisterMapping(char *, char *, void *(*)(void *));
extern char *SWIG_GetPtr(char *, void **, char *);
extern char *SWIG_GetPtrObj(PyObject *, void **, char *);
extern void SWIG_addvarlink(PyObject *, char *, PyObject *(*)(void), int (*)(PyObject *));
extern PyObject *SWIG_newvarlink(void);
#ifdef __cplusplus
}
#endif
#define SWIG_init    initwxc

#define SWIG_name    "wxc"

#include "helpers.h"


static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {
        target = o;
    } else if (target == Py_None) {
        Py_DECREF(Py_None);
        target = o;
    } else {
        if (!PyTuple_Check(target)) {
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);
        PyTuple_SetItem(o3, 0, o);

        o2 = target;
        target = PySequence_Concat(o2, o3);
        Py_DECREF(o2);
        Py_DECREF(o3);
    }
    return target;
}

#if ! wxUSE_HOTKEY
enum wxHotkeyModifier
{
    wxMOD_NONE = 0,
    wxMOD_ALT = 1,
    wxMOD_CONTROL = 2,
    wxMOD_SHIFT = 4,
    wxMOD_WIN = 8
};
#define wxEVT_HOTKEY 9999
#endif


#include <ctype.h>

/*------------------------------------------------------------------
  ptrcast(value,type)

  Constructs a new pointer value.   Value may either be a string
  or an integer. Type is a string corresponding to either the
  C datatype or mangled datatype.

  ptrcast(0,"Vector *")
               or
  ptrcast(0,"Vector_p")   
  ------------------------------------------------------------------ */

static PyObject *ptrcast(PyObject *_PTRVALUE, char *type) {

  char *r,*s;
  void *ptr;
  PyObject *obj;
  char *typestr,*c;

  /* Produce a "mangled" version of the type string.  */

  typestr = (char *) malloc(strlen(type)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr;
  *(r++) = '_';
  c = type;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
        *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;

  /* Check to see what kind of object _PTRVALUE is */
  
  if (PyInt_Check(_PTRVALUE)) {
    ptr = (void *) PyInt_AsLong(_PTRVALUE);
    /* Received a numerical value. Make a pointer out of it */
    r = (char *) malloc(strlen(typestr)+22);
    if (ptr) {
      SWIG_MakePtr(r, ptr, typestr);
    } else {
      sprintf(r,"_0%s",typestr);
    }
    obj = PyString_FromString(r);
    free(r);
  } else if (PyString_Check(_PTRVALUE)) {
    /* Have a real pointer value now.  Try to strip out the pointer
       value */
    s = PyString_AsString(_PTRVALUE);
    r = (char *) malloc(strlen(type)+22);
    
    /* Now extract the pointer value */
    if (!SWIG_GetPtr(s,&ptr,0)) {
      if (ptr) {
	SWIG_MakePtr(r,ptr,typestr);
      } else {
	sprintf(r,"_0%s",typestr);
      }
      obj = PyString_FromString(r);
    } else {
      obj = NULL;
    }
    free(r);
  } else {
    obj = NULL;
  }
  free(typestr);
  if (!obj) 
    PyErr_SetString(PyExc_TypeError,"Type error in ptrcast. Argument is not a valid pointer value.");
  return obj;
}

/*------------------------------------------------------------------
  ptrvalue(ptr,type = 0)

  Attempts to dereference a pointer value.  If type is given, it 
  will try to use that type.  Otherwise, this function will attempt
  to "guess" the proper datatype by checking against all of the 
  builtin C datatypes. 
  ------------------------------------------------------------------ */

static PyObject *ptrvalue(PyObject *_PTRVALUE, int index, char *type) {
  void     *ptr;
  char     *s;
  PyObject *obj;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrvalue. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrvalue. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference NULL pointer.");
    return NULL;
  }

  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    obj = PyInt_FromLong((long) *(((int *) ptr) + index));
  } else if (strcmp(type,"double") == 0) {
    obj = PyFloat_FromDouble((double) *(((double *) ptr)+index));
  } else if (strcmp(type,"short") == 0) {
    obj = PyInt_FromLong((long) *(((short *) ptr)+index));
  } else if (strcmp(type,"long") == 0) {
    obj = PyInt_FromLong((long) *(((long *) ptr)+index));
  } else if (strcmp(type,"float") == 0) {
    obj = PyFloat_FromDouble((double) *(((float *) ptr)+index));
  } else if (strcmp(type,"char") == 0) {
    obj = PyString_FromString(((char *) ptr)+index);
  } else if (strcmp(type,"char *") == 0) {
    char *c = *(((char **) ptr)+index);
    if (c) obj = PyString_FromString(c);
    else obj = PyString_FromString("NULL");
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to dereference unsupported datatype.");
    return NULL;
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrcreate(type,value = 0,numelements = 1)

  Attempts to create a new object of given type.  Type must be
  a basic C datatype.  Will not create complex objects.
  ------------------------------------------------------------------ */

static PyObject *ptrcreate(char *type, PyObject *_PYVALUE, int numelements) {
  void     *ptr;
  PyObject *obj;
  int       sz;
  char     *cast;
  char      temp[40];

  /* Check the type string against a variety of possibilities */

  if (strcmp(type,"int") == 0) {
    sz = sizeof(int)*numelements;
    cast = "_int_p";
  } else if (strcmp(type,"short") == 0) {
    sz = sizeof(short)*numelements;
    cast = "_short_p";
  } else if (strcmp(type,"long") == 0) {
    sz = sizeof(long)*numelements;
    cast = "_long_p";
  } else if (strcmp(type,"double") == 0) {
    sz = sizeof(double)*numelements;
    cast = "_double_p";
  } else if (strcmp(type,"float") == 0) {
    sz = sizeof(float)*numelements;
    cast = "_float_p";
  } else if (strcmp(type,"char") == 0) {
    sz = sizeof(char)*numelements;
    cast = "_char_p";
  } else if (strcmp(type,"char *") == 0) {
    sz = sizeof(char *)*(numelements+1);
    cast = "_char_pp";
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to create unknown datatype."); 
    return NULL;
  }
   
  /* Create the new object */
  
  ptr = (void *) malloc(sz);
  if (!ptr) {
    PyErr_SetString(PyExc_MemoryError,"Out of memory in swig_create."); 
    return NULL;
  }

  /* Now try to set its default value */

  if (_PYVALUE) {
    if (strcmp(type,"int") == 0) {
      int *ip,i,ivalue;
      ivalue = (int) PyInt_AsLong(_PYVALUE);
      ip = (int *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"short") == 0) {
      short *ip,ivalue;
      int i;
      ivalue = (short) PyInt_AsLong(_PYVALUE);
      ip = (short *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"long") == 0) {
      long *ip,ivalue;
      int i;
      ivalue = (long) PyInt_AsLong(_PYVALUE);
      ip = (long *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"double") == 0) {
      double *ip,ivalue;
      int i;
      ivalue = (double) PyFloat_AsDouble(_PYVALUE);
      ip = (double *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"float") == 0) {
      float *ip,ivalue;
      int i;
      ivalue = (float) PyFloat_AsDouble(_PYVALUE);
      ip = (float *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"char") == 0) {
      char *ip,*ivalue;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char *) ptr;
      strncpy(ip,ivalue,numelements-1);
    } else if (strcmp(type,"char *") == 0) {
      char **ip, *ivalue;
      int  i;
      ivalue = (char *) PyString_AsString(_PYVALUE);
      ip = (char **) ptr;
      for (i = 0; i < numelements; i++) {
	if (ivalue) {
	  ip[i] = (char *) malloc(strlen(ivalue)+1);
	  strcpy(ip[i],ivalue);
	} else {
	  ip[i] = 0;
	}
      }
      ip[numelements] = 0;
    }
  } 
  /* Create the pointer value */
  
  SWIG_MakePtr(temp,ptr,cast);
  obj = PyString_FromString(temp);
  return obj;
}


/*------------------------------------------------------------------
  ptrset(ptr,value,index = 0,type = 0)

  Attempts to set the value of a pointer variable.  If type is
  given, we will use that type.  Otherwise, we'll guess the datatype.
  ------------------------------------------------------------------ */

static PyObject *ptrset(PyObject *_PTRVALUE, PyObject *_PYVALUE, int index, char *type) {
  void     *ptr;
  char     *s;
  PyObject *obj;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrset. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrset. Argument is not a valid pointer value.");
    return NULL;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      type = "int";
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      type = "double";
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      type = "short";
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      type = "long";
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      type = "float";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      type = "char";
    } else if (!SWIG_GetPtr(s,&ptr,"_char_pp")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    PyErr_SetString(PyExc_TypeError,"Unable to set NULL pointer.");
    return NULL;
  }
  
  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    *(((int *) ptr)+index) = (int) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"double") == 0) {
    *(((double *) ptr)+index) = (double) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"short") == 0) {
    *(((short *) ptr)+index) = (short) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"long") == 0) {
    *(((long *) ptr)+index) = (long) PyInt_AsLong(_PYVALUE);
  } else if (strcmp(type,"float") == 0) {
    *(((float *) ptr)+index) = (float) PyFloat_AsDouble(_PYVALUE);
  } else if (strcmp(type,"char") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    strcpy(((char *) ptr)+index, c);
  } else if (strcmp(type,"char *") == 0) {
    char *c = PyString_AsString(_PYVALUE);
    char **ca = (char **) ptr;
    if (ca[index]) free(ca[index]);
    if (strcmp(c,"NULL") == 0) {
      ca[index] = 0;
    } else {
      ca[index] = (char *) malloc(strlen(c)+1);
      strcpy(ca[index],c);
    }
  } else {
    PyErr_SetString(PyExc_TypeError,"Unable to set unsupported datatype.");
    return NULL;
  }
  Py_INCREF(Py_None);
  return Py_None;
}


/*------------------------------------------------------------------
  ptradd(ptr,offset)

  Adds a value to an existing pointer value.  Will do a type-dependent
  add for basic datatypes.  For other datatypes, will do a byte-add.
  ------------------------------------------------------------------ */

static PyObject *ptradd(PyObject *_PTRVALUE, int offset) {

  char *r,*s;
  void *ptr,*junk;
  PyObject *obj;
  char *type;

  /* Check to see what kind of object _PTRVALUE is */
  
  if (PyString_Check(_PTRVALUE)) {
    /* Have a potential pointer value now.  Try to strip out the value */
    s = PyString_AsString(_PTRVALUE);

    /* Try to handle a few common datatypes first */

    if (!SWIG_GetPtr(s,&ptr,"_int_p")) {
      ptr = (void *) (((int *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_double_p")) {
      ptr = (void *) (((double *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_short_p")) {
      ptr = (void *) (((short *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_long_p")) {
      ptr = (void *) (((long *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_float_p")) {
      ptr = (void *) (((float *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,"_char_p")) {
      ptr = (void *) (((char *) ptr) + offset);
    } else if (!SWIG_GetPtr(s,&ptr,0)) {
      ptr = (void *) (((char *) ptr) + offset);
    } else {
      PyErr_SetString(PyExc_TypeError,"Type error in ptradd. Argument is not a valid pointer value.");
      return NULL;
    }
    type = SWIG_GetPtr(s,&junk,"INVALID POINTER");
    r = (char *) malloc(strlen(type)+20);
    if (ptr) {
      SWIG_MakePtr(r,ptr,type);
    } else {
      sprintf(r,"_0%s",type);
    }
    obj = PyString_FromString(r);
    free(r);
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrmap(type1,type2)

  Allows a mapping between type1 and type2. (Like a typedef)
  ------------------------------------------------------------------ */

static void ptrmap(char *type1, char *type2) {

  char *typestr1,*typestr2,*c,*r;

  /* Produce a "mangled" version of the type string.  */

  typestr1 = (char *) malloc(strlen(type1)+2);
  
  /* Go through and munge the typestring */
  
  r = typestr1;
  *(r++) = '_';
  c = type1;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  
  typestr2 = (char *) malloc(strlen(type2)+2);

  /* Go through and munge the typestring */
  
  r = typestr2;
  *(r++) = '_';
  c = type2;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	*(r++) = 'p';
      }
      else *(r++) = *c;
    } else {
      *(r++) = '_';
    }
    c++;
  }
  *(r++) = 0;
  SWIG_RegisterMapping(typestr1,typestr2,0);
  SWIG_RegisterMapping(typestr2,typestr1,0);
}

/*------------------------------------------------------------------
  ptrfree(ptr)

  Destroys a pointer value
  ------------------------------------------------------------------ */

PyObject *ptrfree(PyObject *_PTRVALUE) {
  void *ptr, *junk;
  char *s;

  if (!PyString_Check(_PTRVALUE)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrfree. Argument is not a valid pointer value.");
    return NULL;
  }
  s = PyString_AsString(_PTRVALUE);
  if (SWIG_GetPtr(s,&ptr,0)) {
    PyErr_SetString(PyExc_TypeError,"Type error in ptrfree. Argument is not a valid pointer value.");
    return NULL;
  }

  /* Check to see if this pointer is a char ** */
  if (!SWIG_GetPtr(s,&junk,"_char_pp")) {
    char **c = (char **) ptr;
    if (c) {
      int i = 0;
      while (c[i]) {
	free(c[i]);
	i++;
      }
    }
  } 
  if (ptr)
    free((char *) ptr);

  Py_INCREF(Py_None);
  return Py_None;
}


    wxPyApp* wxGetApp() {
        //return wxPythonApp;
        return (wxPyApp*)wxTheApp;
    }

    void wxApp_CleanUp() {
        __wxCleanup();
    }



extern "C" SWIGEXPORT(void) initwindowsc();
extern "C" SWIGEXPORT(void) initwindows2c();
extern "C" SWIGEXPORT(void) initeventsc();
extern "C" SWIGEXPORT(void) initmiscc();
extern "C" SWIGEXPORT(void) initmisc2c();
extern "C" SWIGEXPORT(void) initgdic();
extern "C" SWIGEXPORT(void) initmdic();
extern "C" SWIGEXPORT(void) initcontrolsc();
extern "C" SWIGEXPORT(void) initcontrols2c();
extern "C" SWIGEXPORT(void) initcmndlgsc();
extern "C" SWIGEXPORT(void) initstattoolc();
extern "C" SWIGEXPORT(void) initframesc();
extern "C" SWIGEXPORT(void) initwindows3c();
extern "C" SWIGEXPORT(void) initimagec();
extern "C" SWIGEXPORT(void) initprintfwc();
extern "C" SWIGEXPORT(void) initsizersc();
extern "C" SWIGEXPORT(void) initclip_dndc();
extern "C" SWIGEXPORT(void) initstreamsc();
extern "C" SWIGEXPORT(void) initfilesysc();
extern "C" SWIGEXPORT(void) initutilsc();
extern "C" SWIGEXPORT(void) initfontsc();



// Export a C API in a struct.  Other modules will be able to load this from
// the wxc module and will then have safe access to these functions, even if
// in another shared library.
static wxPyCoreAPI API = {
    (p_SWIG_MakePtr_t)SWIG_MakePtr,
    (p_SWIG_GetPtr_t)SWIG_GetPtr,
    (p_SWIG_GetPtrObj_t)SWIG_GetPtrObj,
    (p_SWIG_RegisterMapping_t)SWIG_RegisterMapping,
    (p_SWIG_addvarlink_t)SWIG_addvarlink,
    (p_SWIG_newvarlink_t)SWIG_newvarlink,

    wxPyBeginAllowThreads,
    wxPyEndAllowThreads,
    wxPyBeginBlockThreads,
    wxPyEndBlockThreads,

    wxPyConstructObject,
    wxPy_ConvertList,

    wxString_in_helper,
    Py2wxString,
    wx2PyString,

    byte_LIST_helper,
    int_LIST_helper,
    long_LIST_helper,
    string_LIST_helper,
    wxPoint_LIST_helper,
    wxBitmap_LIST_helper,
    wxString_LIST_helper,
    wxAcceleratorEntry_LIST_helper,

    wxSize_helper,
    wxPoint_helper,
    wxRealPoint_helper,
    wxRect_helper,
    wxColour_helper,
    wxPoint2DDouble_helper,

    wxPyCBH_setCallbackInfo,
    wxPyCBH_findCallback,
    wxPyCBH_callCallback,
    wxPyCBH_callCallbackObj,
    wxPyCBH_delete,

    wxPyClassExists,
    wxPyMake_wxObject,
    wxPyMake_wxSizer,
    wxPyPtrTypeMap_Add,
    wxArrayString2PyList_helper,
    wxArrayInt2PyList_helper,

    wxPyClientData_dtor,
    wxPyUserData_dtor,
    wxPyOORClientData_dtor,

    wxPyCBInputStream_create
};


#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_ptrcast(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;
    char *_kwnames[] = { "ptr","type", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"Os:ptrcast",_kwnames,&_obj0,&_arg1)) 
        return NULL;
{
  _arg0 = _obj0;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (PyObject *)ptrcast(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrvalue(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    int  _arg1 = (int ) 0;
    char * _arg2 = (char *) 0;
    PyObject * _obj0 = 0;
    char *_kwnames[] = { "ptr","index","type", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O|is:ptrvalue",_kwnames,&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
  _arg0 = _obj0;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (PyObject *)ptrvalue(_arg0,_arg1,_arg2);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrset(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    PyObject * _arg1;
    int  _arg2 = (int ) 0;
    char * _arg3 = (char *) 0;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    char *_kwnames[] = { "ptr","value","index","type", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"OO|is:ptrset",_kwnames,&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
  _arg0 = _obj0;
}
{
  _arg1 = _obj1;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (PyObject *)ptrset(_arg0,_arg1,_arg2,_arg3);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrcreate(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    PyObject * _result;
    char * _arg0;
    PyObject * _arg1 = (PyObject *) 0;
    int  _arg2 = (int ) 1;
    PyObject * _obj1 = 0;
    char *_kwnames[] = { "type","value","nitems", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"s|Oi:ptrcreate",_kwnames,&_arg0,&_obj1,&_arg2)) 
        return NULL;
    if (_obj1)
{
  _arg1 = _obj1;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (PyObject *)ptrcreate(_arg0,_arg1,_arg2);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrfree(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    PyObject * _obj0 = 0;
    char *_kwnames[] = { "ptr", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:ptrfree",_kwnames,&_obj0)) 
        return NULL;
{
  _arg0 = _obj0;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (PyObject *)ptrfree(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptradd(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    PyObject * _result;
    PyObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;
    char *_kwnames[] = { "ptr","offset", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"Oi:ptradd",_kwnames,&_obj0,&_arg1)) 
        return NULL;
{
  _arg0 = _obj0;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (PyObject *)ptradd(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_ptrmap(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    char * _arg0;
    char * _arg1;
    char *_kwnames[] = { "type1","type2", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"ss:ptrmap",_kwnames,&_arg0,&_arg1)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    ptrmap(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static int _wrap_wxDefaultPosition_set(PyObject *val) {

    PyErr_SetString(PyExc_TypeError,"Variable wxDefaultPosition is read-only.");
    return 1;
}

static PyObject *_wrap_wxDefaultPosition_get() {
    PyObject * pyobj;
    char ptemp[128];

    SWIG_MakePtr(ptemp,(char *) &wxDefaultPosition,"_wxPoint_p");
    pyobj = PyString_FromString(ptemp);
    return pyobj;
}

static int _wrap_wxDefaultSize_set(PyObject *val) {

    PyErr_SetString(PyExc_TypeError,"Variable wxDefaultSize is read-only.");
    return 1;
}

static PyObject *_wrap_wxDefaultSize_get() {
    PyObject * pyobj;
    char ptemp[128];

    SWIG_MakePtr(ptemp,(char *) &wxDefaultSize,"_wxSize_p");
    pyobj = PyString_FromString(ptemp);
    return pyobj;
}

static PyObject *_wrap_wxGetApp(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _result;
    char *_kwnames[] = {  NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":wxGetApp",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (wxPyApp *)wxGetApp();

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{ _resultobj = wxPyMake_wxObject(_result); }
    return _resultobj;
}

static PyObject *_wrap_wxApp_CleanUp(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    char *_kwnames[] = {  NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":wxApp_CleanUp",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxApp_CleanUp();

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static void *SwigwxPyAppTowxEvtHandler(void *ptr) {
    wxPyApp *src;
    wxEvtHandler *dest;
    src = (wxPyApp *) ptr;
    dest = (wxEvtHandler *) src;
    return (void *) dest;
}

static void *SwigwxPyAppTowxObject(void *ptr) {
    wxPyApp *src;
    wxObject *dest;
    src = (wxPyApp *) ptr;
    dest = (wxObject *) src;
    return (void *) dest;
}

static wxPyApp *new_wxPyApp() {
            wxPythonApp = new wxPyApp();
            return wxPythonApp;
        }

static PyObject *_wrap_new_wxPyApp(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _result;
    char *_kwnames[] = {  NULL };
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":new_wxPyApp",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (wxPyApp *)new_wxPyApp();

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_wxPyApp_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

#define delete_wxPyApp(_swigobj) (delete _swigobj)
static PyObject *_wrap_delete_wxPyApp(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:delete_wxPyApp",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_wxPyApp. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    delete_wxPyApp(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp__setCallbackInfo(_swigobj,_swigarg0,_swigarg1)  (_swigobj->_setCallbackInfo(_swigarg0,_swigarg1))
static PyObject *_wrap_wxPyApp__setCallbackInfo(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    PyObject * _arg1;
    PyObject * _arg2;
    PyObject * _argo0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    char *_kwnames[] = { "self","self","_class", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"OOO:wxPyApp__setCallbackInfo",_kwnames,&_argo0,&_obj1,&_obj2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp__setCallbackInfo. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
  _arg1 = _obj1;
}
{
  _arg2 = _obj2;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp__setCallbackInfo(_arg0,_arg1,_arg2);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp_GetAppName(_swigobj)  (_swigobj->GetAppName())
static PyObject *_wrap_wxPyApp_GetAppName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxString * _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetAppName",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetAppName. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = new wxString (wxPyApp_GetAppName(_arg0));

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
#if wxUSE_UNICODE
    _resultobj = PyUnicode_FromWideChar(_result->c_str(), _result->Len());
#else
    _resultobj = PyString_FromStringAndSize(_result->c_str(), _result->Len());
#endif
}
{
    delete _result;
}
    return _resultobj;
}

#define wxPyApp_GetClassName(_swigobj)  (_swigobj->GetClassName())
static PyObject *_wrap_wxPyApp_GetClassName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxString * _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetClassName",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetClassName. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = new wxString (wxPyApp_GetClassName(_arg0));

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
#if wxUSE_UNICODE
    _resultobj = PyUnicode_FromWideChar(_result->c_str(), _result->Len());
#else
    _resultobj = PyString_FromStringAndSize(_result->c_str(), _result->Len());
#endif
}
{
    delete _result;
}
    return _resultobj;
}

#define wxPyApp_GetExitOnFrameDelete(_swigobj)  (_swigobj->GetExitOnFrameDelete())
static PyObject *_wrap_wxPyApp_GetExitOnFrameDelete(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetExitOnFrameDelete",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetExitOnFrameDelete. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (bool )wxPyApp_GetExitOnFrameDelete(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_GetPrintMode(_swigobj)  (_swigobj->GetPrintMode())
static PyObject *_wrap_wxPyApp_GetPrintMode(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    int  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetPrintMode",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetPrintMode. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (int )wxPyApp_GetPrintMode(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_GetTopWindow(_swigobj)  (_swigobj->GetTopWindow())
static PyObject *_wrap_wxPyApp_GetTopWindow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxWindow * _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetTopWindow",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetTopWindow. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (wxWindow *)wxPyApp_GetTopWindow(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{ _resultobj = wxPyMake_wxObject(_result); }
    return _resultobj;
}

#define wxPyApp_GetVendorName(_swigobj)  (_swigobj->GetVendorName())
static PyObject *_wrap_wxPyApp_GetVendorName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxString * _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetVendorName",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetVendorName. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = new wxString (wxPyApp_GetVendorName(_arg0));

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
#if wxUSE_UNICODE
    _resultobj = PyUnicode_FromWideChar(_result->c_str(), _result->Len());
#else
    _resultobj = PyString_FromStringAndSize(_result->c_str(), _result->Len());
#endif
}
{
    delete _result;
}
    return _resultobj;
}

#define wxPyApp_GetUseBestVisual(_swigobj)  (_swigobj->GetUseBestVisual())
static PyObject *_wrap_wxPyApp_GetUseBestVisual(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetUseBestVisual",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetUseBestVisual. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (bool )wxPyApp_GetUseBestVisual(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_Dispatch(_swigobj)  (_swigobj->Dispatch())
static PyObject *_wrap_wxPyApp_Dispatch(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_Dispatch",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_Dispatch. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_Dispatch(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp_ExitMainLoop(_swigobj)  (_swigobj->ExitMainLoop())
static PyObject *_wrap_wxPyApp_ExitMainLoop(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_ExitMainLoop",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_ExitMainLoop. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_ExitMainLoop(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp_Initialized(_swigobj)  (_swigobj->Initialized())
static PyObject *_wrap_wxPyApp_Initialized(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_Initialized",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_Initialized. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (bool )wxPyApp_Initialized(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_MainLoop(_swigobj)  (_swigobj->MainLoop())
static PyObject *_wrap_wxPyApp_MainLoop(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    int  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_MainLoop",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_MainLoop. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (int )wxPyApp_MainLoop(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_Pending(_swigobj)  (_swigobj->Pending())
static PyObject *_wrap_wxPyApp_Pending(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_Pending",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_Pending. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (bool )wxPyApp_Pending(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_ProcessIdle(_swigobj)  (_swigobj->ProcessIdle())
static PyObject *_wrap_wxPyApp_ProcessIdle(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_ProcessIdle",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_ProcessIdle. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (bool )wxPyApp_ProcessIdle(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_Yield(_swigobj,_swigarg0)  (_swigobj->Yield(_swigarg0))
static PyObject *_wrap_wxPyApp_Yield(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _result;
    wxPyApp * _arg0;
    bool  _arg1 = (bool ) FALSE;
    PyObject * _argo0 = 0;
    int tempbool1 = (int) FALSE;
    char *_kwnames[] = { "self","onlyIfNeeded", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O|i:wxPyApp_Yield",_kwnames,&_argo0,&tempbool1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_Yield. Expected _wxPyApp_p.");
        return NULL;
        }
    }
    _arg1 = (bool ) tempbool1;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (bool )wxPyApp_Yield(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_SetAppName(_swigobj,_swigarg0)  (_swigobj->SetAppName(_swigarg0))
static PyObject *_wrap_wxPyApp_SetAppName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    wxString * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _obj1 = 0;
    char *_kwnames[] = { "self","name", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"OO:wxPyApp_SetAppName",_kwnames,&_argo0,&_obj1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetAppName. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    _arg1 = wxString_in_helper(_obj1);
    if (_arg1 == NULL)
        return NULL;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetAppName(_arg0,*_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
    if (_obj1)
        delete _arg1;
}
    return _resultobj;
}

#define wxPyApp_SetClassName(_swigobj,_swigarg0)  (_swigobj->SetClassName(_swigarg0))
static PyObject *_wrap_wxPyApp_SetClassName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    wxString * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _obj1 = 0;
    char *_kwnames[] = { "self","name", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"OO:wxPyApp_SetClassName",_kwnames,&_argo0,&_obj1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetClassName. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    _arg1 = wxString_in_helper(_obj1);
    if (_arg1 == NULL)
        return NULL;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetClassName(_arg0,*_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
    if (_obj1)
        delete _arg1;
}
    return _resultobj;
}

#define wxPyApp_SetExitOnFrameDelete(_swigobj,_swigarg0)  (_swigobj->SetExitOnFrameDelete(_swigarg0))
static PyObject *_wrap_wxPyApp_SetExitOnFrameDelete(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    bool  _arg1;
    PyObject * _argo0 = 0;
    int tempbool1;
    char *_kwnames[] = { "self","flag", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"Oi:wxPyApp_SetExitOnFrameDelete",_kwnames,&_argo0,&tempbool1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetExitOnFrameDelete. Expected _wxPyApp_p.");
        return NULL;
        }
    }
    _arg1 = (bool ) tempbool1;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetExitOnFrameDelete(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp_SetPrintMode(_swigobj,_swigarg0)  (_swigobj->SetPrintMode(_swigarg0))
static PyObject *_wrap_wxPyApp_SetPrintMode(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self","mode", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"Oi:wxPyApp_SetPrintMode",_kwnames,&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetPrintMode. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetPrintMode(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp_SetTopWindow(_swigobj,_swigarg0)  (_swigobj->SetTopWindow(_swigarg0))
static PyObject *_wrap_wxPyApp_SetTopWindow(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    wxWindow * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;
    char *_kwnames[] = { "self","window", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"OO:wxPyApp_SetTopWindow",_kwnames,&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetTopWindow. Expected _wxPyApp_p.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_wxWindow_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of wxPyApp_SetTopWindow. Expected _wxWindow_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetTopWindow(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp_SetVendorName(_swigobj,_swigarg0)  (_swigobj->SetVendorName(_swigarg0))
static PyObject *_wrap_wxPyApp_SetVendorName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    wxString * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _obj1 = 0;
    char *_kwnames[] = { "self","name", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"OO:wxPyApp_SetVendorName",_kwnames,&_argo0,&_obj1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetVendorName. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    _arg1 = wxString_in_helper(_obj1);
    if (_arg1 == NULL)
        return NULL;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetVendorName(_arg0,*_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
    if (_obj1)
        delete _arg1;
}
    return _resultobj;
}

#define wxPyApp_SetUseBestVisual(_swigobj,_swigarg0)  (_swigobj->SetUseBestVisual(_swigarg0))
static PyObject *_wrap_wxPyApp_SetUseBestVisual(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    bool  _arg1;
    PyObject * _argo0 = 0;
    int tempbool1;
    char *_kwnames[] = { "self","flag", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"Oi:wxPyApp_SetUseBestVisual",_kwnames,&_argo0,&tempbool1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetUseBestVisual. Expected _wxPyApp_p.");
        return NULL;
        }
    }
    _arg1 = (bool ) tempbool1;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetUseBestVisual(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define wxPyApp_GetAssertMode(_swigobj)  (_swigobj->GetAssertMode())
static PyObject *_wrap_wxPyApp_GetAssertMode(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    int  _result;
    wxPyApp * _arg0;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_GetAssertMode",_kwnames,&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_GetAssertMode. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (int )wxPyApp_GetAssertMode(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

#define wxPyApp_SetAssertMode(_swigobj,_swigarg0)  (_swigobj->SetAssertMode(_swigarg0))
static PyObject *_wrap_wxPyApp_SetAssertMode(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxPyApp * _arg0;
    int  _arg1;
    PyObject * _argo0 = 0;
    char *_kwnames[] = { "self","mode", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"Oi:wxPyApp_SetAssertMode",_kwnames,&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_wxPyApp_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of wxPyApp_SetAssertMode. Expected _wxPyApp_p.");
        return NULL;
        }
    }
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp_SetAssertMode(_arg0,_arg1);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_GetMacSupportPCMenuShortcuts(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _result;
    char *_kwnames[] = {  NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":wxPyApp_GetMacSupportPCMenuShortcuts",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (bool )wxPyApp::GetMacSupportPCMenuShortcuts();

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_GetMacAboutMenuItemId(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    long  _result;
    char *_kwnames[] = {  NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":wxPyApp_GetMacAboutMenuItemId",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (long )wxPyApp::GetMacAboutMenuItemId();

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_GetMacPreferencesMenuItemId(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    long  _result;
    char *_kwnames[] = {  NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":wxPyApp_GetMacPreferencesMenuItemId",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (long )wxPyApp::GetMacPreferencesMenuItemId();

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_GetMacExitMenuItemId(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    long  _result;
    char *_kwnames[] = {  NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":wxPyApp_GetMacExitMenuItemId",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = (long )wxPyApp::GetMacExitMenuItemId();

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_GetMacHelpMenuTitleName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxString * _result;
    char *_kwnames[] = {  NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,":wxPyApp_GetMacHelpMenuTitleName",_kwnames)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    _result = new wxString (wxPyApp::GetMacHelpMenuTitleName());

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}{
#if wxUSE_UNICODE
    _resultobj = PyUnicode_FromWideChar(_result->c_str(), _result->Len());
#else
    _resultobj = PyString_FromStringAndSize(_result->c_str(), _result->Len());
#endif
}
{
    delete _result;
}
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_SetMacSupportPCMenuShortcuts(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    bool  _arg0;
    int tempbool0;
    char *_kwnames[] = { "val", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"i:wxPyApp_SetMacSupportPCMenuShortcuts",_kwnames,&tempbool0)) 
        return NULL;
    _arg0 = (bool ) tempbool0;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp::SetMacSupportPCMenuShortcuts(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_SetMacAboutMenuItemId(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    long  _arg0;
    char *_kwnames[] = { "val", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"l:wxPyApp_SetMacAboutMenuItemId",_kwnames,&_arg0)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp::SetMacAboutMenuItemId(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_SetMacPreferencesMenuItemId(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    long  _arg0;
    char *_kwnames[] = { "val", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"l:wxPyApp_SetMacPreferencesMenuItemId",_kwnames,&_arg0)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp::SetMacPreferencesMenuItemId(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_SetMacExitMenuItemId(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    long  _arg0;
    char *_kwnames[] = { "val", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"l:wxPyApp_SetMacExitMenuItemId",_kwnames,&_arg0)) 
        return NULL;
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp::SetMacExitMenuItemId(_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_wxPyApp_SetMacHelpMenuTitleName(PyObject *self, PyObject *args, PyObject *kwargs) {
    PyObject * _resultobj;
    wxString * _arg0;
    PyObject * _obj0 = 0;
    char *_kwnames[] = { "val", NULL };

    self = self;
    if(!PyArg_ParseTupleAndKeywords(args,kwargs,"O:wxPyApp_SetMacHelpMenuTitleName",_kwnames,&_obj0)) 
        return NULL;
{
    _arg0 = wxString_in_helper(_obj0);
    if (_arg0 == NULL)
        return NULL;
}
{
    PyThreadState* __tstate = wxPyBeginAllowThreads();
    wxPyApp::SetMacHelpMenuTitleName(*_arg0);

    wxPyEndAllowThreads(__tstate);
    if (PyErr_Occurred()) return NULL;
}    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
    if (_obj0)
        delete _arg0;
}
    return _resultobj;
}

static PyMethodDef wxcMethods[] = {
	 { "wxPyApp_SetMacHelpMenuTitleName", (PyCFunction) _wrap_wxPyApp_SetMacHelpMenuTitleName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetMacExitMenuItemId", (PyCFunction) _wrap_wxPyApp_SetMacExitMenuItemId, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetMacPreferencesMenuItemId", (PyCFunction) _wrap_wxPyApp_SetMacPreferencesMenuItemId, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetMacAboutMenuItemId", (PyCFunction) _wrap_wxPyApp_SetMacAboutMenuItemId, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetMacSupportPCMenuShortcuts", (PyCFunction) _wrap_wxPyApp_SetMacSupportPCMenuShortcuts, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetMacHelpMenuTitleName", (PyCFunction) _wrap_wxPyApp_GetMacHelpMenuTitleName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetMacExitMenuItemId", (PyCFunction) _wrap_wxPyApp_GetMacExitMenuItemId, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetMacPreferencesMenuItemId", (PyCFunction) _wrap_wxPyApp_GetMacPreferencesMenuItemId, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetMacAboutMenuItemId", (PyCFunction) _wrap_wxPyApp_GetMacAboutMenuItemId, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetMacSupportPCMenuShortcuts", (PyCFunction) _wrap_wxPyApp_GetMacSupportPCMenuShortcuts, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetAssertMode", (PyCFunction) _wrap_wxPyApp_SetAssertMode, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetAssertMode", (PyCFunction) _wrap_wxPyApp_GetAssertMode, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetUseBestVisual", (PyCFunction) _wrap_wxPyApp_SetUseBestVisual, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetVendorName", (PyCFunction) _wrap_wxPyApp_SetVendorName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetTopWindow", (PyCFunction) _wrap_wxPyApp_SetTopWindow, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetPrintMode", (PyCFunction) _wrap_wxPyApp_SetPrintMode, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetExitOnFrameDelete", (PyCFunction) _wrap_wxPyApp_SetExitOnFrameDelete, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetClassName", (PyCFunction) _wrap_wxPyApp_SetClassName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_SetAppName", (PyCFunction) _wrap_wxPyApp_SetAppName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_Yield", (PyCFunction) _wrap_wxPyApp_Yield, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_ProcessIdle", (PyCFunction) _wrap_wxPyApp_ProcessIdle, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_Pending", (PyCFunction) _wrap_wxPyApp_Pending, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_MainLoop", (PyCFunction) _wrap_wxPyApp_MainLoop, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_Initialized", (PyCFunction) _wrap_wxPyApp_Initialized, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_ExitMainLoop", (PyCFunction) _wrap_wxPyApp_ExitMainLoop, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_Dispatch", (PyCFunction) _wrap_wxPyApp_Dispatch, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetUseBestVisual", (PyCFunction) _wrap_wxPyApp_GetUseBestVisual, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetVendorName", (PyCFunction) _wrap_wxPyApp_GetVendorName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetTopWindow", (PyCFunction) _wrap_wxPyApp_GetTopWindow, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetPrintMode", (PyCFunction) _wrap_wxPyApp_GetPrintMode, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetExitOnFrameDelete", (PyCFunction) _wrap_wxPyApp_GetExitOnFrameDelete, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetClassName", (PyCFunction) _wrap_wxPyApp_GetClassName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp_GetAppName", (PyCFunction) _wrap_wxPyApp_GetAppName, METH_VARARGS | METH_KEYWORDS },
	 { "wxPyApp__setCallbackInfo", (PyCFunction) _wrap_wxPyApp__setCallbackInfo, METH_VARARGS | METH_KEYWORDS },
	 { "delete_wxPyApp", (PyCFunction) _wrap_delete_wxPyApp, METH_VARARGS | METH_KEYWORDS },
	 { "new_wxPyApp", (PyCFunction) _wrap_new_wxPyApp, METH_VARARGS | METH_KEYWORDS },
	 { "wxApp_CleanUp", (PyCFunction) _wrap_wxApp_CleanUp, METH_VARARGS | METH_KEYWORDS },
	 { "wxGetApp", (PyCFunction) _wrap_wxGetApp, METH_VARARGS | METH_KEYWORDS },
	 { "_wxSetDictionary", (PyCFunction) __wxSetDictionary, METH_VARARGS | METH_KEYWORDS },
	 { "_wxStart", (PyCFunction) __wxStart, METH_VARARGS | METH_KEYWORDS },
	 { "ptrmap", (PyCFunction) _wrap_ptrmap, METH_VARARGS | METH_KEYWORDS },
	 { "ptradd", (PyCFunction) _wrap_ptradd, METH_VARARGS | METH_KEYWORDS },
	 { "ptrfree", (PyCFunction) _wrap_ptrfree, METH_VARARGS | METH_KEYWORDS },
	 { "ptrcreate", (PyCFunction) _wrap_ptrcreate, METH_VARARGS | METH_KEYWORDS },
	 { "ptrset", (PyCFunction) _wrap_ptrset, METH_VARARGS | METH_KEYWORDS },
	 { "ptrvalue", (PyCFunction) _wrap_ptrvalue, METH_VARARGS | METH_KEYWORDS },
	 { "ptrcast", (PyCFunction) _wrap_ptrcast, METH_VARARGS | METH_KEYWORDS },
	 { NULL, NULL }
};
#ifdef __cplusplus
}
#endif
/*
 * This table is used by the pointer type-checker
 */
static struct { char *n1; char *n2; void *(*pcnv)(void *); } _swig_mapping[] = {
    { "_signed_long","_long",0},
    { "_wxPrintQuality","_wxCoord",0},
    { "_wxPrintQuality","_int",0},
    { "_wxPrintQuality","_signed_int",0},
    { "_wxPrintQuality","_unsigned_int",0},
    { "_wxPrintQuality","_wxWindowID",0},
    { "_wxPrintQuality","_uint",0},
    { "_wxPrintQuality","_EBool",0},
    { "_wxPrintQuality","_size_t",0},
    { "_wxPrintQuality","_time_t",0},
    { "_byte","_unsigned_char",0},
    { "_long","_unsigned_long",0},
    { "_long","_signed_long",0},
    { "_size_t","_wxCoord",0},
    { "_size_t","_wxPrintQuality",0},
    { "_size_t","_time_t",0},
    { "_size_t","_unsigned_int",0},
    { "_size_t","_int",0},
    { "_size_t","_wxWindowID",0},
    { "_size_t","_uint",0},
    { "_uint","_wxCoord",0},
    { "_uint","_wxPrintQuality",0},
    { "_uint","_time_t",0},
    { "_uint","_size_t",0},
    { "_uint","_unsigned_int",0},
    { "_uint","_int",0},
    { "_uint","_wxWindowID",0},
    { "_wxChar","_char",0},
    { "_char","_wxChar",0},
    { "_struct_wxNativeFontInfo","_wxNativeFontInfo",0},
    { "_EBool","_wxCoord",0},
    { "_EBool","_wxPrintQuality",0},
    { "_EBool","_signed_int",0},
    { "_EBool","_int",0},
    { "_EBool","_wxWindowID",0},
    { "_unsigned_long","_long",0},
    { "_wxNativeFontInfo","_struct_wxNativeFontInfo",0},
    { "_signed_int","_wxCoord",0},
    { "_signed_int","_wxPrintQuality",0},
    { "_signed_int","_EBool",0},
    { "_signed_int","_wxWindowID",0},
    { "_signed_int","_int",0},
    { "_WXTYPE","_wxDateTime_t",0},
    { "_WXTYPE","_short",0},
    { "_WXTYPE","_signed_short",0},
    { "_WXTYPE","_unsigned_short",0},
    { "_unsigned_short","_wxDateTime_t",0},
    { "_unsigned_short","_WXTYPE",0},
    { "_unsigned_short","_short",0},
    { "_wxObject","_wxPyApp",SwigwxPyAppTowxObject},
    { "_signed_short","_WXTYPE",0},
    { "_signed_short","_short",0},
    { "_unsigned_char","_byte",0},
    { "_unsigned_int","_wxCoord",0},
    { "_unsigned_int","_wxPrintQuality",0},
    { "_unsigned_int","_time_t",0},
    { "_unsigned_int","_size_t",0},
    { "_unsigned_int","_uint",0},
    { "_unsigned_int","_wxWindowID",0},
    { "_unsigned_int","_int",0},
    { "_short","_wxDateTime_t",0},
    { "_short","_WXTYPE",0},
    { "_short","_unsigned_short",0},
    { "_short","_signed_short",0},
    { "_wxWindowID","_wxCoord",0},
    { "_wxWindowID","_wxPrintQuality",0},
    { "_wxWindowID","_time_t",0},
    { "_wxWindowID","_size_t",0},
    { "_wxWindowID","_EBool",0},
    { "_wxWindowID","_uint",0},
    { "_wxWindowID","_int",0},
    { "_wxWindowID","_signed_int",0},
    { "_wxWindowID","_unsigned_int",0},
    { "_int","_wxCoord",0},
    { "_int","_wxPrintQuality",0},
    { "_int","_time_t",0},
    { "_int","_size_t",0},
    { "_int","_EBool",0},
    { "_int","_uint",0},
    { "_int","_wxWindowID",0},
    { "_int","_unsigned_int",0},
    { "_int","_signed_int",0},
    { "_wxDateTime_t","_unsigned_short",0},
    { "_wxDateTime_t","_short",0},
    { "_wxDateTime_t","_WXTYPE",0},
    { "_time_t","_wxCoord",0},
    { "_time_t","_wxPrintQuality",0},
    { "_time_t","_unsigned_int",0},
    { "_time_t","_int",0},
    { "_time_t","_wxWindowID",0},
    { "_time_t","_uint",0},
    { "_time_t","_size_t",0},
    { "_wxCoord","_int",0},
    { "_wxCoord","_signed_int",0},
    { "_wxCoord","_unsigned_int",0},
    { "_wxCoord","_wxWindowID",0},
    { "_wxCoord","_uint",0},
    { "_wxCoord","_EBool",0},
    { "_wxCoord","_size_t",0},
    { "_wxCoord","_time_t",0},
    { "_wxCoord","_wxPrintQuality",0},
    { "_wxEvtHandler","_wxPyApp",SwigwxPyAppTowxEvtHandler},
{0,0,0}};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) initwxc() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("wxc", wxcMethods);
	 d = PyModule_GetDict(m);
	 PyDict_SetItemString(d,"wxMAJOR_VERSION", PyInt_FromLong((long) wxMAJOR_VERSION));
	 PyDict_SetItemString(d,"wxMINOR_VERSION", PyInt_FromLong((long) wxMINOR_VERSION));
	 PyDict_SetItemString(d,"wxRELEASE_NUMBER", PyInt_FromLong((long) wxRELEASE_NUMBER));
	 PyDict_SetItemString(d,"wxNOT_FOUND", PyInt_FromLong((long) wxNOT_FOUND));
	 PyDict_SetItemString(d,"wxVSCROLL", PyInt_FromLong((long) wxVSCROLL));
	 PyDict_SetItemString(d,"wxHSCROLL", PyInt_FromLong((long) wxHSCROLL));
	 PyDict_SetItemString(d,"wxCAPTION", PyInt_FromLong((long) wxCAPTION));
	 PyDict_SetItemString(d,"wxDOUBLE_BORDER", PyInt_FromLong((long) wxDOUBLE_BORDER));
	 PyDict_SetItemString(d,"wxSUNKEN_BORDER", PyInt_FromLong((long) wxSUNKEN_BORDER));
	 PyDict_SetItemString(d,"wxRAISED_BORDER", PyInt_FromLong((long) wxRAISED_BORDER));
	 PyDict_SetItemString(d,"wxBORDER", PyInt_FromLong((long) wxBORDER));
	 PyDict_SetItemString(d,"wxSIMPLE_BORDER", PyInt_FromLong((long) wxSIMPLE_BORDER));
	 PyDict_SetItemString(d,"wxSTATIC_BORDER", PyInt_FromLong((long) wxSTATIC_BORDER));
	 PyDict_SetItemString(d,"wxTRANSPARENT_WINDOW", PyInt_FromLong((long) wxTRANSPARENT_WINDOW));
	 PyDict_SetItemString(d,"wxNO_BORDER", PyInt_FromLong((long) wxNO_BORDER));
	 PyDict_SetItemString(d,"wxUSER_COLOURS", PyInt_FromLong((long) wxUSER_COLOURS));
	 PyDict_SetItemString(d,"wxNO_3D", PyInt_FromLong((long) wxNO_3D));
	 PyDict_SetItemString(d,"wxTAB_TRAVERSAL", PyInt_FromLong((long) wxTAB_TRAVERSAL));
	 PyDict_SetItemString(d,"wxWANTS_CHARS", PyInt_FromLong((long) wxWANTS_CHARS));
	 PyDict_SetItemString(d,"wxPOPUP_WINDOW", PyInt_FromLong((long) wxPOPUP_WINDOW));
	 PyDict_SetItemString(d,"wxHORIZONTAL", PyInt_FromLong((long) wxHORIZONTAL));
	 PyDict_SetItemString(d,"wxVERTICAL", PyInt_FromLong((long) wxVERTICAL));
	 PyDict_SetItemString(d,"wxBOTH", PyInt_FromLong((long) wxBOTH));
	 PyDict_SetItemString(d,"wxCENTER_FRAME", PyInt_FromLong((long) wxCENTER_FRAME));
	 PyDict_SetItemString(d,"wxCENTRE_ON_SCREEN", PyInt_FromLong((long) wxCENTRE_ON_SCREEN));
	 PyDict_SetItemString(d,"wxCENTER_ON_SCREEN", PyInt_FromLong((long) wxCENTER_ON_SCREEN));
	 PyDict_SetItemString(d,"wxSTAY_ON_TOP", PyInt_FromLong((long) wxSTAY_ON_TOP));
	 PyDict_SetItemString(d,"wxICONIZE", PyInt_FromLong((long) wxICONIZE));
	 PyDict_SetItemString(d,"wxMINIMIZE", PyInt_FromLong((long) wxMINIMIZE));
	 PyDict_SetItemString(d,"wxMAXIMIZE", PyInt_FromLong((long) wxMAXIMIZE));
	 PyDict_SetItemString(d,"wxCLOSE_BOX", PyInt_FromLong((long) wxCLOSE_BOX));
	 PyDict_SetItemString(d,"wxTHICK_FRAME", PyInt_FromLong((long) wxTHICK_FRAME));
	 PyDict_SetItemString(d,"wxSYSTEM_MENU", PyInt_FromLong((long) wxSYSTEM_MENU));
	 PyDict_SetItemString(d,"wxMINIMIZE_BOX", PyInt_FromLong((long) wxMINIMIZE_BOX));
	 PyDict_SetItemString(d,"wxMAXIMIZE_BOX", PyInt_FromLong((long) wxMAXIMIZE_BOX));
	 PyDict_SetItemString(d,"wxTINY_CAPTION_HORIZ", PyInt_FromLong((long) wxTINY_CAPTION_HORIZ));
	 PyDict_SetItemString(d,"wxTINY_CAPTION_VERT", PyInt_FromLong((long) wxTINY_CAPTION_VERT));
	 PyDict_SetItemString(d,"wxRESIZE_BOX", PyInt_FromLong((long) wxRESIZE_BOX));
	 PyDict_SetItemString(d,"wxRESIZE_BORDER", PyInt_FromLong((long) wxRESIZE_BORDER));
	 PyDict_SetItemString(d,"wxDIALOG_MODAL", PyInt_FromLong((long) wxDIALOG_MODAL));
	 PyDict_SetItemString(d,"wxDIALOG_MODELESS", PyInt_FromLong((long) wxDIALOG_MODELESS));
	 PyDict_SetItemString(d,"wxDIALOG_NO_PARENT", PyInt_FromLong((long) wxDIALOG_NO_PARENT));
	 PyDict_SetItemString(d,"wxDEFAULT_FRAME_STYLE", PyInt_FromLong((long) wxDEFAULT_FRAME_STYLE));
	 PyDict_SetItemString(d,"wxDEFAULT_DIALOG_STYLE", PyInt_FromLong((long) wxDEFAULT_DIALOG_STYLE));
	 PyDict_SetItemString(d,"wxFRAME_TOOL_WINDOW", PyInt_FromLong((long) wxFRAME_TOOL_WINDOW));
	 PyDict_SetItemString(d,"wxFRAME_FLOAT_ON_PARENT", PyInt_FromLong((long) wxFRAME_FLOAT_ON_PARENT));
	 PyDict_SetItemString(d,"wxFRAME_NO_WINDOW_MENU", PyInt_FromLong((long) wxFRAME_NO_WINDOW_MENU));
	 PyDict_SetItemString(d,"wxFRAME_NO_TASKBAR", PyInt_FromLong((long) wxFRAME_NO_TASKBAR));
	 PyDict_SetItemString(d,"wxFRAME_SHAPED", PyInt_FromLong((long) wxFRAME_SHAPED));
	 PyDict_SetItemString(d,"wxED_CLIENT_MARGIN", PyInt_FromLong((long) wxED_CLIENT_MARGIN));
	 PyDict_SetItemString(d,"wxED_BUTTONS_BOTTOM", PyInt_FromLong((long) wxED_BUTTONS_BOTTOM));
	 PyDict_SetItemString(d,"wxED_BUTTONS_RIGHT", PyInt_FromLong((long) wxED_BUTTONS_RIGHT));
	 PyDict_SetItemString(d,"wxED_STATIC_LINE", PyInt_FromLong((long) wxED_STATIC_LINE));
	 PyDict_SetItemString(d,"wxEXT_DIALOG_STYLE", PyInt_FromLong((long) wxEXT_DIALOG_STYLE));
	 PyDict_SetItemString(d,"wxCLIP_CHILDREN", PyInt_FromLong((long) wxCLIP_CHILDREN));
	 PyDict_SetItemString(d,"wxCLIP_SIBLINGS", PyInt_FromLong((long) wxCLIP_SIBLINGS));
	 PyDict_SetItemString(d,"wxRETAINED", PyInt_FromLong((long) wxRETAINED));
	 PyDict_SetItemString(d,"wxBACKINGSTORE", PyInt_FromLong((long) wxBACKINGSTORE));
	 PyDict_SetItemString(d,"wxCOLOURED", PyInt_FromLong((long) wxCOLOURED));
	 PyDict_SetItemString(d,"wxFIXED_LENGTH", PyInt_FromLong((long) wxFIXED_LENGTH));
	 PyDict_SetItemString(d,"wxALIGN_LEFT", PyInt_FromLong((long) wxALIGN_LEFT));
	 PyDict_SetItemString(d,"wxALIGN_CENTER_HORIZONTAL", PyInt_FromLong((long) wxALIGN_CENTER_HORIZONTAL));
	 PyDict_SetItemString(d,"wxALIGN_CENTRE_HORIZONTAL", PyInt_FromLong((long) wxALIGN_CENTRE_HORIZONTAL));
	 PyDict_SetItemString(d,"wxALIGN_RIGHT", PyInt_FromLong((long) wxALIGN_RIGHT));
	 PyDict_SetItemString(d,"wxALIGN_BOTTOM", PyInt_FromLong((long) wxALIGN_BOTTOM));
	 PyDict_SetItemString(d,"wxALIGN_CENTER_VERTICAL", PyInt_FromLong((long) wxALIGN_CENTER_VERTICAL));
	 PyDict_SetItemString(d,"wxALIGN_CENTRE_VERTICAL", PyInt_FromLong((long) wxALIGN_CENTRE_VERTICAL));
	 PyDict_SetItemString(d,"wxALIGN_TOP", PyInt_FromLong((long) wxALIGN_TOP));
	 PyDict_SetItemString(d,"wxALIGN_CENTER", PyInt_FromLong((long) wxALIGN_CENTER));
	 PyDict_SetItemString(d,"wxALIGN_CENTRE", PyInt_FromLong((long) wxALIGN_CENTRE));
	 PyDict_SetItemString(d,"wxSHAPED", PyInt_FromLong((long) wxSHAPED));
	 PyDict_SetItemString(d,"wxADJUST_MINSIZE", PyInt_FromLong((long) wxADJUST_MINSIZE));
	 PyDict_SetItemString(d,"wxLB_NEEDED_SB", PyInt_FromLong((long) wxLB_NEEDED_SB));
	 PyDict_SetItemString(d,"wxLB_ALWAYS_SB", PyInt_FromLong((long) wxLB_ALWAYS_SB));
	 PyDict_SetItemString(d,"wxLB_SORT", PyInt_FromLong((long) wxLB_SORT));
	 PyDict_SetItemString(d,"wxLB_SINGLE", PyInt_FromLong((long) wxLB_SINGLE));
	 PyDict_SetItemString(d,"wxLB_MULTIPLE", PyInt_FromLong((long) wxLB_MULTIPLE));
	 PyDict_SetItemString(d,"wxLB_EXTENDED", PyInt_FromLong((long) wxLB_EXTENDED));
	 PyDict_SetItemString(d,"wxLB_OWNERDRAW", PyInt_FromLong((long) wxLB_OWNERDRAW));
	 PyDict_SetItemString(d,"wxLB_HSCROLL", PyInt_FromLong((long) wxLB_HSCROLL));
	 PyDict_SetItemString(d,"wxPROCESS_ENTER", PyInt_FromLong((long) wxPROCESS_ENTER));
	 PyDict_SetItemString(d,"wxPASSWORD", PyInt_FromLong((long) wxPASSWORD));
	 PyDict_SetItemString(d,"wxCB_SIMPLE", PyInt_FromLong((long) wxCB_SIMPLE));
	 PyDict_SetItemString(d,"wxCB_DROPDOWN", PyInt_FromLong((long) wxCB_DROPDOWN));
	 PyDict_SetItemString(d,"wxCB_SORT", PyInt_FromLong((long) wxCB_SORT));
	 PyDict_SetItemString(d,"wxCB_READONLY", PyInt_FromLong((long) wxCB_READONLY));
	 PyDict_SetItemString(d,"wxRA_HORIZONTAL", PyInt_FromLong((long) wxRA_HORIZONTAL));
	 PyDict_SetItemString(d,"wxRA_VERTICAL", PyInt_FromLong((long) wxRA_VERTICAL));
	 PyDict_SetItemString(d,"wxRA_SPECIFY_ROWS", PyInt_FromLong((long) wxRA_SPECIFY_ROWS));
	 PyDict_SetItemString(d,"wxRA_SPECIFY_COLS", PyInt_FromLong((long) wxRA_SPECIFY_COLS));
	 PyDict_SetItemString(d,"wxRB_GROUP", PyInt_FromLong((long) wxRB_GROUP));
	 PyDict_SetItemString(d,"wxRB_SINGLE", PyInt_FromLong((long) wxRB_SINGLE));
	 PyDict_SetItemString(d,"wxGA_PROGRESSBAR", PyInt_FromLong((long) wxGA_PROGRESSBAR));
	 PyDict_SetItemString(d,"wxGA_HORIZONTAL", PyInt_FromLong((long) wxGA_HORIZONTAL));
	 PyDict_SetItemString(d,"wxGA_VERTICAL", PyInt_FromLong((long) wxGA_VERTICAL));
	 PyDict_SetItemString(d,"wxGA_SMOOTH", PyInt_FromLong((long) wxGA_SMOOTH));
	 PyDict_SetItemString(d,"wxSL_HORIZONTAL", PyInt_FromLong((long) wxSL_HORIZONTAL));
	 PyDict_SetItemString(d,"wxSL_VERTICAL", PyInt_FromLong((long) wxSL_VERTICAL));
	 PyDict_SetItemString(d,"wxSL_AUTOTICKS", PyInt_FromLong((long) wxSL_AUTOTICKS));
	 PyDict_SetItemString(d,"wxSL_LABELS", PyInt_FromLong((long) wxSL_LABELS));
	 PyDict_SetItemString(d,"wxSL_LEFT", PyInt_FromLong((long) wxSL_LEFT));
	 PyDict_SetItemString(d,"wxSL_TOP", PyInt_FromLong((long) wxSL_TOP));
	 PyDict_SetItemString(d,"wxSL_RIGHT", PyInt_FromLong((long) wxSL_RIGHT));
	 PyDict_SetItemString(d,"wxSL_BOTTOM", PyInt_FromLong((long) wxSL_BOTTOM));
	 PyDict_SetItemString(d,"wxSL_BOTH", PyInt_FromLong((long) wxSL_BOTH));
	 PyDict_SetItemString(d,"wxSL_SELRANGE", PyInt_FromLong((long) wxSL_SELRANGE));
	 PyDict_SetItemString(d,"wxSB_HORIZONTAL", PyInt_FromLong((long) wxSB_HORIZONTAL));
	 PyDict_SetItemString(d,"wxSB_VERTICAL", PyInt_FromLong((long) wxSB_VERTICAL));
	 PyDict_SetItemString(d,"wxST_SIZEGRIP", PyInt_FromLong((long) wxST_SIZEGRIP));
	 PyDict_SetItemString(d,"wxST_NO_AUTORESIZE", PyInt_FromLong((long) wxST_NO_AUTORESIZE));
	 PyDict_SetItemString(d,"wxBU_NOAUTODRAW", PyInt_FromLong((long) wxBU_NOAUTODRAW));
	 PyDict_SetItemString(d,"wxBU_AUTODRAW", PyInt_FromLong((long) wxBU_AUTODRAW));
	 PyDict_SetItemString(d,"wxBU_LEFT", PyInt_FromLong((long) wxBU_LEFT));
	 PyDict_SetItemString(d,"wxBU_TOP", PyInt_FromLong((long) wxBU_TOP));
	 PyDict_SetItemString(d,"wxBU_RIGHT", PyInt_FromLong((long) wxBU_RIGHT));
	 PyDict_SetItemString(d,"wxBU_BOTTOM", PyInt_FromLong((long) wxBU_BOTTOM));
	 PyDict_SetItemString(d,"wxBU_EXACTFIT", PyInt_FromLong((long) wxBU_EXACTFIT));
	 PyDict_SetItemString(d,"wxFLOOD_SURFACE", PyInt_FromLong((long) wxFLOOD_SURFACE));
	 PyDict_SetItemString(d,"wxFLOOD_BORDER", PyInt_FromLong((long) wxFLOOD_BORDER));
	 PyDict_SetItemString(d,"wxODDEVEN_RULE", PyInt_FromLong((long) wxODDEVEN_RULE));
	 PyDict_SetItemString(d,"wxWINDING_RULE", PyInt_FromLong((long) wxWINDING_RULE));
	 PyDict_SetItemString(d,"wxTOOL_TOP", PyInt_FromLong((long) wxTOOL_TOP));
	 PyDict_SetItemString(d,"wxTOOL_BOTTOM", PyInt_FromLong((long) wxTOOL_BOTTOM));
	 PyDict_SetItemString(d,"wxTOOL_LEFT", PyInt_FromLong((long) wxTOOL_LEFT));
	 PyDict_SetItemString(d,"wxTOOL_RIGHT", PyInt_FromLong((long) wxTOOL_RIGHT));
	 PyDict_SetItemString(d,"wxOK", PyInt_FromLong((long) wxOK));
	 PyDict_SetItemString(d,"wxYES_NO", PyInt_FromLong((long) wxYES_NO));
	 PyDict_SetItemString(d,"wxCANCEL", PyInt_FromLong((long) wxCANCEL));
	 PyDict_SetItemString(d,"wxYES", PyInt_FromLong((long) wxYES));
	 PyDict_SetItemString(d,"wxNO", PyInt_FromLong((long) wxNO));
	 PyDict_SetItemString(d,"wxNO_DEFAULT", PyInt_FromLong((long) wxNO_DEFAULT));
	 PyDict_SetItemString(d,"wxYES_DEFAULT", PyInt_FromLong((long) wxYES_DEFAULT));
	 PyDict_SetItemString(d,"wxICON_EXCLAMATION", PyInt_FromLong((long) wxICON_EXCLAMATION));
	 PyDict_SetItemString(d,"wxICON_HAND", PyInt_FromLong((long) wxICON_HAND));
	 PyDict_SetItemString(d,"wxICON_QUESTION", PyInt_FromLong((long) wxICON_QUESTION));
	 PyDict_SetItemString(d,"wxICON_INFORMATION", PyInt_FromLong((long) wxICON_INFORMATION));
	 PyDict_SetItemString(d,"wxICON_STOP", PyInt_FromLong((long) wxICON_STOP));
	 PyDict_SetItemString(d,"wxICON_ASTERISK", PyInt_FromLong((long) wxICON_ASTERISK));
	 PyDict_SetItemString(d,"wxICON_MASK", PyInt_FromLong((long) wxICON_MASK));
	 PyDict_SetItemString(d,"wxICON_WARNING", PyInt_FromLong((long) wxICON_WARNING));
	 PyDict_SetItemString(d,"wxICON_ERROR", PyInt_FromLong((long) wxICON_ERROR));
	 PyDict_SetItemString(d,"wxFORWARD", PyInt_FromLong((long) wxFORWARD));
	 PyDict_SetItemString(d,"wxBACKWARD", PyInt_FromLong((long) wxBACKWARD));
	 PyDict_SetItemString(d,"wxRESET", PyInt_FromLong((long) wxRESET));
	 PyDict_SetItemString(d,"wxHELP", PyInt_FromLong((long) wxHELP));
	 PyDict_SetItemString(d,"wxMORE", PyInt_FromLong((long) wxMORE));
	 PyDict_SetItemString(d,"wxSETUP", PyInt_FromLong((long) wxSETUP));
	 PyDict_SetItemString(d,"wxCENTRE", PyInt_FromLong((long) wxCENTRE));
	 PyDict_SetItemString(d,"wxCENTER", PyInt_FromLong((long) wxCENTER));
	 PyDict_SetItemString(d,"wxSIZE_AUTO_WIDTH", PyInt_FromLong((long) wxSIZE_AUTO_WIDTH));
	 PyDict_SetItemString(d,"wxSIZE_AUTO_HEIGHT", PyInt_FromLong((long) wxSIZE_AUTO_HEIGHT));
	 PyDict_SetItemString(d,"wxSIZE_AUTO", PyInt_FromLong((long) wxSIZE_AUTO));
	 PyDict_SetItemString(d,"wxSIZE_USE_EXISTING", PyInt_FromLong((long) wxSIZE_USE_EXISTING));
	 PyDict_SetItemString(d,"wxSIZE_ALLOW_MINUS_ONE", PyInt_FromLong((long) wxSIZE_ALLOW_MINUS_ONE));
	 PyDict_SetItemString(d,"wxPORTRAIT", PyInt_FromLong((long) wxPORTRAIT));
	 PyDict_SetItemString(d,"wxLANDSCAPE", PyInt_FromLong((long) wxLANDSCAPE));
	 PyDict_SetItemString(d,"wxPRINT_QUALITY_HIGH", PyInt_FromLong((long) wxPRINT_QUALITY_HIGH));
	 PyDict_SetItemString(d,"wxPRINT_QUALITY_MEDIUM", PyInt_FromLong((long) wxPRINT_QUALITY_MEDIUM));
	 PyDict_SetItemString(d,"wxPRINT_QUALITY_LOW", PyInt_FromLong((long) wxPRINT_QUALITY_LOW));
	 PyDict_SetItemString(d,"wxPRINT_QUALITY_DRAFT", PyInt_FromLong((long) wxPRINT_QUALITY_DRAFT));
	 PyDict_SetItemString(d,"wxID_ANY", PyInt_FromLong((long) wxID_ANY));
	 PyDict_SetItemString(d,"wxID_SEPARATOR", PyInt_FromLong((long) wxID_SEPARATOR));
	 PyDict_SetItemString(d,"wxID_OPEN", PyInt_FromLong((long) wxID_OPEN));
	 PyDict_SetItemString(d,"wxID_CLOSE", PyInt_FromLong((long) wxID_CLOSE));
	 PyDict_SetItemString(d,"wxID_NEW", PyInt_FromLong((long) wxID_NEW));
	 PyDict_SetItemString(d,"wxID_SAVE", PyInt_FromLong((long) wxID_SAVE));
	 PyDict_SetItemString(d,"wxID_SAVEAS", PyInt_FromLong((long) wxID_SAVEAS));
	 PyDict_SetItemString(d,"wxID_REVERT", PyInt_FromLong((long) wxID_REVERT));
	 PyDict_SetItemString(d,"wxID_EXIT", PyInt_FromLong((long) wxID_EXIT));
	 PyDict_SetItemString(d,"wxID_UNDO", PyInt_FromLong((long) wxID_UNDO));
	 PyDict_SetItemString(d,"wxID_REDO", PyInt_FromLong((long) wxID_REDO));
	 PyDict_SetItemString(d,"wxID_HELP", PyInt_FromLong((long) wxID_HELP));
	 PyDict_SetItemString(d,"wxID_PRINT", PyInt_FromLong((long) wxID_PRINT));
	 PyDict_SetItemString(d,"wxID_PRINT_SETUP", PyInt_FromLong((long) wxID_PRINT_SETUP));
	 PyDict_SetItemString(d,"wxID_PREVIEW", PyInt_FromLong((long) wxID_PREVIEW));
	 PyDict_SetItemString(d,"wxID_ABOUT", PyInt_FromLong((long) wxID_ABOUT));
	 PyDict_SetItemString(d,"wxID_HELP_CONTENTS", PyInt_FromLong((long) wxID_HELP_CONTENTS));
	 PyDict_SetItemString(d,"wxID_HELP_COMMANDS", PyInt_FromLong((long) wxID_HELP_COMMANDS));
	 PyDict_SetItemString(d,"wxID_HELP_PROCEDURES", PyInt_FromLong((long) wxID_HELP_PROCEDURES));
	 PyDict_SetItemString(d,"wxID_HELP_CONTEXT", PyInt_FromLong((long) wxID_HELP_CONTEXT));
	 PyDict_SetItemString(d,"wxID_CLOSE_ALL", PyInt_FromLong((long) wxID_CLOSE_ALL));
	 PyDict_SetItemString(d,"wxID_PREFERENCES", PyInt_FromLong((long) wxID_PREFERENCES));
	 PyDict_SetItemString(d,"wxID_CUT", PyInt_FromLong((long) wxID_CUT));
	 PyDict_SetItemString(d,"wxID_COPY", PyInt_FromLong((long) wxID_COPY));
	 PyDict_SetItemString(d,"wxID_PASTE", PyInt_FromLong((long) wxID_PASTE));
	 PyDict_SetItemString(d,"wxID_CLEAR", PyInt_FromLong((long) wxID_CLEAR));
	 PyDict_SetItemString(d,"wxID_FIND", PyInt_FromLong((long) wxID_FIND));
	 PyDict_SetItemString(d,"wxID_DUPLICATE", PyInt_FromLong((long) wxID_DUPLICATE));
	 PyDict_SetItemString(d,"wxID_SELECTALL", PyInt_FromLong((long) wxID_SELECTALL));
	 PyDict_SetItemString(d,"wxID_DELETE", PyInt_FromLong((long) wxID_DELETE));
	 PyDict_SetItemString(d,"wxID_REPLACE", PyInt_FromLong((long) wxID_REPLACE));
	 PyDict_SetItemString(d,"wxID_REPLACE_ALL", PyInt_FromLong((long) wxID_REPLACE_ALL));
	 PyDict_SetItemString(d,"wxID_PROPERTIES", PyInt_FromLong((long) wxID_PROPERTIES));
	 PyDict_SetItemString(d,"wxID_VIEW_DETAILS", PyInt_FromLong((long) wxID_VIEW_DETAILS));
	 PyDict_SetItemString(d,"wxID_VIEW_LARGEICONS", PyInt_FromLong((long) wxID_VIEW_LARGEICONS));
	 PyDict_SetItemString(d,"wxID_VIEW_SMALLICONS", PyInt_FromLong((long) wxID_VIEW_SMALLICONS));
	 PyDict_SetItemString(d,"wxID_VIEW_LIST", PyInt_FromLong((long) wxID_VIEW_LIST));
	 PyDict_SetItemString(d,"wxID_VIEW_SORTDATE", PyInt_FromLong((long) wxID_VIEW_SORTDATE));
	 PyDict_SetItemString(d,"wxID_VIEW_SORTNAME", PyInt_FromLong((long) wxID_VIEW_SORTNAME));
	 PyDict_SetItemString(d,"wxID_VIEW_SORTSIZE", PyInt_FromLong((long) wxID_VIEW_SORTSIZE));
	 PyDict_SetItemString(d,"wxID_VIEW_SORTTYPE", PyInt_FromLong((long) wxID_VIEW_SORTTYPE));
	 PyDict_SetItemString(d,"wxID_FILE1", PyInt_FromLong((long) wxID_FILE1));
	 PyDict_SetItemString(d,"wxID_FILE2", PyInt_FromLong((long) wxID_FILE2));
	 PyDict_SetItemString(d,"wxID_FILE3", PyInt_FromLong((long) wxID_FILE3));
	 PyDict_SetItemString(d,"wxID_FILE4", PyInt_FromLong((long) wxID_FILE4));
	 PyDict_SetItemString(d,"wxID_FILE5", PyInt_FromLong((long) wxID_FILE5));
	 PyDict_SetItemString(d,"wxID_FILE6", PyInt_FromLong((long) wxID_FILE6));
	 PyDict_SetItemString(d,"wxID_FILE7", PyInt_FromLong((long) wxID_FILE7));
	 PyDict_SetItemString(d,"wxID_FILE8", PyInt_FromLong((long) wxID_FILE8));
	 PyDict_SetItemString(d,"wxID_FILE9", PyInt_FromLong((long) wxID_FILE9));
	 PyDict_SetItemString(d,"wxID_OK", PyInt_FromLong((long) wxID_OK));
	 PyDict_SetItemString(d,"wxID_CANCEL", PyInt_FromLong((long) wxID_CANCEL));
	 PyDict_SetItemString(d,"wxID_APPLY", PyInt_FromLong((long) wxID_APPLY));
	 PyDict_SetItemString(d,"wxID_YES", PyInt_FromLong((long) wxID_YES));
	 PyDict_SetItemString(d,"wxID_NO", PyInt_FromLong((long) wxID_NO));
	 PyDict_SetItemString(d,"wxID_STATIC", PyInt_FromLong((long) wxID_STATIC));
	 PyDict_SetItemString(d,"wxID_FORWARD", PyInt_FromLong((long) wxID_FORWARD));
	 PyDict_SetItemString(d,"wxID_BACKWARD", PyInt_FromLong((long) wxID_BACKWARD));
	 PyDict_SetItemString(d,"wxID_DEFAULT", PyInt_FromLong((long) wxID_DEFAULT));
	 PyDict_SetItemString(d,"wxID_MORE", PyInt_FromLong((long) wxID_MORE));
	 PyDict_SetItemString(d,"wxID_SETUP", PyInt_FromLong((long) wxID_SETUP));
	 PyDict_SetItemString(d,"wxID_RESET", PyInt_FromLong((long) wxID_RESET));
	 PyDict_SetItemString(d,"wxID_CONTEXT_HELP", PyInt_FromLong((long) wxID_CONTEXT_HELP));
	 PyDict_SetItemString(d,"wxID_YESTOALL", PyInt_FromLong((long) wxID_YESTOALL));
	 PyDict_SetItemString(d,"wxID_NOTOALL", PyInt_FromLong((long) wxID_NOTOALL));
	 PyDict_SetItemString(d,"wxID_ABORT", PyInt_FromLong((long) wxID_ABORT));
	 PyDict_SetItemString(d,"wxID_RETRY", PyInt_FromLong((long) wxID_RETRY));
	 PyDict_SetItemString(d,"wxID_IGNORE", PyInt_FromLong((long) wxID_IGNORE));
	 PyDict_SetItemString(d,"wxOPEN", PyInt_FromLong((long) wxOPEN));
	 PyDict_SetItemString(d,"wxSAVE", PyInt_FromLong((long) wxSAVE));
	 PyDict_SetItemString(d,"wxHIDE_READONLY", PyInt_FromLong((long) wxHIDE_READONLY));
	 PyDict_SetItemString(d,"wxOVERWRITE_PROMPT", PyInt_FromLong((long) wxOVERWRITE_PROMPT));
	 PyDict_SetItemString(d,"wxFILE_MUST_EXIST", PyInt_FromLong((long) wxFILE_MUST_EXIST));
	 PyDict_SetItemString(d,"wxMULTIPLE", PyInt_FromLong((long) wxMULTIPLE));
	 PyDict_SetItemString(d,"wxCHANGE_DIR", PyInt_FromLong((long) wxCHANGE_DIR));
	 PyDict_SetItemString(d,"wxACCEL_ALT", PyInt_FromLong((long) wxACCEL_ALT));
	 PyDict_SetItemString(d,"wxACCEL_CTRL", PyInt_FromLong((long) wxACCEL_CTRL));
	 PyDict_SetItemString(d,"wxACCEL_SHIFT", PyInt_FromLong((long) wxACCEL_SHIFT));
	 PyDict_SetItemString(d,"wxACCEL_NORMAL", PyInt_FromLong((long) wxACCEL_NORMAL));
	 PyDict_SetItemString(d,"wxPD_AUTO_HIDE", PyInt_FromLong((long) wxPD_AUTO_HIDE));
	 PyDict_SetItemString(d,"wxPD_APP_MODAL", PyInt_FromLong((long) wxPD_APP_MODAL));
	 PyDict_SetItemString(d,"wxPD_CAN_ABORT", PyInt_FromLong((long) wxPD_CAN_ABORT));
	 PyDict_SetItemString(d,"wxPD_ELAPSED_TIME", PyInt_FromLong((long) wxPD_ELAPSED_TIME));
	 PyDict_SetItemString(d,"wxPD_ESTIMATED_TIME", PyInt_FromLong((long) wxPD_ESTIMATED_TIME));
	 PyDict_SetItemString(d,"wxPD_REMAINING_TIME", PyInt_FromLong((long) wxPD_REMAINING_TIME));
	 PyDict_SetItemString(d,"wxDD_NEW_DIR_BUTTON", PyInt_FromLong((long) wxDD_NEW_DIR_BUTTON));
	 PyDict_SetItemString(d,"wxDD_DEFAULT_STYLE", PyInt_FromLong((long) wxDD_DEFAULT_STYLE));
	 PyDict_SetItemString(d,"wxMENU_TEAROFF", PyInt_FromLong((long) wxMENU_TEAROFF));
	 PyDict_SetItemString(d,"wxMB_DOCKABLE", PyInt_FromLong((long) wxMB_DOCKABLE));
	 PyDict_SetItemString(d,"wxNO_FULL_REPAINT_ON_RESIZE", PyInt_FromLong((long) wxNO_FULL_REPAINT_ON_RESIZE));
	 PyDict_SetItemString(d,"wxFULL_REPAINT_ON_RESIZE", PyInt_FromLong((long) wxFULL_REPAINT_ON_RESIZE));
	 PyDict_SetItemString(d,"wxLEFT", PyInt_FromLong((long) wxLEFT));
	 PyDict_SetItemString(d,"wxRIGHT", PyInt_FromLong((long) wxRIGHT));
	 PyDict_SetItemString(d,"wxUP", PyInt_FromLong((long) wxUP));
	 PyDict_SetItemString(d,"wxDOWN", PyInt_FromLong((long) wxDOWN));
	 PyDict_SetItemString(d,"wxALL", PyInt_FromLong((long) wxALL));
	 PyDict_SetItemString(d,"wxTOP", PyInt_FromLong((long) wxTOP));
	 PyDict_SetItemString(d,"wxBOTTOM", PyInt_FromLong((long) wxBOTTOM));
	 PyDict_SetItemString(d,"wxNORTH", PyInt_FromLong((long) wxNORTH));
	 PyDict_SetItemString(d,"wxSOUTH", PyInt_FromLong((long) wxSOUTH));
	 PyDict_SetItemString(d,"wxEAST", PyInt_FromLong((long) wxEAST));
	 PyDict_SetItemString(d,"wxWEST", PyInt_FromLong((long) wxWEST));
	 PyDict_SetItemString(d,"wxSTRETCH_NOT", PyInt_FromLong((long) wxSTRETCH_NOT));
	 PyDict_SetItemString(d,"wxSHRINK", PyInt_FromLong((long) wxSHRINK));
	 PyDict_SetItemString(d,"wxGROW", PyInt_FromLong((long) wxGROW));
	 PyDict_SetItemString(d,"wxEXPAND", PyInt_FromLong((long) wxEXPAND));
	 PyDict_SetItemString(d,"wxLI_HORIZONTAL", PyInt_FromLong((long) wxLI_HORIZONTAL));
	 PyDict_SetItemString(d,"wxLI_VERTICAL", PyInt_FromLong((long) wxLI_VERTICAL));
	 PyDict_SetItemString(d,"wxJOYSTICK1", PyInt_FromLong((long) wxJOYSTICK1));
	 PyDict_SetItemString(d,"wxJOYSTICK2", PyInt_FromLong((long) wxJOYSTICK2));
	 PyDict_SetItemString(d,"wxJOY_BUTTON1", PyInt_FromLong((long) wxJOY_BUTTON1));
	 PyDict_SetItemString(d,"wxJOY_BUTTON2", PyInt_FromLong((long) wxJOY_BUTTON2));
	 PyDict_SetItemString(d,"wxJOY_BUTTON3", PyInt_FromLong((long) wxJOY_BUTTON3));
	 PyDict_SetItemString(d,"wxJOY_BUTTON4", PyInt_FromLong((long) wxJOY_BUTTON4));
	 PyDict_SetItemString(d,"wxJOY_BUTTON_ANY", PyInt_FromLong((long) wxJOY_BUTTON_ANY));
	 PyDict_SetItemString(d,"wxWS_EX_VALIDATE_RECURSIVELY", PyInt_FromLong((long) wxWS_EX_VALIDATE_RECURSIVELY));
	 PyDict_SetItemString(d,"wxWS_EX_BLOCK_EVENTS", PyInt_FromLong((long) wxWS_EX_BLOCK_EVENTS));
	 PyDict_SetItemString(d,"wxWS_EX_TRANSIENT", PyInt_FromLong((long) wxWS_EX_TRANSIENT));
	 PyDict_SetItemString(d,"wxWS_EX_THEMED_BACKGROUND", PyInt_FromLong((long) wxWS_EX_THEMED_BACKGROUND));
	 PyDict_SetItemString(d,"wxWS_EX_PROCESS_IDLE", PyInt_FromLong((long) wxWS_EX_PROCESS_IDLE));
	 PyDict_SetItemString(d,"wxWS_EX_PROCESS_UI_UPDATES", PyInt_FromLong((long) wxWS_EX_PROCESS_UI_UPDATES));
	 PyDict_SetItemString(d,"wxMM_TEXT", PyInt_FromLong((long) wxMM_TEXT));
	 PyDict_SetItemString(d,"wxMM_LOMETRIC", PyInt_FromLong((long) wxMM_LOMETRIC));
	 PyDict_SetItemString(d,"wxMM_HIMETRIC", PyInt_FromLong((long) wxMM_HIMETRIC));
	 PyDict_SetItemString(d,"wxMM_LOENGLISH", PyInt_FromLong((long) wxMM_LOENGLISH));
	 PyDict_SetItemString(d,"wxMM_HIENGLISH", PyInt_FromLong((long) wxMM_HIENGLISH));
	 PyDict_SetItemString(d,"wxMM_TWIPS", PyInt_FromLong((long) wxMM_TWIPS));
	 PyDict_SetItemString(d,"wxMM_ISOTROPIC", PyInt_FromLong((long) wxMM_ISOTROPIC));
	 PyDict_SetItemString(d,"wxMM_ANISOTROPIC", PyInt_FromLong((long) wxMM_ANISOTROPIC));
	 PyDict_SetItemString(d,"wxMM_POINTS", PyInt_FromLong((long) wxMM_POINTS));
	 PyDict_SetItemString(d,"wxMM_METRIC", PyInt_FromLong((long) wxMM_METRIC));
	 PyDict_SetItemString(d,"wxTIMER_CONTINUOUS", PyInt_FromLong((long) wxTIMER_CONTINUOUS));
	 PyDict_SetItemString(d,"wxTIMER_ONE_SHOT", PyInt_FromLong((long) wxTIMER_ONE_SHOT));
	 PyDict_SetItemString(d,"wxMOUSE_BTN_ANY", PyInt_FromLong((long) wxMOUSE_BTN_ANY));
	 PyDict_SetItemString(d,"wxMOUSE_BTN_NONE", PyInt_FromLong((long) wxMOUSE_BTN_NONE));
	 PyDict_SetItemString(d,"wxMOUSE_BTN_LEFT", PyInt_FromLong((long) wxMOUSE_BTN_LEFT));
	 PyDict_SetItemString(d,"wxMOUSE_BTN_MIDDLE", PyInt_FromLong((long) wxMOUSE_BTN_MIDDLE));
	 PyDict_SetItemString(d,"wxMOUSE_BTN_RIGHT", PyInt_FromLong((long) wxMOUSE_BTN_RIGHT));
	 PyDict_SetItemString(d,"wxBORDER_DEFAULT", PyInt_FromLong((long) wxBORDER_DEFAULT));
	 PyDict_SetItemString(d,"wxBORDER_NONE", PyInt_FromLong((long) wxBORDER_NONE));
	 PyDict_SetItemString(d,"wxBORDER_STATIC", PyInt_FromLong((long) wxBORDER_STATIC));
	 PyDict_SetItemString(d,"wxBORDER_SIMPLE", PyInt_FromLong((long) wxBORDER_SIMPLE));
	 PyDict_SetItemString(d,"wxBORDER_RAISED", PyInt_FromLong((long) wxBORDER_RAISED));
	 PyDict_SetItemString(d,"wxBORDER_SUNKEN", PyInt_FromLong((long) wxBORDER_SUNKEN));
	 PyDict_SetItemString(d,"wxBORDER_DOUBLE", PyInt_FromLong((long) wxBORDER_DOUBLE));
	 PyDict_SetItemString(d,"wxBORDER_MASK", PyInt_FromLong((long) wxBORDER_MASK));
	 PyDict_SetItemString(d,"wxDEFAULT", PyInt_FromLong((long) wxDEFAULT));
	 PyDict_SetItemString(d,"wxDECORATIVE", PyInt_FromLong((long) wxDECORATIVE));
	 PyDict_SetItemString(d,"wxROMAN", PyInt_FromLong((long) wxROMAN));
	 PyDict_SetItemString(d,"wxSCRIPT", PyInt_FromLong((long) wxSCRIPT));
	 PyDict_SetItemString(d,"wxSWISS", PyInt_FromLong((long) wxSWISS));
	 PyDict_SetItemString(d,"wxMODERN", PyInt_FromLong((long) wxMODERN));
	 PyDict_SetItemString(d,"wxTELETYPE", PyInt_FromLong((long) wxTELETYPE));
	 PyDict_SetItemString(d,"wxVARIABLE", PyInt_FromLong((long) wxVARIABLE));
	 PyDict_SetItemString(d,"wxFIXED", PyInt_FromLong((long) wxFIXED));
	 PyDict_SetItemString(d,"wxNORMAL", PyInt_FromLong((long) wxNORMAL));
	 PyDict_SetItemString(d,"wxLIGHT", PyInt_FromLong((long) wxLIGHT));
	 PyDict_SetItemString(d,"wxBOLD", PyInt_FromLong((long) wxBOLD));
	 PyDict_SetItemString(d,"wxITALIC", PyInt_FromLong((long) wxITALIC));
	 PyDict_SetItemString(d,"wxSLANT", PyInt_FromLong((long) wxSLANT));
	 PyDict_SetItemString(d,"wxSOLID", PyInt_FromLong((long) wxSOLID));
	 PyDict_SetItemString(d,"wxDOT", PyInt_FromLong((long) wxDOT));
	 PyDict_SetItemString(d,"wxLONG_DASH", PyInt_FromLong((long) wxLONG_DASH));
	 PyDict_SetItemString(d,"wxSHORT_DASH", PyInt_FromLong((long) wxSHORT_DASH));
	 PyDict_SetItemString(d,"wxDOT_DASH", PyInt_FromLong((long) wxDOT_DASH));
	 PyDict_SetItemString(d,"wxUSER_DASH", PyInt_FromLong((long) wxUSER_DASH));
	 PyDict_SetItemString(d,"wxTRANSPARENT", PyInt_FromLong((long) wxTRANSPARENT));
	 PyDict_SetItemString(d,"wxSTIPPLE", PyInt_FromLong((long) wxSTIPPLE));
	 PyDict_SetItemString(d,"wxBDIAGONAL_HATCH", PyInt_FromLong((long) wxBDIAGONAL_HATCH));
	 PyDict_SetItemString(d,"wxCROSSDIAG_HATCH", PyInt_FromLong((long) wxCROSSDIAG_HATCH));
	 PyDict_SetItemString(d,"wxFDIAGONAL_HATCH", PyInt_FromLong((long) wxFDIAGONAL_HATCH));
	 PyDict_SetItemString(d,"wxCROSS_HATCH", PyInt_FromLong((long) wxCROSS_HATCH));
	 PyDict_SetItemString(d,"wxHORIZONTAL_HATCH", PyInt_FromLong((long) wxHORIZONTAL_HATCH));
	 PyDict_SetItemString(d,"wxVERTICAL_HATCH", PyInt_FromLong((long) wxVERTICAL_HATCH));
	 PyDict_SetItemString(d,"wxJOIN_BEVEL", PyInt_FromLong((long) wxJOIN_BEVEL));
	 PyDict_SetItemString(d,"wxJOIN_MITER", PyInt_FromLong((long) wxJOIN_MITER));
	 PyDict_SetItemString(d,"wxJOIN_ROUND", PyInt_FromLong((long) wxJOIN_ROUND));
	 PyDict_SetItemString(d,"wxCAP_ROUND", PyInt_FromLong((long) wxCAP_ROUND));
	 PyDict_SetItemString(d,"wxCAP_PROJECTING", PyInt_FromLong((long) wxCAP_PROJECTING));
	 PyDict_SetItemString(d,"wxCAP_BUTT", PyInt_FromLong((long) wxCAP_BUTT));
	 PyDict_SetItemString(d,"wxCLEAR", PyInt_FromLong((long) wxCLEAR));
	 PyDict_SetItemString(d,"wxXOR", PyInt_FromLong((long) wxXOR));
	 PyDict_SetItemString(d,"wxINVERT", PyInt_FromLong((long) wxINVERT));
	 PyDict_SetItemString(d,"wxOR_REVERSE", PyInt_FromLong((long) wxOR_REVERSE));
	 PyDict_SetItemString(d,"wxAND_REVERSE", PyInt_FromLong((long) wxAND_REVERSE));
	 PyDict_SetItemString(d,"wxCOPY", PyInt_FromLong((long) wxCOPY));
	 PyDict_SetItemString(d,"wxAND", PyInt_FromLong((long) wxAND));
	 PyDict_SetItemString(d,"wxAND_INVERT", PyInt_FromLong((long) wxAND_INVERT));
	 PyDict_SetItemString(d,"wxNO_OP", PyInt_FromLong((long) wxNO_OP));
	 PyDict_SetItemString(d,"wxNOR", PyInt_FromLong((long) wxNOR));
	 PyDict_SetItemString(d,"wxEQUIV", PyInt_FromLong((long) wxEQUIV));
	 PyDict_SetItemString(d,"wxSRC_INVERT", PyInt_FromLong((long) wxSRC_INVERT));
	 PyDict_SetItemString(d,"wxOR_INVERT", PyInt_FromLong((long) wxOR_INVERT));
	 PyDict_SetItemString(d,"wxNAND", PyInt_FromLong((long) wxNAND));
	 PyDict_SetItemString(d,"wxOR", PyInt_FromLong((long) wxOR));
	 PyDict_SetItemString(d,"wxSET", PyInt_FromLong((long) wxSET));
	 PyDict_SetItemString(d,"WXK_BACK", PyInt_FromLong((long) WXK_BACK));
	 PyDict_SetItemString(d,"WXK_TAB", PyInt_FromLong((long) WXK_TAB));
	 PyDict_SetItemString(d,"WXK_RETURN", PyInt_FromLong((long) WXK_RETURN));
	 PyDict_SetItemString(d,"WXK_ESCAPE", PyInt_FromLong((long) WXK_ESCAPE));
	 PyDict_SetItemString(d,"WXK_SPACE", PyInt_FromLong((long) WXK_SPACE));
	 PyDict_SetItemString(d,"WXK_DELETE", PyInt_FromLong((long) WXK_DELETE));
	 PyDict_SetItemString(d,"WXK_START", PyInt_FromLong((long) WXK_START));
	 PyDict_SetItemString(d,"WXK_LBUTTON", PyInt_FromLong((long) WXK_LBUTTON));
	 PyDict_SetItemString(d,"WXK_RBUTTON", PyInt_FromLong((long) WXK_RBUTTON));
	 PyDict_SetItemString(d,"WXK_CANCEL", PyInt_FromLong((long) WXK_CANCEL));
	 PyDict_SetItemString(d,"WXK_MBUTTON", PyInt_FromLong((long) WXK_MBUTTON));
	 PyDict_SetItemString(d,"WXK_CLEAR", PyInt_FromLong((long) WXK_CLEAR));
	 PyDict_SetItemString(d,"WXK_SHIFT", PyInt_FromLong((long) WXK_SHIFT));
	 PyDict_SetItemString(d,"WXK_ALT", PyInt_FromLong((long) WXK_ALT));
	 PyDict_SetItemString(d,"WXK_CONTROL", PyInt_FromLong((long) WXK_CONTROL));
	 PyDict_SetItemString(d,"WXK_MENU", PyInt_FromLong((long) WXK_MENU));
	 PyDict_SetItemString(d,"WXK_PAUSE", PyInt_FromLong((long) WXK_PAUSE));
	 PyDict_SetItemString(d,"WXK_CAPITAL", PyInt_FromLong((long) WXK_CAPITAL));
	 PyDict_SetItemString(d,"WXK_PRIOR", PyInt_FromLong((long) WXK_PRIOR));
	 PyDict_SetItemString(d,"WXK_NEXT", PyInt_FromLong((long) WXK_NEXT));
	 PyDict_SetItemString(d,"WXK_END", PyInt_FromLong((long) WXK_END));
	 PyDict_SetItemString(d,"WXK_HOME", PyInt_FromLong((long) WXK_HOME));
	 PyDict_SetItemString(d,"WXK_LEFT", PyInt_FromLong((long) WXK_LEFT));
	 PyDict_SetItemString(d,"WXK_UP", PyInt_FromLong((long) WXK_UP));
	 PyDict_SetItemString(d,"WXK_RIGHT", PyInt_FromLong((long) WXK_RIGHT));
	 PyDict_SetItemString(d,"WXK_DOWN", PyInt_FromLong((long) WXK_DOWN));
	 PyDict_SetItemString(d,"WXK_SELECT", PyInt_FromLong((long) WXK_SELECT));
	 PyDict_SetItemString(d,"WXK_PRINT", PyInt_FromLong((long) WXK_PRINT));
	 PyDict_SetItemString(d,"WXK_EXECUTE", PyInt_FromLong((long) WXK_EXECUTE));
	 PyDict_SetItemString(d,"WXK_SNAPSHOT", PyInt_FromLong((long) WXK_SNAPSHOT));
	 PyDict_SetItemString(d,"WXK_INSERT", PyInt_FromLong((long) WXK_INSERT));
	 PyDict_SetItemString(d,"WXK_HELP", PyInt_FromLong((long) WXK_HELP));
	 PyDict_SetItemString(d,"WXK_NUMPAD0", PyInt_FromLong((long) WXK_NUMPAD0));
	 PyDict_SetItemString(d,"WXK_NUMPAD1", PyInt_FromLong((long) WXK_NUMPAD1));
	 PyDict_SetItemString(d,"WXK_NUMPAD2", PyInt_FromLong((long) WXK_NUMPAD2));
	 PyDict_SetItemString(d,"WXK_NUMPAD3", PyInt_FromLong((long) WXK_NUMPAD3));
	 PyDict_SetItemString(d,"WXK_NUMPAD4", PyInt_FromLong((long) WXK_NUMPAD4));
	 PyDict_SetItemString(d,"WXK_NUMPAD5", PyInt_FromLong((long) WXK_NUMPAD5));
	 PyDict_SetItemString(d,"WXK_NUMPAD6", PyInt_FromLong((long) WXK_NUMPAD6));
	 PyDict_SetItemString(d,"WXK_NUMPAD7", PyInt_FromLong((long) WXK_NUMPAD7));
	 PyDict_SetItemString(d,"WXK_NUMPAD8", PyInt_FromLong((long) WXK_NUMPAD8));
	 PyDict_SetItemString(d,"WXK_NUMPAD9", PyInt_FromLong((long) WXK_NUMPAD9));
	 PyDict_SetItemString(d,"WXK_MULTIPLY", PyInt_FromLong((long) WXK_MULTIPLY));
	 PyDict_SetItemString(d,"WXK_ADD", PyInt_FromLong((long) WXK_ADD));
	 PyDict_SetItemString(d,"WXK_SEPARATOR", PyInt_FromLong((long) WXK_SEPARATOR));
	 PyDict_SetItemString(d,"WXK_SUBTRACT", PyInt_FromLong((long) WXK_SUBTRACT));
	 PyDict_SetItemString(d,"WXK_DECIMAL", PyInt_FromLong((long) WXK_DECIMAL));
	 PyDict_SetItemString(d,"WXK_DIVIDE", PyInt_FromLong((long) WXK_DIVIDE));
	 PyDict_SetItemString(d,"WXK_F1", PyInt_FromLong((long) WXK_F1));
	 PyDict_SetItemString(d,"WXK_F2", PyInt_FromLong((long) WXK_F2));
	 PyDict_SetItemString(d,"WXK_F3", PyInt_FromLong((long) WXK_F3));
	 PyDict_SetItemString(d,"WXK_F4", PyInt_FromLong((long) WXK_F4));
	 PyDict_SetItemString(d,"WXK_F5", PyInt_FromLong((long) WXK_F5));
	 PyDict_SetItemString(d,"WXK_F6", PyInt_FromLong((long) WXK_F6));
	 PyDict_SetItemString(d,"WXK_F7", PyInt_FromLong((long) WXK_F7));
	 PyDict_SetItemString(d,"WXK_F8", PyInt_FromLong((long) WXK_F8));
	 PyDict_SetItemString(d,"WXK_F9", PyInt_FromLong((long) WXK_F9));
	 PyDict_SetItemString(d,"WXK_F10", PyInt_FromLong((long) WXK_F10));
	 PyDict_SetItemString(d,"WXK_F11", PyInt_FromLong((long) WXK_F11));
	 PyDict_SetItemString(d,"WXK_F12", PyInt_FromLong((long) WXK_F12));
	 PyDict_SetItemString(d,"WXK_F13", PyInt_FromLong((long) WXK_F13));
	 PyDict_SetItemString(d,"WXK_F14", PyInt_FromLong((long) WXK_F14));
	 PyDict_SetItemString(d,"WXK_F15", PyInt_FromLong((long) WXK_F15));
	 PyDict_SetItemString(d,"WXK_F16", PyInt_FromLong((long) WXK_F16));
	 PyDict_SetItemString(d,"WXK_F17", PyInt_FromLong((long) WXK_F17));
	 PyDict_SetItemString(d,"WXK_F18", PyInt_FromLong((long) WXK_F18));
	 PyDict_SetItemString(d,"WXK_F19", PyInt_FromLong((long) WXK_F19));
	 PyDict_SetItemString(d,"WXK_F20", PyInt_FromLong((long) WXK_F20));
	 PyDict_SetItemString(d,"WXK_F21", PyInt_FromLong((long) WXK_F21));
	 PyDict_SetItemString(d,"WXK_F22", PyInt_FromLong((long) WXK_F22));
	 PyDict_SetItemString(d,"WXK_F23", PyInt_FromLong((long) WXK_F23));
	 PyDict_SetItemString(d,"WXK_F24", PyInt_FromLong((long) WXK_F24));
	 PyDict_SetItemString(d,"WXK_NUMLOCK", PyInt_FromLong((long) WXK_NUMLOCK));
	 PyDict_SetItemString(d,"WXK_SCROLL", PyInt_FromLong((long) WXK_SCROLL));
	 PyDict_SetItemString(d,"WXK_PAGEUP", PyInt_FromLong((long) WXK_PAGEUP));
	 PyDict_SetItemString(d,"WXK_PAGEDOWN", PyInt_FromLong((long) WXK_PAGEDOWN));
	 PyDict_SetItemString(d,"WXK_NUMPAD_SPACE", PyInt_FromLong((long) WXK_NUMPAD_SPACE));
	 PyDict_SetItemString(d,"WXK_NUMPAD_TAB", PyInt_FromLong((long) WXK_NUMPAD_TAB));
	 PyDict_SetItemString(d,"WXK_NUMPAD_ENTER", PyInt_FromLong((long) WXK_NUMPAD_ENTER));
	 PyDict_SetItemString(d,"WXK_NUMPAD_F1", PyInt_FromLong((long) WXK_NUMPAD_F1));
	 PyDict_SetItemString(d,"WXK_NUMPAD_F2", PyInt_FromLong((long) WXK_NUMPAD_F2));
	 PyDict_SetItemString(d,"WXK_NUMPAD_F3", PyInt_FromLong((long) WXK_NUMPAD_F3));
	 PyDict_SetItemString(d,"WXK_NUMPAD_F4", PyInt_FromLong((long) WXK_NUMPAD_F4));
	 PyDict_SetItemString(d,"WXK_NUMPAD_HOME", PyInt_FromLong((long) WXK_NUMPAD_HOME));
	 PyDict_SetItemString(d,"WXK_NUMPAD_LEFT", PyInt_FromLong((long) WXK_NUMPAD_LEFT));
	 PyDict_SetItemString(d,"WXK_NUMPAD_UP", PyInt_FromLong((long) WXK_NUMPAD_UP));
	 PyDict_SetItemString(d,"WXK_NUMPAD_RIGHT", PyInt_FromLong((long) WXK_NUMPAD_RIGHT));
	 PyDict_SetItemString(d,"WXK_NUMPAD_DOWN", PyInt_FromLong((long) WXK_NUMPAD_DOWN));
	 PyDict_SetItemString(d,"WXK_NUMPAD_PRIOR", PyInt_FromLong((long) WXK_NUMPAD_PRIOR));
	 PyDict_SetItemString(d,"WXK_NUMPAD_PAGEUP", PyInt_FromLong((long) WXK_NUMPAD_PAGEUP));
	 PyDict_SetItemString(d,"WXK_NUMPAD_NEXT", PyInt_FromLong((long) WXK_NUMPAD_NEXT));
	 PyDict_SetItemString(d,"WXK_NUMPAD_PAGEDOWN", PyInt_FromLong((long) WXK_NUMPAD_PAGEDOWN));
	 PyDict_SetItemString(d,"WXK_NUMPAD_END", PyInt_FromLong((long) WXK_NUMPAD_END));
	 PyDict_SetItemString(d,"WXK_NUMPAD_BEGIN", PyInt_FromLong((long) WXK_NUMPAD_BEGIN));
	 PyDict_SetItemString(d,"WXK_NUMPAD_INSERT", PyInt_FromLong((long) WXK_NUMPAD_INSERT));
	 PyDict_SetItemString(d,"WXK_NUMPAD_DELETE", PyInt_FromLong((long) WXK_NUMPAD_DELETE));
	 PyDict_SetItemString(d,"WXK_NUMPAD_EQUAL", PyInt_FromLong((long) WXK_NUMPAD_EQUAL));
	 PyDict_SetItemString(d,"WXK_NUMPAD_MULTIPLY", PyInt_FromLong((long) WXK_NUMPAD_MULTIPLY));
	 PyDict_SetItemString(d,"WXK_NUMPAD_ADD", PyInt_FromLong((long) WXK_NUMPAD_ADD));
	 PyDict_SetItemString(d,"WXK_NUMPAD_SEPARATOR", PyInt_FromLong((long) WXK_NUMPAD_SEPARATOR));
	 PyDict_SetItemString(d,"WXK_NUMPAD_SUBTRACT", PyInt_FromLong((long) WXK_NUMPAD_SUBTRACT));
	 PyDict_SetItemString(d,"WXK_NUMPAD_DECIMAL", PyInt_FromLong((long) WXK_NUMPAD_DECIMAL));
	 PyDict_SetItemString(d,"WXK_NUMPAD_DIVIDE", PyInt_FromLong((long) WXK_NUMPAD_DIVIDE));
	 PyDict_SetItemString(d,"WXK_WINDOWS_LEFT", PyInt_FromLong((long) WXK_WINDOWS_LEFT));
	 PyDict_SetItemString(d,"WXK_WINDOWS_RIGHT", PyInt_FromLong((long) WXK_WINDOWS_RIGHT));
	 PyDict_SetItemString(d,"WXK_WINDOWS_MENU", PyInt_FromLong((long) WXK_WINDOWS_MENU));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_INVALID", PyInt_FromLong((long) wxBITMAP_TYPE_INVALID));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_BMP", PyInt_FromLong((long) wxBITMAP_TYPE_BMP));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_BMP_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_BMP_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_ICO", PyInt_FromLong((long) wxBITMAP_TYPE_ICO));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_ICO_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_ICO_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_CUR", PyInt_FromLong((long) wxBITMAP_TYPE_CUR));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_CUR_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_CUR_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_XBM", PyInt_FromLong((long) wxBITMAP_TYPE_XBM));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_XBM_DATA", PyInt_FromLong((long) wxBITMAP_TYPE_XBM_DATA));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_XPM", PyInt_FromLong((long) wxBITMAP_TYPE_XPM));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_XPM_DATA", PyInt_FromLong((long) wxBITMAP_TYPE_XPM_DATA));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_TIF", PyInt_FromLong((long) wxBITMAP_TYPE_TIF));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_TIF_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_TIF_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_GIF", PyInt_FromLong((long) wxBITMAP_TYPE_GIF));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_GIF_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_GIF_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PNG", PyInt_FromLong((long) wxBITMAP_TYPE_PNG));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PNG_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_PNG_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_JPEG", PyInt_FromLong((long) wxBITMAP_TYPE_JPEG));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_JPEG_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_JPEG_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PNM", PyInt_FromLong((long) wxBITMAP_TYPE_PNM));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PNM_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_PNM_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PCX", PyInt_FromLong((long) wxBITMAP_TYPE_PCX));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PCX_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_PCX_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PICT", PyInt_FromLong((long) wxBITMAP_TYPE_PICT));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_PICT_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_PICT_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_ICON", PyInt_FromLong((long) wxBITMAP_TYPE_ICON));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_ICON_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_ICON_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_ANI", PyInt_FromLong((long) wxBITMAP_TYPE_ANI));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_IFF", PyInt_FromLong((long) wxBITMAP_TYPE_IFF));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_MACCURSOR", PyInt_FromLong((long) wxBITMAP_TYPE_MACCURSOR));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_MACCURSOR_RESOURCE", PyInt_FromLong((long) wxBITMAP_TYPE_MACCURSOR_RESOURCE));
	 PyDict_SetItemString(d,"wxBITMAP_TYPE_ANY", PyInt_FromLong((long) wxBITMAP_TYPE_ANY));
	 PyDict_SetItemString(d,"wxCURSOR_NONE", PyInt_FromLong((long) wxCURSOR_NONE));
	 PyDict_SetItemString(d,"wxCURSOR_ARROW", PyInt_FromLong((long) wxCURSOR_ARROW));
	 PyDict_SetItemString(d,"wxCURSOR_RIGHT_ARROW", PyInt_FromLong((long) wxCURSOR_RIGHT_ARROW));
	 PyDict_SetItemString(d,"wxCURSOR_BULLSEYE", PyInt_FromLong((long) wxCURSOR_BULLSEYE));
	 PyDict_SetItemString(d,"wxCURSOR_CHAR", PyInt_FromLong((long) wxCURSOR_CHAR));
	 PyDict_SetItemString(d,"wxCURSOR_CROSS", PyInt_FromLong((long) wxCURSOR_CROSS));
	 PyDict_SetItemString(d,"wxCURSOR_HAND", PyInt_FromLong((long) wxCURSOR_HAND));
	 PyDict_SetItemString(d,"wxCURSOR_IBEAM", PyInt_FromLong((long) wxCURSOR_IBEAM));
	 PyDict_SetItemString(d,"wxCURSOR_LEFT_BUTTON", PyInt_FromLong((long) wxCURSOR_LEFT_BUTTON));
	 PyDict_SetItemString(d,"wxCURSOR_MAGNIFIER", PyInt_FromLong((long) wxCURSOR_MAGNIFIER));
	 PyDict_SetItemString(d,"wxCURSOR_MIDDLE_BUTTON", PyInt_FromLong((long) wxCURSOR_MIDDLE_BUTTON));
	 PyDict_SetItemString(d,"wxCURSOR_NO_ENTRY", PyInt_FromLong((long) wxCURSOR_NO_ENTRY));
	 PyDict_SetItemString(d,"wxCURSOR_PAINT_BRUSH", PyInt_FromLong((long) wxCURSOR_PAINT_BRUSH));
	 PyDict_SetItemString(d,"wxCURSOR_PENCIL", PyInt_FromLong((long) wxCURSOR_PENCIL));
	 PyDict_SetItemString(d,"wxCURSOR_POINT_LEFT", PyInt_FromLong((long) wxCURSOR_POINT_LEFT));
	 PyDict_SetItemString(d,"wxCURSOR_POINT_RIGHT", PyInt_FromLong((long) wxCURSOR_POINT_RIGHT));
	 PyDict_SetItemString(d,"wxCURSOR_QUESTION_ARROW", PyInt_FromLong((long) wxCURSOR_QUESTION_ARROW));
	 PyDict_SetItemString(d,"wxCURSOR_RIGHT_BUTTON", PyInt_FromLong((long) wxCURSOR_RIGHT_BUTTON));
	 PyDict_SetItemString(d,"wxCURSOR_SIZENESW", PyInt_FromLong((long) wxCURSOR_SIZENESW));
	 PyDict_SetItemString(d,"wxCURSOR_SIZENS", PyInt_FromLong((long) wxCURSOR_SIZENS));
	 PyDict_SetItemString(d,"wxCURSOR_SIZENWSE", PyInt_FromLong((long) wxCURSOR_SIZENWSE));
	 PyDict_SetItemString(d,"wxCURSOR_SIZEWE", PyInt_FromLong((long) wxCURSOR_SIZEWE));
	 PyDict_SetItemString(d,"wxCURSOR_SIZING", PyInt_FromLong((long) wxCURSOR_SIZING));
	 PyDict_SetItemString(d,"wxCURSOR_SPRAYCAN", PyInt_FromLong((long) wxCURSOR_SPRAYCAN));
	 PyDict_SetItemString(d,"wxCURSOR_WAIT", PyInt_FromLong((long) wxCURSOR_WAIT));
	 PyDict_SetItemString(d,"wxCURSOR_WATCH", PyInt_FromLong((long) wxCURSOR_WATCH));
	 PyDict_SetItemString(d,"wxCURSOR_BLANK", PyInt_FromLong((long) wxCURSOR_BLANK));
	 PyDict_SetItemString(d,"wxCURSOR_DEFAULT", PyInt_FromLong((long) wxCURSOR_DEFAULT));
	 PyDict_SetItemString(d,"wxCURSOR_ARROWWAIT", PyInt_FromLong((long) wxCURSOR_ARROWWAIT));
	 PyDict_SetItemString(d,"wxCURSOR_MAX", PyInt_FromLong((long) wxCURSOR_MAX));
	 PyDict_SetItemString(d,"wxPAPER_NONE", PyInt_FromLong((long) wxPAPER_NONE));
	 PyDict_SetItemString(d,"wxPAPER_LETTER", PyInt_FromLong((long) wxPAPER_LETTER));
	 PyDict_SetItemString(d,"wxPAPER_LEGAL", PyInt_FromLong((long) wxPAPER_LEGAL));
	 PyDict_SetItemString(d,"wxPAPER_A4", PyInt_FromLong((long) wxPAPER_A4));
	 PyDict_SetItemString(d,"wxPAPER_CSHEET", PyInt_FromLong((long) wxPAPER_CSHEET));
	 PyDict_SetItemString(d,"wxPAPER_DSHEET", PyInt_FromLong((long) wxPAPER_DSHEET));
	 PyDict_SetItemString(d,"wxPAPER_ESHEET", PyInt_FromLong((long) wxPAPER_ESHEET));
	 PyDict_SetItemString(d,"wxPAPER_LETTERSMALL", PyInt_FromLong((long) wxPAPER_LETTERSMALL));
	 PyDict_SetItemString(d,"wxPAPER_TABLOID", PyInt_FromLong((long) wxPAPER_TABLOID));
	 PyDict_SetItemString(d,"wxPAPER_LEDGER", PyInt_FromLong((long) wxPAPER_LEDGER));
	 PyDict_SetItemString(d,"wxPAPER_STATEMENT", PyInt_FromLong((long) wxPAPER_STATEMENT));
	 PyDict_SetItemString(d,"wxPAPER_EXECUTIVE", PyInt_FromLong((long) wxPAPER_EXECUTIVE));
	 PyDict_SetItemString(d,"wxPAPER_A3", PyInt_FromLong((long) wxPAPER_A3));
	 PyDict_SetItemString(d,"wxPAPER_A4SMALL", PyInt_FromLong((long) wxPAPER_A4SMALL));
	 PyDict_SetItemString(d,"wxPAPER_A5", PyInt_FromLong((long) wxPAPER_A5));
	 PyDict_SetItemString(d,"wxPAPER_B4", PyInt_FromLong((long) wxPAPER_B4));
	 PyDict_SetItemString(d,"wxPAPER_B5", PyInt_FromLong((long) wxPAPER_B5));
	 PyDict_SetItemString(d,"wxPAPER_FOLIO", PyInt_FromLong((long) wxPAPER_FOLIO));
	 PyDict_SetItemString(d,"wxPAPER_QUARTO", PyInt_FromLong((long) wxPAPER_QUARTO));
	 PyDict_SetItemString(d,"wxPAPER_10X14", PyInt_FromLong((long) wxPAPER_10X14));
	 PyDict_SetItemString(d,"wxPAPER_11X17", PyInt_FromLong((long) wxPAPER_11X17));
	 PyDict_SetItemString(d,"wxPAPER_NOTE", PyInt_FromLong((long) wxPAPER_NOTE));
	 PyDict_SetItemString(d,"wxPAPER_ENV_9", PyInt_FromLong((long) wxPAPER_ENV_9));
	 PyDict_SetItemString(d,"wxPAPER_ENV_10", PyInt_FromLong((long) wxPAPER_ENV_10));
	 PyDict_SetItemString(d,"wxPAPER_ENV_11", PyInt_FromLong((long) wxPAPER_ENV_11));
	 PyDict_SetItemString(d,"wxPAPER_ENV_12", PyInt_FromLong((long) wxPAPER_ENV_12));
	 PyDict_SetItemString(d,"wxPAPER_ENV_14", PyInt_FromLong((long) wxPAPER_ENV_14));
	 PyDict_SetItemString(d,"wxPAPER_ENV_DL", PyInt_FromLong((long) wxPAPER_ENV_DL));
	 PyDict_SetItemString(d,"wxPAPER_ENV_C5", PyInt_FromLong((long) wxPAPER_ENV_C5));
	 PyDict_SetItemString(d,"wxPAPER_ENV_C3", PyInt_FromLong((long) wxPAPER_ENV_C3));
	 PyDict_SetItemString(d,"wxPAPER_ENV_C4", PyInt_FromLong((long) wxPAPER_ENV_C4));
	 PyDict_SetItemString(d,"wxPAPER_ENV_C6", PyInt_FromLong((long) wxPAPER_ENV_C6));
	 PyDict_SetItemString(d,"wxPAPER_ENV_C65", PyInt_FromLong((long) wxPAPER_ENV_C65));
	 PyDict_SetItemString(d,"wxPAPER_ENV_B4", PyInt_FromLong((long) wxPAPER_ENV_B4));
	 PyDict_SetItemString(d,"wxPAPER_ENV_B5", PyInt_FromLong((long) wxPAPER_ENV_B5));
	 PyDict_SetItemString(d,"wxPAPER_ENV_B6", PyInt_FromLong((long) wxPAPER_ENV_B6));
	 PyDict_SetItemString(d,"wxPAPER_ENV_ITALY", PyInt_FromLong((long) wxPAPER_ENV_ITALY));
	 PyDict_SetItemString(d,"wxPAPER_ENV_MONARCH", PyInt_FromLong((long) wxPAPER_ENV_MONARCH));
	 PyDict_SetItemString(d,"wxPAPER_ENV_PERSONAL", PyInt_FromLong((long) wxPAPER_ENV_PERSONAL));
	 PyDict_SetItemString(d,"wxPAPER_FANFOLD_US", PyInt_FromLong((long) wxPAPER_FANFOLD_US));
	 PyDict_SetItemString(d,"wxPAPER_FANFOLD_STD_GERMAN", PyInt_FromLong((long) wxPAPER_FANFOLD_STD_GERMAN));
	 PyDict_SetItemString(d,"wxPAPER_FANFOLD_LGL_GERMAN", PyInt_FromLong((long) wxPAPER_FANFOLD_LGL_GERMAN));
	 PyDict_SetItemString(d,"wxPAPER_ISO_B4", PyInt_FromLong((long) wxPAPER_ISO_B4));
	 PyDict_SetItemString(d,"wxPAPER_JAPANESE_POSTCARD", PyInt_FromLong((long) wxPAPER_JAPANESE_POSTCARD));
	 PyDict_SetItemString(d,"wxPAPER_9X11", PyInt_FromLong((long) wxPAPER_9X11));
	 PyDict_SetItemString(d,"wxPAPER_10X11", PyInt_FromLong((long) wxPAPER_10X11));
	 PyDict_SetItemString(d,"wxPAPER_15X11", PyInt_FromLong((long) wxPAPER_15X11));
	 PyDict_SetItemString(d,"wxPAPER_ENV_INVITE", PyInt_FromLong((long) wxPAPER_ENV_INVITE));
	 PyDict_SetItemString(d,"wxPAPER_LETTER_EXTRA", PyInt_FromLong((long) wxPAPER_LETTER_EXTRA));
	 PyDict_SetItemString(d,"wxPAPER_LEGAL_EXTRA", PyInt_FromLong((long) wxPAPER_LEGAL_EXTRA));
	 PyDict_SetItemString(d,"wxPAPER_TABLOID_EXTRA", PyInt_FromLong((long) wxPAPER_TABLOID_EXTRA));
	 PyDict_SetItemString(d,"wxPAPER_A4_EXTRA", PyInt_FromLong((long) wxPAPER_A4_EXTRA));
	 PyDict_SetItemString(d,"wxPAPER_LETTER_TRANSVERSE", PyInt_FromLong((long) wxPAPER_LETTER_TRANSVERSE));
	 PyDict_SetItemString(d,"wxPAPER_A4_TRANSVERSE", PyInt_FromLong((long) wxPAPER_A4_TRANSVERSE));
	 PyDict_SetItemString(d,"wxPAPER_LETTER_EXTRA_TRANSVERSE", PyInt_FromLong((long) wxPAPER_LETTER_EXTRA_TRANSVERSE));
	 PyDict_SetItemString(d,"wxPAPER_A_PLUS", PyInt_FromLong((long) wxPAPER_A_PLUS));
	 PyDict_SetItemString(d,"wxPAPER_B_PLUS", PyInt_FromLong((long) wxPAPER_B_PLUS));
	 PyDict_SetItemString(d,"wxPAPER_LETTER_PLUS", PyInt_FromLong((long) wxPAPER_LETTER_PLUS));
	 PyDict_SetItemString(d,"wxPAPER_A4_PLUS", PyInt_FromLong((long) wxPAPER_A4_PLUS));
	 PyDict_SetItemString(d,"wxPAPER_A5_TRANSVERSE", PyInt_FromLong((long) wxPAPER_A5_TRANSVERSE));
	 PyDict_SetItemString(d,"wxPAPER_B5_TRANSVERSE", PyInt_FromLong((long) wxPAPER_B5_TRANSVERSE));
	 PyDict_SetItemString(d,"wxPAPER_A3_EXTRA", PyInt_FromLong((long) wxPAPER_A3_EXTRA));
	 PyDict_SetItemString(d,"wxPAPER_A5_EXTRA", PyInt_FromLong((long) wxPAPER_A5_EXTRA));
	 PyDict_SetItemString(d,"wxPAPER_B5_EXTRA", PyInt_FromLong((long) wxPAPER_B5_EXTRA));
	 PyDict_SetItemString(d,"wxPAPER_A2", PyInt_FromLong((long) wxPAPER_A2));
	 PyDict_SetItemString(d,"wxPAPER_A3_TRANSVERSE", PyInt_FromLong((long) wxPAPER_A3_TRANSVERSE));
	 PyDict_SetItemString(d,"wxPAPER_A3_EXTRA_TRANSVERSE", PyInt_FromLong((long) wxPAPER_A3_EXTRA_TRANSVERSE));
	 PyDict_SetItemString(d,"wxDUPLEX_SIMPLEX", PyInt_FromLong((long) wxDUPLEX_SIMPLEX));
	 PyDict_SetItemString(d,"wxDUPLEX_HORIZONTAL", PyInt_FromLong((long) wxDUPLEX_HORIZONTAL));
	 PyDict_SetItemString(d,"wxDUPLEX_VERTICAL", PyInt_FromLong((long) wxDUPLEX_VERTICAL));
	 PyDict_SetItemString(d,"wxITEM_SEPARATOR", PyInt_FromLong((long) wxITEM_SEPARATOR));
	 PyDict_SetItemString(d,"wxITEM_NORMAL", PyInt_FromLong((long) wxITEM_NORMAL));
	 PyDict_SetItemString(d,"wxITEM_CHECK", PyInt_FromLong((long) wxITEM_CHECK));
	 PyDict_SetItemString(d,"wxITEM_RADIO", PyInt_FromLong((long) wxITEM_RADIO));
	 PyDict_SetItemString(d,"wxITEM_MAX", PyInt_FromLong((long) wxITEM_MAX));
	 PyDict_SetItemString(d,"wxHT_NOWHERE", PyInt_FromLong((long) wxHT_NOWHERE));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_FIRST", PyInt_FromLong((long) wxHT_SCROLLBAR_FIRST));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_ARROW_LINE_1", PyInt_FromLong((long) wxHT_SCROLLBAR_ARROW_LINE_1));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_ARROW_LINE_2", PyInt_FromLong((long) wxHT_SCROLLBAR_ARROW_LINE_2));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_ARROW_PAGE_1", PyInt_FromLong((long) wxHT_SCROLLBAR_ARROW_PAGE_1));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_ARROW_PAGE_2", PyInt_FromLong((long) wxHT_SCROLLBAR_ARROW_PAGE_2));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_THUMB", PyInt_FromLong((long) wxHT_SCROLLBAR_THUMB));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_BAR_1", PyInt_FromLong((long) wxHT_SCROLLBAR_BAR_1));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_BAR_2", PyInt_FromLong((long) wxHT_SCROLLBAR_BAR_2));
	 PyDict_SetItemString(d,"wxHT_SCROLLBAR_LAST", PyInt_FromLong((long) wxHT_SCROLLBAR_LAST));
	 PyDict_SetItemString(d,"wxHT_WINDOW_OUTSIDE", PyInt_FromLong((long) wxHT_WINDOW_OUTSIDE));
	 PyDict_SetItemString(d,"wxHT_WINDOW_INSIDE", PyInt_FromLong((long) wxHT_WINDOW_INSIDE));
	 PyDict_SetItemString(d,"wxHT_WINDOW_VERT_SCROLLBAR", PyInt_FromLong((long) wxHT_WINDOW_VERT_SCROLLBAR));
	 PyDict_SetItemString(d,"wxHT_WINDOW_HORZ_SCROLLBAR", PyInt_FromLong((long) wxHT_WINDOW_HORZ_SCROLLBAR));
	 PyDict_SetItemString(d,"wxHT_WINDOW_CORNER", PyInt_FromLong((long) wxHT_WINDOW_CORNER));
	 PyDict_SetItemString(d,"wxHT_MAX", PyInt_FromLong((long) wxHT_MAX));
	 PyDict_SetItemString(d,"wxMOD_NONE", PyInt_FromLong((long) wxMOD_NONE));
	 PyDict_SetItemString(d,"wxMOD_ALT", PyInt_FromLong((long) wxMOD_ALT));
	 PyDict_SetItemString(d,"wxMOD_CONTROL", PyInt_FromLong((long) wxMOD_CONTROL));
	 PyDict_SetItemString(d,"wxMOD_SHIFT", PyInt_FromLong((long) wxMOD_SHIFT));
	 PyDict_SetItemString(d,"wxMOD_WIN", PyInt_FromLong((long) wxMOD_WIN));
	 PyDict_SetItemString(d,"wxUPDATE_UI_NONE", PyInt_FromLong((long) wxUPDATE_UI_NONE));
	 PyDict_SetItemString(d,"wxUPDATE_UI_RECURSE", PyInt_FromLong((long) wxUPDATE_UI_RECURSE));
	 PyDict_SetItemString(d,"wxUPDATE_UI_FROMIDLE", PyInt_FromLong((long) wxUPDATE_UI_FROMIDLE));
	 PyDict_SetItemString(d,"wxEVT_NULL", PyInt_FromLong((long) wxEVT_NULL));
	 PyDict_SetItemString(d,"wxEVT_FIRST", PyInt_FromLong((long) wxEVT_FIRST));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_BUTTON_CLICKED", PyInt_FromLong((long) wxEVT_COMMAND_BUTTON_CLICKED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_CHECKBOX_CLICKED", PyInt_FromLong((long) wxEVT_COMMAND_CHECKBOX_CLICKED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_CHOICE_SELECTED", PyInt_FromLong((long) wxEVT_COMMAND_CHOICE_SELECTED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_LISTBOX_SELECTED", PyInt_FromLong((long) wxEVT_COMMAND_LISTBOX_SELECTED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_LISTBOX_DOUBLECLICKED", PyInt_FromLong((long) wxEVT_COMMAND_LISTBOX_DOUBLECLICKED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_CHECKLISTBOX_TOGGLED", PyInt_FromLong((long) wxEVT_COMMAND_CHECKLISTBOX_TOGGLED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_SPINCTRL_UPDATED", PyInt_FromLong((long) wxEVT_COMMAND_SPINCTRL_UPDATED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_TEXT_UPDATED", PyInt_FromLong((long) wxEVT_COMMAND_TEXT_UPDATED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_TEXT_ENTER", PyInt_FromLong((long) wxEVT_COMMAND_TEXT_ENTER));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_TEXT_URL", PyInt_FromLong((long) wxEVT_COMMAND_TEXT_URL));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_TEXT_MAXLEN", PyInt_FromLong((long) wxEVT_COMMAND_TEXT_MAXLEN));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_MENU_SELECTED", PyInt_FromLong((long) wxEVT_COMMAND_MENU_SELECTED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_SLIDER_UPDATED", PyInt_FromLong((long) wxEVT_COMMAND_SLIDER_UPDATED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_RADIOBOX_SELECTED", PyInt_FromLong((long) wxEVT_COMMAND_RADIOBOX_SELECTED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_RADIOBUTTON_SELECTED", PyInt_FromLong((long) wxEVT_COMMAND_RADIOBUTTON_SELECTED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_SCROLLBAR_UPDATED", PyInt_FromLong((long) wxEVT_COMMAND_SCROLLBAR_UPDATED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_VLBOX_SELECTED", PyInt_FromLong((long) wxEVT_COMMAND_VLBOX_SELECTED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_COMBOBOX_SELECTED", PyInt_FromLong((long) wxEVT_COMMAND_COMBOBOX_SELECTED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_TOOL_CLICKED", PyInt_FromLong((long) wxEVT_COMMAND_TOOL_CLICKED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_TOOL_RCLICKED", PyInt_FromLong((long) wxEVT_COMMAND_TOOL_RCLICKED));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_TOOL_ENTER", PyInt_FromLong((long) wxEVT_COMMAND_TOOL_ENTER));
	 PyDict_SetItemString(d,"wxEVT_SET_FOCUS", PyInt_FromLong((long) wxEVT_SET_FOCUS));
	 PyDict_SetItemString(d,"wxEVT_KILL_FOCUS", PyInt_FromLong((long) wxEVT_KILL_FOCUS));
	 PyDict_SetItemString(d,"wxEVT_CHILD_FOCUS", PyInt_FromLong((long) wxEVT_CHILD_FOCUS));
	 PyDict_SetItemString(d,"wxEVT_MOUSEWHEEL", PyInt_FromLong((long) wxEVT_MOUSEWHEEL));
	 PyDict_SetItemString(d,"wxEVT_LEFT_DOWN", PyInt_FromLong((long) wxEVT_LEFT_DOWN));
	 PyDict_SetItemString(d,"wxEVT_LEFT_UP", PyInt_FromLong((long) wxEVT_LEFT_UP));
	 PyDict_SetItemString(d,"wxEVT_MIDDLE_DOWN", PyInt_FromLong((long) wxEVT_MIDDLE_DOWN));
	 PyDict_SetItemString(d,"wxEVT_MIDDLE_UP", PyInt_FromLong((long) wxEVT_MIDDLE_UP));
	 PyDict_SetItemString(d,"wxEVT_RIGHT_DOWN", PyInt_FromLong((long) wxEVT_RIGHT_DOWN));
	 PyDict_SetItemString(d,"wxEVT_RIGHT_UP", PyInt_FromLong((long) wxEVT_RIGHT_UP));
	 PyDict_SetItemString(d,"wxEVT_MOTION", PyInt_FromLong((long) wxEVT_MOTION));
	 PyDict_SetItemString(d,"wxEVT_ENTER_WINDOW", PyInt_FromLong((long) wxEVT_ENTER_WINDOW));
	 PyDict_SetItemString(d,"wxEVT_LEAVE_WINDOW", PyInt_FromLong((long) wxEVT_LEAVE_WINDOW));
	 PyDict_SetItemString(d,"wxEVT_LEFT_DCLICK", PyInt_FromLong((long) wxEVT_LEFT_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_MIDDLE_DCLICK", PyInt_FromLong((long) wxEVT_MIDDLE_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_RIGHT_DCLICK", PyInt_FromLong((long) wxEVT_RIGHT_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_MOUSE_CAPTURE_CHANGED", PyInt_FromLong((long) wxEVT_MOUSE_CAPTURE_CHANGED));
	 PyDict_SetItemString(d,"wxEVT_NC_LEFT_DOWN", PyInt_FromLong((long) wxEVT_NC_LEFT_DOWN));
	 PyDict_SetItemString(d,"wxEVT_NC_LEFT_UP", PyInt_FromLong((long) wxEVT_NC_LEFT_UP));
	 PyDict_SetItemString(d,"wxEVT_NC_MIDDLE_DOWN", PyInt_FromLong((long) wxEVT_NC_MIDDLE_DOWN));
	 PyDict_SetItemString(d,"wxEVT_NC_MIDDLE_UP", PyInt_FromLong((long) wxEVT_NC_MIDDLE_UP));
	 PyDict_SetItemString(d,"wxEVT_NC_RIGHT_DOWN", PyInt_FromLong((long) wxEVT_NC_RIGHT_DOWN));
	 PyDict_SetItemString(d,"wxEVT_NC_RIGHT_UP", PyInt_FromLong((long) wxEVT_NC_RIGHT_UP));
	 PyDict_SetItemString(d,"wxEVT_NC_MOTION", PyInt_FromLong((long) wxEVT_NC_MOTION));
	 PyDict_SetItemString(d,"wxEVT_NC_ENTER_WINDOW", PyInt_FromLong((long) wxEVT_NC_ENTER_WINDOW));
	 PyDict_SetItemString(d,"wxEVT_NC_LEAVE_WINDOW", PyInt_FromLong((long) wxEVT_NC_LEAVE_WINDOW));
	 PyDict_SetItemString(d,"wxEVT_NC_LEFT_DCLICK", PyInt_FromLong((long) wxEVT_NC_LEFT_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_NC_MIDDLE_DCLICK", PyInt_FromLong((long) wxEVT_NC_MIDDLE_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_NC_RIGHT_DCLICK", PyInt_FromLong((long) wxEVT_NC_RIGHT_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_SET_CURSOR", PyInt_FromLong((long) wxEVT_SET_CURSOR));
	 PyDict_SetItemString(d,"wxEVT_CHAR", PyInt_FromLong((long) wxEVT_CHAR));
	 PyDict_SetItemString(d,"wxEVT_KEY_DOWN", PyInt_FromLong((long) wxEVT_KEY_DOWN));
	 PyDict_SetItemString(d,"wxEVT_KEY_UP", PyInt_FromLong((long) wxEVT_KEY_UP));
	 PyDict_SetItemString(d,"wxEVT_CHAR_HOOK", PyInt_FromLong((long) wxEVT_CHAR_HOOK));
	 PyDict_SetItemString(d,"wxEVT_HOTKEY", PyInt_FromLong((long) wxEVT_HOTKEY));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_TOP", PyInt_FromLong((long) wxEVT_SCROLL_TOP));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_BOTTOM", PyInt_FromLong((long) wxEVT_SCROLL_BOTTOM));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_LINEUP", PyInt_FromLong((long) wxEVT_SCROLL_LINEUP));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_LINEDOWN", PyInt_FromLong((long) wxEVT_SCROLL_LINEDOWN));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_PAGEUP", PyInt_FromLong((long) wxEVT_SCROLL_PAGEUP));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_PAGEDOWN", PyInt_FromLong((long) wxEVT_SCROLL_PAGEDOWN));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_THUMBTRACK", PyInt_FromLong((long) wxEVT_SCROLL_THUMBTRACK));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_THUMBRELEASE", PyInt_FromLong((long) wxEVT_SCROLL_THUMBRELEASE));
	 PyDict_SetItemString(d,"wxEVT_SCROLL_ENDSCROLL", PyInt_FromLong((long) wxEVT_SCROLL_ENDSCROLL));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_TOP", PyInt_FromLong((long) wxEVT_SCROLLWIN_TOP));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_BOTTOM", PyInt_FromLong((long) wxEVT_SCROLLWIN_BOTTOM));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_LINEUP", PyInt_FromLong((long) wxEVT_SCROLLWIN_LINEUP));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_LINEDOWN", PyInt_FromLong((long) wxEVT_SCROLLWIN_LINEDOWN));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_PAGEUP", PyInt_FromLong((long) wxEVT_SCROLLWIN_PAGEUP));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_PAGEDOWN", PyInt_FromLong((long) wxEVT_SCROLLWIN_PAGEDOWN));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_THUMBTRACK", PyInt_FromLong((long) wxEVT_SCROLLWIN_THUMBTRACK));
	 PyDict_SetItemString(d,"wxEVT_SCROLLWIN_THUMBRELEASE", PyInt_FromLong((long) wxEVT_SCROLLWIN_THUMBRELEASE));
	 PyDict_SetItemString(d,"wxEVT_SIZE", PyInt_FromLong((long) wxEVT_SIZE));
	 PyDict_SetItemString(d,"wxEVT_MOVE", PyInt_FromLong((long) wxEVT_MOVE));
	 PyDict_SetItemString(d,"wxEVT_SIZING", PyInt_FromLong((long) wxEVT_SIZING));
	 PyDict_SetItemString(d,"wxEVT_MOVING", PyInt_FromLong((long) wxEVT_MOVING));
	 PyDict_SetItemString(d,"wxEVT_CLOSE_WINDOW", PyInt_FromLong((long) wxEVT_CLOSE_WINDOW));
	 PyDict_SetItemString(d,"wxEVT_END_SESSION", PyInt_FromLong((long) wxEVT_END_SESSION));
	 PyDict_SetItemString(d,"wxEVT_QUERY_END_SESSION", PyInt_FromLong((long) wxEVT_QUERY_END_SESSION));
	 PyDict_SetItemString(d,"wxEVT_ACTIVATE_APP", PyInt_FromLong((long) wxEVT_ACTIVATE_APP));
	 PyDict_SetItemString(d,"wxEVT_POWER", PyInt_FromLong((long) wxEVT_POWER));
	 PyDict_SetItemString(d,"wxEVT_ACTIVATE", PyInt_FromLong((long) wxEVT_ACTIVATE));
	 PyDict_SetItemString(d,"wxEVT_CREATE", PyInt_FromLong((long) wxEVT_CREATE));
	 PyDict_SetItemString(d,"wxEVT_DESTROY", PyInt_FromLong((long) wxEVT_DESTROY));
	 PyDict_SetItemString(d,"wxEVT_SHOW", PyInt_FromLong((long) wxEVT_SHOW));
	 PyDict_SetItemString(d,"wxEVT_ICONIZE", PyInt_FromLong((long) wxEVT_ICONIZE));
	 PyDict_SetItemString(d,"wxEVT_MAXIMIZE", PyInt_FromLong((long) wxEVT_MAXIMIZE));
	 PyDict_SetItemString(d,"wxEVT_PAINT", PyInt_FromLong((long) wxEVT_PAINT));
	 PyDict_SetItemString(d,"wxEVT_ERASE_BACKGROUND", PyInt_FromLong((long) wxEVT_ERASE_BACKGROUND));
	 PyDict_SetItemString(d,"wxEVT_NC_PAINT", PyInt_FromLong((long) wxEVT_NC_PAINT));
	 PyDict_SetItemString(d,"wxEVT_PAINT_ICON", PyInt_FromLong((long) wxEVT_PAINT_ICON));
	 PyDict_SetItemString(d,"wxEVT_MENU_OPEN", PyInt_FromLong((long) wxEVT_MENU_OPEN));
	 PyDict_SetItemString(d,"wxEVT_MENU_CLOSE", PyInt_FromLong((long) wxEVT_MENU_CLOSE));
	 PyDict_SetItemString(d,"wxEVT_MENU_HIGHLIGHT", PyInt_FromLong((long) wxEVT_MENU_HIGHLIGHT));
	 PyDict_SetItemString(d,"wxEVT_CONTEXT_MENU", PyInt_FromLong((long) wxEVT_CONTEXT_MENU));
	 PyDict_SetItemString(d,"wxEVT_SYS_COLOUR_CHANGED", PyInt_FromLong((long) wxEVT_SYS_COLOUR_CHANGED));
	 PyDict_SetItemString(d,"wxEVT_DISPLAY_CHANGED", PyInt_FromLong((long) wxEVT_DISPLAY_CHANGED));
	 PyDict_SetItemString(d,"wxEVT_SETTING_CHANGED", PyInt_FromLong((long) wxEVT_SETTING_CHANGED));
	 PyDict_SetItemString(d,"wxEVT_QUERY_NEW_PALETTE", PyInt_FromLong((long) wxEVT_QUERY_NEW_PALETTE));
	 PyDict_SetItemString(d,"wxEVT_PALETTE_CHANGED", PyInt_FromLong((long) wxEVT_PALETTE_CHANGED));
	 PyDict_SetItemString(d,"wxEVT_JOY_BUTTON_DOWN", PyInt_FromLong((long) wxEVT_JOY_BUTTON_DOWN));
	 PyDict_SetItemString(d,"wxEVT_JOY_BUTTON_UP", PyInt_FromLong((long) wxEVT_JOY_BUTTON_UP));
	 PyDict_SetItemString(d,"wxEVT_JOY_MOVE", PyInt_FromLong((long) wxEVT_JOY_MOVE));
	 PyDict_SetItemString(d,"wxEVT_JOY_ZMOVE", PyInt_FromLong((long) wxEVT_JOY_ZMOVE));
	 PyDict_SetItemString(d,"wxEVT_DROP_FILES", PyInt_FromLong((long) wxEVT_DROP_FILES));
	 PyDict_SetItemString(d,"wxEVT_DRAW_ITEM", PyInt_FromLong((long) wxEVT_DRAW_ITEM));
	 PyDict_SetItemString(d,"wxEVT_MEASURE_ITEM", PyInt_FromLong((long) wxEVT_MEASURE_ITEM));
	 PyDict_SetItemString(d,"wxEVT_COMPARE_ITEM", PyInt_FromLong((long) wxEVT_COMPARE_ITEM));
	 PyDict_SetItemString(d,"wxEVT_INIT_DIALOG", PyInt_FromLong((long) wxEVT_INIT_DIALOG));
	 PyDict_SetItemString(d,"wxEVT_IDLE", PyInt_FromLong((long) wxEVT_IDLE));
	 PyDict_SetItemString(d,"wxEVT_UPDATE_UI", PyInt_FromLong((long) wxEVT_UPDATE_UI));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_LEFT_CLICK", PyInt_FromLong((long) wxEVT_COMMAND_LEFT_CLICK));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_LEFT_DCLICK", PyInt_FromLong((long) wxEVT_COMMAND_LEFT_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_RIGHT_CLICK", PyInt_FromLong((long) wxEVT_COMMAND_RIGHT_CLICK));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_RIGHT_DCLICK", PyInt_FromLong((long) wxEVT_COMMAND_RIGHT_DCLICK));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_SET_FOCUS", PyInt_FromLong((long) wxEVT_COMMAND_SET_FOCUS));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_KILL_FOCUS", PyInt_FromLong((long) wxEVT_COMMAND_KILL_FOCUS));
	 PyDict_SetItemString(d,"wxEVT_COMMAND_ENTER", PyInt_FromLong((long) wxEVT_COMMAND_ENTER));
	 PyDict_SetItemString(d,"wxEVT_NAVIGATION_KEY", PyInt_FromLong((long) wxEVT_NAVIGATION_KEY));
	 PyDict_SetItemString(d,"wxEVT_TIMER", PyInt_FromLong((long) wxEVT_TIMER));
	 PyDict_SetItemString(d,"cvar", SWIG_globals);
	 SWIG_addvarlink(SWIG_globals,"wxDefaultPosition",_wrap_wxDefaultPosition_get, _wrap_wxDefaultPosition_set);
	 SWIG_addvarlink(SWIG_globals,"wxDefaultSize",_wrap_wxDefaultSize_get, _wrap_wxDefaultSize_set);
	 PyDict_SetItemString(d,"wxPYAPP_ASSERT_SUPPRESS", PyInt_FromLong((long) wxPYAPP_ASSERT_SUPPRESS));
	 PyDict_SetItemString(d,"wxPYAPP_ASSERT_EXCEPTION", PyInt_FromLong((long) wxPYAPP_ASSERT_EXCEPTION));
	 PyDict_SetItemString(d,"wxPYAPP_ASSERT_DIALOG", PyInt_FromLong((long) wxPYAPP_ASSERT_DIALOG));
	 PyDict_SetItemString(d,"wxPYAPP_ASSERT_LOG", PyInt_FromLong((long) wxPYAPP_ASSERT_LOG));

    // Make our API structure a CObject so other modules can import it
    // from this module.
    PyObject* v = PyCObject_FromVoidPtr(&API, NULL);
    PyDict_SetItemString(d,"wxPyCoreAPI", v);
    Py_XDECREF(v);


    __wxPreStart(d);     // initialize the GUI toolkit, if needed.


        // Since these modules are all linked together, initialize them now
        // because Python won't be able to find their shared library files,
        // (since there isn't any.)
    initwindowsc();
    initwindows2c();
    initeventsc();
    initmiscc();
    initmisc2c();
    initgdic();
    initmdic();
    initcontrolsc();
    initcontrols2c();
    initcmndlgsc();
    initstattoolc();
    initframesc();
    initwindows3c();
    initimagec();
    initprintfwc();
    initsizersc();
    initclip_dndc();
    initstreamsc();
    initfilesysc();
    initutilsc();
    initfontsc();


    // Although these are redfined in __version__ they need to be here too so
    // that an assert can be done to ensure that the wxPython and the wxWindows
    // versions match.
    PyDict_SetItemString(d,"wxMAJOR_VERSION", PyInt_FromLong((long)wxMAJOR_VERSION ));
    PyDict_SetItemString(d,"wxMINOR_VERSION", PyInt_FromLong((long)wxMINOR_VERSION ));
    PyDict_SetItemString(d,"wxRELEASE_VERSION", PyInt_FromLong((long)wxRELEASE_NUMBER ));

{
   int i;
   for (i = 0; _swig_mapping[i].n1; i++)
        SWIG_RegisterMapping(_swig_mapping[i].n1,_swig_mapping[i].n2,_swig_mapping[i].pcnv);
}
}
