
#include <unistd.h>
#include <stdio.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <sys/types.h>
#include <pthread.h>
#include <time.h>
#include <dlfcn.h>
#include <sys/time.h>
#include <time.h>
#include <syslog.h>

#include "../pfqlib.h"
#include "pfqlib_priv.h"
#include "../config.h"
#include "../pfregex.h"
#include "../pfqmessage.h"
#include "../backends/pfq_backend.h"

#define LOGLEVEL LOG_USER | LOG_ERR

#define PFQ_SONAME "0.0.0"

void *beptr;
char* (*pfqbe_id)();
char* (*pfqbe_version)();
int (*pfqbe_apiversion)();
int (*pfqbe_init)();
int (*pfqbe_setup)(struct msg_t*,struct be_msg_t*);
int (*pfqbe_close)();
int (*pfqbe_fill_queue)();
int (*pfqbe_retr_headers)(const char*);
int (*pfqbe_retr_status)(const char*);
int (*pfqbe_retr_body)(const char*,char*,size_t);
int (*pfqbe_message_delete)(const char*);
int (*pfqbe_message_hold)(const char*);
int (*pfqbe_message_release)(const char*);
int (*pfqbe_message_requeue)(const char*);
int (*pfqbe_set_queue)(int);
char* (*pfqbe_queue_name)(int);
void (*pfqbe_use_envelope)(int);
int (*pfqbe_get_caps)();
int (*pfqbe_queue_count)();
struct pfb_conf_t* (*pfqbe_getconf)();

int dig_suspend;
int NUMTAG;
int NUMMSG;

#define TH_UNINITIALIZED -1
#define TH_RUNNABLE       0
#define TH_STOPRQ         1
#define TH_STOPPED        2
int thread_control;

struct msg_t *queue;
struct be_msg_t *queue_thread;

struct pfql_status_t pfql_status;
struct pfql_conf_t   pfql_conf;

time_t queue_last_changed;

struct pfql_status_t* pfql_getstatus() {
	return &pfql_status;
}

struct pfql_conf_t* pfql_getconf() {
	return &pfql_conf;
}

const char* pfql_version() {
	return PFQL_VERSION;
}

const char* pfql_queue_name(int i) {
	return pfqbe_queue_name(i);
}

time_t pfql_queue_last_changed() {
	return queue_last_changed;
}

int pfql_backend_apiversion() {
	return pfqbe_apiversion();
}

const char* pfql_backend_id() {
	return pfqbe_id();
}

const char* pfql_backend_version() {
	return pfqbe_version();
}

int pfql_retr_status(const char *id ) {
	return pfqbe_retr_status(id);
}

int pfql_retr_headers(const char *id ) {
	return pfqbe_retr_headers(id);
}

int pfql_retr_body(const char *id, void* buf, size_t t) {
int res;
	res = pfqbe_retr_body(id,buf,t);
	if ( res != PFBE_MSGNOTEX )
		return res;
	else
		return PFQL_MSGNOTEX;
}

int pfql_msg_getpos(const char* id) {
int i;
	if ( !NUMMSG )
		return PFQL_MSGNOTEX;
	for ( i=0; i<NUMMSG; i++ ) {
		if ( !strcmp(id, queue[i].id ) )
			return i;
	}
	return PFQL_MSGNOTEX;
}

int pfql_num_msg() {
	return NUMMSG;
}

int pfql_num_tag() {
	return NUMTAG;
}

void pfql_msg_tag(const char* id) {
int i;

	i = pfql_msg_getpos(id);
	if ( i==-1 )
		return;

	if ( !queue[i].tagged ) {
		queue[i].tagged = 1;
		NUMTAG++;
	}
}

void pfql_msg_untag(const char* id) {
int i;
	i = pfql_msg_getpos(id);
	if ( i==-1 )
		return;
	
	if ( queue[i].tagged ) {
		queue[i].tagged = 0;
		NUMTAG--;
	}
}

void pfql_msg_toggletag(const char* id) {
int i;
	i = pfql_msg_getpos(id);
	if ( i==-1 )
		return;
	
	if ( queue[i].tagged )
		pfql_msg_untag(id);
	else
		pfql_msg_tag(id);

}

int pfql_msg_istagged(const char* id) {
int i;
	i = pfql_msg_getpos(id);
	if ( i==-1 )
		return 0;
	return queue[i].tagged;
}

struct msg_t *pfql_msg_at(int i) {
	if ( i<NUMMSG )
		return &queue[i];
	else
		return NULL;
}

struct msg_t *pfql_msg(const char* id) {
int i;
	i = pfql_msg_getpos(id);
	if ( i==-1 )
		return NULL;
	else
		return &queue[i];
}

// Threaded loop
void* queue_fill_thread(void *arg) {
	int NUMMSG_NEW;
	int i;
	int b;
	
	while ( thread_control == TH_RUNNABLE ) {
		if ( !dig_suspend && pfql_status.do_scan ) {
			if ( dig_limit )
				dig_start = time(NULL);
			NUMMSG_NEW = pfqbe_fill_queue();
			b = 0;
			if ( NUMMSG_NEW != NUMMSG )
				b = 1;
			NUMMSG = NUMMSG_NEW;
			for ( i=0; i<NUMMSG_NEW; i++ ) {
				if ( queue_thread[i].changed ) {
					memcpy ( queue[i].id, queue_thread[i].id, sizeof(queue[i].id) );
					memcpy ( queue[i].path, queue_thread[i].path, sizeof(queue[i].path) );
					queue[i].hcached = 0;
					queue[i].scached = 0;
					queue[i].tagged  = 0;
					b = 1;
				}
			}
			if ( b )
				queue_last_changed = time(NULL);
			dig_lastqueue = pfql_status.cur_queue;
		}
		sleep ( pfql_conf.scan_delay );
	}
	pthread_mutex_unlock ( &queue_fill_mutex );
	thread_control = TH_STOPPED;
	pthread_exit(NULL);
}

// Launches the dig thread
int queue_fill_start() {
	if ( pthread_mutex_trylock(&queue_fill_mutex)!=0 )
		return PFQL_ERROR;
	thread_control = TH_RUNNABLE;
	pthread_create ( &queue_fill_thread_t, NULL, queue_fill_thread, NULL );
	return PFQL_OK;
}

// Stops the dig thread
int queue_fill_stop() {
	if ( thread_control != TH_UNINITIALIZED )
		thread_control = TH_STOPRQ;
	while ( thread_control != TH_STOPPED && thread_control != TH_UNINITIALIZED )
		usleep ( 200000 );
	return 0;
}

// Performs an action on the message
void msg_action_do ( const char* id, int act ) {

	switch ( act ) {
	case MSG_DELETE:
		pfqbe_message_delete ( id );
		break;
	case MSG_HOLD:
		pfqbe_message_hold ( id );
		break;
	case MSG_RELEASE:
		pfqbe_message_release ( id );
		break;
	case MSG_REQUEUE:
		pfqbe_message_requeue ( id );
		break;
	default:
		return;
	}
}

// Tags all messages
void pfql_tag_all() {
int i;
	for ( i=0; i<NUMMSG; i++ )
		queue[i].tagged = TRUE;
	NUMTAG = NUMMSG;
}

// Resets tag flag on all messages
void pfql_tag_none() {
int i;
	for ( i=0; i<NUMMSG; i++ )
		queue[i].tagged = FALSE;
	pfql_status.wrk_tagged = FALSE;
	NUMTAG = 0;
}

// Reset the cache flag of the messages
void msg_cachereset() {
int i;
	for ( i=0; i<NUMMSG; i++ )
		queue[i].hcached = 0;
}

// Wrapper
void pfql_msg_action ( const char *id, int act ) {
int i;

	if ( (pfql_status.wrk_tagged) || (pfql_status.auto_wrk_tagged && NUMTAG) ) {
		dig_suspend = 1;
		for ( i = 0; i<NUMMSG; i++ ) {
			if ( queue[i].tagged )
				msg_action_do ( queue[i].id, act );
		}
		pfql_tag_none();
		dig_suspend = 0;
	} else {
		i = pfql_msg_getpos(id);
		if ( i==-1 )
			return;
		msg_action_do ( queue[i].id, act );
	}
	return;
}

// Clears the queue
void queue_reset() {
	memset ( queue, 0, sizeof(struct msg_t)*pfql_conf.msg_max );
}

int pfql_num_queues() {
	return pfqbe_queue_count();
}

// Changes the current queue
void pfql_set_queue( int q ) {

	if ( q > pfqbe_queue_count() )
		return;
	
	pfql_status.cur_queue = q;
	NUMTAG = 0;
	pfql_status.wrk_tagged = FALSE;
	queue_reset();
	queue_last_changed = time(NULL);
	
	pfqbe_set_queue ( q );

	// Ensure that a scan is made before proceeding, loop 1/5 sec
	while ( dig_lastqueue != pfql_status.cur_queue ) { usleep ( 200000 ); };
	
}

// Search for a message; returns -1 if not found
int msg_match(int reset, int direction) {
int i, res;
static int pos;

	if ( reset )
		pos = -1;
	if ( direction==0 )
		pos++;
	else
		pos--;
	if ( pos<0 )
		return -1;

	res = 0;

	if ( direction==0 ) {
		for ( i=pos; i<NUMMSG; i++ ) {
			pfqbe_retr_headers ( queue[i].id );
			if ( ( (search_mode & SM_FROM) && regexec(regexp,queue[i].from,res,NULL,0)==0 ) ||
			     ( (search_mode & SM_TO)   && regexec(regexp,queue[i].to  ,res,NULL,0)==0 ) ||
			     ( (search_mode & SM_SUBJ) && regexec(regexp,queue[i].subj,res,NULL,0)==0 ) ) {
				pos = i;
				return i;
			}
		}
	} else {
		for ( i=pos; i>=0; i-- ) {
			pfqbe_retr_headers ( queue[i].id );
			if ( ( (search_mode & SM_FROM) && regexec(regexp,queue[i].from,res,NULL,0)==0 ) ||
			     ( (search_mode & SM_TO)   && regexec(regexp,queue[i].to  ,res,NULL,0)==0 ) ||
			     ( (search_mode & SM_SUBJ) && regexec(regexp,queue[i].subj,res,NULL,0)==0 ) ) {
				pos = i;
				return i;
			}
		}
	}
	return -1;
}

int pfql_msg_search(const char* regexps) {
int res;
	res = regcomp ( regexp, regexps, 0 );
	if ( !res ) 
		return msg_match(1,0);
	else
		return PFQL_INVREGEXP;
}

int pfql_msg_searchnext(const char* regexps) {
int res;
	res = regcomp ( regexp, regexps, 0 );
	if ( !res ) 
		return msg_match(0,0);
	else
		return PFQL_INVREGEXP;
}

int pfql_msg_searchprev(const char* regexps) {
int res;
	res = regcomp ( regexp, regexps, 0 );
	if ( !res ) 
		return msg_match(0,1);
	else
		return PFQL_INVREGEXP;
}

void pfql_msg_searchandtag(const char* regexps) {
int res;

	res = regcomp ( regexp, regexps, 0 );
	if ( !res ) {
		res = msg_match(1,0);
		while ( res != -1 ) {
			queue[res].tagged = 1;
			NUMTAG++;
			res = pfql_msg_searchnext(regexps);
		}
	}
}

// Toggle envelope usage for from/to
void pfql_toggle_envelope() {
	if ( !(pfqbe_get_caps() & BECAPS_MSG_ENVELOPE) )
		return;

	pfql_status.use_envelope = !pfql_status.use_envelope;
	msg_cachereset();
	pfqbe_use_envelope ( pfql_status.use_envelope );
}

int be_load ( const char* be ) {
	char buf[BUF_SIZE];
	
	if ( strlen(pfql_conf.backends_path) )
		sprintf ( buf, "%s/libpfq_%s.so.%s", pfql_conf.backends_path, be, PFQ_SONAME );
	else
		sprintf ( buf, "%s/libpfq_%s.so.%s", PFBEDIR, be, PFQ_SONAME );
	
	beptr = dlopen ( buf, RTLD_LAZY );
	if ( !beptr ) {
		syslog ( LOGLEVEL, "%s", dlerror() );
		
		// Try 'pfqueue' subdir
		if ( strlen(pfql_conf.backends_path) )
			sprintf ( buf, "%s/pfqueue/libpfq_%s.so", pfql_conf.backends_path, be );
		else
			sprintf ( buf, "pfqueue/libpfq_%s.so", be );
		beptr = dlopen ( buf, RTLD_LAZY );
	}
	if ( !beptr ) {
		syslog ( LOGLEVEL, "%s", dlerror() );
		return PFQL_BENOTFOUND;
	}
	
	pfqbe_apiversion = dlsym( beptr, "pfb_apiversion" );
	if ( !pfqbe_apiversion )
		return PFQL_BEMISSINGSYM;

	if ( pfqbe_apiversion()!=3 )
		return PFQL_BEWRONGAPI;

	pfqbe_init  = dlsym( beptr, "pfb_init" );
	if ( !pfqbe_init )
		return PFQL_BEMISSINGSYM;

	pfqbe_close  = dlsym( beptr, "pfb_close" );
	if ( !pfqbe_close )
		return PFQL_BEMISSINGSYM;

	pfqbe_id  = dlsym( beptr, "pfb_id" );
	if ( !pfqbe_id )
		return PFQL_BEMISSINGSYM;

	pfqbe_version  = dlsym( beptr, "pfb_version" );
	if ( !pfqbe_version )
		return PFQL_BEMISSINGSYM;

	pfqbe_setup = dlsym( beptr, "pfb_setup" );
	if ( !pfqbe_setup )
		return PFQL_BEMISSINGSYM;

	pfqbe_fill_queue = dlsym( beptr, "pfb_fill_queue" );
	if ( !pfqbe_fill_queue )
		return PFQL_BEMISSINGSYM;

	pfqbe_retr_headers = dlsym( beptr, "pfb_retr_headers" );
	if ( !pfqbe_retr_headers )
		return PFQL_BEMISSINGSYM;

	pfqbe_retr_status = dlsym( beptr, "pfb_retr_status" );
	if ( !pfqbe_retr_status )
		return PFQL_BEMISSINGSYM;

	pfqbe_retr_body = dlsym( beptr, "pfb_retr_body" );
	if ( !pfqbe_retr_body )
		return PFQL_BEMISSINGSYM;

	pfqbe_message_delete = dlsym( beptr, "pfb_message_delete" );
	if ( !pfqbe_message_delete )
		return PFQL_BEMISSINGSYM;

	pfqbe_message_hold = dlsym( beptr, "pfb_message_hold" );
	if ( !pfqbe_message_hold )
		return PFQL_BEMISSINGSYM;

	pfqbe_message_release = dlsym( beptr, "pfb_message_release" );
	if ( !pfqbe_message_release )
		return PFQL_BEMISSINGSYM;

	pfqbe_message_requeue = dlsym( beptr, "pfb_message_requeue" );
	if ( !pfqbe_message_requeue )
		return PFQL_BEMISSINGSYM;

	pfqbe_set_queue = dlsym( beptr, "pfb_set_queue" );
	if ( !pfqbe_set_queue )
		return PFQL_BEMISSINGSYM;

	pfqbe_use_envelope = dlsym( beptr, "pfb_use_envelope" );
	if ( !pfqbe_use_envelope )
		return PFQL_BEMISSINGSYM;

	pfqbe_get_caps = dlsym( beptr, "pfb_get_caps" );
	if ( !pfqbe_get_caps )
		return PFQL_BEMISSINGSYM;
	
	pfqbe_queue_name = dlsym( beptr, "pfb_queue_name" );
	if ( !pfqbe_queue_name )
		return PFQL_BEMISSINGSYM;
	
	pfqbe_queue_count = dlsym( beptr, "pfb_queue_count" );
	if ( !pfqbe_queue_count )
		return PFQL_BEMISSINGSYM;

	pfqbe_getconf = dlsym( beptr, "pfb_getconf" );
	if ( !pfqbe_queue_count )
		return PFQL_BEMISSINGSYM;

	return PFQL_OK;
}

int be_try ( const char *b ) {
	int res;

	res = be_load ( b );
	if ( res )
		return PFQL_ERROR;
	
	res = pfqbe_init ();
	if ( res ) 
		return PFQL_ERROR;

	pfqbe_getconf()->msg_max = pfql_conf.msg_max;
	pfqbe_getconf()->scan_limit = pfql_conf.scan_limit;
	res = pfqbe_setup(queue, queue_thread);
	if ( res )
		return PFQL_ERROR;

	pfqbe_close();
	
	return PFQL_OK;
}

int pfql_init() {
	/* Defaults */
	pfql_conf.max_char      = 200;
	pfql_conf.initial_queue = 0;
	sprintf ( pfql_conf.backends_path, "%c", 0 );
	sprintf ( pfql_conf.backend_name, "autodetect" );
	pfql_conf.msg_max       = 200;
	pfql_conf.scan_limit    = 0;
	pfql_conf.scan_delay    = 1;
	sprintf ( pfql_conf.remote_host, "%c", 0 );
	pfql_conf.remote_port   = 20000;

	pfql_status.wrk_tagged      = 0;
	pfql_status.auto_wrk_tagged = 0;
	pfql_status.ask_confirm     = 1;
	pfql_status.do_scan         = 1;
	pfql_status.use_envelope    = 0;
	pfql_status.use_colors      = 1;
	pfql_status.cur_queue       = 0;

	beptr = 0;
	queue = 0;
	queue_thread = 0;
	regexp = 0;

	NUMTAG = 0;

	return PFQL_OK;
}

void pfql_backend_setconfig(const char* c) {
	strcpy ( pfqbe_getconf()->config_path, c );
}

void pfql_backend_setcommand(const char* c) {
	strcpy ( pfqbe_getconf()->command_path, c );
}

int pfql_start() {
	int res;

	thread_control = TH_UNINITIALIZED;

	/* Alloc resources */
	regexp = (regex_t*) malloc (sizeof(regex_t));
	res = regcomp ( regexp, "*", 0 );
	queue = (struct msg_t*)malloc(sizeof(struct msg_t)*pfql_conf.msg_max);
	beptr = 0;

	if ( !queue ) {
		syslog ( LOGLEVEL, "pfqlib: sorry, cannot malloc for %d elements!", pfql_conf.msg_max );
		return PFQL_MALLOC;
	}
	queue_thread = (struct be_msg_t*)malloc(sizeof(struct be_msg_t)*pfql_conf.msg_max);
	if ( !queue_thread ) {
		free ( queue );
		syslog ( LOGLEVEL, "pfqlib: sorry, cannot malloc for %d elements!", pfql_conf.msg_max );
		return PFQL_MALLOC;
	}

	if ( !strcmp ( pfql_conf.backend_name, "autodetect" ) ) {
		// Try to autodetect backend
		strcpy ( pfql_conf.backend_name, "exim" );
		res = be_try ( pfql_conf.backend_name );
		if ( res!=PFQL_OK ) {
			strcpy ( pfql_conf.backend_name, "postfix2" );
			res = be_try ( pfql_conf.backend_name );
		}
		if ( res!=PFQL_OK ) {
			strcpy ( pfql_conf.backend_name, "postfix1" );
			res = be_try ( pfql_conf.backend_name );
		}
		if ( res!=PFQL_OK ) {
			syslog ( LOGLEVEL, "pfqlib: cannot autodetect suitable backend, try -b and/or -B option" );
			beptr = 0;
			return PFQL_NOBE;
		}
	}
	
	switch ( be_load ( pfql_conf.backend_name ) ) {
	case PFQL_BENOTFOUND:
		syslog ( LOGLEVEL, "pfqlib: backend not found!" );
		beptr = 0;
		return PFQL_BENOTFOUND;
	case PFQL_BEMISSINGSYM:
		syslog ( LOGLEVEL, "pfqlib: backend not valid (missing symbols)!" );
		beptr = 0;
		return PFQL_BEMISSINGSYM;
	}

	strcpy ( pfqbe_getconf()->host, pfql_conf.remote_host );
	pfqbe_getconf()->port = pfql_conf.remote_port;

	if ( pfqbe_init()!=PFBE_OK ) {
		syslog ( LOGLEVEL, "pfqlib: %s backend failed to init!", pfql_conf.backend_name );
		beptr = 0;
		return PFQL_BEINIT;
	}
	
	strcpy ( pfqbe_getconf()->config_path, pfql_conf.backend_config );
	strcpy ( pfqbe_getconf()->command_path,pfql_conf.backend_progs );
	pfqbe_getconf()->msg_max = pfql_conf.msg_max;
	pfqbe_getconf()->scan_limit = pfql_conf.scan_limit;
	
	if ( pfqbe_setup( queue, queue_thread )!=PFBE_OK ) {
		syslog ( LOGLEVEL, "pfqlib: %s backend failed to setup!", pfql_conf.backend_name );
		beptr = 0;
		return PFQL_BEINIT;
	}

	dig_lastqueue = -1;

	queue_fill_start();
	pfql_set_queue ( pfql_conf.initial_queue );

	return PFQL_OK;

}

void pfql_close() {

	pthread_mutex_destroy ( &queue_fill_mutex );
	queue_fill_stop();

	if (beptr) {
		pfqbe_close();
		dlclose (beptr);
	}
	
	if ( queue )
		free ( queue );
	if ( queue_thread )
		free ( queue_thread );
	if ( regexp )
		regfree ( regexp );

}
