#include "petsc.h"
#include "petscfix.h"
/* multequal.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscmat.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultequal_ PMATMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultequal_ pmatmultequal
#else
#define matmultequal_ pmatmultequal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultequal_ MATMULTEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultequal_ matmultequal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultaddequal_ PMATMULTADDEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultaddequal_ pmatmultaddequal
#else
#define matmultaddequal_ pmatmultaddequal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmultaddequal_ MATMULTADDEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultaddequal_ matmultaddequal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeequal_ PMATMULTTRANSPOSEEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeequal_ pmatmulttransposeequal
#else
#define matmulttransposeequal_ pmatmulttransposeequal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeequal_ MATMULTTRANSPOSEEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeequal_ matmulttransposeequal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeaddequal_ PMATMULTTRANSPOSEADDEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeaddequal_ pmatmulttransposeaddequal
#else
#define matmulttransposeaddequal_ pmatmulttransposeaddequal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define matmulttransposeaddequal_ MATMULTTRANSPOSEADDEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransposeaddequal_ matmulttransposeaddequal
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   matmultequal_(Mat A,Mat B,PetscInt *n,PetscTruth *flg, int *__ierr ){
*__ierr = MatMultEqual(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),*n,flg);
}
void PETSC_STDCALL   matmultaddequal_(Mat A,Mat B,PetscInt *n,PetscTruth *flg, int *__ierr ){
*__ierr = MatMultAddEqual(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),*n,flg);
}
void PETSC_STDCALL   matmulttransposeequal_(Mat A,Mat B,PetscInt *n,PetscTruth *flg, int *__ierr ){
*__ierr = MatMultTransposeEqual(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),*n,flg);
}
void PETSC_STDCALL   matmulttransposeaddequal_(Mat A,Mat B,PetscInt *n,PetscTruth *flg, int *__ierr ){
*__ierr = MatMultTransposeAddEqual(
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ),*n,flg);
}
#if defined(__cplusplus)
}
#endif
