#include "petsc.h"
#include "petscfix.h"
/* ilu.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "petscpc.h"
#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetusedroptolerance_ PPCILUSETUSEDROPTOLERANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetusedroptolerance_ ppcilusetusedroptolerance
#else
#define pcilusetusedroptolerance_ ppcilusetusedroptolerance_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetusedroptolerance_ PCILUSETUSEDROPTOLERANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetusedroptolerance_ pcilusetusedroptolerance
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetfill_ PPCILUSETFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetfill_ ppcilusetfill
#else
#define pcilusetfill_ ppcilusetfill_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetfill_ PCILUSETFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetfill_ pcilusetfill
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetreuseordering_ PPCILUSETREUSEORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetreuseordering_ ppcilusetreuseordering
#else
#define pcilusetreuseordering_ ppcilusetreuseordering_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetreuseordering_ PCILUSETREUSEORDERING
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetreuseordering_ pcilusetreuseordering
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pciludtsetreusefill_ PPCILUDTSETREUSEFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pciludtsetreusefill_ ppciludtsetreusefill
#else
#define pciludtsetreusefill_ ppciludtsetreusefill_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pciludtsetreusefill_ PCILUDTSETREUSEFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pciludtsetreusefill_ pciludtsetreusefill
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetlevels_ PPCILUSETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetlevels_ ppcilusetlevels
#else
#define pcilusetlevels_ ppcilusetlevels_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetlevels_ PCILUSETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetlevels_ pcilusetlevels
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetallowdiagonalfill_ PPCILUSETALLOWDIAGONALFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetallowdiagonalfill_ ppcilusetallowdiagonalfill
#else
#define pcilusetallowdiagonalfill_ ppcilusetallowdiagonalfill_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetallowdiagonalfill_ PCILUSETALLOWDIAGONALFILL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetallowdiagonalfill_ pcilusetallowdiagonalfill
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetuseinplace_ PPCILUSETUSEINPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetuseinplace_ ppcilusetuseinplace
#else
#define pcilusetuseinplace_ ppcilusetuseinplace_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetuseinplace_ PCILUSETUSEINPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetuseinplace_ pcilusetuseinplace
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilureorderfornonzerodiagonal_ PPCILUREORDERFORNONZERODIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilureorderfornonzerodiagonal_ ppcilureorderfornonzerodiagonal
#else
#define pcilureorderfornonzerodiagonal_ ppcilureorderfornonzerodiagonal_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilureorderfornonzerodiagonal_ PCILUREORDERFORNONZERODIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilureorderfornonzerodiagonal_ pcilureorderfornonzerodiagonal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetpivotinblocks_ PPCILUSETPIVOTINBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetpivotinblocks_ ppcilusetpivotinblocks
#else
#define pcilusetpivotinblocks_ ppcilusetpivotinblocks_
#endif
#else
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pcilusetpivotinblocks_ PCILUSETPIVOTINBLOCKS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pcilusetpivotinblocks_ pcilusetpivotinblocks
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL   pcilusetusedroptolerance_(PC pc,PetscReal *dt,PetscReal *dtcol,PetscInt *maxrowcount, int *__ierr ){
*__ierr = PCILUSetUseDropTolerance(
	(PC)PetscToPointer((pc) ),*dt,*dtcol,*maxrowcount);
}
void PETSC_STDCALL   pcilusetfill_(PC pc,PetscReal *fill, int *__ierr ){
*__ierr = PCILUSetFill(
	(PC)PetscToPointer((pc) ),*fill);
}
void PETSC_STDCALL   pcilusetreuseordering_(PC pc,PetscTruth *flag, int *__ierr ){
*__ierr = PCILUSetReuseOrdering(
	(PC)PetscToPointer((pc) ),*flag);
}
void PETSC_STDCALL   pciludtsetreusefill_(PC pc,PetscTruth *flag, int *__ierr ){
*__ierr = PCILUDTSetReuseFill(
	(PC)PetscToPointer((pc) ),*flag);
}
void PETSC_STDCALL   pcilusetlevels_(PC pc,PetscInt *levels, int *__ierr ){
*__ierr = PCILUSetLevels(
	(PC)PetscToPointer((pc) ),*levels);
}
void PETSC_STDCALL   pcilusetallowdiagonalfill_(PC pc, int *__ierr ){
*__ierr = PCILUSetAllowDiagonalFill(
	(PC)PetscToPointer((pc) ));
}
void PETSC_STDCALL   pcilusetuseinplace_(PC pc, int *__ierr ){
*__ierr = PCILUSetUseInPlace(
	(PC)PetscToPointer((pc) ));
}
void PETSC_STDCALL   pcilureorderfornonzerodiagonal_(PC pc,PetscReal *rtol, int *__ierr ){
*__ierr = PCILUReorderForNonzeroDiagonal(
	(PC)PetscToPointer((pc) ),*rtol);
}
void PETSC_STDCALL   pcilusetpivotinblocks_(PC pc,PetscTruth *pivot, int *__ierr ){
*__ierr = PCILUSetPivotInBlocks(
	(PC)PetscToPointer((pc) ),*pivot);
}
#if defined(__cplusplus)
}
#endif
