/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 MainWindow
 src/split.cc
 *******************************************/

#include "definings.hh"
#include "mainwindow.hh"

/*** On Button Split -> Sourcefile ***/
void class_window_main::on_button_split_sourcefile(){
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_OPEN, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring filename = filechooser.run();
	
	if(filename != ""){
		
		entry_split_sourcefile.set_text(filename);
		ustring_split_sourcefile = get_filename(filename);
		ustring_split_pages      = get_ustring_from_unsigned_int(get_pagenumber(filename));
	}
	
	// Push Statius
	push_status(Pdfchain::SPLIT);
	return;
}



/*** Save - Split ***/
void class_window_main::save_split(){
	
	// Check Errors -> No Source File
	if(entry_split_sourcefile.get_text() == ""){
		
		// Error Messages
		dialogs.error_cerr("calss_window_main::save_split()", Text::err_NO_SOURCE_FILE, Text::err_msg_EXIT_FUNCTION);
		dialogs.error_message(this, Text::str_SPLIT, Text::err_NO_SOURCE_FILE);
		
		return;
	}
	
	Glib::ustring command;
	
	// Create Filechooser
	class_filechoosers filechooser(this, Pdfchain::FILE_CHOOSER_FOLDER, Pdfchain::FILE_FILTER_PDF);
	Glib::ustring foldername = filechooser.run();
	
	if(foldername != ""){
		
		
		
		// Create Command
		command += Command::cmd_PDFTK + Command::cmd_SPACE;
		command += quote_out(entry_split_sourcefile.get_text());      // Quoting Special Chars of Source File
		command += Command::cmd_BURST + Command::cmd_OUTPUT + Command::cmd_SPACE;
		command += quote_out(foldername);                             // Quoting Special Chars of Output Folder
		command += Command::cmd_SLASH;
		command += quote_out(entry_split_prefix.get_text());
		
		if(radiobutton_split_manual.property_active() == true){
			command += "%0" + spinbutton_split_digits.get_text() + "d";
		}
		else if(radiobutton_split_auto.property_active() == true){
			command += "%0" + get_ustring_from_unsigned_int(static_cast<unsigned int>(ustring_split_pages.length())) + "d";
		}
		else{
			// Error Message
			dialogs.error_cerr("class_window_main::save_split()", Text::err_UNKNOWN_SELECTION_DIGITS, Text::str_DIGITS);
		}
		
		command += Command::cmd_SUFFIX;
		command += save_set_rights();
		
		// Execute Command
		execute(this, command);
	}
	
	return;
}
