/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Main
 src/definings.h
 *******************************************/

/*****************************
 UTF-8
 
 http://www.utf8-chartable.de/
 
 >> :  c2 bb
 << :  c2 ab
 *****************************/

#ifndef PDF_CHAIN_DEFININGS
#define PDF_CHAIN_DEFININGS

#include <iostream>
#include <gtkmm.h>
#include <giomm.h>
#include "../config.h"

/*** Prototypes of global Functions ***/
bool execute(Gtk::Window*, Glib::ustring);
Glib::ustring quote_out(Glib::ustring);

unsigned int  get_pagenumber(Glib::ustring);               // Used from Merge and Split
Glib::ustring get_ustring_from_unsigned_int(unsigned int); // Used form Merge and Attachments
Glib::ustring get_filename(Glib::ustring);                 // Used form Merge and Attachments
char          get_letter(unsigned int);                    // Used form Merge

/*** Definings (do not edit!) ***/
// ../config.h
#ifndef VERSION
#define VERSION "unknown version"
#endif

#ifndef PACKAGE_BUGREPORT
#define PACKAGE_BUGREPORT "http://pdfchain.sourceforge.net/"
#endif

// Signs
#define SPACE          " "             // used at window_main_merge()
#define COMMA          ","
#define BAR            "-"

// Strings
#define ONE_TO_END     "1-end"         // for Window Main -> Merge -> Pages
#define END            "end"           // Allowed String at Merge-Pages (used at class_window_main::save_merge())
#define ALLOWED_SIGNS  "0123456789 ,-" // Allowed Signs at Merge-Pages (used at class_window_main::save_merge())

#define STRING_AT_PDF1 "/Type/Page"    // for counting Pages from PDF
#define STRING_AT_PDF2 "/Type /Page"   // find this string at a PDF
#define STRING_AT_PDF3 "/Type/Pages"  
#define STRING_AT_PDF4 "/Type /Pages"  // used at class_window_main::get_pagenumber()

// Paths
#define PATH_ICON      "/usr/share/pixmaps/pdfchain.png"
//#define PATH_HOME      "~/"

// Constants
#define BUFFER_SIZE    512             // (Byte) Read-Buffer (used at class_window_main::get_pagenumber())
#define FILES_MAX       26             // Maximum Files at Merge-List (class_window_main_merge::at merge_count_sourcefiles())

/*** Namespace Pdfchain ***/
namespace Pdfchain{
	
	// Message Types        (from main.cc)
	/*
	 enum MessageType{
		 INFO,
		 QUESTION,
		 ERROR
	 };
	 */
	
	// Tabs (for Statusbar) (from window_main.hh)
	enum Selection{
		MERGE,
		SPLIT,
		STAMP,
		ATTACHMENTS,
		CLEAR
	};
	
	// File Filters         (from filechoosers.hh) 
	enum FileFilterType{
		FILE_FILTER_PDF,
		FILE_FILTER_FDF,
		FILE_FILTER_TXT,
		FILE_FILTER_DUMP,
		FILE_FILTER_ANY,
		FILE_FILTER_NONE
	};
	
	// File Chooser Dialogs (from filechooser.hh)
	enum FileChooserType{
		FILE_CHOOSER_OPEN,
		FILE_CHOOSER_OPEN_MULTIPLE,
		FILE_CHOOSER_SAVE,
		FILE_CHOOSER_FOLDER
	};
}



/*** Namespace Text ***/
namespace Text{
	
	// Characters
	const Glib::ustring str_QUOTE_BEGIN   = "\xC2\xBB"; // >>
	const Glib::ustring str_QUOTE_END     = "\xC2\xAB"; // <<
	
	//#define QUOTE_BEGIN    "\xC2\xBB"      // >>
	//#define QUOTE_END      "\xC2\xAB"      // <<
	
	// Title and About Dialog (do not edit!)
	const Glib::ustring str_PDF_CHAIN     = "PDF Chain";
	//const Glib::ustring str_VERSION       = "v. 0.121 - alpha";
	const Glib::ustring str_ALPHA         = " - alpha";
	const Glib::ustring str_VERSION       = VERSION + str_ALPHA;        // VERSION is from "../config.h"
	const Glib::ustring str_COMMENTS      = "GUI for PDFTK";
	
	const Glib::ustring str_AUTHOR1       = "Martin Singer <m_power3@users.sourceforge.net>";
	
	const Glib::ustring str_COPYRIGHT     = "Copyright: 2009 Martin Singer";
//	const Glib::ustring str_WEBSITE       = "http://sourceforge.net/projects/pdfchain";
	const Glib::ustring str_WEBSITE       = PACKAGE_BUGREPORT;
	const Glib::ustring str_WEBSITE_LABEL = "Visit the PDF Chain Projekt";
	const Glib::ustring str_LICENSE       =
		"PDF Chain\n"
		"Copyright: 2009 Martin Singer\n\n"
		
		"This program is free software; you can redistribute it and/or modify it under the terms of\n"
		"the GNU General Public License as published by the Free Software Foundation;\n"
		"either version 3 of the License, or (at your option) any later version.\n\n"
		
		"This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;\n"
		"without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n"
		"See the GNU General Public License for more details.\n\n"
		
		"You should have received a copy of the GNU General Public License along with this program;\n"
		"if not, see <http://www.gnu.org/licenses/>.";
		
		
		// Strings (editable)
		// Main Menu
		const Glib::ustring str_FILE                     = "File";
	const Glib::ustring str_TOOLS                    = "Tools";
	const Glib::ustring str_HELP                     = "Help";
	
	// Main Window
	const Glib::ustring str_MERGE                    = "Merge";
	const Glib::ustring str_SPLIT                    = "Split";
	const Glib::ustring str_BACKGROUND_STAMP         = "Background / Stamp";
	const Glib::ustring str_ATTACHMENTS              = "Attachment(s)";
	
	// Tools
	const Glib::ustring str_EXTRACT_ATTACHMENTS      = "Extract Attachments";
	const Glib::ustring str_UNCOMPRESS_COMPRESS      = "Uncompress / Compress";
	const Glib::ustring str_DUMP_DATA_FIELDS         = "Dump Data Fields";
	const Glib::ustring str_DUMP_DATA                = "Dump Data";
	const Glib::ustring str_UPDATE_INFO              = "Update Info";
	const Glib::ustring str_GENERATE_FDF             = "Generate FDF";
	const Glib::ustring str_FILL_FORM                = "Fill Form";
	const Glib::ustring str_FLATTEN                  = "Flatten";
	const Glib::ustring str_DROP_XFA                 = "Drop XFA";
	
	
	
	// Main Window -> Permissions
	const Glib::ustring str_PERMISSIONS              = "Permissions";
	const Glib::ustring str_RIGHTS                   = "Rights";
	const Glib::ustring str_OWNER_PASSWORD           = "Owner Password";
	const Glib::ustring str_USER_PASSWORD            = "User Password";
	const Glib::ustring str_ENCRYPTION               = "Encryption";
	
	// Main Window -> Permissions -> Rights
	const Glib::ustring str_PRINTING                 = "Printing";
	const Glib::ustring str_DEGRADED_PRINTING        = "Degraded Printing";
	const Glib::ustring str_MODIFY_CONTENTS          = "Modify Contents";
	const Glib::ustring str_ASSEMBLY                 = "Assembly";
	const Glib::ustring str_COPY_CONTENTS            = "Copy Contents";
	const Glib::ustring str_SCREENREADERS            = "Screenreaders";
	const Glib::ustring str_MODIFY_ANNOTATIONS       = "Modify Annotations";
	const Glib::ustring str_FILL_IN                  = "Fill In";
	
	// Main Window -> Permissions -> Rights -> Tooltips
	const Glib::ustring tip_PRINTING                 = "Top Quality Printing";
	const Glib::ustring tip_DEGRADED_PRINTING        = "Lower Quality Printing";
	const Glib::ustring tip_MODIFY_CONTENT           = "Also allows Assembly";
	const Glib::ustring tip_ASSEMBLY                 = "";
	const Glib::ustring tip_COPY_CONTENTS            = "Also allows Screenreaders";
	const Glib::ustring tip_SCREENREADERS            = "";
	const Glib::ustring tip_MODIFY_ANNOTATIONS       = "Also allows Fill In";
	const Glib::ustring tip_FILL_IN                  = "";
	
	// Main Window -> Permissions -> Encryption
	const Glib::ustring str_NONE                     = "None";
	const Glib::ustring str_40_BIT                   = "40 Bit";
	const Glib::ustring str_128_BIT                  = "128 Bit";
	
	// Main Window -> Statusbar
	const Glib::ustring str_PAGES                    = "Page(s)";
	const Glib::ustring str_PASSWORD_IS_SET          = "Password is set";
	
	
	
	// Main Window -> Merge
	
	const Glib::ustring str_ADD                      = "Add";
	const Glib::ustring str_EVEN_ODD                 = "Even / Odd";
	const Glib::ustring str_ROTATION                 = "Rotation";
	const Glib::ustring str_SOURCE_FILES             = "Source File(s)";
	
	const Glib::ustring str_UP                       = "Up";
	const Glib::ustring str_DOWN                     = "Down";
	//const Glib::ustring str_ADD                      = "Add";
	const Glib::ustring str_COPY                     = "Copy";
	const Glib::ustring str_REMOVE                   = "Remove";
	
	const Glib::ustring tip_UP                       = "Move Selected File Up";
	const Glib::ustring tip_DOWN                     = "Move Selected File Down";
	const Glib::ustring tip_COPY                     = "Copy Selected File";
	const Glib::ustring tip_ADD                      = "Add Some Files";
	const Glib::ustring tip_REMOVE                   = "Remove Selected File";
	
	// Main Window -> Merge -> Options
	const Glib::ustring str_MERGE_OPTIONS            = "Merge Options";
	const Glib::ustring str_0_DEG                    = "0°";
	const Glib::ustring str_90_DEG                   = "90°";
	const Glib::ustring str_180_DEG                  = "180°";
	const Glib::ustring str_270_DEG                  = "270°";
	const Glib::ustring str_ALL                      = "All";
	const Glib::ustring str_EVEN                     = "Even";
	const Glib::ustring str_ODD                      = "Odd";
	const Glib::ustring str_INPUT_PASSWORD           = "Input Password";
	
	// Main Window -> Merge -> Document ID
	const Glib::ustring str_FILE_ID                  = "File ID";
	const Glib::ustring str_CREATE_NEW_ID            = "Create New ID";
	const Glib::ustring str_ID_FROM_FIRST_PDF        = "ID From First PDF";
	const Glib::ustring str_ID_FROM_FINAL_PDF        = "ID From Final PDF";
	
	// Main Window -> Split
	const Glib::ustring str_SOURCE_FILE              = "Source File (PDF)";
	const Glib::ustring str_PREFIX                   = "Prefix";
	const Glib::ustring str_SHEET                    = "Sheet";
	const Glib::ustring str_DIGITS                   = "Counter Digits";
	const Glib::ustring str_AUTO                     = "Auto";
	const Glib::ustring str_MANUAL                   = "Manual";
	
	// Main Window -> Background / Stamp
	const Glib::ustring str_BACKGROUND_STAMP_FILE    = "Background / Stamp File (PDF)";
	const Glib::ustring str_SELECT                   = "Select";              // first using of Select
	const Glib::ustring str_BACKGROUND               = "Background";
	const Glib::ustring str_STAMP                    = "Stamp";
	
	// Main Window -> Attachments
	const Glib::ustring str_ADD_TO_FILE              = "Add to File";
	const Glib::ustring str_ADD_TO_PAGE              = "Add to Page";
	
	
	
	// Tools
	const Glib::ustring str_UNCOMPRESS               = "Uncompress";
	const Glib::ustring str_COMPRESS                 = "Compress";
	const Glib::ustring str_DUMP_DATA_FILE           = "Dump Data File";
	//const Glib::ustring str_FDF_FILE                 = "FDF File";          // declared at Filechooser Dialogs
	const Glib::ustring str_DO_NOT_DROP_XFA          = "Don't Drop XFA";
	const Glib::ustring str_DO_NOT_FLATTEN           = "Don't Flatten";
	
	
	
	// Filechooser Dialogs (Open, Save)
	const Glib::ustring str_ADD_EXTENSION            = "Add Extension";
	
	const Glib::ustring str_PLEASE_CHOOSE_A          = "Please choose a";             
	const Glib::ustring str_PLEASE_CHOOSE_SOME       = "Please choose some";
	
	const Glib::ustring str_OPEN                     = "Open";
	const Glib::ustring str_SAVE                     = "Save";
	
	const Glib::ustring str_ANY                      = "Any";
	const Glib::ustring str_PDF                      = "PDF";
	const Glib::ustring str_FDF                      = "FDF";
	const Glib::ustring str_TXT                      = "TXT";
	const Glib::ustring str_DUMP                     = "Dump";
	
	//const Glib::ustring str_FILE                     = "File";              // declared at Main Menu
	const Glib::ustring str_FILES                    = "Files";
	const Glib::ustring str_FOLDER                   = "Folder";
	
	const Glib::ustring str_ANY_FILE                 = str_ANY  + SPACE + str_FILE;
	const Glib::ustring str_PDF_FILE                 = str_PDF  + SPACE + str_FILE;
	const Glib::ustring str_FDF_FILE                 = str_FDF  + SPACE + str_FILE;
	const Glib::ustring str_TXT_FILE                 = str_TXT  + SPACE + str_FILE;
	const Glib::ustring str_DUMP_FILE                = str_DUMP + SPACE + str_FILE;
	
	const Glib::ustring str_ANY_FILES                = str_ANY  + SPACE + str_FILES;
	const Glib::ustring str_PDF_FILES                = str_PDF  + SPACE + str_FILES;
	const Glib::ustring str_FDF_FILES                = str_FDF  + SPACE + str_FILES;
	const Glib::ustring str_TXT_FILES                = str_TXT  + SPACE + str_FILES;
	const Glib::ustring str_DUMP_FILES               = str_DUMP + SPACE + str_FILES;
	
	
	
	// Dialogs - Window
	const Glib::ustring str_NEW                      = "New";
	const Glib::ustring str_QUIT                     = "Quit";
	
	const Glib::ustring str_INFO                     = "Info";
	const Glib::ustring str_QUESTION                 = "Question";
	const Glib::ustring str_ERROR                    = "Error";
	
	const Glib::ustring str_PDFTK                    = "PDFTK";
	const Glib::ustring str_ASCII                    = "ASCII";
	
	// Dialogs - Messages
	const Glib::ustring msg_NEW                      = "Do you really want to clear all inputs?";
	const Glib::ustring msg_QUIT                     = "Do you really want to quit PDF Chain?";
	const Glib::ustring msg_PDFTK                    = "PDFTK returns success\n(but that's not guaranteed)";
	const Glib::ustring msg_FILE_OVERWRITE           = "File alredy exists!\nDo you want to overwrite?";
	const Glib::ustring msg_MAX_26_FILES             = "26 Files Maximum!";
	
	
	
	// ERRORs (used at cerr and dialogs)
	const Glib::ustring err_PDFTK                                 = "PDFTK retruns an error";
	const Glib::ustring err_ASCII                                 = "Command contains Non-ASCII signs\nPDFTK works with ASCII signs only!";
	
	const Glib::ustring err_PATH_DOES_NOT_EXIST                   = "Path does not exist";
	const Glib::ustring err_FILE_DOES_NOT_EXIST                   = "File does not exist";
	
	const Glib::ustring err_FILE_HAS_NO_PAGES                     = "File has no pages";
	const Glib::ustring err_TO_MUCH_FILES                         = "To much files (max. 26)";
	const Glib::ustring err_NO_SOURCE_FILE                        = "No Source File (PDF)";
	const Glib::ustring err_NO_BACKGROUND_STAMP_FILE              = "No Background / Stamp File (PDF)";
	const Glib::ustring err_NO_ATTACHMENT_FILE                    = "No Attachment(s)";
	const Glib::ustring err_NO_PAGE_NUMBER                        = "No page number at Add to Page";
	const Glib::ustring err_INCORRECT_PAGE_NUMBER                 = "Incorrect page number at Add to Page";
	const Glib::ustring err_UNKNOWN_ARGUMENT_PAGES                = "Unknown argument at Pages";
	
	const Glib::ustring err_NO_DUMP_DATA_FILE                     = "No Dump Data File";
	const Glib::ustring err_NO_FDF_FILE                           = "No FDF File";
	
	// Errors (only used at cerr)
	const Glib::ustring err_UNKNOWN_SELECTION_AT                  = "Unknown selection at ";
	const Glib::ustring err_USING                                 = ", using " ;
	
	const Glib::ustring err_UNKNOWN_FILE_CHOOSER_TYPE             = "Unknown FILE_CHOOSER_TYPE, using";
	const Glib::ustring err_UNKNOWN_FILE_FILTER_TYPE              = "Unknown FILE_FILTER_TYPE, using";
	//const Glib::ustring err_UNKNOWN_MESSAGE_TYPE                  = "Unknown MESSAGE_TYPE, using";
	
	const Glib::ustring err_UNKNOWN_BUTTON                        = "Unknown button clicked, using";
	const Glib::ustring err_UNDEFINED_CHARACTER_REQUESTED         = "Undefined character requested, returning";
	
	const Glib::ustring err_UNKNOWN_SELECTION_TAB                 = "Unknown Tab selected, using";
	const Glib::ustring err_UNKNOWN_SELECTION_ENCRYPTION          = err_UNKNOWN_SELECTION_AT + str_ENCRYPTION          + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_EVEN_ODD            = err_UNKNOWN_SELECTION_AT + str_EVEN_ODD            + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_ROTATION            = err_UNKNOWN_SELECTION_AT + str_ROTATION            + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_FILE_ID             = err_UNKNOWN_SELECTION_AT + str_FILE_ID             + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_DIGITS              = err_UNKNOWN_SELECTION_AT + str_DIGITS              + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_PAGE                = err_UNKNOWN_SELECTION_AT + str_ADD_TO_FILE         + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_BACKGROUND_STAMP    = err_UNKNOWN_SELECTION_AT + str_BACKGROUND_STAMP    + err_USING;
	
	const Glib::ustring err_UNKNOWN_SELECTION_UNCOMPRESS_COMPRESS = err_UNKNOWN_SELECTION_AT + str_UNCOMPRESS_COMPRESS + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_FLATTEN             = err_UNKNOWN_SELECTION_AT + str_FLATTEN             + err_USING;
	const Glib::ustring err_UNKNOWN_SELECTION_DROP_XFA            = err_UNKNOWN_SELECTION_AT + str_DROP_XFA            + err_USING;
	
	// Error Messages (only used at cerr)
	const Glib::ustring err_msg_ERROR_AT_FUNCTION                 = "Error at function ";
	const Glib::ustring err_msg_NO_OUTPUT_CREATED                 = "no output crated";
	const Glib::ustring err_msg_EXIT_FUNCTION                     = "exit function";
	const Glib::ustring err_msg_NONE                              = "NONE";
	const Glib::ustring err_msg_CANCEL                            = "CANCEL";
	const Glib::ustring err_msg_NO                                = "NO";
}



/*** Namespace Extension (do not edit) ***/
namespace Extension{
	const Glib::ustring ext_PDF       = ".pdf";
	const Glib::ustring ext_FDF       = ".fdf";
	const Glib::ustring ext_TXT       = ".txt";
	const Glib::ustring ext_DUMP      = ".dump";
	const Glib::ustring ext_ANY       = "";
	const Glib::ustring ext_NONE      = "";
	
	const Glib::ustring mimetype_PDF  = "application/pdf";
	const Glib::ustring mimetype_FDF  = "text/plain";
	const Glib::ustring mimetype_TXT  = "text/plain";
	const Glib::ustring mimetype_DUMP = "text/plain";
	const Glib::ustring mimetype_ANY  = "";
	const Glib::ustring mimetype_NONE = "";
	
	const Glib::ustring pattern_PDF   = "*.pdf";
	const Glib::ustring pattern_FDF   = "*.fdf";
	const Glib::ustring pattern_TXT   = "*.txt";
	const Glib::ustring pattern_DUMP  = "*.dump";
	const Glib::ustring pattern_ANY   = "*";
	const Glib::ustring pattern_NONE  = "*";
}



/*** Namespace Commands (Parts for building PDFTK-Command) (do not edit)***/
namespace Command{
	
	// Characters
	const Glib::ustring cmd_NONE               = "";
	const Glib::ustring cmd_SPACE              = " ";
	const Glib::ustring cmd_EQUAL              = "=";
	const Glib::ustring cmd_SLASH              = "/";
	
	// Commands
	const Glib::ustring cmd_PDFTK              = "pdftk";
	const Glib::ustring cmd_CAT                = " cat";
	const Glib::ustring cmd_INPUT_PW           = " input_pw";
	const Glib::ustring cmd_OUTPUT             = " output";
	
	// Merge
	const Glib::ustring cmd_EVEN               = "even";
	const Glib::ustring cmd_ODD                = "odd";
	
	const Glib::ustring cmd_NORTH              = "N";
	const Glib::ustring cmd_SOUTH              = "S";
	const Glib::ustring cmd_EAST               = "E";
	const Glib::ustring cmd_WEST               = "W";
	
	const Glib::ustring cmd_KEEP_FIRST_ID      = " keep_first_id";
	const Glib::ustring cmd_KEEP_FINAL_ID      = " keep_final_id";
	
	// Split
	const Glib::ustring cmd_BURST              = " burst";
	//const Glib::ustring cmd_SUFFIX             = "%04d.pdf";                     //Editable
	const Glib::ustring cmd_SUFFIX             = ".pdf";
	
	// Background / Stamp
	const Glib::ustring cmd_BACKGROUND         = " background";
	const Glib::ustring cmd_STAMP              = " stamp";
	
	// Attachments
	const Glib::ustring cmd_ATTACH_FILES       = " attach_files";
	const Glib::ustring cmd_TO_PAGE            = " to_page";
	
	// Permissions
	// Rights
	const Glib::ustring cmd_ALLOW              = " allow";
	const Glib::ustring cmd_ALL_FEATURES       = " AllFeatures";
	
	const Glib::ustring cmd_PRINTING           = " Printing";
	const Glib::ustring cmd_DEGRADED_PRINTING  = " DegradedPrinting";
	const Glib::ustring cmd_MODIFY_CONTENTS    = " ModifyContents";
	const Glib::ustring cmd_ASSEMBLY           = " Assembly";
	const Glib::ustring cmd_COPY_CONTENTS      = " CopyContents";
	const Glib::ustring cmd_SCREEN_READERS     = " ScreenReaders";
	const Glib::ustring cmd_MODIFY_ANNOTATIONS = " ModifyAnnotations";
	const Glib::ustring cmd_FILL_IN            = " FillIn";
	
	// Passwords
	const Glib::ustring cmd_OWNER_PW           = " owner_pw";
	const Glib::ustring cmd_USER_PW            = " user_pw";
	
	// Encryption
	const Glib::ustring cmd_ENCRYPT_40BIT      = " encrypt_40bit";
	const Glib::ustring cmd_ENCRYPT_128BIT     = " encrypt_128bit";
	
	
	// Tools
	const Glib::ustring cmd_UNPACK_FILES       = " unpack_files";      // Extract Attachments
	const Glib::ustring cmd_COMPRESS           = " compress";          // Compress / Uncompress
	const Glib::ustring cmd_UNCOMPRESS         = " uncompress"; 
	const Glib::ustring cmd_DUMP_DATA_FIELDS   = " dump_data_fields";  // Dump Data Fields
	const Glib::ustring cmd_DUMP_DATA          = " dump_data";         // Dump Data
	const Glib::ustring cmd_UPDATE_INFO        = " update_info";       // Update Info
	const Glib::ustring cmd_GENERATE_FDF       = " generate_fdf";      // Generate FDF
	const Glib::ustring cmd_FILL_FORM          = " fill_form";         // Fill Form
	const Glib::ustring cmd_FLATTEN            = " flatten";           // Flatten  & Fill Form
	const Glib::ustring cmd_DROP_XFA           = " drop_xfa";          // Drop XFA & Fill Form
}

#endif
