/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

/* ppo computation functions for first/last AAs in sequence */

#include "Pdb_dhl1.h"
#include "Pdb_dhl2.h"

/* In each function:

   The x,y,z positions of each of the 4 atoms defining a
   dihedral angle are extracted from the Pdb_line array
   and used to compute the angle.
*/

/* This function accounts for the situation in which no hydrogens have
   been specified, and thus cannot be used in computing the phi angle.
*/
void NnoH(Pdb_line* memfile,
	  map<string, int>& m0, map<string, int>& m1, map<string, int>& m2,
	  double* ppo,
	  double* x, double* y, double* z){
  /* phi calculation */
  ppo[0] = 0.0;

  /* psi calculation */
  x[0] = memfile[m0[" N   "]].get_x(); y[0] = memfile[m0[" N   "]].get_y();
  z[0] = memfile[m0[" N   "]].get_z();

  x[1] = memfile[m0[" CA  "]].get_x(); y[1] = memfile[m0[" CA  "]].get_y();
  z[1] = memfile[m0[" CA  "]].get_z();

  x[2] = memfile[m0[" C   "]].get_x(); y[2] = memfile[m0[" C   "]].get_y();
  z[2] = memfile[m0[" C   "]].get_z();

  x[3] = memfile[m1[" N   "]].get_x(); y[3] = memfile[m1[" N   "]].get_y();
  z[3] = memfile[m1[" N   "]].get_z();

  ppo[1] = dihedral_angle(x,y,z);

  /* omega calculation */
  x[0] = memfile[m0[" CA  "]].get_x(); y[0] = memfile[m0[" CA  "]].get_y();
  z[0] = memfile[m0[" CA  "]].get_z();

  x[1] = memfile[m0[" C   "]].get_x(); y[1] = memfile[m0[" C   "]].get_y();
  z[1] = memfile[m0[" C   "]].get_z();

  x[2] = memfile[m1[" N   "]].get_x(); y[2] = memfile[m1[" N   "]].get_y();
  z[2] = memfile[m1[" N   "]].get_z();

  x[3] = memfile[m1[" CA  "]].get_x(); y[3] = memfile[m1[" CA  "]].get_y();
  z[3] = memfile[m1[" CA  "]].get_z();

  ppo[2] = dihedral_angle(x,y,z);

}

void NH3(Pdb_line* memfile,
	 map<string, int>& m0, map<string, int>& m1, map<string, int>& m2,
	 double* ppo,
	 double* x, double* y, double* z){

  /* One of the H's would be replaced by C in a peptide
     bond, and this C would be used in the phi angle
     computation, so it will "replace" the C here.
  */
  /* phi calculation */
  /* We can use 1H, 2H, or 3H here, I think */
  x[0] = memfile[m0[" 1H  "]].get_x(); y[0] = memfile[m0[" 1H  "]].get_y();
  z[0] = memfile[m0[" 1H  "]].get_z();

  x[1] = memfile[m0[" N   "]].get_x(); y[1] = memfile[m0[" N   "]].get_y();
  z[1] = memfile[m0[" N   "]].get_z();

  x[2] = memfile[m0[" CA  "]].get_x(); y[2] = memfile[m0[" CA  "]].get_y();
  z[2] = memfile[m0[" CA  "]].get_z();

  x[3] = memfile[m0[" C   "]].get_x(); y[3] = memfile[m0[" C   "]].get_y();
  z[3] = memfile[m0[" C   "]].get_z();

  ppo[0] = dihedral_angle(x,y,z);

  /* psi calculation */
  x[0] = memfile[m0[" N   "]].get_x(); y[0] = memfile[m0[" N   "]].get_y();
  z[0] = memfile[m0[" N   "]].get_z();

  x[1] = memfile[m0[" CA  "]].get_x(); y[1] = memfile[m0[" CA  "]].get_y();
  z[1] = memfile[m0[" CA  "]].get_z();

  x[2] = memfile[m0[" C   "]].get_x(); y[2] = memfile[m0[" C   "]].get_y();
  z[2] = memfile[m0[" C   "]].get_z();

  x[3] = memfile[m1[" N   "]].get_x(); y[3] = memfile[m1[" N   "]].get_y();
  z[3] = memfile[m1[" N   "]].get_z();

  ppo[1] = dihedral_angle(x,y,z);

  /* omega calculation */
  x[0] = memfile[m0[" CA  "]].get_x(); y[0] = memfile[m0[" CA  "]].get_y();
  z[0] = memfile[m0[" CA  "]].get_z();

  x[1] = memfile[m0[" C   "]].get_x(); y[1] = memfile[m0[" C   "]].get_y();
  z[1] = memfile[m0[" C   "]].get_z();

  x[2] = memfile[m1[" N   "]].get_x(); y[2] = memfile[m1[" N   "]].get_y();
  z[2] = memfile[m1[" N   "]].get_z();

  x[3] = memfile[m1[" CA  "]].get_x(); y[3] = memfile[m1[" CA  "]].get_y();
  z[3] = memfile[m1[" CA  "]].get_z();

  ppo[2] = dihedral_angle(x,y,z);


}

void COOH(Pdb_line* memfile,
	 map<string, int>& m0, map<string, int>& m1, map<string, int>& m2,
	 double* ppo,
	 double* x, double* y, double* z){

  /* Last AA is m2 */
  /* In COOH, the O bonded to the H is called "O", and the other one
     is OXT if the AA is a terminus, I think.
  */

  /* phi calculation */
  x[0] = memfile[m1[" CA  "]].get_x(); y[0] = memfile[m1[" CA  "]].get_y();
  z[0] = memfile[m1[" CA  "]].get_z();

  x[1] = memfile[m2[" N   "]].get_x(); y[1] = memfile[m2[" N   "]].get_y();
  z[1] = memfile[m2[" N   "]].get_z();

  x[2] = memfile[m2[" CA  "]].get_x(); y[2] = memfile[m2[" CA  "]].get_y();
  z[2] = memfile[m2[" CA  "]].get_z();

  x[3] = memfile[m2[" C   "]].get_x(); y[3] = memfile[m2[" C   "]].get_y();
  z[3] = memfile[m2[" C   "]].get_z();

  ppo[0] = dihedral_angle(x,y,z);

  /* psi calculation */
  /* Since OXT is used in bonding to another AA, use it in the computation.
   */
  x[0] = memfile[m2[" N   "]].get_x(); y[0] = memfile[m2[" N   "]].get_y();
  z[0] = memfile[m2[" N   "]].get_z();

  x[1] = memfile[m2[" CA  "]].get_x(); y[1] = memfile[m2[" CA  "]].get_y();
  z[1] = memfile[m2[" CA  "]].get_z();

  x[2] = memfile[m2[" C   "]].get_x(); y[2] = memfile[m2[" C   "]].get_y();
  z[2] = memfile[m2[" C   "]].get_z();

  x[3] = memfile[m2[" OXT "]].get_x(); y[3] = memfile[m2[" OXT "]].get_y();
  z[3] = memfile[m2[" OXT "]].get_z();

  ppo[1] = dihedral_angle(x,y,z);

  /* omega calculation */
 
  ppo[2] = 0.0;

}
