/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

#include "pdb2dhl.h"

int main(int argc, char* argv[]){

  /* Read PDB file into memory and read user commands.
   
     <infile> is pdb file's full name, <dir> is 'f' or 'b',
     specifying a forward or backward read of the PDB file.
     PDB file must always be read in the N to C direction.
     <outfile> will be prefix of output file's name. <Nterm>
     and <Cterm> are the N and C terminus end groups, respectively.
  */
  char* infile = new char[20];
  char dir;
  char* outfile = new char[20];
  char* Nterm = new char[10];
  char* Cterm = new char[10];
  cin >> infile; cin >> dir; cin >> outfile;
  cin >> Nterm; cin >> Cterm;

  Pdb_line* memfile = new Pdb_line[NUM_PDB_LINES];
  read_file(infile, memfile);

  /* Produce <outfile>.inp, which contains the ECEPPAK ($GEOM field or)
     dihedral angle representation of the PDB file.
  */
  pdb_to_dhl(memfile, dir, outfile, Nterm, Cterm);

  /* Produce <outfile>.seq, which contains the (ECEPPAK $SEQ field or)
     amino acid sequence of the polypeptide (correct only if the PDB file
     lists the AAs in connected order).
  */
  prt_seq(memfile, dir, outfile, Nterm, Cterm);

  delete[] memfile; delete infile; delete outfile;
  delete Nterm; delete Cterm;

  

}
