/*
  pdb2dhl, pdb2epk:  Convert PDB files to dihedral angle/ECEPPAK input file format
  Copyright (C) 2002  Farokh Jamalyaria

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  Author's contact information:
  Farokh Jamalyaria, farokhj@yahoo.com
  9 Commons Lobby G222
  College Station, TX 77840
*/

/********************************************************************/
/*Code in Format.cpp and Format.h adapted from:			    */
/*								    */
/*Stroustrup, Bjarne. The C++ Programming Language: Special Edition.*/
/*    Addison-Wesley, 1997.					    */
/********************************************************************/

#ifndef FORMAT_H
#define FORMAT_H

#include <iostream>
#include <fstream>
#include <iomanip>

class Bound_format;

class Format {

  friend void write_file(ofstream&, const Bound_format&);
  int prc; // precision
  int wdt; // width, 0 means as wide as necessary
  int fmt; // general, scientific, or fixed

public:
  explicit Format(int p=6) : prc(p) // default precision is 6
  {
    fmt=ios::fixed; // general format
    wdt=0; // as wide as necessary
  }

  Bound_format operator()(double d) const; // make a Bound_format
					   // for *this and d
  Format& scientific();
  Format& fixed();
  Format& general();

  Format& uppercase();
  Format& lowercase();
  Format& precision(int p);

  Format& width(int w); // applies to all types
  Format& fill(char);

  Format& plus(bool b = true); 			// explicit plus
  Format& trailing_zeros(bool b = true); 	// print trailing zeros 
};

struct Bound_format{
  const Format& f;
  double val;

  Bound_format(const Format& ff, double v) : f(ff), val(v) {}
};
#endif
