PCSX2 is an open source Playstation 2 emulator. Its purpose is to mimic the the PS2 hardware, using a combination of MIPS CPU [Interpreters](http://en.wikipedia.org/wiki/Interpreter_\(computing\)), [Recompilers](http://en.wikipedia.org/wiki/Dynamic_recompilation) and a [Virtual Machine](http://en.wikipedia.org/wiki/Virtual_machine) which manages hardware states and PS2 system memory.

# Project Details

The PCSX2 project has been running for more than ten years. Once able to run only a few public domain demos, recent versions enable many games to work at full speed, including popular titles such as *Final Fantasy X* or *Devil May Cry 3*. Visit the *[PCSX2 homepage](http://pcsx2.net)* to check the latest compatibility status of games (with more than 2000 titles tested), or ask your doubts in the *[Official forums](http://forums.pcsx2.net/)*.

The latest officially released version is *1.2.1* (SVN r5875).
Installers and binaries for both Windows and Linux are available from **[our homepage](http://pcsx2.net/)**.

| ![KOF 2002](https://dl.dropboxusercontent.com/u/743491/PCSX2/KoF2002.jpg "KOF 2002") | ![Final Fantasy XII](https://dl.dropboxusercontent.com/u/743491/PCSX2/FinalFantasyXII.jpg "Final Fantasy XII") | ![Odin Sphere](https://dl.dropboxusercontent.com/u/743491/PCSX2/OdinSphere.jpg "Odin Sphere")
|:----:|:----:|:----:|

# System Requirements

## Minimum
* Windows/Linux OS
* CPU: Any that supports SSE2 (Pentium 4 and up, Athlon64 and up)
* GPU: Any that supports Pixel Shader model 2.0, except Nvidia FX series (broken SM2.0, too slow anyway)
* 512MB RAM (note Vista needs at least 2GB to run reliably)

## Recommended
* Windows Vista / Windows 7 (32bit or 64bit) with the [latest DirectX](http://www.microsoft.com/en-us/download/details.aspx?id=35)
* CPU: Intel Core 2 Duo @ 3.2ghz or better
* GPU: 8800gt or better (for Direct3D10 support)
* RAM: 1GB on Linux/Windows XP, 2GB or more on Vista

**Note**: Because of copyright issues, and the complexity of trying to work around it, you need a BIOS dump extracted from a legitimately owned Playstation 2 console to use the emulator.

**Note:** PCSX2 mainly takes advantage of 2 CPU cores. As of r4865 PCSX2 can now take advantage of a 3rd core using the MTVU speedhack. This can be a significant speedup on CPUs with 3+ cores, however on GS limited games (or on dual core CPUs) it may be a slowdown.

| ![Pro Evo 2009](https://dl.dropboxusercontent.com/u/743491/PCSX2/ProEvo2009.jpg "Pro Evo 2009") | ![Megaman X8](https://dl.dropboxusercontent.com/u/743491/PCSX2/MegamanX8.jpg "Megaman X8") | ![TOTA](https://dl.dropboxusercontent.com/u/743491/PCSX2/TOTA.jpg "TOTA")
|:----:|:----:|:----:|
