//SCAD

module line_segment_r(length, width, thickness, x, y, a, bd, c1, c2) {
	translate([x,y,0]) rotate ([0,0,a]) union() {
		if (bd) {cube ([length, width,thickness],true);}
		if (c2) {translate([length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
		if (c1) { translate([-length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
	}
}

module line_segment(length, width, thickness, x, y, a) {
	translate([x,y,0]) rotate ([0,0,a]) {
		cube ([length, width,thickness],true);
	}
}

// START_OF_LAYER: topsilk
module layer_topsilk_body (offset) {
translate ([0, 0, offset]) union () {
	line_segment_r(0.762000,0.177800,0.037500,5.715000,-4.445000,90.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,5.803900,-3.937000,-124.992020,1,1,1);
	line_segment_r(0.279400,0.177800,0.037500,6.032500,-3.810000,180.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,6.261100,-3.937000,124.992020,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,6.350000,-4.445000,90.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,6.032500,-4.318000,180.000000,1,1,1);
	line_segment_r(0.287368,0.177800,0.037500,6.756401,-3.911600,-135.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,6.858001,-4.318000,90.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,6.845301,-4.826000,180.000000,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,4.445000,-6.985000,180.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,3.937000,-6.896100,-34.992020,1,1,1);
	line_segment_r(0.279400,0.177800,0.037500,3.810000,-6.667500,90.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,3.937000,-6.438900,-145.007980,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,4.445000,-6.350000,180.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,4.318000,-6.667500,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,3.873500,-5.981699,-45.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,3.810000,-5.727699,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,3.873500,-5.473699,-135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,4.064000,-5.410199,180.000000,1,1,1);
	line_segment_r(0.898026,0.177800,0.037500,4.508500,-5.727699,-45.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,4.826000,-5.727699,90.000000,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,6.985000,-8.255000,90.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,6.896100,-8.763000,55.007980,1,1,1);
	line_segment_r(0.279400,0.177800,0.037500,6.667500,-8.890000,180.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,6.438900,-8.763000,-55.007980,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,6.350000,-8.255000,90.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,6.667500,-8.382000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,5.981699,-8.826500,45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,5.791199,-8.890000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,5.600699,-8.826500,-45.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,5.600699,-7.937500,45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,5.791199,-7.874000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,5.981699,-7.937500,-45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,5.791199,-8.432800,180.000000,1,1,1);
	line_segment_r(0.203200,0.177800,0.037500,5.537199,-8.661400,90.000000,1,1,1);
	line_segment_r(0.304800,0.177800,0.037500,5.537199,-8.153400,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,5.600699,-8.369300,135.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,5.600699,-8.496300,-135.000000,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,8.255000,-5.715000,180.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,8.763000,-5.803900,145.007980,1,1,1);
	line_segment_r(0.279400,0.177800,0.037500,8.890000,-6.032500,90.000000,1,1,1);
	line_segment_r(0.310046,0.177800,0.037500,8.763000,-6.261100,34.992020,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,8.255000,-6.350000,180.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,8.382000,-6.032500,90.000000,1,1,1);
	line_segment_r(0.813197,0.177800,0.037500,8.572500,-6.908801,141.340195,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,8.255000,-6.972301,90.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,8.382000,-7.162801,180.000000,1,1,1);
}
}


// END_OF_LAYER layer_topsilk

// START_OF_LAYER: bottomsilk
module layer_bottomsilk_body (offset) {
translate ([0, 0, offset]) union () {
}
}


// END_OF_LAYER layer_bottomsilk

module board_outline () {
	polygon([[0,0],[0,-12.700000],[12.700000,-12.700000],[12.700000,0]],
[[0,1,2,3]]);
}

module all_holes() {
	plating=0.017500;
	union () {
		for (i = layer_pdrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0]+2*plating, h=1.770000, center=true, $fn=30);
		}
		for (i = layer_udrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0], h=1.770000, center=true, $fn=30);
		}
	}
}

module board_body() {
	translate ([0, 0, -0.800000]) linear_extrude(height=1.600000) board_outline();}

/***************************************************/
/*                                                 */
/* Components                                      */
/*                                                 */
/***************************************************/
module all_components() {
}

/***************************************************/
/*                                                 */
/* Final board assembly                            */
/* Here is the complete board built from           */
/* pre-generated modules                           */
/*                                                 */
/***************************************************/
		color ([1, 1, 1])
			layer_topsilk_body(0.818750);

		color ([1, 1, 1])
			layer_bottomsilk_body(-0.818750);

		color ([0.44, 0.44, 0])
			difference() {
				board_body();
				all_holes();
			}

		all_components();
// END_OF_BOARD
