//SCAD

module line_segment_r(length, width, thickness, x, y, a, bd, c1, c2) {
	translate([x,y,0]) rotate ([0,0,a]) union() {
		if (bd) {cube ([length, width,thickness],true);}
		if (c2) {translate([length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
		if (c1) { translate([-length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
	}
}

module line_segment(length, width, thickness, x, y, a) {
	translate([x,y,0]) rotate ([0,0,a]) {
		cube ([length, width,thickness],true);
	}
}

// START_OF_LAYER: topsilk
module layer_topsilk_body (offset) {
translate ([0, 0, offset]) union () {
	line_segment_r(3.175000,0.127000,0.037500,0.635000,-7.937500,90.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,1.270000,-9.525000,180.000000,1,1,1);
	line_segment_r(3.175000,0.127000,0.037500,1.905000,-7.937500,90.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,1.270000,-6.350000,180.000000,1,1,1);
	line_segment_r(3.175059,0.127000,0.037500,3.399409,-4.932553,135.000000,1,1,1);
	line_segment_r(1.270167,0.127000,0.037500,4.971034,-5.606034,-135.000000,1,1,1);
	line_segment_r(3.175059,0.127000,0.037500,4.297553,-4.034409,135.000000,1,1,1);
	line_segment_r(1.270167,0.127000,0.037500,2.725928,-3.360928,-135.000000,1,1,1);
	line_segment_r(3.175059,0.127000,0.037500,5.939409,-4.932553,135.000000,1,1,1);
	line_segment_r(1.270167,0.127000,0.037500,7.511034,-5.606034,-135.000000,1,1,1);
	line_segment_r(3.175059,0.127000,0.037500,6.837553,-4.034409,135.000000,1,1,1);
	line_segment_r(1.270167,0.127000,0.037500,5.265928,-3.360928,-135.000000,1,1,1);
	line_segment_r(3.175058,0.127000,0.037500,3.816604,-8.568055,157.780670,1,1,1);
	line_segment_r(1.270090,0.127000,0.037500,5.526405,-8.580501,-112.220581,1,1,1);
	line_segment_r(3.175058,0.127000,0.037500,4.296918,-7.392289,157.780670,1,1,1);
	line_segment_r(1.270090,0.127000,0.037500,2.587117,-7.379843,-112.220581,1,1,1);
	line_segment_r(3.175000,0.127000,0.037500,2.222500,-1.905000,180.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,3.810000,-1.270000,-90.000000,1,1,1);
	line_segment_r(3.175000,0.127000,0.037500,2.222500,-0.635000,0.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,0.635000,-1.270000,-90.000000,1,1,1);
	line_segment_r(3.175000,0.127000,0.037500,1.905000,-4.127500,90.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,1.270000,-2.540000,180.000000,1,1,1);
	line_segment_r(3.175000,0.127000,0.037500,0.635000,-4.127500,90.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,1.270000,-5.715000,180.000000,1,1,1);
	line_segment_r(3.175000,0.127000,0.037500,6.032500,-1.905000,180.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,7.620000,-1.270000,90.000000,1,1,1);
	line_segment_r(3.175000,0.127000,0.037500,6.032500,-0.635000,180.000000,1,1,1);
	line_segment_r(1.270000,0.127000,0.037500,4.445000,-1.270000,90.000000,1,1,1);
	line_segment_r(3.175058,0.127000,0.037500,7.626604,-8.568055,157.780670,1,1,1);
	line_segment_r(1.270090,0.127000,0.037500,9.336405,-8.580501,-112.220581,1,1,1);
	line_segment_r(3.175058,0.127000,0.037500,8.106918,-7.392289,157.780670,1,1,1);
	line_segment_r(1.270090,0.127000,0.037500,6.397117,-7.379843,-112.220581,1,1,1);
	line_segment_r(0.330200,0.177800,0.037500,2.032000,-5.740400,90.000000,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.073275,-5.534025,-135.000000,1,1,1);
	line_segment_r(0.165100,0.177800,0.037500,2.197100,-5.492750,180.000000,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.320925,-5.534025,-45.000000,1,1,1);
	line_segment_r(0.247650,0.177800,0.037500,2.362200,-5.699125,90.000000,1,1,1);
	line_segment_r(0.660400,0.177800,0.037500,2.362200,-5.822950,180.000000,1,1,1);
	line_segment_r(0.385076,0.177800,0.037500,2.527300,-5.591810,-149.036240,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.073275,-5.253354,-45.000000,1,1,1);
	line_segment_r(0.165100,0.177800,0.037500,2.032000,-5.129529,90.000000,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.073275,-5.005704,-135.000000,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.651125,-5.005704,-45.000000,1,1,1);
	line_segment_r(0.165100,0.177800,0.037500,2.692400,-5.129529,90.000000,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.651125,-5.253354,-135.000000,1,1,1);
	line_segment_r(0.165100,0.177800,0.037500,2.329180,-5.129529,90.000000,1,1,1);
	line_segment_r(0.132080,0.177800,0.037500,2.180590,-4.964429,180.000000,1,1,1);
	line_segment_r(0.198120,0.177800,0.037500,2.510790,-4.964429,180.000000,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.370455,-5.005704,45.000000,1,1,1);
	line_segment_r(0.116743,0.177800,0.037500,2.287905,-5.005704,135.000000,1,1,1);
	line_segment_r(0.508000,0.177800,0.037500,1.778000,-10.160000,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,1.714500,-10.477500,45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,1.524000,-10.541000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,1.333500,-10.477500,135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,1.270000,-10.223500,90.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,1.270000,-10.033000,180.000000,1,1,1);
	line_segment_r(0.592425,0.177800,0.037500,1.016000,-10.388600,30.963757,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,1.714500,-11.290301,45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,1.778000,-11.099801,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,1.714500,-10.909301,135.000000,1,1,1);
	line_segment_r(0.762000,0.177800,0.037500,1.270000,-10.845801,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,0.825500,-10.909301,45.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,1.257300,-11.290301,45.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,1.320800,-11.036301,90.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,0.762000,-11.099801,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,0.825500,-11.290301,135.000000,1,1,1);
	line_segment_r(0.304800,0.177800,0.037500,1.041400,-11.353801,180.000000,1,1,1);
	line_segment_r(0.508000,0.177800,0.037500,4.953000,-9.525000,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,4.889500,-9.842500,45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,4.699000,-9.906000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,4.508500,-9.842500,135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,4.445000,-9.588500,90.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,4.445000,-9.398000,180.000000,1,1,1);
	line_segment_r(0.592425,0.177800,0.037500,4.191000,-9.753600,30.963757,1,1,1);
	line_segment_r(1.135923,0.177800,0.037500,4.445000,-10.591801,153.434952,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,4.953000,-10.528301,90.000000,1,1,1);
	line_segment_r(0.279400,0.177800,0.037500,0.520700,-0.381000,180.000000,1,1,1);
	line_segment_r(0.098783,0.177800,0.037500,0.695325,-0.415925,135.000000,1,1,1);
	line_segment_r(0.139700,0.177800,0.037500,0.730250,-0.520700,90.000000,1,1,1);
	line_segment_r(0.098783,0.177800,0.037500,0.695325,-0.625475,-135.000000,1,1,1);
	line_segment_r(0.209550,0.177800,0.037500,0.555625,-0.660400,180.000000,1,1,1);
	line_segment_r(0.558800,0.177800,0.037500,0.450850,-0.660400,90.000000,1,1,1);
	line_segment_r(0.325834,0.177800,0.037500,0.646430,-0.800100,120.963753,1,1,1);
	line_segment_r(0.158053,0.177800,0.037500,0.953771,-0.436880,-135.000000,1,1,1);
	line_segment_r(0.558800,0.177800,0.037500,1.009651,-0.660400,90.000000,1,1,1);
	line_segment_r(0.209550,0.177800,0.037500,1.002666,-0.939800,180.000000,1,1,1);
	line_segment_r(0.508000,0.177800,0.037500,8.191500,-0.635000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.509000,-0.698500,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,8.572500,-0.889000,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.509000,-1.079500,-135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,8.255000,-1.143000,180.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,8.064500,-1.143000,90.000000,1,1,1);
	line_segment_r(0.592425,0.177800,0.037500,8.420100,-1.397000,120.963753,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.940801,-0.698500,-135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,9.194801,-0.635000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,9.448801,-0.698500,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,9.512301,-0.889000,90.000000,1,1,1);
	line_segment_r(0.898026,0.177800,0.037500,9.194801,-1.333500,-135.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,9.194801,-1.651000,180.000000,1,1,1);
	line_segment_r(0.304800,0.177800,0.037500,3.556000,-3.530600,90.000000,1,1,1);
	line_segment_r(0.107763,0.177800,0.037500,3.594100,-3.340100,-135.000000,1,1,1);
	line_segment_r(0.152400,0.177800,0.037500,3.708400,-3.302000,180.000000,1,1,1);
	line_segment_r(0.107763,0.177800,0.037500,3.822700,-3.340100,-45.000000,1,1,1);
	line_segment_r(0.228600,0.177800,0.037500,3.860800,-3.492500,90.000000,1,1,1);
	line_segment_r(0.609600,0.177800,0.037500,3.860800,-3.606800,180.000000,1,1,1);
	line_segment_r(0.355455,0.177800,0.037500,4.013200,-3.393440,-149.036240,1,1,1);
	line_segment_r(0.487918,0.177800,0.037500,3.746500,-2.966719,-38.659809,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,3.937000,-2.928619,90.000000,1,1,1);
	line_segment_r(0.609600,0.177800,0.037500,3.860800,-2.814319,180.000000,1,1,1);
	line_segment_r(0.508000,0.177800,0.037500,9.017000,-3.683000,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.953500,-4.000500,45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,8.763000,-4.064000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.572500,-4.000500,135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,8.509000,-3.746500,90.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,8.509000,-3.556000,180.000000,1,1,1);
	line_segment_r(0.592425,0.177800,0.037500,8.255000,-3.911600,30.963757,1,1,1);
	line_segment_r(0.508000,0.177800,0.037500,9.017000,-4.622801,90.000000,1,1,1);
	line_segment_r(0.508000,0.177800,0.037500,8.763000,-4.368801,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.572500,-4.432301,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,8.636000,-4.622801,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.572500,-4.813301,45.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,8.318500,-4.876801,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.064500,-4.813301,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,8.001000,-4.622801,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.064500,-4.432301,45.000000,1,1,1);
	line_segment_r(0.508000,0.177800,0.037500,8.509000,-9.779000,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.445500,-10.096500,45.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,8.255000,-10.160000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.064500,-10.096500,135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,8.001000,-9.842500,90.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,8.001000,-9.652000,180.000000,1,1,1);
	line_segment_r(0.592425,0.177800,0.037500,7.747000,-10.007600,30.963757,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,7.556500,-10.528301,45.000000,1,1,1);
	line_segment_r(0.203200,0.177800,0.037500,7.721600,-10.464801,180.000000,1,1,1);
	line_segment_r(0.251447,0.177800,0.037500,7.912100,-10.553701,135.000000,1,1,1);
	line_segment_r(0.152400,0.177800,0.037500,8.001000,-10.718801,90.000000,1,1,1);
	line_segment_r(0.251447,0.177800,0.037500,7.912100,-10.883901,45.000000,1,1,1);
	line_segment_r(0.203200,0.177800,0.037500,7.721600,-10.972801,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,7.556500,-10.909301,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,7.493000,-10.718801,90.000000,1,1,1);
	line_segment_r(0.251447,0.177800,0.037500,8.089900,-10.553701,45.000000,1,1,1);
	line_segment_r(0.203200,0.177800,0.037500,8.280400,-10.464801,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.445500,-10.528301,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,8.509000,-10.718801,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,8.445500,-10.909301,45.000000,1,1,1);
	line_segment_r(0.203200,0.177800,0.037500,8.280400,-10.972801,180.000000,1,1,1);
	line_segment_r(0.251447,0.177800,0.037500,8.089900,-10.883901,135.000000,1,1,1);
}
}


// END_OF_LAYER layer_topsilk

// START_OF_LAYER: bottomsilk
module layer_bottomsilk_body (offset) {
translate ([0, 0, offset]) union () {
}
}


// END_OF_LAYER layer_bottomsilk

module board_outline () {
	polygon([[0,0],[0,-12.700000],[12.700000,-12.700000],[12.700000,0]],
[[0,1,2,3]]);
}

module all_holes() {
	plating=0.017500;
	union () {
		for (i = layer_pdrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0]+2*plating, h=1.770000, center=true, $fn=30);
		}
		for (i = layer_udrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0], h=1.770000, center=true, $fn=30);
		}
	}
}

module board_body() {
	translate ([0, 0, -0.800000]) linear_extrude(height=1.600000) board_outline();}

/***************************************************/
/*                                                 */
/* Components                                      */
/*                                                 */
/***************************************************/
module all_components() {
}

/***************************************************/
/*                                                 */
/* Final board assembly                            */
/* Here is the complete board built from           */
/* pre-generated modules                           */
/*                                                 */
/***************************************************/
		color ([1, 1, 1])
			layer_topsilk_body(0.818750);

		color ([1, 1, 1])
			layer_bottomsilk_body(-0.818750);

		color ([0.44, 0.44, 0])
			difference() {
				board_body();
				all_holes();
			}

		all_components();
// END_OF_BOARD
