//SCAD

module line_segment_r(length, width, thickness, x, y, a, bd, c1, c2) {
	translate([x,y,0]) rotate ([0,0,a]) union() {
		if (bd) {cube ([length, width,thickness],true);}
		if (c2) {translate([length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
		if (c1) { translate([-length/2.,0,0]) cylinder(h=thickness, r=width/2,center=true,$fn=30);}
	}
}

module line_segment(length, width, thickness, x, y, a) {
	translate([x,y,0]) rotate ([0,0,a]) {
		cube ([length, width,thickness],true);
	}
}

// START_OF_LAYER: plated-drill
layer_pdrill_list=[
];


// END_OF_LAYER layer_pdrill

// START_OF_LAYER: topsilk
module layer_topsilk_body (offset) {
translate ([0, 0, offset]) union () {
	line_segment_r(2.540000,0.254000,0.037500,0.635000,-3.175000,90.000000,1,1,1);
	line_segment_r(10.160000,0.254000,0.037500,5.715000,-4.445000,0.000000,1,1,1);
	line_segment_r(2.540000,0.254000,0.037500,10.795000,-3.175000,-90.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,2.540000,-1.905000,180.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,8.890000,-1.905000,180.000000,1,1,1);
	line_segment_r(0.110793,0.254000,0.037500,4.447416,1.849656,92.500130,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.457064,1.739390,97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.476284,1.630383,102.499977,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,4.504932,1.523467,107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.542789,1.419454,112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,4.589569,1.319137,117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.644913,1.223279,122.499947,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.708401,1.132609,127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.779549,1.047817,132.499451,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,4.857817,0.969549,137.500168,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.942609,0.898400,142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.033279,0.834912,147.500046,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.129138,0.779568,152.499878,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.229455,0.732790,157.499954,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.333467,0.694932,162.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.440383,0.666284,167.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.549389,0.647063,172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.659656,0.637416,177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.770344,0.637416,-177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.880610,0.647063,-172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.989616,0.666284,-167.500031,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.096533,0.694932,-162.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.200545,0.732790,-157.499756,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.300862,0.779568,-152.499878,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.396721,0.834912,-147.500046,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.487391,0.898400,-142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.572183,0.969549,-137.499817,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.650451,1.047817,-132.499832,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.721600,1.132609,-127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.785088,1.223279,-122.499947,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.840432,1.319137,-117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.887210,1.419454,-112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.925068,1.523467,-107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.953716,1.630383,-102.499977,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.972937,1.739390,-97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.982584,1.849656,-92.500130,1,1,1);
	line_segment_r(2.540000,0.254000,0.037500,0.635000,-8.255000,90.000000,1,1,1);
	line_segment_r(10.160000,0.254000,0.037500,5.715000,-9.525000,0.000000,1,1,1);
	line_segment_r(2.540000,0.254000,0.037500,10.795000,-8.255000,-90.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,2.540000,-6.985000,180.000000,1,1,1);
	line_segment_r(3.810000,0.254000,0.037500,8.890000,-6.985000,180.000000,1,1,1);
	line_segment_r(0.110793,0.254000,0.037500,4.447416,6.929656,92.500130,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.457064,6.819389,97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.476284,6.710383,102.499977,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,4.504932,6.603467,107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.542789,6.499454,112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,4.589569,6.399137,117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.644913,6.303279,122.499947,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.708401,6.212609,127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.779549,6.127817,132.499451,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,4.857817,6.049549,137.500168,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,4.942609,5.978400,142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.033279,5.914913,147.500046,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.129138,5.859569,152.499878,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,5.229455,5.812789,157.499954,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.333467,5.774932,162.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.440383,5.746284,167.500031,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.549389,5.727064,172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.659656,5.717416,177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.770344,5.717416,-177.499863,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.880610,5.727064,-172.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,5.989616,5.746284,-167.500031,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.096533,5.774932,-162.500183,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.200545,5.812789,-157.499756,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.300862,5.859569,-152.499878,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.396721,5.914913,-147.500046,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.487391,5.978400,-142.500214,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.572183,6.049549,-137.499817,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.650451,6.127817,-132.499832,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.721600,6.212609,-127.500198,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.785088,6.303279,-122.499947,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.840432,6.399137,-117.500122,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.887210,6.499454,-112.500244,1,0,1);
	line_segment_r(0.110794,0.254000,0.037500,6.925068,6.603467,-107.499825,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.953716,6.710383,-102.499977,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.972937,6.819389,-97.499809,1,0,1);
	line_segment_r(0.110793,0.254000,0.037500,6.982584,6.929656,-92.500130,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,1.905000,-1.079500,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,1.968500,-1.587500,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,2.159000,-1.651000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.349500,-1.587500,-135.000000,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,2.413000,-1.079500,90.000000,1,1,1);
	line_segment_r(0.287368,0.177800,0.037500,2.819401,-0.736600,-135.000000,1,1,1);
	line_segment_r(1.016000,0.177800,0.037500,2.921001,-1.143000,90.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,2.908301,-1.651000,180.000000,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,1.905000,-6.159500,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,1.968500,-6.667500,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,2.159000,-6.731000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.349500,-6.667500,-135.000000,1,1,1);
	line_segment_r(0.889000,0.177800,0.037500,2.413000,-6.159500,90.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,2.781301,-5.778500,-135.000000,1,1,1);
	line_segment_r(0.381000,0.177800,0.037500,3.035301,-5.715000,180.000000,1,1,1);
	line_segment_r(0.179605,0.177800,0.037500,3.289301,-5.778500,135.000000,1,1,1);
	line_segment_r(0.254000,0.177800,0.037500,3.352801,-5.969000,90.000000,1,1,1);
	line_segment_r(0.898026,0.177800,0.037500,3.035301,-6.413500,-135.000000,1,1,1);
	line_segment_r(0.635000,0.177800,0.037500,3.035301,-6.731000,180.000000,1,1,1);
}
}


// END_OF_LAYER layer_topsilk

// START_OF_LAYER: bottomsilk
module layer_bottomsilk_body (offset) {
translate ([0, 0, offset]) union () {
}
}


// END_OF_LAYER layer_bottomsilk

module board_outline () {
	polygon([[0,0],[0,-12.700000],[12.700000,-12.700000],[12.700000,0]],
[[0,1,2,3]]);
}

module all_holes() {
	plating=0.017500;
	union () {
		for (i = layer_pdrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0]+2*plating, h=1.770000, center=true, $fn=30);
		}
		for (i = layer_udrill_list) {
			translate([i[1][0],i[1][1],0]) cylinder(r=i[0], h=1.770000, center=true, $fn=30);
		}
	}
}

module board_body() {
	translate ([0, 0, -0.800000]) linear_extrude(height=1.600000) board_outline();}

/***************************************************/
/*                                                 */
/* Components                                      */
/*                                                 */
/***************************************************/
module all_components() {
}

/***************************************************/
/*                                                 */
/* Final board assembly                            */
/* Here is the complete board built from           */
/* pre-generated modules                           */
/*                                                 */
/***************************************************/
		color ([1, 1, 1])
			layer_topsilk_body(0.818750);

		color ([1, 1, 1])
			layer_bottomsilk_body(-0.818750);

		color ([0.44, 0.44, 0])
			difference() {
				board_body();
				all_holes();
			}

		all_components();
// END_OF_BOARD
