/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <limits.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "config.h"

#ifdef HAVE_BDB_18x

#include "dlhash.h"
#include "dlhash_tools.h"
#include "tools.h"

#ifdef HAVE_DB1_H
#include <db1/db.h>
#elif defined(HAVE_DB185_H)
#include <db_185.h>
#elif defined(HAVE_DB2_DB185_H)
#include <db2/db_185.h>
#elif defined(HAVE_DB3_DB185_H)
#include <db3/db_185.h>
#else
#include <db.h>
#endif

typedef int int32__t;
typedef unsigned int uint32__t;

#ifdef WORDS_BIGENDIAN
#define COPY_INT32(i1,i2) \
	((char *)(i1))[0] = ((char *)(i2))[3];\
	((char *)(i1))[1] = ((char *)(i2))[2];\
	((char *)(i1))[2] = ((char *)(i2))[1];\
	((char *)(i1))[3] = ((char *)(i2))[0];
#else
#define COPY_INT32(i1,i2)  *((int32__t *) i1) = *((int32__t *) i2);
#endif

static char *moz_cache_filename = NULL;
static time_t moz_cache_db_modtime = 0L;
static dlhash *moz_hash = NULL;

typedef struct {
	char	*urlstr;
	char	*filename;
} moz_pair_t;

static moz_pair_t *moz_pair_new(f, u)
char *f;
char *u;
{
	moz_pair_t *rv = NULL;

	if (f && u)
	{
		rv = _malloc(sizeof(moz_pair_t));
		rv->filename = tl_strdup(f);
		rv->urlstr = tl_strdup(u);
	}

	return rv;
}

static void moz_pair_free(mp)
moz_pair_t *mp;
{
	_free(mp->filename);
	_free(mp->urlstr);
	_free(mp);
}

static char *moz_pair_get_urlstr(mp)
moz_pair_t *mp;
{
	return mp->urlstr;
}

static char *moz_cache_get_filename(data)
DBT *data;
{
	char *tmp = data->data;
	uint32__t size;

	COPY_INT32(&size, tmp);
	if (size != data->size || data->size < 20)
		return NULL;

	tmp += sizeof(uint32__t) 	/* size */
		+ sizeof(int32__t); 	/* recordid */

	COPY_INT32(&size, tmp);
	tmp += sizeof(uint32__t) + size; /* key_len + key */

	COPY_INT32(&size, tmp);
	tmp += sizeof(uint32__t) + size; /* meta_len + meta */

	tmp += sizeof(uint32__t);	/* filename_len */

	return tmp;
}

static char *moz_cache_get_urlstr(data)
DBT *data;
{
	char *tmp = data->data;
	uint32__t size;

	COPY_INT32(&size, tmp);
	if (size != data->size || data->size < 20)
		return NULL;

	tmp += sizeof(uint32__t) 	/* size */
		+ sizeof(int32__t); 	/* recordid */

	COPY_INT32(&size, tmp);
	tmp += sizeof(uint32__t); 	/* key_len */

	return tmp;
}

static void moz_cache_open_db(dirname)
char *dirname;
{
	bool_t reopen = FALSE;
	HASHINFO hash_info = {
		4*1024,	  /* bucket size */
		0,        /* fill factor */
		0,        /* number of elements */
		96*1024,  /* bytes to cache */
		0,        /* hash function */
		0};       /* byte order */
	char pom[PATH_MAX];


	LOCK_NSCACHE
	if (!moz_hash)
	{
		moz_hash = dlhash_new(256, (dlkey_func)moz_pair_get_urlstr,
			(dlhash_func)str_hash_func, (dlcomp_func)str_comp_func);
		dlhash_set_free_func(moz_hash, (dlfree_func)moz_pair_free, NULL);
	}

	if (dirname)
	{
		struct stat estat;

		sprintf(pom, "%s/cache.db", dirname);

		if (!moz_cache_filename || strcmp(pom, moz_cache_filename)) 
			reopen = TRUE;

		if (!reopen && !stat(pom, &estat) &&
		    estat.st_mtime != moz_cache_db_modtime)
			reopen = TRUE;
	}

	if (reopen || !dirname)
	{
		_free(moz_cache_filename);
		moz_cache_db_modtime = 0L;
		dlhash_empty(moz_hash);
	}

	if (reopen)
	{
		struct stat estat;
		DB *moz_cache_db;
		DBT key,data;

		moz_cache_db = dbopen(pom, O_RDONLY, 0600, DB_HASH, &hash_info);

		if (!moz_cache_db)
		{
			xprintf(0, gettext("Unable to open Mozilla cache index - %s\n"), pom);
		}
		else
		{
			if (!stat(pom, &estat))
			    moz_cache_db_modtime = estat.st_mtime;

			_free(moz_cache_filename);
			moz_cache_filename = tl_strdup(pom);

			while (!moz_cache_db->seq(moz_cache_db, &key, &data, R_NEXT))
			{
				moz_pair_t *mp;

				mp = moz_pair_new(moz_cache_get_filename(&data),
						  moz_cache_get_urlstr(&data));

				if (mp)
					dlhash_insert(moz_hash, mp);
			}

			moz_cache_db->close(moz_cache_db);
		}
	}
	UNLOCK_NSCACHE
}

char *moz_cache_find_localname(urlstr)
char *urlstr;
{
	char *retv = NULL;

	moz_cache_open_db(priv_cfg.moz_cache_dir);

	LOCK_NSCACHE
	if (moz_hash)
	{
		moz_pair_t *mp;

		mp = dlhash_find_by_key(moz_hash, urlstr);

		if (mp)
			retv = tl_strdup(mp->filename);
	}
	UNLOCK_NSCACHE

	return retv;
}

#endif

