//
// C++ Implementation: emptytagfilter
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "emptytagfilter.h"


#include <QVariant>
#include <QTimer>

#include <ept/debtags/debtags.h>

// NTagModel
#include "vocabularymodel.h"
#include "vocabularymodelrole.h"

// NPlugin
#include "debtagsplugincontainer.h"

namespace NTagModel {

EmptyTagFilter::EmptyTagFilter(const VocabularyModel* pModel, QObject* pParent)
 : QSortFilterProxyModel(pParent)
{
	_tagSelectionHasChanged = false;
	_pVocabularyModel = pModel;
	connect(_pVocabularyModel, SIGNAL(dataChanged(QModelIndex, QModelIndex)), SLOT(tagSelectionChanged()));
}


EmptyTagFilter::~EmptyTagFilter()
{
}


bool EmptyTagFilter::filterAcceptsRow(int sourceRow, const QModelIndex& sourceParent) const
{
	// TODO: Do not compute the companion tags every time the filterMethod is called, but only when the selected tags change

	// tree filtering -> if a child is shown, also show the facet
	QModelIndex current = sourceModel()->index(sourceRow, 0, sourceParent);
	if (!current.isValid())
	{
		qDebug("[EmptyTagFilter::filterAcceptsRow] Invalid model index!");
		return false;
	}
	for( int i = 0; i < sourceModel()->rowCount(current); ++i )
	{
		const QModelIndex child = current.child(i, 0);
		if (filterAcceptsRow(i, current))
			return true;
	}

	// facets without tags will not be shown
	if (sourceModel()->data(current, TypeRole).toInt() == FacetTypeItem)
		return false;
	
 	Tag tag = sourceModel()->data(current, TagRole).value<TagWrapper>().tag;
 	// if no tags are selected, the companion tags are useless -> show only those tags
 	// which have a cardinality > 0
 	if (_pVocabularyModel->selectedTags().empty())
 		return _pVocabularyModel->debtags()->getCardinality(tag) > 0;
	static set<Tag> companionTags;
	if (_tagSelectionHasChanged) {
		companionTags = _pVocabularyModel->debtags()->getCompanionTags(_pVocabularyModel->selectedTags());
		_tagSelectionHasChanged = false;
	}
/*	if (companionTags.find(tag) == companionTags.end())
		qDebug("Tag " + toQString(tag.fullname()) + " is hidden as non-companion");
	else 
		qDebug("Tag " + toQString(tag.fullname()) + " is shown as companion");*/
	return companionTags.find(tag) != companionTags.end();
}


void EmptyTagFilter::tagSelectionChanged()
{
	_tagSelectionHasChanged = true;
	// queue evaluation of tags
// 	QTimer::singleShot(3000, this, SLOT(onSelectionChangedTimeout()));
	invalidateFilter();
}

void EmptyTagFilter::onSelectionChangedTimeout()
{
	invalidateFilter();
}


}	// NTagModel 

#undef emit	
#include <ept/debtags/debtags.tcc>
