//
// C++ Implementation: pluginsettingsdlg
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <qlayout.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>
//Added by qt3to4:
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <q3button.h>


#include "pluginsettingsdlg.h"

#include "plugincontainer.h"


namespace NPlugin 
{

PluginSettingsDlg::PluginSettingsDlg(QWidget *parent, const char *name)
 : QDialog(parent, name)
{
	new QVBoxLayout(this, 5, 6);
	_pPluginWidget = new QTabWidget(this, "PluginSettingsTabs");
	layout()->add(_pPluginWidget);
	QHBoxLayout* pButtonLayout = new QHBoxLayout(layout(), -1, "ButtonLayout");
	QPushButton* pOkButton = new QPushButton(tr("&OK"), this, "OkButton");
	connect(pOkButton, SIGNAL(clicked()), SLOT(accept()));
	QPushButton* pCancelButton = new QPushButton(tr("&Cancel"), this, "CancelButton");
	connect(pCancelButton, SIGNAL(clicked()), SLOT(reject()));
	pButtonLayout->addItem(new QSpacerItem(0,0, QSizePolicy::Expanding, QSizePolicy::Minimum ));
	pButtonLayout->add(pOkButton);
	pButtonLayout->add(pCancelButton);
}


PluginSettingsDlg::~PluginSettingsDlg()
{
}

void PluginSettingsDlg::addPlugin(PluginContainer* pPluginContainer)
{
//	_pPluginWidget->addTab( new QLabel("test", _pPluginWidget), pPluginContainer->title() );
	QWidget* pSettingsWidget = pPluginContainer->getSettingsWidget(this);
	if (pSettingsWidget != 0)
	{
		_pPluginWidget->addTab(pSettingsWidget, pPluginContainer->title());
	}
}


};
