//
// C++ Implementation: aptfrontpackage
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "aptfrontpackage.h"

#include <ept/cache/version.h>
#include <ept/cache/apt/packages.h>
#include <ept/cache/apt/records.h>

typedef ept::configuration::apt::cache::Relation Relation;

namespace NApt 
{

QString AptFrontPackage::_emptyString;


AptFrontPackage::AptFrontPackage(const Package& sourcePackage)
 : _source(sourcePackage)
{
}

AptFrontPackage::~AptFrontPackage()
{
}

QString AptFrontPackage::name() const
{
	return toQString(_source.name());;
}

QString AptFrontPackage::essential() const
{
	return _emptyString;
}

QString AptFrontPackage::priority() const
{
	return _emptyString;
}

QString AptFrontPackage::section() const
{
	return toQString(_source.section(string()));;
}

QString AptFrontPackage::installedSize() const
{
	if (_source.candidateVersion().valid())
		return toQString(_source.candidateVersion().installedSizeString());
 	if (_source.installedVersion().valid())
		return toQString(_source.installedVersion().installedSizeString());
	return _emptyString;
}


uint AptFrontPackage::getInstalledSize() const
{
	if (_source.candidateVersion().valid())
		return _source.candidateVersion().installedSize();
 	if (_source.installedVersion().valid())
		return _source.installedVersion().installedSize();
	return 0;
}



QString AptFrontPackage::maintainer() const
{
	return toQString(_source.maintainer(string()));;
}

QString AptFrontPackage::architecture() const
{
	return toQString(_source.architecture(string()));
}

QString AptFrontPackage::source() const
{
	return toQString(_source.source(string()));;
}

QString AptFrontPackage::version() const
{
	if (_source.candidateVersion().valid())
		return toQString(_source.candidateVersion().versionString());
	return _emptyString;
}

QString AptFrontPackage::replaces() const
{
	return AptFrontPackage::getRelation(Relation::Replaces);
}

QString AptFrontPackage::provides() const
{
	return _emptyString;
}

QString AptFrontPackage::preDepends() const
{
	return AptFrontPackage::getRelation(Relation::PreDependency);
}

QString AptFrontPackage::depends() const
{
	return AptFrontPackage::getRelation(Relation::Dependency);
}

QString AptFrontPackage::recommends() const
{
	return AptFrontPackage::getRelation(Relation::Recommends);
}

QString AptFrontPackage::suggests() const
{
	return AptFrontPackage::getRelation(Relation::Suggests);
}

QString AptFrontPackage::conflicts() const
{
	return AptFrontPackage::getRelation(Relation::Conflicts);
}

QString AptFrontPackage::filename() const
{

	return toQString(_source.fileName(string()));;
}

QString AptFrontPackage::size() const
{
	return _emptyString;
}

uint AptFrontPackage::getSize() const
{
	return 0;
}


QString AptFrontPackage::md5sum() const
{
	return toQString(_source.md5sum(string()));;
}

QString AptFrontPackage::conffiles() const
{
	return _emptyString;
}

QString AptFrontPackage::description() const
{
	return toQString(_source.longDescription(string()));
}

AptFrontPackage::InstalledState AptFrontPackage::installedState() const
{
	return (_source.isInstalled()) ? INSTALLED : NOT_INSTALLED;
}

QString AptFrontPackage::installedVersion() const
{
	if (_source.installedVersion().valid())
		return toQString(_source.installedVersion().versionString());
	return _emptyString;
}

QString AptFrontPackage::shortDescription() const
{
	return toQString(_source.shortDescription(string()));;
}


QString AptFrontPackage::getRelation(Relation::Type type) const
{
	string relationString;
	bool isFirst = true;
	// if no information is available
	if (!_source.hasVersion())
		return "";
	wibble::Range<Relation> depends = _source.depends();
	for ( wibble::Range<Relation>::iterator i = depends.begin(); i != depends.end(); ++i)
	{
		if (i->type() == type)
		{
			if (isFirst)
				isFirst = false;
			else
				relationString += ", ";
			relationString += i->name();
		}
	}
	return toQString(relationString);
}



}

#undef emit
#include <ept/cache/apt/packages.tcc>
#include <ept/cache/relation.tcc>
