//
// C++ Implementation: pluginlistviewitem
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "pluginlistitem.h"

#include "helpers.h"

namespace NPlugin {

PluginListItem::PluginListItem(Q3ListView* parent, const PluginManager::PluginData& pd) :
	QObject(parent, "pluginListItem"), 
	Q3CheckListItem(parent, toQString(pd.name()), Q3CheckListItem::CheckBox ),
	_pluginData(pd)
 
{
	setText(1, toQString(pd.version()));
	setText(2, toQString(pd.author()));
	setText(3, toQString(pd.directory));
	if (pd.pPlugin)	// if the plugin is loaded
		setOn(true);
}

PluginListItem::~PluginListItem()
{
}

void PluginListItem::stateChange(bool status)
{
	emit(toggled(this, status));
}


void PluginListItem::setDynamicData(void* libraryHandle, PluginContainer* pPlugin)
{
	_pluginData.libraryHandle = libraryHandle;
	_pluginData.pPlugin = pPlugin;
}


};
