/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import com.phonegap.DirectoryManager;
import com.phonegap.ExifHelper;
import com.phonegap.FileUtils;
import com.phonegap.api.LOG;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Capture
extends Plugin {
    private static final String VIDEO_3GPP = "video/3gpp";
    private static final String AUDIO_3GPP = "audio/3gpp";
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final int CAPTURE_AUDIO = 0;
    private static final int CAPTURE_IMAGE = 1;
    private static final int CAPTURE_VIDEO = 2;
    private static final String LOG_TAG = "Capture";
    private static final int CAPTURE_INTERNAL_ERR = 0;
    private static final int CAPTURE_APPLICATION_BUSY = 1;
    private static final int CAPTURE_INVALID_ARGUMENT = 2;
    private static final int CAPTURE_NO_MEDIA_FILES = 3;
    private static final int CAPTURE_NOT_SUPPORTED = 20;
    private String callbackId;
    private long limit;
    private double duration;
    private JSONArray results;
    private Uri imageUri;

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        this.callbackId = callbackId;
        this.limit = 1L;
        this.duration = 0.0;
        this.results = new JSONArray();
        JSONObject options = args.optJSONObject(0);
        if (options != null) {
            this.limit = options.optLong("limit", 1L);
            this.duration = options.optDouble("duration", 0.0);
        }
        if (action.equals("getFormatData")) {
            try {
                JSONObject obj = this.getFormatData(args.getString(0), args.getString(1));
                return new PluginResult(PluginResult.Status.OK, obj);
            }
            catch (JSONException e) {
                return new PluginResult(PluginResult.Status.ERROR);
            }
        }
        if (action.equals("captureAudio")) {
            this.captureAudio();
        } else if (action.equals("captureImage")) {
            this.captureImage();
        } else if (action.equals("captureVideo")) {
            this.captureVideo(this.duration);
        }
        PluginResult r = new PluginResult(PluginResult.Status.NO_RESULT);
        r.setKeepCallback(true);
        return r;
    }

    private JSONObject getFormatData(String filePath, String mimeType) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("height", 0);
            obj.put("width", 0);
            obj.put("bitrate", 0);
            obj.put("duration", 0);
            obj.put("codecs", (Object)"");
            if (mimeType == null || mimeType.equals("")) {
                mimeType = FileUtils.getMimeType(filePath);
            }
            Log.d((String)LOG_TAG, (String)("Mime type = " + mimeType));
            if (mimeType.equals(IMAGE_JPEG) || filePath.endsWith(".jpg")) {
                obj = this.getImageData(filePath, obj);
            } else if (mimeType.endsWith(AUDIO_3GPP)) {
                obj = this.getAudioVideoData(filePath, obj, false);
            } else if (mimeType.equals(VIDEO_3GPP)) {
                obj = this.getAudioVideoData(filePath, obj, true);
            }
        }
        catch (JSONException e) {
            Log.d((String)LOG_TAG, (String)"Error: setting media file data object");
        }
        return obj;
    }

    private JSONObject getImageData(String filePath, JSONObject obj) throws JSONException {
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath);
        obj.put("height", bitmap.getHeight());
        obj.put("width", bitmap.getWidth());
        return obj;
    }

    private JSONObject getAudioVideoData(String filePath, JSONObject obj, boolean video) throws JSONException {
        MediaPlayer player = new MediaPlayer();
        try {
            player.setDataSource(filePath);
            player.prepare();
            obj.put("duration", player.getDuration());
            if (video) {
                obj.put("height", player.getVideoHeight());
                obj.put("width", player.getVideoWidth());
            }
        }
        catch (IOException e) {
            Log.d((String)LOG_TAG, (String)"Error: loading video file");
        }
        return obj;
    }

    private void captureAudio() {
        Intent intent = new Intent("android.provider.MediaStore.RECORD_SOUND");
        this.ctx.startActivityForResult(this, intent, 0);
    }

    private void captureImage() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        File photo = new File(DirectoryManager.getTempDirectoryPath((Context)this.ctx), "Capture.jpg");
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photo));
        this.imageUri = Uri.fromFile((File)photo);
        this.ctx.startActivityForResult(this, intent, 1);
    }

    private void captureVideo(double duration) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        this.ctx.startActivityForResult(this, intent, 2);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        block24: {
            if (resultCode == -1) {
                if (requestCode == 0) {
                    Uri data = intent.getData();
                    this.results.put((Object)this.createMediaFile(data));
                    if ((long)this.results.length() >= this.limit) {
                        this.success(new PluginResult(PluginResult.Status.OK, this.results, "navigator.device.capture._castMediaFile"), this.callbackId);
                    } else {
                        this.captureAudio();
                    }
                } else if (requestCode == 1) {
                    try {
                        ExifHelper exif = new ExifHelper();
                        exif.createInFile(DirectoryManager.getTempDirectoryPath((Context)this.ctx) + "/Capture.jpg");
                        exif.readExifData();
                        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.ctx.getContentResolver(), (Uri)this.imageUri);
                        ContentValues values = new ContentValues();
                        values.put("mime_type", IMAGE_JPEG);
                        Uri uri = null;
                        try {
                            uri = this.ctx.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
                        }
                        catch (UnsupportedOperationException e) {
                            LOG.d(LOG_TAG, "Can't write to external media storage.");
                            try {
                                uri = this.ctx.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
                            }
                            catch (UnsupportedOperationException ex) {
                                LOG.d(LOG_TAG, "Can't write to internal media storage.");
                                this.fail(this.createErrorObject(0, "Error capturing image - no media storage found."));
                                return;
                            }
                        }
                        OutputStream os = this.ctx.getContentResolver().openOutputStream(uri);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, os);
                        os.close();
                        bitmap.recycle();
                        bitmap = null;
                        System.gc();
                        exif.createOutFile(FileUtils.getRealPathFromURI(uri, this.ctx));
                        exif.writeExifData();
                        this.results.put((Object)this.createMediaFile(uri));
                        if ((long)this.results.length() >= this.limit) {
                            this.success(new PluginResult(PluginResult.Status.OK, this.results, "navigator.device.capture._castMediaFile"), this.callbackId);
                            break block24;
                        }
                        this.captureImage();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.fail(this.createErrorObject(0, "Error capturing image."));
                    }
                } else if (requestCode == 2) {
                    Uri data = intent.getData();
                    this.results.put((Object)this.createMediaFile(data));
                    if ((long)this.results.length() >= this.limit) {
                        this.success(new PluginResult(PluginResult.Status.OK, this.results, "navigator.device.capture._castMediaFile"), this.callbackId);
                    } else {
                        this.captureVideo(this.duration);
                    }
                }
            } else if (resultCode == 0) {
                if (this.results.length() > 0) {
                    this.success(new PluginResult(PluginResult.Status.OK, this.results, "navigator.device.capture._castMediaFile"), this.callbackId);
                } else {
                    this.fail(this.createErrorObject(3, "Canceled."));
                }
            } else if (this.results.length() > 0) {
                this.success(new PluginResult(PluginResult.Status.OK, this.results, "navigator.device.capture._castMediaFile"), this.callbackId);
            } else {
                this.fail(this.createErrorObject(3, "Did not complete!"));
            }
        }
    }

    private JSONObject createMediaFile(Uri data) {
        File fp = new File(FileUtils.getRealPathFromURI(data, this.ctx));
        JSONObject obj = new JSONObject();
        try {
            obj.put("name", (Object)fp.getName());
            obj.put("fullPath", (Object)fp.getAbsolutePath());
            if (fp.getAbsoluteFile().toString().endsWith(".3gp") || fp.getAbsoluteFile().toString().endsWith(".3gpp")) {
                if (data.toString().contains("/audio/")) {
                    obj.put("type", (Object)AUDIO_3GPP);
                } else {
                    obj.put("type", (Object)VIDEO_3GPP);
                }
            } else {
                obj.put("type", (Object)FileUtils.getMimeType(fp.getAbsolutePath()));
            }
            obj.put("lastModifiedDate", fp.lastModified());
            obj.put("size", fp.length());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private JSONObject createErrorObject(int code, String message) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("code", code);
            obj.put("message", (Object)message);
        }
        catch (JSONException e) {
            // empty catch block
        }
        return obj;
    }

    public void fail(JSONObject err) {
        this.error(new PluginResult(PluginResult.Status.ERROR, err), this.callbackId);
    }
}

