/*=========================================================================

  Program:   ORFEO Toolbox
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


  Copyright (c) Centre National d'Etudes Spatiales. All rights reserved.
  See OTBCopyright.txt for details.


     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#ifndef otbWrapperComplexOutputImageParameter_h
#define otbWrapperComplexOutputImageParameter_h

#include "itkImageBase.h"
#include "otbWrapperParameter.h"
#include "otbImageFileWriter.h"

namespace otb
{
namespace Wrapper
{
/** \class ComplexOutputImageParameter
 *  \brief This class represents a ComplexOutputImage parameter
 *
 * \ingroup OTBApplicationEngine
 */

class ITK_ABI_EXPORT ComplexOutputImageParameter : public Parameter
{
public:
  /** Standard class typedef */
  typedef ComplexOutputImageParameter   Self;
  typedef Parameter                     Superclass;
  typedef itk::SmartPointer<Self>       Pointer;
  typedef itk::SmartPointer<const Self> ConstPointer;

  typedef itk::ImageBase<2> ImageBaseType;

  /** Defining ::New() static method */
  itkNewMacro(Self);

  /** RTTI support */
  itkTypeMacro(ComplexOutputImageParameter, Parameter);

  /** Set the value */
  itkSetObjectMacro(Image, ImageBaseType);

  /** Get the value */
  itkGetObjectMacro(Image, ImageBaseType);

  /** Return any value */
  void SetValue(ImageBaseType* image);

  /** Return any value */
  ImageBaseType* GetValue( void );

  /** Set/Get m_ComplexPixelType to be used when saving */
  itkSetMacro(ComplexPixelType, ComplexImagePixelType);
  itkGetMacro(ComplexPixelType, ComplexImagePixelType);

  /** Set/Get m_DefaultComplexPixelType*/
  itkSetMacro(DefaultComplexPixelType, ComplexImagePixelType);
  itkGetMacro(DefaultComplexPixelType, ComplexImagePixelType);

  /** Set/Get available RAM value */
  itkSetMacro(RAMValue, unsigned int);
  itkGetMacro(RAMValue, unsigned int);

  /** Implement the reset method (replace pixel type by default type) */
  void Reset() ITK_OVERRIDE
  {
    m_ComplexPixelType = m_DefaultComplexPixelType;
  }

  /** Static method to convert pixel type into string */
  static std::string ConvertPixelTypeToString(ComplexImagePixelType type);

  /** Return true if a filename is set */
  bool HasValue() const ITK_OVERRIDE;

  void SetFileName (const char* filename)
  {
    m_FileName = filename;
    SetActive(true);
  }
  void SetFileName (const std::string& filename)
  {
    this->SetFileName(filename.c_str());
  }

  itkGetStringMacro(FileName);

  void Write();

  itk::ProcessObject* GetWriter();

  void InitializeWriters();

protected:
  /** Constructor */
  ComplexOutputImageParameter();
  /** Destructor */
  ~ComplexOutputImageParameter() ITK_OVERRIDE;

  template <class TInputImageType>
    void SwitchImageWrite();

  template <class TInputVectorImageType>
    void SwitchVectorImageWrite();

  //FloatVectorImageType::Pointer m_Image;
  ImageBaseType::Pointer m_Image;
  std::string            m_FileName;
  ComplexImagePixelType         m_ComplexPixelType;
  ComplexImagePixelType         m_DefaultComplexPixelType;

  typedef otb::ImageFileWriter<ComplexFloatImageType>  ComplexFloatWriterType;
  typedef otb::ImageFileWriter<ComplexDoubleImageType> ComplexDoubleWriterType;


  typedef otb::ImageFileWriter<ComplexFloatVectorImageType>  ComplexVectorFloatWriterType;
  typedef otb::ImageFileWriter<ComplexDoubleVectorImageType> ComplexVectorDoubleWriterType;


  ComplexFloatWriterType::Pointer  m_ComplexFloatWriter;
  ComplexDoubleWriterType::Pointer m_ComplexDoubleWriter;

  ComplexVectorFloatWriterType::Pointer  m_ComplexVectorFloatWriter;
  ComplexVectorDoubleWriterType::Pointer m_ComplexVectorDoubleWriter;


private:
  ComplexOutputImageParameter(const Parameter &); //purposely not implemented
  void operator =(const Parameter&); //purposely not implemented

  unsigned int                  m_RAMValue;

}; // End class OutputImage Parameter

} // End namespace Wrapper
} // End namespace otb

#endif
