
/******************************************************************************
**
**  Copyright (C) 2001  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/******************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      filter_header.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>

#include "utilities.h"
#include "scan_record.h"
#include "filter.h"

osi_bool filter_header( const char *file_path, FILTER_CONTEXT *context )
{
    unsigned char number[MAX_FILTER_ARGUMENT_LENGTH] = "\0";
    unsigned char buffer[MAX_FILTER_ARGUMENT_LENGTH] = "\0";

    int index  = 0;
    int length = 0;
    
    if( ( file_path != NULL ) && ( context != NULL ) )
    {
        memset( number, 0, sizeof( number ) );
    
        if( context->filter_argument != NULL )
        {
            /* lowercase the value so we can compare it */
            /* if there is a hex prefix, skip past it.  */
        
            lowercase_string( (char *)context->filter_argument );
        
            if( strncmp( context->filter_argument, "0x", 2 ) == 0 )
            {
                context->filter_argument += 2;
            }

            if( context->file_handle == NULL )
            {        
                context->file_handle = osi_fopen( file_path, "r", 0 );
            }

            else
            {
                fseek( context->file_handle, 0, SEEK_SET );
            }

            if( context->file_handle != NULL )
            {
                length = fread( number, 1,
                                strlen( context->filter_argument ),
                                context->file_handle );

                for( index = 0; index < length; index++ )
                {
                    osi_snprintf( &buffer[index*2], 2, "%02x", number[index] );
                }
            
                buffer[length*2] = '\0';
            
                if( memcmp( context->filter_argument, buffer,
                            strlen(context->filter_argument) ) == 0 )
                {
                    return TRUE;
                }
            }
        }
    }

    return FALSE;
}
