/*
 * vi configuration file
 * We try to automatically configure to various compilers and operating
 * systems. Extend the autoconf section as needed.
 */

#ifndef _CONFIG_H
# define _CONFIG_H

/*************************** autoconf section ************************/

#include "../defs.h"

#if defined(cray)
#define M_SYSV
#define _POSIX_SOURCE   /* This is a kludge to avoid problems with sys/types */
#endif

#if (defined(sun) && defined(HAVE_ELF_H)) || defined(hpux) || defined(sgi)
#define M_SYSV
#endif

#if (defined(sun) && !defined(HAVE_ELF_H)) || defined(ultrix)
#define bsd
#endif

#ifdef _AIX
#define _POSIX_SOURCE
#define ANY_UNIX 1
#endif

/* standard unix V (?) */
#ifdef	M_SYSV
# define UNIXV		1
# ifdef M_XENIX
#  ifndef M_I386
#   define TINYSTACK	1
#  endif
# endif
# undef COHERENT
#endif

/* BSD UNIX? */
#ifdef bsd
# define BSD		1
#else
# ifdef sun
#  ifndef M_SYSV
#   define BSD		1
#  endif
# endif
#endif

/*************************** end of autoconf section ************************/

/* All undefined symbols are defined to zero here, to allow for older    */
/* compilers which dont understand #if defined() or #if UNDEFINED_SYMBOL */

/*************************** operating systems *****************************/
 
#ifndef	BSD
# define BSD	0		/* UNIX - Berkeley 4.x */
#endif

#ifndef	UNIXV
# define UNIXV	0		/* UNIX - AT&T SYSV */
#endif

#ifndef	UNIX7
# define UNIX7	0		/* UNIX - version 7 */
#endif

				/* generic combination of Unices */
#if UNIXV || UNIX7 || BSD || MINIX || COHERENT
# define ANY_UNIX 1
#else
# define ANY_UNIX 0
#endif

/* Should we use "new style" ANSI C prototypes? */
#ifdef __STDC__
# define NEWSTYLE 1
#endif
#ifdef __cplusplus
# define NEWSTYLE 1
#endif
#ifndef NEWSTYLE
# define NEWSTYLE 0
#endif

#if NEWSTYLE
# define P_(s) s
#else
# define P_(s) ()
#endif

/* There are two terminal-related functions that we need: ttyread() and
 * ttywrite().  The ttyread() function implements read-with-timeout and is
 * a true function on all systems.  The ttywrite() function is almost always
 * just a macro...
 */
# define ttywrite(buf, len)	write(1, buf, (unsigned)(len))	/* raw write */

/* The strchr() function is an official standard now, so everybody has it
 * except Unix version 7 (which is old) and BSD Unix (which is academic).
 * Those guys use something called index() to do the same thing.
 */
#if BSD || UNIX7 || OSK
# define strchr	index
# define strrchr rindex
#endif
#if !NEWSTYLE
extern char *strchr();
#endif

/* BSD uses bcopy() instead of memcpy() */
#if BSD
# define memcpy(dest, src, siz)	bcopy(src, dest, siz)
#endif

/* BSD uses getwd() instead of getcwd().  The arguments are a little different,
 * but we'll ignore that and hope for the best; adding arguments to the macro
 * would mess up an "extern" declaration of the function.
 *
 */
#if BSD
# define getcwd	getwd
#endif
extern char *getcwd();

/* text versa binary mode for read/write */
#define	tread(fd,buf,n)		read(fd,buf,(unsigned)(n))
#define twrite(fd,buf,n)	write(fd,buf,(unsigned)(n))

/**************************** Compiler quirks *********************************/

/* the UNIX version 7 and (some) TOS compilers, don't allow "void" */
#if UNIX7
# define void int
#endif

#if UNIX7 
# define UCHAR(c)	((c) & 0xff)
# define uchar		char
#else
# define UCHAR(c)	((unsigned char)(c))
# define uchar		unsigned char
#endif

/* Some compilers prefer to have malloc declared as returning a (void *) */
/* ANSI, on the other hand, needs the arguments to free() to be cast */
#ifndef	__STDC__
# if BSD
extern void *malloc();
#  define _free_(ptr)	free((void *)ptr)
# else
extern char *malloc();
#  define _free_(ptr)	free((char *)ptr)
# endif
#else
# define _free_(ptr)	free((void *)ptr)
#endif	/* __STDC__ */

/* everybody but Amiga wants lseek declared here */
extern long lseek();

/* ANSI C has getenv() declared in stdlib.h, which we've already included.
 * Other compilers will need it declared here, though.
 */
#ifndef __STDC__
extern char *getenv();
#endif

/* Signal handler functions used to return an int value, which was ignored.
 * On newer systems, signal handlers are void functions.  Here, we try to
 * guess the proper return type for this system.
 */
#ifdef __STDC__
# define SIGTYPE void
#else
# if UNIXV
#  define SIGTYPE void		/* Note: This is wrong for SCO Xenix. */
# endif
#endif
#ifndef SIGTYPE
# define SIGTYPE int
#endif

/******************* Names of files and environment vars **********************/

#if ANY_UNIX
# ifndef TMPDIR
#   define TMPDIR	"/tmp"		/* directory where temp files live */
# endif
# ifndef PRSVDIR
#  define PRSVDIR	"/usr/preserve"	/* directory where preserved file live */
# endif
# ifndef PRSVINDEX
#  define PRSVINDEX	"/usr/preserve/Index" /* index of files in PRSVDIR */
# endif
# ifndef EXRC
#  define EXRC		".exrc"		/* init file in current directory */
# endif
# define SCRATCHOUT	"%s/soXXXXXX"	/* temp file used as input to filter */
# ifndef SHELL
#  define SHELL		"/bin/sh"	/* default shell */
# endif
# define gethome(x)	getenv("HOME")
#endif

#ifndef	TAGS
# define TAGS		"tags"		/* name of the tags file */
#endif

#ifndef TMPNAME
# define TMPNAME	"%s/elv_%x.%x"	/* format of names for temp files */
#endif

#ifndef EXINIT
# define EXINIT		"EXINIT"	/* name of EXINIT environment variable */
#endif

#ifndef	EXRC
# define EXRC		"elvis.rc"	/* name of ".exrc" file in current dir */
#endif

#ifndef HMEXRC
# define HMEXRC		EXRC		/* name of ".exrc" file in home dir */
#endif

#ifndef	KEYWORDPRG
# define KEYWORDPRG	"ref"
#endif

#ifndef	SCRATCHOUT
# define SCRATCHIN	"%s/SIXXXXXX"
# define SCRATCHOUT	"%s/SOXXXXXX"
#endif

#ifndef ERRLIST
# define ERRLIST	"errlist"
#endif

#ifndef	SLASH
# define SLASH		'/'
#endif

#ifndef SHELL
# define SHELL		"shell"
#endif

#ifndef REG
# define REG		register
#endif

#ifndef NEEDSYNC
# define NEEDSYNC	FALSE
#endif

#ifndef FILEPERMS
# define FILEPERMS	0666
#endif

#ifndef PRESERVE
# define PRESERVE	"elvprsv"	/* name of the "preserve" program */
#endif

#ifndef CC_COMMAND
# define CC_COMMAND	"cc -c"
#endif

#ifndef MAKE_COMMAND
# define MAKE_COMMAND	"make"
#endif

#ifndef REDIRECT
# define REDIRECT	"2>"
#endif

#ifndef BLKSIZE
# ifdef CRUNCH
#  define BLKSIZE	1024
# else
#  define BLKSIZE	4096
# endif
#endif

#ifndef KEYBUFSIZE
# define KEYBUFSIZE	1000
#endif

#ifndef MAILER
# define MAILER		"mail"
#endif

#ifndef gethome
extern char *gethome();
#endif

#endif  /* ndef _CONFIG_H */
