/* (C) 2004-2006 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#include <UnitTest++.h>
#include <ReportAssert.h>
#include <osgCal/Model>
#include <osg/MatrixTransform>
#include <osg/Projection>
#include <osgCal/CustomAssert>

#ifdef WIN32
#undef main
#endif

namespace osgCal {


  struct SubMeshSoftware
  {
    SubMeshSoftware();
    SubMeshSoftware(CalModel*, int, int);
    virtual ~SubMeshSoftware() {}
    void update();
    bool create();
  };

  SubMeshSoftware::SubMeshSoftware() {}
  SubMeshSoftware::SubMeshSoftware(CalModel*, int, int) {}
  void SubMeshSoftware::update() {}
  bool SubMeshSoftware::create() { return true;}

  struct SubMeshHardware
  {
    SubMeshHardware();
    SubMeshHardware(Model*, int);
    virtual ~SubMeshHardware() {}
    void update();
    bool InitHardwareMesh(int, osg::VertexProgram*, GlueCalHardwareModel*, unsigned int*, unsigned int, int);
  };
  SubMeshHardware::SubMeshHardware(){}
  SubMeshHardware::SubMeshHardware(Model*, int) {}
  void SubMeshHardware::update() {}
  bool SubMeshHardware::InitHardwareMesh(int, osg::VertexProgram*, GlueCalHardwareModel*, unsigned int*, unsigned int, int) { return true;}

  void CoreModel::garbageCollect() {}

  TextureLayersFlatten::TextureLayersFlatten() {}
  TextureLayersFlatten::~TextureLayersFlatten() {}
	void TextureLayersFlatten::init( int width,
                                   int height,
                                   std::vector<Layer> &layers,
                                   osg::Group *on,
                                   osg::Texture2D *myOutputTexture,
                                   osg::Texture2D *colorMask,
                                   osg::Texture2D *maskOn,
                                   osg::Texture2D *alphaPart,
                                   bool bUseOldLayersParams) {}
  void TextureLayersFlatten::flushTextureCacheForAllBRT() {}
  void TextureLayersFlatten::BaseRenderTechnic::setColorFactor(const osg::Vec3f& col) {}
  void TextureLayersFlatten::BaseRenderTechnic::setOpacity(float val) {}
  void TextureLayersFlatten::destroy() {}

  void InvertPremultipliedAlpha(osg::Image& image) {}

  bool CoreModel::SubUsingMeshId(int) { return true;}
  bool CoreModel::AddUsingMeshId(int) { return true;}

  std::vector<osg::ref_ptr<osg::Texture2D> >* CoreModel::getTextures2D(int ) { return 0;}
  bool CoreModel::getTexturesNameFromMaterialID(int _coreMaterialId, std::vector<std::string> &_res) {return true;}
}

struct MyModel : public osgCal::Model
{
  std::vector<osg::Vec3> pos;
  std::vector<osg::Vec3> normal;
  std::vector<char> mesh;
  int nbVertices;

  MyModel() {
    nbVertices = 6973;
    pos.resize(nbVertices);
    normal.resize(nbVertices);
    mesh.resize(nbVertices);
    int nbMesh = 34;
    for (int i = 0; i < nbVertices; i++ ) {
      pos[i] = osg::Vec3(1.0/(i+1),0,0);
      normal[i] = osg::Vec3(i,0,0);
      // setup the index mesh
      mesh[i] = (int) ((i * 1.0 / nbVertices) * nbMesh);
    }

    for (int i = 0; i < nbVertices/2; i++ ) {
      normal[i] = osg::Vec3(i,1,0);
    }

    for (int i = 0; i < nbVertices/3; i++ ) {
      normal[i] = osg::Vec3(i,0,1);
    }
  }

};

TEST_FIXTURE(MyModel, FixNormalHW1)
{
  fixNormalHW(nbVertices, &pos.front(), &normal.front(), &mesh.front(), 2);
}

TEST_FIXTURE(MyModel, FixNormalHW2)
{
  fixNormalHW(nbVertices, &pos.front(), &normal.front(), &mesh.front(), 0);
}

TEST_FIXTURE(MyModel, FixNormalHWBadArguments1)
{
  CHECK_ASSERT(fixNormalHW(0, &pos.front(), &normal.front(), &mesh.front(), 0));
}

TEST_FIXTURE(MyModel, FixNormalHWBadArguments2)
{
  CHECK_ASSERT(fixNormalHW(nbVertices, 0, &normal.front(), &mesh.front(), 0));
}

TEST_FIXTURE(MyModel, FixNormalHWBadArguments3)
{
  CHECK_ASSERT(fixNormalHW(nbVertices, &pos.front(), 0, &mesh.front(), 0));
}

TEST_FIXTURE(MyModel, FixNormalHWBadArguments4)
{
  CHECK_ASSERT(fixNormalHW(nbVertices, &pos.front(), &normal.front(), 0, 0));
}

void reportCustomAssert()
{
  std::string description = CustomAssert::Instance().GetDescription();
  std::string message = CustomAssert::Instance().GetMessage();
  std::string function = CustomAssert::Instance().GetFunction();
  std::string file = CustomAssert::Instance().GetFile();
  int line  = CustomAssert::Instance().GetLine();
  UnitTest::ReportAssert((description+" "+message).c_str(), (function+" "+file).c_str(), line);
}

int main(int argc, char *argv[])
{
  CustomAssert::Instance().SetHandler(reportCustomAssert);  
  return UnitTest::RunAllTests();
}
