/*
 *
 * Copyright (C) 2004-2006 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *
 */

#include "osgCal/CustomAssert"
#include <iostream>
#include <string>
#include <cassert>

CustomAssert* CustomAssert::sInstance = NULL;

void CustomAssert::CreateInstance()
{
  if (NULL == sInstance)
    {
      sInstance = new CustomAssert();
    }
}

void CustomAssert::DestroyInstance()
{
  if (NULL != sInstance)
    {
      delete(sInstance);
      sInstance = NULL;
    }
}

CustomAssert& CustomAssert::Instance()
{
  if (NULL == sInstance)
    CustomAssert::CreateInstance();
  return *sInstance;
}
CustomAssert::CustomAssert() : mHandler(&CustomAssert::DefaultHandler), mDescription(""), mFile(""), mFunction(""), mLine(-1), mMessage("")

{
}
void CustomAssert::SetHandler(void (&handler)())
{
  mHandler = handler;
}

bool CustomAssert::Check(bool condition, const char* description, const char* file, const char* function, int line, const char* message)
{
  if (condition == false)
    {
      mDescription = description;
      mMessage = message;
      mFile = file;
      mFunction = function;
      mLine = line;
      mMessage = message;
      mHandler();
    }
  return condition;
}
const char* CustomAssert::GetDescription() const
{
  return mDescription;
}
const char* CustomAssert::GetMessage() const
{
  return mMessage;
}
const char* CustomAssert::GetFile() const
{
  return mFile;
}
const char* CustomAssert::GetFunction() const
{
  return mFunction;
}
const int CustomAssert::GetLine() const
{
  return mLine;
}

CustomAssert::HANDLER CustomAssert::GetHandler() const
{
  return *mHandler;
}

#define ABORT *((char*)0) = 0;
void CustomAssert::DefaultHandler()
{
  std::string description = CustomAssert::Instance().GetDescription();
  std::string message = CustomAssert::Instance().GetMessage();
  std::string function = CustomAssert::Instance().GetFunction();
  std::string file = CustomAssert::Instance().GetFile();
  int line  = CustomAssert::Instance().GetLine();
  std::cout << "*CustomAssert* " << description << " " << message << " " << function << ":" << file << ":" << line << std::endl;
  ABORT;
}

