/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
* Author:
*  Igor Kravtchenko <igor@obraz.net>
*
* Description:
* Class to load GIF, it's currently a changed version of a code that loaded GIF
* with RGB promotion (without keeping the palette).  This version keeps the image
* as set of index inside a 256 colors palette.  Would need to handle both case
* at will with some user options, color index depth, etc.
*
*/

#ifndef GIFLOADER_H
#define GIFLOADER_H

class GIFImage : public osg::Image {
public:

	GIFImage();
	virtual ~GIFImage();

	class Color {
	public:
		unsigned char r, g, b;
	};

	void setPalette(int nbColors, Color *);
	virtual Color* getPalette() { return palette_; }

	int getNbColors() const { return nbColors_; }

	// -1 means for no transparence
	virtual void setTransparence(int _col) { transparence_ = _col; }
	virtual int getTransparentColor() const { return transparence_; }

protected:
	int transparence_;
	int nbColors_;
	Color *palette_;
};

#endif
