/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Header;
import org.javagroups.JChannel;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.View;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.log.Trace;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PerfTest
implements MessageListener,
MembershipListener {
    static final String HDRNAME = "PerfHeaderName";
    HashMap data;
    Vector mbrs;
    String props;
    PullPushAdapter adapter;
    JChannel ch;
    boolean sender;
    long sleep_time;
    boolean busy_sleep;
    int num_bursts;
    int num_msgs_per_burst;
    int msg_size;
    byte[] buf;
    long sent_msgs;

    /*
     * Exception decompiling
     */
    public void start() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 71->75)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void mainLoop() throws Exception {
        boolean looping = true;
        while (looping) {
            int choice = this.choice();
            switch (choice) {
                case 113: 
                case 120: {
                    looping = false;
                    break;
                }
                case 115: {
                    MyHeader hdr = new MyHeader(2, this.num_bursts * this.num_msgs_per_burst);
                    Message start_msg = new Message(null, null, null);
                    start_msg.putHeader(HDRNAME, hdr);
                    this.adapter.send(start_msg);
                    break;
                }
                case 99: {
                    Message clear_msg = new Message();
                    clear_msg.putHeader(HDRNAME, new MyHeader(3, 0));
                    this.adapter.send(clear_msg);
                    break;
                }
                case 116: {
                    this.printStats();
                    break;
                }
                case 112: {
                    this.printParams();
                    break;
                }
                case 118: {
                    System.out.println("-- view: " + this.ch.getView());
                    break;
                }
                case 97: {
                    this.printStatsForAllSenders();
                    break;
                }
            }
        }
    }

    private final void printStatsForAllSenders() {
        long start_time = 0L;
        long stop_time = 0L;
        int num_msgs = 0;
        int num_senders = 0;
        Iterator it = this.data.values().iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            if (entry.num_received <= 0) continue;
            num_msgs += entry.num_received;
            ++num_senders;
            start_time = start_time == 0L ? entry.start : Math.min(start_time, entry.start);
            stop_time = stop_time == 0L ? entry.stop : Math.max(stop_time, entry.stop);
        }
        long total_time = stop_time - start_time;
        StringBuffer sb = new StringBuffer();
        sb.append("total number of messages sent by me: ").append(this.sent_msgs).append("\n");
        sb.append("total number of messages received: ").append(num_msgs).append("\n");
        sb.append("total number of senders: ").append(num_senders).append("\n");
        sb.append("total time: ").append(total_time).append(" ms\n");
        sb.append("msgs/sec: ").append((double)num_msgs / ((double)total_time / 1000.0)).append("\n");
        sb.append("throughput (kb/sec): ").append((double)(num_msgs * this.msg_size) / 1000.0 / ((double)total_time / 1000.0)).append("\n");
        System.out.println(sb.toString());
    }

    private final void printParams() {
        System.out.println("num_bursts: " + this.num_bursts + "\nnum_msgs_per_burst: " + this.num_msgs_per_burst + "\nmsg_size: " + this.msg_size + "\nsleep_time: " + this.sleep_time + "\nsender: " + this.sender);
    }

    private final void printStats() {
        Iterator it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            System.out.println("stats for " + entry.getKey());
            System.out.println(((Entry)entry.getValue()).printStats() + '\n');
        }
    }

    void sendMessages() {
        int seqno = 0;
        if (!this.sender) {
            System.out.println("-- I'm not a sender; will not send messages");
            return;
        }
        System.out.println("-- sending " + this.num_bursts * this.num_msgs_per_burst + " msgs");
        this.sent_msgs = 0L;
        try {
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < this.num_bursts) {
                int j = 0;
                while (j < this.num_msgs_per_burst) {
                    MyHeader hdr = new MyHeader(1, seqno++);
                    Message msg = new Message(null, null, this.buf);
                    msg.putHeader(HDRNAME, hdr);
                    this.adapter.send(msg);
                    ++this.sent_msgs;
                    if (this.sent_msgs % 100L == 0L) {
                        System.out.println("++ sent " + this.sent_msgs);
                    }
                    ++j;
                }
                Util.sleep(this.sleep_time);
                ++i;
            }
            long stop = System.currentTimeMillis();
            System.out.println("-- sent " + this.num_bursts * this.num_msgs_per_burst + " msgs (in " + (stop - start) + " ms)");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    int choice() throws Exception {
        System.out.println("s=send, c=clear, t=print stats, p=print parameters v=view, a=times for all messages, q=quit\nChoice: ");
        System.out.flush();
        System.in.skip(System.in.available());
        int c = System.in.read();
        System.out.flush();
        return c;
    }

    public void receive(Message msg) {
        Address sender = msg.getSrc();
        MyHeader hdr = (MyHeader)msg.removeHeader(HDRNAME);
        if (hdr == null) {
            System.err.println("-- error: header was null");
            return;
        }
        switch (hdr.type) {
            case 2: {
                this.updateTimestamp();
                new Thread(this){
                    final /* synthetic */ PerfTest this$0;

                    public final void run() {
                        this.this$0.sendMessages();
                    }
                    {
                        this.this$0 = perfTest;
                    }
                }.start();
                break;
            }
            case 1: {
                Entry entry = (Entry)this.data.get(sender);
                if (entry == null) {
                    System.err.println("-- received a message from " + sender + ", who is not in the list");
                    break;
                }
                entry.add(hdr.seqno);
                if (hdr.seqno % 100 == 0) {
                    System.out.println("-- received " + sender + ':' + hdr.seqno);
                }
                if (entry.getNumReceived() < this.num_bursts * this.num_msgs_per_burst || !entry.done()) break;
                System.out.println("*--* " + sender + " DONE");
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.clear();
                break;
            }
        }
    }

    private final void updateTimestamp() {
        Iterator it = this.data.values().iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            entry.start = System.currentTimeMillis();
        }
    }

    void clear() {
        System.out.println("-- clearing the data");
        this.data.clear();
        int i = 0;
        while (i < this.mbrs.size()) {
            this.data.put(this.mbrs.elementAt(i), new Entry(this.num_bursts * this.num_msgs_per_burst));
            ++i;
        }
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view.getMembers());
        this.mbrs.clear();
        this.mbrs.addAll(new_view.getMembers());
        this.clear();
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public static void main(String[] args) {
        String props = null;
        int num_bursts = 100;
        int num_msgs_per_burst = 10;
        long sleep_time = 10L;
        int msg_size = 10000;
        boolean sender = true;
        Trace.init();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-props")) {
                props = args[++i];
            } else if (args[i].equals("-num_bursts")) {
                num_bursts = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-num_msgs_per_burst")) {
                num_msgs_per_burst = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-sleep_time")) {
                sleep_time = Long.parseLong(args[++i]);
            } else if (args[i].equals("-msg_size")) {
                msg_size = Integer.parseInt(args[++i]);
            } else if (args[i].equals("-sender")) {
                sender = new Boolean(args[++i]);
            } else {
                PerfTest.help();
                return;
            }
            ++i;
        }
        try {
            PerfTest t = new PerfTest(props, num_bursts, num_msgs_per_burst, msg_size, sleep_time, sender);
            t.start();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("PerfTest [-help] [-props <properties>] [-num_bursts <num>] [-num_msgs_per_burst <num>] [-sleep_time <number of msecs>] [-msg_size <bytes>] [-sender <true/false>]");
    }

    private final /* synthetic */ void this() {
        this.data = new HashMap();
        this.mbrs = new Vector();
        this.props = null;
        this.adapter = null;
        this.ch = null;
        this.sender = true;
        this.sleep_time = 10L;
        this.busy_sleep = false;
        this.num_bursts = 100;
        this.num_msgs_per_burst = 10;
        this.msg_size = 10000;
        this.buf = null;
        this.sent_msgs = 0L;
    }

    public PerfTest(String props, int num_bursts, int num_msgs_per_burst, int msg_size, long sleep_time, boolean sender) {
        this.this();
        this.props = props;
        this.num_bursts = num_bursts;
        this.num_msgs_per_burst = num_msgs_per_burst;
        this.msg_size = msg_size;
        this.sleep_time = sleep_time;
        this.buf = new byte[msg_size];
        this.sender = sender;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class MyHeader
    extends Header {
        public static final int DATA = 1;
        public static final int START = 2;
        public static final int CLEAR = 3;
        public static final int DONE = 4;
        int type;
        int seqno;

        public long size() {
            return 16L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            switch (this.type) {
                case 1: {
                    sb.append("DATA (seqno=").append(this.seqno).append(")");
                    break;
                }
                case 2: {
                    sb.append("START");
                    break;
                }
                case 3: {
                    sb.append("CLEAR");
                    break;
                }
                default: {
                    sb.append("<n/a>");
                    break;
                }
            }
            return sb.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeInt(this.seqno);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.seqno = in.readInt();
        }

        private final /* synthetic */ void this() {
            this.type = 0;
            this.seqno = -1;
        }

        public MyHeader() {
            this.this();
        }

        public MyHeader(int type, int seqno) {
            this.this();
            this.type = type;
            this.seqno = seqno;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Entry {
        long start;
        long stop;
        int num_received;
        int[] seqnos;

        void add(int seqno) {
            if (this.seqnos != null) {
                this.seqnos[seqno] = seqno;
            }
            ++this.num_received;
            if (this.num_received >= this.seqnos.length && this.done()) {
                this.stop = System.currentTimeMillis();
            }
        }

        boolean done() {
            if (this.seqnos == null) {
                return false;
            }
            int i = 0;
            while (i < this.seqnos.length) {
                if (this.seqnos[i] < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        int getNumReceived() {
            return this.num_received;
        }

        int getRealReceived() {
            int num = 0;
            if (this.seqnos == null) {
                return 0;
            }
            int i = 0;
            while (i < this.seqnos.length) {
                if (this.seqnos[i] > -1) {
                    ++num;
                }
                ++i;
            }
            return num;
        }

        String printStats() {
            StringBuffer sb = new StringBuffer();
            sb.append("done=").append(this.done()).append("\n");
            sb.append("number of messages received: ").append(this.getRealReceived()).append("\n");
            sb.append("total time: ").append(this.stop - this.start).append(" ms\n");
            sb.append("msgs/sec: ").append((double)this.getRealReceived() / ((double)(this.stop - this.start) / 1000.0)).append("\n");
            sb.append("throughput (kb/sec): ").append((double)(this.getRealReceived() * PerfTest.this.msg_size) / 1000.0 / ((double)(this.stop - this.start) / 1000.0)).append("\n");
            return sb.toString();
        }

        private final /* synthetic */ void this() {
            this.start = 0L;
            this.stop = 0L;
            this.num_received = 0;
            this.seqnos = null;
        }

        Entry(int num) {
            this.this();
            this.seqnos = new int[num];
            int i = 0;
            while (i < this.seqnos.length) {
                this.seqnos[i] = -1;
                ++i;
            }
            this.start = System.currentTimeMillis();
        }
    }
}

