/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.javagroups.protocols.pbcast.Digest;
import org.javagroups.stack.IpAddress;

public class DigestTest
extends TestCase {
    Digest d;
    IpAddress a1;
    IpAddress a2;
    IpAddress a3;
    static /* synthetic */ Class class$org$javagroups$tests$DigestTest;

    public void setUp() {
        this.d = new Digest(3);
        this.a1 = new IpAddress(5555);
        this.a2 = new IpAddress(6666);
        this.a3 = new IpAddress(7777);
        this.d.add(this.a1, 4, 500L, 501L);
        this.d.add(this.a2, 25L, 26L, 26L);
        this.d.add(this.a3, 20L, 25L, 33L);
    }

    public void tearDown() {
    }

    public void testConstructor() {
        boolean bl = false;
        if (this.d.size() == 3) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        this.d.reset(2);
        boolean bl2 = false;
        if (this.d.size() == 2) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        this.d.reset(4);
        boolean bl3 = false;
        if (this.d.size() == 4) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
    }

    public void testConstructor2() {
        Digest dd = new Digest(3);
        boolean bl = false;
        if (dd.lowSeqnoAt(0) == 0L) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (dd.highSeqnoAt(0) == 0L) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        boolean bl3 = false;
        if (dd.highSeqnoSeenAt(0) == (long)-1) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
    }

    public void testGetIndex() {
        boolean bl = false;
        if (this.d.getIndex(this.a1) == 0) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (this.d.getIndex(this.a3) == 2) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
    }

    public void testContains() {
        DigestTest.assertTrue((boolean)this.d.contains(this.a2));
    }

    public void testSenderAt() {
        DigestTest.assertTrue((boolean)this.d.senderAt(2).equals(this.a3));
    }

    public void testResetAt() {
        this.d.resetAt(0);
        boolean bl = false;
        if (this.d.lowSeqnoAt(0) == 0L) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (this.d.highSeqnoAt(0) == 0L) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        boolean bl3 = false;
        if (this.d.highSeqnoSeenAt(0) == (long)-1) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
    }

    public void testLowSeqnoAt() {
        boolean bl = false;
        if (this.d.lowSeqnoAt(0) == (long)4) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (this.d.lowSeqnoAt(1) == 25L) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        boolean bl3 = false;
        if (this.d.lowSeqnoAt(2) == 20L) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
    }

    public void testHighSeqnoAt() {
        boolean bl = false;
        if (this.d.highSeqnoAt(0) == 500L) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (this.d.highSeqnoAt(1) == 26L) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        boolean bl3 = false;
        if (this.d.highSeqnoAt(2) == 25L) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
    }

    public void testHighSeqnoSeenAt() {
        boolean bl = false;
        if (this.d.highSeqnoSeenAt(0) == 501L) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (this.d.highSeqnoSeenAt(1) == 26L) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        boolean bl3 = false;
        if (this.d.highSeqnoSeenAt(2) == 33L) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
    }

    public void testCopy() {
        this.d = this.d.copy();
        this.testLowSeqnoAt();
        this.testHighSeqnoAt();
        this.testHighSeqnoSeenAt();
        this.testGetIndex();
        this.testContains();
        this.testSenderAt();
        this.testResetAt();
    }

    public void testNonConflictingMerge() {
        Digest cons_d = new Digest(5);
        IpAddress ip1 = new IpAddress(1111);
        IpAddress ip2 = new IpAddress(2222);
        cons_d.add(ip1, 1L, 10L, 10L);
        cons_d.add(ip2, 2, 20L, 20L);
        cons_d.merge(this.d);
        boolean bl = false;
        if (cons_d.getIndex(ip1) == 0) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (cons_d.getIndex(ip2) == 1) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        boolean bl3 = false;
        if (cons_d.getIndex(this.a1) == 2) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
        boolean bl4 = false;
        if (cons_d.getIndex(this.a2) == 3) {
            bl4 = true;
        }
        DigestTest.assertTrue((boolean)bl4);
        boolean bl5 = false;
        if (cons_d.getIndex(this.a3) == 4) {
            bl5 = true;
        }
        DigestTest.assertTrue((boolean)bl5);
        boolean bl6 = false;
        if (cons_d.lowSeqnoAt(0) == 1L) {
            bl6 = true;
        }
        DigestTest.assertTrue((boolean)bl6);
        boolean bl7 = false;
        if (cons_d.lowSeqnoAt(1) == (long)2) {
            bl7 = true;
        }
        DigestTest.assertTrue((boolean)bl7);
        boolean bl8 = false;
        if (cons_d.lowSeqnoAt(2) == (long)4) {
            bl8 = true;
        }
        DigestTest.assertTrue((boolean)bl8);
        boolean bl9 = false;
        if (cons_d.lowSeqnoAt(3) == 25L) {
            bl9 = true;
        }
        DigestTest.assertTrue((boolean)bl9);
        boolean bl10 = false;
        if (cons_d.lowSeqnoAt(4) == 20L) {
            bl10 = true;
        }
        DigestTest.assertTrue((boolean)bl10);
        boolean bl11 = false;
        if (cons_d.highSeqnoAt(0) == 10L) {
            bl11 = true;
        }
        DigestTest.assertTrue((boolean)bl11);
        boolean bl12 = false;
        if (cons_d.highSeqnoAt(1) == 20L) {
            bl12 = true;
        }
        DigestTest.assertTrue((boolean)bl12);
        boolean bl13 = false;
        if (cons_d.highSeqnoAt(2) == 500L) {
            bl13 = true;
        }
        DigestTest.assertTrue((boolean)bl13);
        boolean bl14 = false;
        if (cons_d.highSeqnoAt(3) == 26L) {
            bl14 = true;
        }
        DigestTest.assertTrue((boolean)bl14);
        boolean bl15 = false;
        if (cons_d.highSeqnoAt(4) == 25L) {
            bl15 = true;
        }
        DigestTest.assertTrue((boolean)bl15);
        boolean bl16 = false;
        if (cons_d.highSeqnoSeenAt(0) == 10L) {
            bl16 = true;
        }
        DigestTest.assertTrue((boolean)bl16);
        boolean bl17 = false;
        if (cons_d.highSeqnoSeenAt(1) == 20L) {
            bl17 = true;
        }
        DigestTest.assertTrue((boolean)bl17);
        boolean bl18 = false;
        if (cons_d.highSeqnoSeenAt(2) == 501L) {
            bl18 = true;
        }
        DigestTest.assertTrue((boolean)bl18);
        boolean bl19 = false;
        if (cons_d.highSeqnoSeenAt(3) == 26L) {
            bl19 = true;
        }
        DigestTest.assertTrue((boolean)bl19);
        boolean bl20 = false;
        if (cons_d.highSeqnoSeenAt(4) == 33L) {
            bl20 = true;
        }
        DigestTest.assertTrue((boolean)bl20);
    }

    public void testConflictingMerge() {
        Digest new_d = new Digest(2);
        new_d.add(this.a1, 5, 450L, 501L);
        new_d.add(this.a3, 18L, 28L, 35L);
        this.d.merge(new_d);
        boolean bl = false;
        if (this.d.lowSeqnoAt(0) == (long)4) {
            bl = true;
        }
        DigestTest.assertTrue((boolean)bl);
        boolean bl2 = false;
        if (this.d.highSeqnoAt(0) == 500L) {
            bl2 = true;
        }
        DigestTest.assertTrue((boolean)bl2);
        boolean bl3 = false;
        if (this.d.highSeqnoSeenAt(0) == 501L) {
            bl3 = true;
        }
        DigestTest.assertTrue((boolean)bl3);
        boolean bl4 = false;
        if (this.d.lowSeqnoAt(1) == 25L) {
            bl4 = true;
        }
        DigestTest.assertTrue((boolean)bl4);
        boolean bl5 = false;
        if (this.d.highSeqnoAt(1) == 26L) {
            bl5 = true;
        }
        DigestTest.assertTrue((boolean)bl5);
        boolean bl6 = false;
        if (this.d.highSeqnoSeenAt(1) == 26L) {
            bl6 = true;
        }
        DigestTest.assertTrue((boolean)bl6);
        boolean bl7 = false;
        if (this.d.lowSeqnoAt(2) == 18L) {
            bl7 = true;
        }
        DigestTest.assertTrue((boolean)bl7);
        boolean bl8 = false;
        if (this.d.highSeqnoAt(2) == 28L) {
            bl8 = true;
        }
        DigestTest.assertTrue((boolean)bl8);
        boolean bl9 = false;
        if (this.d.highSeqnoSeenAt(2) == 35L) {
            bl9 = true;
        }
        DigestTest.assertTrue((boolean)bl9);
    }

    public static Test suite() {
        Class clazz = class$org$javagroups$tests$DigestTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$DigestTest = DigestTest.class$("[Lorg.javagroups.tests.DigestTest;", false);
        }
        TestSuite s = new TestSuite(clazz);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DigestTest.suite());
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DigestTest(String name) {
        super(name);
    }
}

