/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.TransportedVectorTime;
import org.javagroups.protocols.VectorTime;
import org.javagroups.stack.Protocol;

public class CAUSAL
extends Protocol {
    private VectorTime localVector;
    private LinkedList delayQueue;
    private Address localAddress;

    private final void addToDelayQueue(TransportedVectorTime tvt) {
        ListIterator i = this.delayQueue.listIterator(0);
        TransportedVectorTime current = null;
        while (i.hasNext()) {
            current = (TransportedVectorTime)i.next();
            if (!tvt.lessThanOrEqual(current)) continue;
            this.delayQueue.add(i.previousIndex(), tvt);
            return;
        }
        this.delayQueue.add(tvt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                Message causalMsg = new Message(msg.getDest(), msg.getSrc(), msg);
                CAUSAL cAUSAL = this;
                synchronized (cAUSAL) {
                    this.localVector.increment();
                    causalMsg.putHeader(this.getName(), new CausalHeader(this.localVector.getTransportedVectorTime()));
                }
                this.passDown(new Event(1, causalMsg));
                return;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.localVector = new VectorTime(this.localAddress);
                this.delayQueue = new LinkedList();
                break;
            }
            case 6: {
                Vector newViewMembers = ((View)evt.getArg()).getMembers();
                this.localVector.merge((Vector)newViewMembers.clone());
                this.localVector.reset();
                break;
            }
            case 1: {
                Header obj = null;
                Message msg = (Message)evt.getArg();
                obj = msg.getHeader(this.getName());
                if (!(obj instanceof CausalHeader)) {
                    Trace.error("CAUSAL", "NO CAUSAL.Header found");
                    this.passUp(evt);
                    return;
                }
                CausalHeader header = (CausalHeader)obj;
                TransportedVectorTime messageVector = header.getVectorTime();
                CAUSAL cAUSAL = this;
                synchronized (cAUSAL) {
                    if (this.localVector.isCausallyNext(messageVector)) {
                        this.passUp(new Event(1, msg.getObject()));
                        this.localVector.max(messageVector);
                    } else {
                        messageVector.setAssociatedMessage(msg);
                        this.addToDelayQueue(messageVector);
                    }
                    TransportedVectorTime queuedVector = null;
                    while (true) {
                        if (this.delayQueue.size() <= 0 || !this.localVector.isCausallyNext(queuedVector = (TransportedVectorTime)this.delayQueue.getFirst())) {
                            return;
                        }
                        this.delayQueue.remove(queuedVector);
                        this.passUp(new Event(1, queuedVector.getAssociatedMessage().getObject()));
                        this.localVector.max(queuedVector);
                    }
                }
            }
        }
        this.passUp(evt);
    }

    public String getName() {
        return "CAUSAL";
    }

    public static class CausalHeader
    extends Header {
        private TransportedVectorTime t;

        public TransportedVectorTime getVectorTime() {
            return this.t;
        }

        public long size() {
            return 231 + this.t.size() * 4;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.t);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.t = (TransportedVectorTime)in.readObject();
        }

        public String toString() {
            return "[CAUSALHEADER:" + this.t + ']';
        }

        public CausalHeader() {
        }

        public CausalHeader(TransportedVectorTime timeVector) {
            this.t = timeVector;
        }
    }
}

