/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos.wb;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.blocks.MethodCall;
import org.javagroups.demos.wb.Node;
import org.javagroups.demos.wb.SendDialog;
import org.javagroups.demos.wb.Whiteboard;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GraphPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    Whiteboard wb;
    Vector nodes;
    Vector copy;
    String myname;
    public Object my_addr;
    Node pick;
    boolean pickfixed;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    final Color fixedColor;
    final Color selectColor;
    final Color nodeColor;
    final Font default_font;

    private final Frame findParent() {
        Container retval = this.getParent();
        while (retval != null) {
            if (retval instanceof Frame) {
                return (Frame)retval;
            }
            retval = retval.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Node findNodeAtPoint(Point p) {
        int x = p.x;
        int y = p.y;
        Vector vector = this.nodes;
        synchronized (vector) {
            if (this.nodes.size() < 1) {
                return null;
            }
            int i = this.nodes.size() - 1;
            while (i >= 0) {
                Node n = (Node)this.nodes.elementAt(i);
                if (x >= n.xloc && x <= n.xloc + n.width && y >= n.yloc && y <= n.yloc + n.height) {
                    return n;
                }
                --i;
            }
            return null;
        }
    }

    public void addNode(String lbl, Address addr, int xloc, int yloc) {
        Node n = new Node();
        n.x = xloc;
        n.y = yloc;
        n.lbl = lbl;
        n.addr = addr;
        this.nodes.addElement(n);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeNode(Object addr) {
        if (addr == null) {
            System.err.println("removeNode(): address of node to be removed is null !");
            return;
        }
        Vector vector = this.nodes;
        synchronized (vector) {
            int i = 0;
            while (i < this.nodes.size()) {
                Node n = (Node)this.nodes.elementAt(i);
                Address a = n.addr;
                if (a != null && addr.equals(a)) {
                    this.nodes.removeElement(n);
                    System.out.println("Removed node " + n);
                    break;
                }
                ++i;
            }
            this.repaint();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void adjustNodes(Vector v) {
        boolean removed = false;
        Vector vector = this.nodes;
        synchronized (vector) {
            int i = 0;
            while (true) {
                if (i >= this.nodes.size()) {
                    if (removed) {
                        this.repaint();
                    }
                    return;
                }
                Node n = (Node)this.nodes.elementAt(i);
                if (!v.contains(n.addr)) {
                    System.out.println("adjustNodes(): node " + n + " was removed");
                    this.nodes.removeElement(n);
                    removed = true;
                }
                ++i;
            }
        }
    }

    public void paintNode(Graphics g, Node n, FontMetrics fm) {
        String addr = n.addr != null ? n.addr.toString() : null;
        int x = (int)n.x;
        int y = (int)n.y;
        g.setColor(n == this.pick ? this.selectColor : (n.fixed ? this.fixedColor : this.nodeColor));
        int w = fm.stringWidth(n.lbl) + 10;
        if (addr != null) {
            w = Math.max(w, fm.stringWidth(addr) + 10);
        }
        if (addr == null) {
            addr = "<no address>";
        }
        int h = (fm.getHeight() + 4) * 2;
        n.width = w;
        n.height = h;
        n.xloc = x - w / 2;
        n.yloc = y - h / 2;
        g.fillRect(x - w / 2, y - h / 2, w, h);
        g.setColor(Color.black);
        g.drawRect(x - w / 2, y - h / 2, w - 1, h - 1);
        g.drawString(n.lbl, x - (w - 10) / 2, y - (h - 4) / 2 + fm.getAscent());
        g.drawString(addr, x - (w - 10) / 2, y - (h - 4) / 2 + 2 * fm.getAscent() + 4);
    }

    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.default_font);
        }
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        FontMetrics fm = this.offgraphics.getFontMetrics();
        int i = 0;
        while (i < this.nodes.size()) {
            this.paintNode(this.offgraphics, (Node)this.nodes.elementAt(i), fm);
            ++i;
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        int mod = e.getModifiers();
        if (this.pick == null) {
            return;
        }
        this.pick.x = p.x;
        this.pick.y = p.y;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        double bestdist = Double.MAX_VALUE;
        int mod = e.getModifiers();
        if ((mod & 4) != 0) {
            System.out.println("\nright button at " + p);
            Node n = this.findNodeAtPoint(p);
            if (n != null) {
                System.out.println("Found node at " + p + ": " + n);
                SendDialog dlg = new SendDialog(this.findParent(), n, this.myname, this.wb.disp, this.wb.groupname);
                this.repaint();
            }
            e.consume();
            return;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            Node n = (Node)this.nodes.elementAt(i);
            double dist = (n.x - (double)p.x) * (n.x - (double)p.x) + (n.y - (double)p.y) * (n.y - (double)p.y);
            if (dist < bestdist) {
                this.pick = n;
                bestdist = dist;
            }
            ++i;
        }
        this.pickfixed = this.pick.fixed;
        this.pick.fixed = true;
        this.pick.x = p.x;
        this.pick.y = p.y;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        Point p = e.getPoint();
        int mod = e.getModifiers();
        if (this.pick == null) {
            return;
        }
        this.pick.x = p.x;
        this.pick.y = p.y;
        this.pick.fixed = this.pickfixed;
        try {
            this.wb.disp.callRemoteMethods(null, "moveNode", this.pick, 2, 0L);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.pick = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void start(String name) {
        this.myname = name;
        int xloc = (int)(10.0 + 250.0 * Math.random());
        int yloc = (int)(10.0 + 250.0 * Math.random());
        try {
            MethodCall call = new MethodCall("addNode");
            call.addArg(name);
            call.addArg(this.my_addr);
            call.addArg(new Integer(xloc));
            call.addArg(new Integer(yloc));
            this.wb.disp.callRemoteMethods(null, call, 2, 0L);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.repaint();
    }

    public void stop() {
        this.nodes.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState() {
        this.copy.removeAllElements();
        Vector vector = this.nodes;
        synchronized (vector) {
            int i = 0;
            while (i < this.nodes.size()) {
                this.copy.addElement(this.nodes.elementAt(i));
                ++i;
            }
            return;
        }
    }

    public byte[] getState() {
        try {
            return Util.objectToByteBuffer(this.copy);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setState(byte[] data) {
        Object new_state;
        try {
            new_state = Util.objectFromByteBuffer(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Vector vector = this.nodes;
        synchronized (vector) {
            block7: {
                this.nodes.removeAllElements();
                if (new_state == null) break block7;
                Vector n = (Vector)new_state;
                int i = 0;
                while (true) {
                    if (i >= n.size()) {
                        this.repaint();
                        break;
                    }
                    this.nodes.addElement(n.elementAt(i));
                    ++i;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveNode(Node n) {
        boolean changed = false;
        Vector vector = this.nodes;
        synchronized (vector) {
            int i = 0;
            while (i < this.nodes.size()) {
                Node tmp = (Node)this.nodes.elementAt(i);
                if (n.addr.equals(tmp.addr)) {
                    tmp.x = n.x;
                    tmp.y = n.y;
                    changed = true;
                    break;
                }
                ++i;
            }
            if (changed) {
                this.repaint();
            }
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.nodes = new Vector();
        this.copy = new Vector();
        this.myname = null;
        this.my_addr = null;
        this.fixedColor = Color.red;
        this.selectColor = Color.pink;
        this.nodeColor = new Color(250, 220, 100);
        this.default_font = new Font("Helvetica", 0, 12);
    }

    public GraphPanel(Whiteboard wb) {
        this.this();
        this.wb = wb;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

