/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.Serializable;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.ChannelClosedException;
import org.javagroups.ChannelNotConnectedException;
import org.javagroups.Event;
import org.javagroups.MembershipListener;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.SuspectedException;
import org.javagroups.TimeoutException;
import org.javagroups.Transport;
import org.javagroups.UpHandler;
import org.javagroups.View;
import org.javagroups.blocks.GroupRequest;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.blocks.RequestCorrelator;
import org.javagroups.blocks.RequestHandler;
import org.javagroups.blocks.RspCollector;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Rsp;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MessageDispatcher
implements RequestHandler {
    protected Channel channel;
    protected RequestCorrelator corr;
    protected MessageListener msg_listener;
    protected MembershipListener membership_listener;
    protected RequestHandler req_handler;
    protected ProtocolAdapter prot_adapter;
    protected TransportAdapter transport_adapter;
    protected Vector members;
    protected Address local_addr;
    protected boolean deadlock_detection;
    protected PullPushAdapter adapter;
    protected Serializable id;

    public void setDeadlockDetection(boolean flag) {
        this.deadlock_detection = flag;
        this.corr.setDeadlockDetection(flag);
    }

    public void finalize() {
        this.stop();
    }

    public void start() {
        if (this.corr == null) {
            this.corr = this.transport_adapter != null ? new RequestCorrelator("MessageDispatcher", this.transport_adapter, this, this.deadlock_detection, this.local_addr) : new RequestCorrelator("MessageDispatcher", this.prot_adapter, this, this.deadlock_detection, this.local_addr);
            this.corr.start();
        }
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
            this.corr = null;
        }
    }

    public void setMessageListener(MessageListener l) {
        this.msg_listener = l;
    }

    public void setMembershipListener(MembershipListener l) {
        this.membership_listener = l;
    }

    public void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        block7: {
            if (this.channel != null) {
                this.channel.send(msg);
            } else if (this.adapter != null) {
                try {
                    if (this.id != null) {
                        this.adapter.send(this.id, msg);
                        break block7;
                    }
                    this.adapter.send(msg);
                }
                catch (Throwable ex) {
                    Trace.error("MessageDispatcher.send()", "exception=" + Util.print(ex));
                }
            } else {
                Trace.error("MessageDispatcher.send()", "channel == null");
            }
        }
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        GroupRequest _req = null;
        Vector real_dests = dests != null ? (Vector)dests.clone() : (this.members != null ? (Vector)this.members.clone() : null);
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(new Boolean(false))) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null && real_dests != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if ((real_dests == null || real_dests.size() == 0) && Trace.trace) {
            Trace.info("MessageDispatcher.castMessage()", "destination list is empty, won't send message");
            return new RspList();
        }
        _req = new GroupRequest(msg, this.corr, real_dests, mode, timeout, 0);
        _req.execute();
        return _req.getResults();
    }

    public void castMessage(Vector dests, long req_id, Message msg, RspCollector coll) {
        if (msg == null) {
            Trace.error("MessageDispatcher.castMessage()", "request is null");
            return;
        }
        if (coll == null) {
            Trace.error("MessageDispatcher.castMessage()", "response collector is null (must be non-null)");
            return;
        }
        Vector real_dests = dests != null ? (Vector)dests.clone() : (Vector)this.members.clone();
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(new Boolean(false))) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if (real_dests.size() == 0 && Trace.trace) {
            Trace.info("MessageDispatcher.castMessage()", "destination list is empty, won't send message");
            return;
        }
        this.corr.sendRequest(req_id, real_dests, msg, coll);
    }

    public void done(long req_id) {
        this.corr.done(req_id);
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Rsp rsp;
        Vector<Address> mbrs = new Vector<Address>();
        RspList rsp_list = null;
        Address dest = msg.getDest();
        GroupRequest _req = null;
        if (dest == null) {
            Trace.error("MessageProtocol.sendMessage()", "the message's destination is null, cannot send message");
            return null;
        }
        mbrs.addElement(dest);
        _req = new GroupRequest(msg, this.corr, mbrs, mode, timeout, 0);
        _req.execute();
        if (mode == 6) {
            return null;
        }
        rsp_list = _req.getResults();
        if (rsp_list.size() == 0) {
            Trace.warn("MessageProtocol.sendMessage()", " response list is empty");
            return null;
        }
        if (rsp_list.size() > 1) {
            Trace.warn("MessageProtocol.sendMessage()", "response list contains more that 1 response; returning first response !");
        }
        if ((rsp = (Rsp)rsp_list.elementAt(0)).wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException();
        }
        return rsp.getValue();
    }

    public Object handle(Message msg) {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.channel = null;
        this.corr = null;
        this.msg_listener = null;
        this.membership_listener = null;
        this.req_handler = null;
        this.prot_adapter = null;
        this.transport_adapter = null;
        this.members = new Vector();
        this.local_addr = null;
        this.deadlock_detection = true;
        this.adapter = null;
        this.id = null;
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.this();
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, new Boolean(true));
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection) {
        this.this();
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, new Boolean(true));
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection) {
        this(channel, l, l2);
        this.deadlock_detection = deadlock_detection;
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2) {
        this.this();
        this.adapter = adapter;
        this.id = id;
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, new Boolean(true));
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this.this();
        this.adapter = adapter;
        this.id = id;
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, new Boolean(true));
        }
        this.start();
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        public String getName() {
            return "MessageDispatcher";
        }

        public void startUpHandler() {
        }

        public void startDownHandler() {
        }

        public void stopInternal() {
        }

        protected void receiveUpEvent(Event evt) {
        }

        protected void receiveDownEvent(Event evt) {
        }

        public void passUp(Event evt) {
            switch (evt.getType()) {
                case 1: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    MessageDispatcher.this.msg_listener.receive((Message)evt.getArg());
                    break;
                }
                case 17: {
                    if (MessageDispatcher.this.msg_listener != null) {
                        MessageDispatcher.this.channel.returnState(MessageDispatcher.this.msg_listener.getState());
                        break;
                    }
                    MessageDispatcher.this.channel.returnState(null);
                    break;
                }
                case 20: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    try {
                        MessageDispatcher.this.msg_listener.setState((byte[])evt.getArg());
                    }
                    catch (ClassCastException cast_ex) {
                        Trace.error("MessageDispatcher.passUp()", "received SetStateEvent, but argument " + evt.getArg() + " is not serializable. Discarding message.");
                    }
                    break;
                }
                case 6: {
                    View v = (View)evt.getArg();
                    Vector new_mbrs = v.getMembers();
                    if (new_mbrs != null) {
                        MessageDispatcher.this.members.removeAllElements();
                        int i = 0;
                        while (i < new_mbrs.size()) {
                            MessageDispatcher.this.members.addElement(new_mbrs.elementAt(i));
                            ++i;
                        }
                    }
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.viewAccepted(v);
                    break;
                }
                case 9: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.suspect((Address)evt.getArg());
                    break;
                }
                case 10: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.block();
                    break;
                }
            }
        }

        public void passDown(Event evt) {
            this.down(evt);
        }

        public void up(Event evt) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receive(evt);
            } else {
                Trace.error("MessageDispatcher.up()", "corr == null");
            }
        }

        public void down(Event evt) {
            if (MessageDispatcher.this.channel != null) {
                MessageDispatcher.this.channel.down(evt);
            } else {
                Trace.error("MessageDispatcher.down()", "channel == null");
            }
        }

        ProtocolAdapter() {
        }
    }

    class TransportAdapter
    implements Transport {
        public void send(Message msg) throws Exception {
        }

        public Object receive(long timeout) throws Exception {
            return null;
        }

        TransportAdapter() {
        }
    }

    class PullPushHandler
    implements MessageListener,
    MembershipListener {
        public void receive(Message msg) {
            boolean pass_up = true;
            if (MessageDispatcher.this.corr != null) {
                pass_up = MessageDispatcher.this.corr.receiveMessage(msg);
            }
            if (pass_up && MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.receive(msg);
            }
        }

        public byte[] getState() {
            return MessageDispatcher.this.msg_listener != null ? MessageDispatcher.this.msg_listener.getState() : null;
        }

        public void setState(byte[] state) {
            if (MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.setState(state);
            }
        }

        public void viewAccepted(View v) {
            Vector new_mbrs;
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveView(v);
            }
            if ((new_mbrs = v.getMembers()) != null) {
                MessageDispatcher.this.members.removeAllElements();
                int i = 0;
                while (i < new_mbrs.size()) {
                    MessageDispatcher.this.members.addElement(new_mbrs.elementAt(i));
                    ++i;
                }
            }
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.viewAccepted(v);
            }
        }

        public void suspect(Address suspected_mbr) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveSuspect(suspected_mbr);
            }
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.suspect(suspected_mbr);
            }
        }

        public void block() {
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.block();
            }
        }

        PullPushHandler() {
        }
    }
}

