/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class OffScreenSVGRenderer {
    public BufferedImage renderXMLToImage(String string, int n, int n2) throws IOException {
        return this.renderXMLToImage(string, n, n2, false, null, null);
    }

    public BufferedImage renderXMLToImage(String string, int n, int n2, boolean bl, String string2, Color color) throws IOException {
        String string3 = "file:/fake.svg";
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory("org.apache.xerces.parsers.SAXParser");
        SVGDocument sVGDocument = sAXSVGDocumentFactory.createSVGDocument(string3, (Reader)new StringReader(string));
        if (string2 != null && color != null) {
            this.replaceFill(sVGDocument, string2, color);
        }
        return this.renderToImage(sVGDocument, n, n2, bl);
    }

    public BufferedImage renderToImage(String string, int n, int n2) throws IOException {
        return this.renderToImage(string, n, n2, false, null, null);
    }

    public BufferedImage renderToImage(String string, int n, int n2, boolean bl, String string2, Color color) throws IOException {
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory("org.apache.xerces.parsers.SAXParser");
        SVGDocument sVGDocument = sAXSVGDocumentFactory.createSVGDocument(string);
        if (string2 != null && color != null) {
            this.replaceFill(sVGDocument, string2, color);
        }
        return this.renderToImage(sVGDocument, n, n2, bl);
    }

    public BufferedImage renderToImage(SVGDocument sVGDocument, int n, int n2) {
        return this.renderToImage(sVGDocument, n, n2, false);
    }

    public void replaceFill(SVGDocument sVGDocument, String string, Color color) {
        String string2 = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        System.out.println("color code: " + string2);
        NodeList nodeList = sVGDocument.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SVGElement sVGElement;
            if (!(nodeList.item(i) instanceof SVGElement) || !(sVGElement = (SVGElement)nodeList.item(i)).getId().matches(string)) continue;
            System.out.println("child>>> " + sVGElement + ", " + sVGElement.getId());
            String string3 = sVGElement.getAttributeNS(null, "style");
            string3 = string3.replaceFirst("fill:#[a-zA-z0-9]+", "fill:" + string2);
            System.out.println(string3);
            sVGElement.setAttributeNS(null, "style", string3);
        }
    }

    public BufferedImage renderToImage(SVGDocument sVGDocument, int n, int n2, boolean bl) {
        ConcreteImageRendererFactory concreteImageRendererFactory = new ConcreteImageRendererFactory();
        ImageRenderer imageRenderer = concreteImageRendererFactory.createStaticImageRenderer();
        GVTBuilder gVTBuilder = new GVTBuilder();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)new UserAgentAdapter());
        bridgeContext.setDynamicState(0);
        GraphicsNode graphicsNode = gVTBuilder.build(bridgeContext, (Document)sVGDocument);
        imageRenderer.setTree(graphicsNode);
        float f = (float)bridgeContext.getDocumentSize().getWidth();
        float f2 = (float)bridgeContext.getDocumentSize().getHeight();
        float f3 = (float)n / f;
        float f4 = (float)n2 / f2;
        if (!bl) {
            float f5;
            f3 = f5 = Math.min(f3, f4);
            f4 = f5;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f3, f4);
        double d = 0.0f + ((float)n / f3 - f) / 2.0f;
        double d2 = 0.0f + ((float)n2 / f4 - f2) / 2.0f;
        affineTransform.translate(d, d2);
        imageRenderer.updateOffScreen(n, n2);
        imageRenderer.setTree(graphicsNode);
        imageRenderer.setTransform(affineTransform);
        imageRenderer.repaint((Shape)new Rectangle(0, 0, n, n2));
        return imageRenderer.getOffScreen();
    }
}

