/*
 * part-item.h
 *
 * 
 * Author: 
 *  Richard Hult <rhult@hem.passagen.se>
 * 
 *  http://www.dtek.chalmers.se/~d4hult/oregano/ 
 * 
 * Copyright (C) 1999,2000  Richard Hult 
 * 
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the 
 * License, or (at your option) any later version. 
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __PART_ITEM_H
#define __PART_ITEM_H

#include <gnome.h>

typedef struct _PartItem PartItem;
typedef struct _PartItemClass PartItemClass;
typedef struct _PartItemPriv PartItemPriv;

#include "sheet-item.h"
#include "load-library.h"
#include "load-common.h"
#include "part.h"

#define PART_ITEM(obj)          GTK_CHECK_CAST (obj, part_item_get_type (), PartItem)
#define PART_ITEM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, part_item_get_type (), PartItemClass)
#define IS_PART_ITEM(obj)       GTK_CHECK_TYPE (obj, part_item_get_type ())

#include "schematic-view.h"

struct _PartItem {
	SheetItem    parent_object;

	PartItemPriv *priv;
};

struct _PartItemClass {
	SheetItemClass parent_class;
};

GtkType   part_item_get_type (void);
PartItem *part_item_new (Sheet *sheet, Part *part);
PartItem *part_item_new_from_part (Sheet *sheet, Part *part);
void      part_item_signal_connect_floating (PartItem *item);
void      part_item_signal_connect_floating_group (Sheet *sheet, SchematicView *schematic_view); // FIXME: remove later
void      part_item_create_canvas_items_for_preview (GnomeCanvasGroup *group, LibraryPart *library_part);

#endif
