dnl Find the kernel and handle 2.5 settings
AC_DEFUN(AX_FIND_KERNEL,
[
AC_MSG_CHECKING([for kernel OProfile support])
AC_ARG_WITH(kernel-support, [  --with-kernel-support        Use 2.5 kernel (no kernel source tree required)],
if test "$withval" = "yes"; then
	OPROFILE_25=yes
fi
) 

if test "$OPROFILE_25" != "yes"; then
	dnl  --- Find the Linux kernel, at least the headers ---
 
	KSRC=/usr/src/linux
	if test -d $KSRC ; then
	   KINC=$KSRC/include
	else
	   xcnt=$( ls -d /usr/src/kernel-source-* | grep -v gz | grep -v bz2 | grep -v dsc | wc -l )
	   if test $xcnt -eq 1 ; then
	      KSRC=$( ls -d /usr/src/kernel-source-* | grep -v gz | grep -v bz2 | grep -v dsc | head -1 )
	      if test -d $KSRC ; then
	         KINC=$KSRC/include
	      else
	         AC_MSG_ERROR([cannot find a kernel source tree])
	      fi
	   else
	      xver=$( uname -r | cut -f1 -d- )
	      KSRC=/usr/src/kernel-source-$xver
	      if test -d $KSRC ; then
	         KINC=$KSRC/include
	      else
	         AC_MSG_ERROR([too many kernel source trees to choose from])
	      fi
	   fi
	fi
	AC_ARG_WITH(linux, [  --with-linux=dir             Path to Linux source tree], KSRC=$withval) 
	AC_SUBST(KINC)
	AC_SUBST(KSRC)

	AX_KERNEL_OPTION(CONFIG_OPROFILE, OPROFILE_25=yes, OPROFILE_25=no)
	AX_KERNEL_OPTION(CONFIG_OPROFILE_MODULE, OPROFILE_25=yes, OPROFILE_25=$OPROFILE_25)
fi
AC_MSG_RESULT($OPROFILE_25)

AM_CONDITIONAL(kernel_support, test $OPROFILE_25 = yes)
]
)
