/*
       =.            This file is part of the OPIE Project
      .=l.            Copyright (c)  2002 Robert Griebl <sandman@handhelds.org>
     .>+-=
_;:,   .>  :=|.         This library is free software; you can
.> <`_,  > .  <=          redistribute it and/or  modify it under
:`=1 )Y*s>-.--  :           the terms of the GNU Library General Public
.="- .-=="i,   .._         License as published by the Free Software
- .  .-<_>   .<>         Foundation; either version 2 of the License,
  ._= =}    :          or (at your option) any later version.
  .%`+i>    _;_.
  .i_,=:_.   -<s.       This library is distributed in the hope that
  + . -:.    =       it will be useful,  but WITHOUT ANY WARRANTY;
  : ..  .:,   . . .    without even the implied warranty of
  =_    +   =;=|`    MERCHANTABILITY or FITNESS FOR A
 _.=:.    :  :=>`:     PARTICULAR PURPOSE. See the GNU
..}^=.=    =    ;      Library General Public License for more
++=  -.   .`   .:       details.
:   = ...= . :.=-
-.  .:....=;==+<;          You should have received a copy of the GNU
 -_. . .  )=. =           Library General Public License along with
  --    :-=`           this library; see the file COPYING.LIB.
                             If not, write to the Free Software Foundation,
                             Inc., 59 Temple Place - Suite 330,
                             Boston, MA 02111-1307, USA.

*/

#ifndef __OPIE_OCOLORBUTTON_H__
#define __OPIE_OCOLORBUTTON_H__

#include <qpushbutton.h>

class OColorButtonPrivate;
class QColor;

/**
 *
 * @short A Button which will show a OColorPopupMenu
 * @author Robert Griebl ( sandman@handhelds.org )
 * @version 1.0
 * @see QPushButton
 */
class OColorButton : public QPushButton {
	Q_OBJECT
public:
    // FIXME Wflags? -zecke
	OColorButton ( QWidget *parent = 0, const QColor & = black, const char *name = 0 );
	virtual ~OColorButton ( );

	QColor color ( ) const;

signals:
    /**
     * emitted when a color gets selected
     */
	void colorSelected ( const QColor & );

public slots:
	virtual void setColor ( const QColor & );

protected slots:
    /**
     * @internal
     */
	virtual void updateColor ( const QColor & );

private:
	OColorButtonPrivate *d;
};

#endif

