/*
 *   
 *   Ophcrack is a Lanmanager/NTLM hash cracker based on the faster time-memory
 *   trade-off using rainbow tables. 
 *   
 *   Created with the help of: Maxime Mueller, Luca Wullschleger, Claude
 *   Hochreutiner, Andreas Huber and Etienne Dysli.
 *   
 *   Copyright (c) 2008 Philippe Oechslin, Cedric Tissieres, Bertrand Mesot
 *   
 *   Ophcrack is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   
 *   Ophcrack is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Ophcrack; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *   
 *   This program is released under the GPL with the additional exemption 
 *   that compiling, linking, and/or using OpenSSL is allowed.
 *   
 *   
 *   $Rev: 124 $
 *   $Date: 2008-05-05 14:11:52 +0200 (Mon, 05 May 2008) $
 *   
 *   
*/
#ifndef DEFS_H
#define DEFS_H

#include <stdio.h>
#include <stdint.h>
#include <config.h>

#if defined(HAVE_ENDIAN_H)
#include <endian.h>
#elif defined(__FreeBSD__) || defined(OSX)
#include <machine/endian.h>
#endif

#include "bswap.h"

#define MY_MAX(a,b) ((a)>(b)?(a):(b))
#define MY_MIN(a,b) ((a)<(b)?(a):(b))

#define my_setbit(x,pos) x | (1 << pos);
#define my_getbit(x,pos) (x & (1 << pos)) ? 1 : 0

/** Maximum size of the buffers. */

#define STR_BUFF_SIZE 512

/** Maximum length of a password. */

#define MAX_PWD_LEN 50

/* Endianness conversion */

#ifdef BYTE_ORDER
#   if BYTE_ORDER == LITTLE_ENDIAN
#      define ftohl(x)   (x)            /**< File (f) to host (h) long.  */
#      define ftohs(x)   (x)            /**< File (f) to host (h) short. */
#      define htofl(x)   (x)            /**< Host (h) to file (f) long.  */
#      define htofs(x)   (x)            /**< Host (h) to file (f) short. */
#   elif BYTE_ORDER == BIG_ENDIAN
#      define ftohl(x) __bswap_32 (x)   /**< File (f) to host (h) long.  */
#      define ftohs(x) __bswap_16 (x)   /**< File (f) to host (h) short. */
#      define htofl(x) __bswap_32 (x)   /**< Host (h) to file (f) long.  */
#      define htofs(x) __bswap_16 (x)   /**< Host (h) to file (f) short. */
#   else
#      error "No byte order specified."
#   endif
#else
#   error "BYTE_ORDER is not defined."
#endif

#ifdef  __cplusplus
extern "C" {
#endif

typedef unsigned char uchar_t;
typedef unsigned long ulong_t;

#ifdef WIN32
char *strsep(char** stringp, const char* delim);
#endif

uint64_t find_freeram(void);
void convert_to_colon(uchar_t *input);
void convert_from_colon(uchar_t *input);
void wincp1252_to_ascii(uchar_t *str);
void fprintf_hex(FILE *file, char *str, int len);

#ifdef __cplusplus
}
#endif
#endif
