//---------------------------------------------------------------------------
//
// Project: OpenWalnut ( http://www.openwalnut.org )
//
// Copyright 2009 OpenWalnut Community, BSV@Uni-Leipzig and CNCF@MPI-CBS
// For more information see http://www.openwalnut.org/copying
//
// This file is part of OpenWalnut.
//
// OpenWalnut is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// OpenWalnut is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with OpenWalnut. If not, see <http://www.gnu.org/licenses/>.
//
//---------------------------------------------------------------------------

#version 130

#extension GL_EXT_geometry_shader4 : enable

/////////////////////////////////////////////////////////////////////////////
// Uniforms
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Attributes
/////////////////////////////////////////////////////////////////////////////

/**
 * This vertex attribute is the bitmask denoting whether to show the fiber or not
 */
#ifdef BITFIELD_ENABLED
    in float a_bitfield;
#endif

/////////////////////////////////////////////////////////////////////////////
// Varyings
/////////////////////////////////////////////////////////////////////////////

/**
 * The normal in scene-space
 */
varying vec3 v_normal;

/**
 * Varying defines wether to discard the fragments or not.
 */
varying float v_discard;

/**
 * Second color array
 */
varying vec4 v_secondaryColor;

/////////////////////////////////////////////////////////////////////////////
// Variables
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Functions
/////////////////////////////////////////////////////////////////////////////

/**
 * Main entry point of the vertex shader.
 */
void main()
{
#ifdef BITFIELD_ENABLED
    v_discard = 1.0 - a_bitfield;
#endif

    v_secondaryColor = vec4( gl_SecondaryColor.rgb, 1.0 );

    // forward to geometry shader
    v_normal = gl_Normal;
    gl_FrontColor = gl_Color;
    gl_Position = gl_Vertex;
}

