###############################################################################
# OpenVAS Vulnerability Test
# $Id: zabbix_37309.nasl 6582 2010-01-28 15:24:05Z chandra $
#
# ZABBIX Denial Of Service and SQL Injection Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100406);
 script_cve_id("CVE-2009-4499", "CVE-2009-4501");
 script_bugtraq_id(37309);
 script_version ("1.0-$Revision: 6582 $");

 script_name("ZABBIX Denial Of Service and SQL Injection Vulnerabilities");

desc = "Overview:
ZABBIX is prone to a denial-of-service vulnerability and an SQL-
injection vulnerability.

Successful exploits may allow remote attackers to crash the affected
application, exploit latent vulnerabilities in the underlying
database, access or modify data, or compromise the application.

Versions prior to ZABBIX 1.6.8 are vulnerable.

Solution:
Updates are available. Please see the references for details.

References:
http://secunia.com/advisories/37740/
https://support.zabbix.com/browse/ZBX-1031
https://support.zabbix.com/browse/ZBX-1355
http://www.zabbix.com/index.php

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if ZABBIX version is < 1.6.8");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("zabbix_detect.nasl","zabbix_web_detect.nasl");
 script_require_ports("Services/www","Services/zabbix_server", 80,10051);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/zabbix_client")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "1.6.8")) {
    
    if(zabbix_port = get_kb_item("Services/zabbix_server")) {
      port = zabbix_port;
    }

    security_warning(port:port);
    exit(0);
  }

}

exit(0);
